/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.recover;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.recover.CompactionRecoverTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InsertionCrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.CompactionLogger;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.rescon.disk.TierManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionRecoverManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"COMPACTION");
    private final TsFileManager tsFileManager;
    private final String logicalStorageGroupName;
    private final String dataRegionId;

    public CompactionRecoverManager(TsFileManager tsFileManager, String logicalStorageGroupName, String dataRegionId) {
        this.tsFileManager = tsFileManager;
        this.logicalStorageGroupName = logicalStorageGroupName;
        this.dataRegionId = dataRegionId;
    }

    public void recoverInnerSpaceCompaction(boolean isSequence) {
        logger.info("{} [Compaction][Recover] recovering {} inner compaction", (Object)this.logicalStorageGroupName, (Object)(isSequence ? "sequence" : "unsequence"));
        this.recoverCompaction(true, isSequence);
    }

    public void recoverCrossSpaceCompaction() {
        logger.info("{} [Compaction][Recover] recovering cross compaction", (Object)this.logicalStorageGroupName);
        this.recoverCompaction(false, true);
    }

    private void recoverCompaction(boolean isInnerSpace, boolean isLogSequence) {
        List<String> dirs = isLogSequence ? TierManager.getInstance().getAllLocalSequenceFileFolders() : TierManager.getInstance().getAllLocalUnSequenceFileFolders();
        for (String dir : dirs) {
            File storageGroupDir = new File(dir + File.separator + this.logicalStorageGroupName + File.separator + this.dataRegionId);
            logger.info("{} [Compaction][Recover] recover compaction in data region dir {}", (Object)this.logicalStorageGroupName, (Object)storageGroupDir.getAbsolutePath());
            if (!storageGroupDir.exists()) {
                return;
            }
            File[] timePartitionDirs = storageGroupDir.listFiles();
            if (timePartitionDirs == null) {
                return;
            }
            for (File timePartitionDir : timePartitionDirs) {
                if (!timePartitionDir.isDirectory() || !Pattern.compile("\\d*").matcher(timePartitionDir.getName()).matches()) continue;
                logger.info("{} [Compaction][Recover] recover compaction in time partition dir {}", (Object)this.logicalStorageGroupName, (Object)timePartitionDir.getAbsolutePath());
                this.recoverCompaction(isInnerSpace, timePartitionDir);
                this.recoverModSettleFile(timePartitionDir.toPath());
            }
        }
    }

    public void recoverModSettleFile(Path timePartitionDir) {
        try (Stream<Path> settlesStream = Files.list(timePartitionDir);){
            settlesStream.filter(path -> path.toString().endsWith(".mods.settle")).forEach(modsSettle -> {
                Path originModFile = modsSettle.resolveSibling(modsSettle.getFileName().toString().replace(".settle", ""));
                try {
                    if (Files.exists(originModFile, new LinkOption[0])) {
                        Files.deleteIfExists(modsSettle);
                    } else {
                        Files.move(modsSettle, originModFile, new CopyOption[0]);
                    }
                }
                catch (IOException e) {
                    logger.error("recover mods file error on delete origin file or rename mods settle,", (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            logger.error("recover mods file error on list files:{}", (Object)timePartitionDir, (Object)e);
        }
    }

    public void recoverCompaction(boolean isInnerSpace, File timePartitionDir) {
        File[] compactionLogs;
        for (File compactionLog : compactionLogs = CompactionLogger.findCompactionLogs(isInnerSpace, timePartitionDir.getPath())) {
            logger.info("{} [Compaction][Recover] calling compaction recover task.", (Object)this.logicalStorageGroupName);
            if (!isInnerSpace && compactionLog.getAbsolutePath().endsWith(".insertion-compaction.log")) {
                new InsertionCrossSpaceCompactionTask(this.logicalStorageGroupName, this.dataRegionId, this.tsFileManager, compactionLog).recover();
                continue;
            }
            new CompactionRecoverTask(this.logicalStorageGroupName, this.dataRegionId, this.tsFileManager, compactionLog, isInnerSpace).doCompaction();
        }
    }
}

