/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.RepairUnsortedFileCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskPriorityType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.RepairUnsortedFileCompactionEstimator;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileRepairStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;

public class RepairUnsortedFileCompactionTask
extends InnerSpaceCompactionTask {
    private final TsFileResource sourceFile;
    private final boolean rewriteFile;
    private CountDownLatch latch;

    public RepairUnsortedFileCompactionTask(long timePartition, TsFileManager tsFileManager, TsFileResource sourceFile, boolean sequence, long serialId) {
        super(timePartition, tsFileManager, Collections.singletonList(sourceFile), sequence, new RepairUnsortedFileCompactionPerformer(true), serialId, CompactionTaskPriorityType.REPAIR_DATA);
        this.sourceFile = sourceFile;
        this.innerSpaceEstimator = new RepairUnsortedFileCompactionEstimator();
        this.rewriteFile = false;
    }

    public RepairUnsortedFileCompactionTask(long timePartition, TsFileManager tsFileManager, TsFileResource sourceFile, boolean sequence, boolean rewriteFile, long serialId) {
        super(timePartition, tsFileManager, Collections.singletonList(sourceFile), sequence, new RepairUnsortedFileCompactionPerformer(rewriteFile), serialId, CompactionTaskPriorityType.REPAIR_DATA);
        this.sourceFile = sourceFile;
        if (rewriteFile) {
            this.innerSpaceEstimator = new RepairUnsortedFileCompactionEstimator();
        }
        this.rewriteFile = rewriteFile;
    }

    public RepairUnsortedFileCompactionTask(long timePartition, TsFileManager tsFileManager, TsFileResource sourceFile, CountDownLatch latch, boolean sequence, long serialId) {
        super(timePartition, tsFileManager, Collections.singletonList(sourceFile), sequence, new RepairUnsortedFileCompactionPerformer(true), serialId, CompactionTaskPriorityType.REPAIR_DATA);
        this.sourceFile = sourceFile;
        this.innerSpaceEstimator = new RepairUnsortedFileCompactionEstimator();
        this.latch = latch;
        this.rewriteFile = false;
    }

    public RepairUnsortedFileCompactionTask(long timePartition, TsFileManager tsFileManager, TsFileResource sourceFile, CountDownLatch latch, boolean sequence, boolean rewriteFile, long serialId) {
        super(timePartition, tsFileManager, Collections.singletonList(sourceFile), sequence, new RepairUnsortedFileCompactionPerformer(rewriteFile), serialId, CompactionTaskPriorityType.REPAIR_DATA);
        this.sourceFile = sourceFile;
        if (rewriteFile) {
            this.innerSpaceEstimator = new RepairUnsortedFileCompactionEstimator();
        }
        this.rewriteFile = rewriteFile;
        this.latch = latch;
    }

    @Override
    protected void prepare() throws IOException {
        this.targetTsFileResource = new TsFileResource(this.generateTargetFile(), TsFileResourceStatus.COMPACTING);
        String dataDirectory = this.sourceFile.getTsFile().getParent();
        this.logFile = new File(dataDirectory + File.separator + this.targetTsFileResource.getTsFile().getName() + ".inner-compaction.log");
    }

    private File generateTargetFile() throws IOException {
        String path = this.sourceFile.getTsFile().getParentFile().getPath();
        if (this.sourceFile.isSeq()) {
            int pos = path.lastIndexOf("sequence");
            path = path.substring(0, pos) + "unsequence" + path.substring(pos + "sequence".length());
        }
        TsFileNameGenerator.TsFileName tsFileName = TsFileNameGenerator.getTsFileName(this.sourceFile.getTsFile().getName());
        tsFileName.setInnerCompactionCnt(tsFileName.getInnerCompactionCnt() + 1);
        String fileNameStr = String.format("%d-%d-%d-%d.tsfile", tsFileName.getTime(), tsFileName.getVersion(), tsFileName.getInnerCompactionCnt(), 0);
        File targetTsFile = new File(path + File.separator + fileNameStr);
        if (!targetTsFile.getParentFile().exists()) {
            targetTsFile.getParentFile().mkdirs();
        }
        return targetTsFile;
    }

    @Override
    protected void prepareTargetFiles() throws IOException {
        CompactionUtils.updateProgressIndex(this.targetTsFileList, this.selectedTsFileResourceList, Collections.emptyList());
        CompactionUtils.moveTargetFile(this.targetTsFileList, true, this.storageGroupName + "-" + this.dataRegionId);
        LOGGER.info("{}-{} [InnerSpaceCompactionTask] start to rename mods file", (Object)this.storageGroupName, (Object)this.dataRegionId);
        if (this.rewriteFile) {
            CompactionUtils.combineModsInInnerCompaction(this.selectedTsFileResourceList, this.targetTsFileResource);
        } else if (this.sourceFile.modFileExists()) {
            Files.createLink(new File(this.targetTsFileResource.getModFile().getFilePath()).toPath(), new File(this.sourceFile.getModFile().getFilePath()).toPath());
        }
    }

    @Override
    protected boolean doCompaction() {
        boolean isSuccess = super.doCompaction();
        if (!isSuccess) {
            LOGGER.info("Failed to repair file {}", (Object)this.sourceFile.getTsFile().getAbsolutePath());
            this.sourceFile.setTsFileRepairStatus(TsFileRepairStatus.CAN_NOT_REPAIR);
        }
        return isSuccess;
    }

    @Override
    public long getEstimatedMemoryCost() {
        if (this.innerSpaceEstimator != null && this.memoryCost == 0L) {
            try {
                this.memoryCost = this.innerSpaceEstimator.estimateInnerCompactionMemory(this.selectedTsFileResourceList);
            }
            catch (IOException e) {
                this.innerSpaceEstimator.cleanup();
            }
        }
        if (this.memoryCost > SystemInfo.getInstance().getMemorySizeForCompaction()) {
            this.sourceFile.setTsFileRepairStatus(TsFileRepairStatus.CAN_NOT_REPAIR);
            LOGGER.warn("[RepairUnsortedFileCompactionTask] Can not repair unsorted file {} because the required memory to repair is greater than the total compaction memory budget", (Object)this.sourceFile.getTsFile().getAbsolutePath());
        }
        return this.memoryCost;
    }

    @Override
    public boolean isDiskSpaceCheckPassed() {
        if (!this.rewriteFile) {
            return true;
        }
        return super.isDiskSpaceCheckPassed();
    }

    @Override
    public void handleTaskCleanup() {
        super.handleTaskCleanup();
        if (this.latch != null) {
            this.latch.countDown();
        }
    }
}

