/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.ReadPointInnerCompactionWriter;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;

public class RepairUnsortedFileCompactionWriter
extends ReadPointInnerCompactionWriter {
    private List<TimeValuePair>[] dataOfCurrentSeriesArr;

    public RepairUnsortedFileCompactionWriter(TsFileResource targetFileResource) throws IOException {
        super(targetFileResource);
        this.dataOfCurrentSeriesArr = new ArrayList[this.subTaskNum];
    }

    @Override
    public void startMeasurement(List<IMeasurementSchema> measurementSchemaList, int subTaskId) {
        this.dataOfCurrentSeriesArr[subTaskId] = new ArrayList<TimeValuePair>();
        super.startMeasurement(measurementSchemaList, subTaskId);
    }

    @Override
    public void endMeasurement(int subTaskId) throws IOException {
        List<TimeValuePair> dataOfCurrentSeries = this.dataOfCurrentSeriesArr[subTaskId];
        if (dataOfCurrentSeries.isEmpty()) {
            super.endMeasurement(subTaskId);
            return;
        }
        dataOfCurrentSeries.sort(Comparator.comparingLong(TimeValuePair::getTimestamp));
        TimeValuePair previousTimeValuePair = dataOfCurrentSeries.get(0);
        for (TimeValuePair timeValuePair : dataOfCurrentSeries) {
            if (timeValuePair.getTimestamp() == previousTimeValuePair.getTimestamp()) {
                this.mergeTimeValuePair(timeValuePair, previousTimeValuePair);
                continue;
            }
            this.writeDataPoint(previousTimeValuePair.getTimestamp(), previousTimeValuePair.getValue(), this.chunkWriters[subTaskId]);
            int n = subTaskId;
            this.chunkPointNumArray[n] = this.chunkPointNumArray[n] + 1;
            previousTimeValuePair = timeValuePair;
        }
        this.writeDataPoint(previousTimeValuePair.getTimestamp(), previousTimeValuePair.getValue(), this.chunkWriters[subTaskId]);
        int n = subTaskId;
        this.chunkPointNumArray[n] = this.chunkPointNumArray[n] + 1;
        this.dataOfCurrentSeriesArr[subTaskId] = null;
        super.endMeasurement(subTaskId);
    }

    private void mergeTimeValuePair(TimeValuePair from, TimeValuePair to) {
        if (!this.isAlign) {
            return;
        }
        TsPrimitiveType[] fromVector = from.getValue().getVector();
        TsPrimitiveType[] toVector = to.getValue().getVector();
        for (int i = 0; i < toVector.length; ++i) {
            if (toVector[i] != null || fromVector[i] == null) continue;
            toVector[i] = fromVector[i];
        }
        to.getValue().setVector(toVector);
    }

    @Override
    public void write(TsBlock tsBlock, int subTaskId) throws IOException {
        TsBlock.TsBlockAlignedRowIterator pointReader = tsBlock.getTsBlockAlignedRowIterator();
        while (pointReader.hasNextTimeValuePair()) {
            this.write(pointReader.nextTimeValuePair(), subTaskId);
        }
    }

    @Override
    public void write(TimeValuePair timeValuePair, int subTaskId) throws IOException {
        this.dataOfCurrentSeriesArr[subTaskId].add(timeValuePair);
        this.isEmptyFile = false;
    }
}

