/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator;

import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.AbstractInnerSpaceEstimator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.CompactionTaskInfo;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;

public class ReadChunkInnerCompactionEstimator
extends AbstractInnerSpaceEstimator {
    @Override
    public long calculatingMetadataMemoryCost(CompactionTaskInfo taskInfo) {
        long cost = 0L;
        cost += Math.min(taskInfo.getTotalChunkMetadataSize(), (long)(taskInfo.getFileInfoList().size() * taskInfo.getMaxChunkMetadataNumInDevice()) * taskInfo.getMaxChunkMetadataSize());
        long sizeForFileWriter = (long)((double)SystemInfo.getInstance().getMemorySizeForCompaction() / (double)IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount() * IoTDBDescriptor.getInstance().getConfig().getChunkMetadataSizeProportion());
        return cost += sizeForFileWriter;
    }

    @Override
    public long calculatingDataMemoryCost(CompactionTaskInfo taskInfo) {
        if (taskInfo.getTotalChunkNum() == 0L) {
            return taskInfo.getModificationFileSize();
        }
        long averageUncompressedChunkSize = taskInfo.getTotalFileSize() * this.compressionRatio / taskInfo.getTotalChunkNum();
        long maxConcurrentSeriesSizeOfTotalFiles = averageUncompressedChunkSize * (long)taskInfo.getFileInfoList().size() * (long)taskInfo.getMaxConcurrentSeriesNum() * (long)taskInfo.getMaxChunkMetadataNumInSeries() / this.compressionRatio;
        long maxTargetChunkWriterSize = this.config.getTargetChunkSize() * (long)taskInfo.getMaxConcurrentSeriesNum();
        long targetChunkWriterSize = Math.min(maxConcurrentSeriesSizeOfTotalFiles, maxTargetChunkWriterSize);
        long chunkSizeFromSourceFile = averageUncompressedChunkSize * (long)taskInfo.getMaxConcurrentSeriesNum();
        return targetChunkWriterSize + chunkSizeFromSourceFile + taskInfo.getModificationFileSize();
    }
}

