/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.tool;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.ITimeRange;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.Interval;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.ListTimeRangeImpl;

public class UnseqSpaceStatistics {
    public long unsequenceFileNum = 0L;
    public long unsequenceFileSize = 0L;
    public long unsequenceChunkNum = 0L;
    public long unsequenceChunkGroupNum = 0L;
    public long minStartTime = Long.MAX_VALUE;
    public long maxEndTime = Long.MIN_VALUE;
    private Map<String, Map<String, ITimeRange>> chunkStatisticMap = new HashMap<String, Map<String, ITimeRange>>();
    private Map<String, ITimeRange> chunkGroupStatisticMap = new HashMap<String, ITimeRange>();

    public void updateMeasurement(String device, String measurementUID, Interval interval) {
        this.chunkStatisticMap.computeIfAbsent(device, key -> new HashMap()).computeIfAbsent(measurementUID, key -> new ListTimeRangeImpl()).addInterval(interval);
    }

    public void updateDevice(String device, Interval interval) {
        this.chunkGroupStatisticMap.computeIfAbsent(device, key -> new ListTimeRangeImpl()).addInterval(interval);
    }

    public boolean chunkHasOverlap(String device, String measurementUID, Interval interval) {
        if (!this.chunkStatisticMap.containsKey(device)) {
            return false;
        }
        if (!this.chunkStatisticMap.get(device).containsKey(measurementUID)) {
            return false;
        }
        return this.chunkStatisticMap.get(device).get(measurementUID).isOverlapped(interval);
    }

    public boolean chunkGroupHasOverlap(String device, Interval interval) {
        if (!this.chunkGroupStatisticMap.containsKey(device)) {
            return false;
        }
        return this.chunkGroupStatisticMap.get(device).isOverlapped(interval);
    }

    public Map<String, Map<String, ITimeRange>> getChunkStatisticMap() {
        return this.chunkStatisticMap;
    }

    public Map<String, ITimeRange> getChunkGroupStatisticMap() {
        return this.chunkGroupStatisticMap;
    }

    public void setMaxEndTime(long maxEndTime) {
        this.maxEndTime = Math.max(this.maxEndTime, maxEndTime);
    }

    public void setMinStartTime(long minStartTime) {
        this.minStartTime = Math.min(this.minStartTime, minStartTime);
    }
}

