/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.metadata;

import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.metric.SeriesScanCostMetricSet;
import org.apache.iotdb.db.storageengine.dataregion.memtable.ReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.DiskChunkLoader;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IMetadata;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.controller.IChunkMetadataLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class MemChunkMetadataLoader
implements IChunkMetadataLoader {
    private final TsFileResource resource;
    private final PartialPath seriesPath;
    private final QueryContext context;
    private final Filter globalTimeFilter;
    private static final SeriesScanCostMetricSet SERIES_SCAN_COST_METRIC_SET = SeriesScanCostMetricSet.getInstance();

    public MemChunkMetadataLoader(TsFileResource resource, PartialPath seriesPath, QueryContext context, Filter globalTimeFilter) {
        this.resource = resource;
        this.seriesPath = seriesPath;
        this.context = context;
        this.globalTimeFilter = globalTimeFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IChunkMetadata> loadChunkMetadataList(ITimeSeriesMetadata timeSeriesMetadata) {
        long t1 = System.nanoTime();
        try {
            List<IChunkMetadata> chunkMetadataList = this.resource.getChunkMetadataList(this.seriesPath);
            chunkMetadataList.forEach(chunkMetadata -> {
                if (chunkMetadata.needSetChunkLoader()) {
                    chunkMetadata.setVersion(this.resource.getVersion());
                    chunkMetadata.setClosed(this.resource.isClosed());
                    chunkMetadata.setChunkLoader((IChunkLoader)new DiskChunkLoader(this.context, this.resource));
                }
            });
            List<ReadOnlyMemChunk> memChunks = this.resource.getReadOnlyMemChunk(this.seriesPath);
            if (memChunks != null) {
                for (ReadOnlyMemChunk readOnlyMemChunk : memChunks) {
                    if (readOnlyMemChunk.isEmpty()) continue;
                    chunkMetadataList.add(readOnlyMemChunk.getChunkMetaData());
                }
            }
            if (chunkMetadataList.size() > 1) {
                long t2 = System.nanoTime();
                chunkMetadataList.removeIf(chunkMetaData -> this.globalTimeFilter != null && this.globalTimeFilter.canSkip((IMetadata)chunkMetaData) || chunkMetaData.getStartTime() > chunkMetaData.getEndTime());
                SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("chunk_metadata_filter_non_aligned_mem", System.nanoTime() - t2);
            }
            for (IChunkMetadata metadata : chunkMetadataList) {
                metadata.setVersion(this.resource.getVersion());
            }
            List<IChunkMetadata> list = chunkMetadataList;
            return list;
        }
        finally {
            SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("load_chunk_metadata_list_non_aligned_mem", System.nanoTime() - t1);
        }
    }
}

