/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.utils;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntryValue;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.MemTablePinException;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.WALPipeException;
import org.apache.iotdb.db.storageengine.dataregion.wal.node.WALNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALEntryPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WALEntryHandler {
    private static final Logger logger = LoggerFactory.getLogger(WALEntryHandler.class);
    private long memTableId = -1L;
    private volatile WALEntryValue value;
    private final WALEntryPosition walEntryPosition = new WALEntryPosition();
    private WALNode walNode = null;
    private volatile boolean isHardlink = false;
    private final AtomicReference<File> hardlinkFile = new AtomicReference();

    public WALEntryHandler(WALEntryValue value) {
        this.value = value;
    }

    public void pinMemTable() throws MemTablePinException {
        if (this.walNode == null || this.memTableId < 0L) {
            throw new MemTablePinException("Fail to pin memTable because of internal error.");
        }
        this.walNode.pinMemTable(this.memTableId);
    }

    public void unpinMemTable() throws MemTablePinException {
        if (this.walNode == null || this.memTableId < 0L) {
            throw new MemTablePinException("Fail to pin memTable because of internal error.");
        }
        this.walNode.unpinMemTable(this.memTableId);
    }

    public InsertNode getInsertNodeViaCacheIfPossible() {
        try {
            return this.value instanceof InsertNode ? (InsertNode)((Object)this.value) : (InsertNode)this.walEntryPosition.readByteBufferOrInsertNodeViaCacheDirectly().getRight();
        }
        catch (Exception e) {
            logger.warn("Fail to get insert node via cache. {}", (Object)this, (Object)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InsertNode getInsertNode() throws WALPipeException {
        InsertNode node;
        WALEntryValue res = this.value;
        if (res != null) {
            if (res instanceof InsertNode) {
                return (InsertNode)((Object)res);
            }
            throw new WALPipeException("Fail to get value because the entry type isn't InsertNode.");
        }
        while (!this.walEntryPosition.canRead()) {
            try {
                WALEntryHandler wALEntryHandler = this;
                synchronized (wALEntryHandler) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted when waiting for result.", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        InsertNode insertNode = node = this.isHardlink ? this.readFromHardlinkWALFile() : this.readFromOriginalWALFile();
        if (node == null) {
            throw new WALPipeException(String.format("Fail to get the wal value of the position %s.", this.walEntryPosition));
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getByteBuffer() throws WALPipeException {
        while (!this.walEntryPosition.canRead()) {
            try {
                WALEntryHandler wALEntryHandler = this;
                synchronized (wALEntryHandler) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted when waiting for result.", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        ByteBuffer buffer = this.readByteBufferFromWALFile();
        if (buffer == null) {
            throw new WALPipeException(String.format("Fail to get the wal value of the position %s.", this.walEntryPosition));
        }
        return buffer;
    }

    private InsertNode readFromOriginalWALFile() throws WALPipeException {
        try {
            return this.walEntryPosition.readInsertNodeViaCacheAfterCanRead();
        }
        catch (Exception e) {
            throw new WALPipeException("Fail to get value because the file content isn't correct.", e);
        }
    }

    private InsertNode readFromHardlinkWALFile() throws WALPipeException {
        try {
            return this.walEntryPosition.readInsertNodeViaCacheAfterCanRead();
        }
        catch (Exception e) {
            throw new WALPipeException("Fail to get value because the file content isn't correct.", e);
        }
    }

    private ByteBuffer readByteBufferFromWALFile() throws WALPipeException {
        try {
            return this.walEntryPosition.readByteBufferViaCacheAfterCanRead();
        }
        catch (Exception e) {
            throw new WALPipeException("Fail to get value because the file content isn't correct.", e);
        }
    }

    public void setWalNode(WALNode walNode, long memTableId) {
        this.walNode = walNode;
        this.memTableId = memTableId;
        this.walEntryPosition.setWalNode(walNode, memTableId);
    }

    public long getMemTableId() {
        return this.memTableId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntryPosition(long walFileVersionId, long position) {
        this.walEntryPosition.setEntryPosition(walFileVersionId, position, this.value);
        this.value = null;
        WALEntryHandler wALEntryHandler = this;
        synchronized (wALEntryHandler) {
            this.notifyAll();
        }
    }

    public WALEntryPosition getWalEntryPosition() {
        return this.walEntryPosition;
    }

    public int getSize() {
        return this.walEntryPosition.getSize();
    }

    public void setSize(int size) {
        this.walEntryPosition.setSize(size);
    }

    public void hardlinkTo(File hardlinkFile) {
        this.isHardlink = true;
        this.hardlinkFile.set(hardlinkFile);
    }

    public String toString() {
        return "WALEntryHandler{memTableId=" + this.memTableId + ", value=" + this.value + ", walEntryPosition=" + this.walEntryPosition + '}';
    }
}

