/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.iotdb.db.exception.TsFileTimeseriesMetadataException;
import org.apache.iotdb.tsfile.exception.TsFileStatisticsMistakesException;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexEntry;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexNode;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.MetadataIndexNodeType;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileSelfCheckTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsFileSelfCheckTool.class);

    private Map<Long, Pair<Path, TimeseriesMetadata>> getTimeseriesMetadataMapWithReader(TsFileSelfCheckToolReader reader) throws Exception {
        Map<Long, Pair<Path, TimeseriesMetadata>> timeseriesMetadataMap = null;
        timeseriesMetadataMap = reader.getAllTimeseriesMetadataWithOffset();
        return timeseriesMetadataMap;
    }

    public Map<Long, Pair<Path, TimeseriesMetadata>> getTimeseriesMetadataMapWithPath(String filename) throws IOException, TsFileTimeseriesMetadataException {
        TsFileSelfCheckToolReader reader = new TsFileSelfCheckToolReader(filename);
        Map<Long, Pair<Path, TimeseriesMetadata>> timeseriesMetadataMap = null;
        try {
            timeseriesMetadataMap = this.getTimeseriesMetadataMapWithReader(reader);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while getting all TimeseriesMetadata with offset in TsFile.");
            throw new TsFileTimeseriesMetadataException("Error occurred while getting all TimeseriesMetadata with offset in TsFile.");
        }
        return timeseriesMetadataMap;
    }

    public long check(String filename, boolean fastFinish) throws IOException, TsFileStatisticsMistakesException, TsFileTimeseriesMetadataException {
        LOGGER.info("file path: {}", (Object)filename);
        TsFileSelfCheckToolReader reader = new TsFileSelfCheckToolReader(filename);
        Map<Long, Pair<Path, TimeseriesMetadata>> timeseriesMetadataMap = null;
        long res = -1L;
        try {
            timeseriesMetadataMap = this.getTimeseriesMetadataMapWithReader(reader);
            res = reader.selfCheckWithInfo(filename, fastFinish, timeseriesMetadataMap);
        }
        catch (TsFileStatisticsMistakesException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while getting all TimeseriesMetadata with offset in TsFile.");
            throw new TsFileTimeseriesMetadataException("Error occurred while getting all TimeseriesMetadata with offset in TsFile.");
        }
        finally {
            reader.close();
        }
        return res;
    }

    private class TsFileSelfCheckToolReader
    extends TsFileSequenceReader {
        public TsFileSelfCheckToolReader(String file) throws IOException {
            super(file);
        }

        private void generateMetadataIndexWithOffset(long startOffset, MetadataIndexEntry metadataIndex, ByteBuffer buffer, String deviceId, MetadataIndexNodeType type, Map<Long, Pair<Path, TimeseriesMetadata>> timeseriesMetadataMap, boolean needChunkMetadata) throws IOException {
            if (type.equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                while (buffer.hasRemaining()) {
                    long pos = startOffset + (long)buffer.position();
                    TimeseriesMetadata timeseriesMetadata = TimeseriesMetadata.deserializeFrom((ByteBuffer)buffer, (boolean)needChunkMetadata);
                    timeseriesMetadataMap.put(pos, (Pair<Path, TimeseriesMetadata>)new Pair((Object)new Path(deviceId, timeseriesMetadata.getMeasurementId(), true), (Object)timeseriesMetadata));
                }
            } else {
                if (type.equals((Object)MetadataIndexNodeType.LEAF_DEVICE)) {
                    deviceId = metadataIndex.getName();
                }
                MetadataIndexNode metadataIndexNode = MetadataIndexNode.deserializeFrom((ByteBuffer)buffer);
                int metadataIndexListSize = metadataIndexNode.getChildren().size();
                for (int i = 0; i < metadataIndexListSize; ++i) {
                    long endOffset = metadataIndexNode.getEndOffset();
                    if (i != metadataIndexListSize - 1) {
                        endOffset = ((MetadataIndexEntry)metadataIndexNode.getChildren().get(i + 1)).getOffset();
                    }
                    ByteBuffer nextBuffer = this.readData(((MetadataIndexEntry)metadataIndexNode.getChildren().get(i)).getOffset(), endOffset);
                    this.generateMetadataIndexWithOffset(((MetadataIndexEntry)metadataIndexNode.getChildren().get(i)).getOffset(), (MetadataIndexEntry)metadataIndexNode.getChildren().get(i), nextBuffer, deviceId, metadataIndexNode.getNodeType(), timeseriesMetadataMap, needChunkMetadata);
                }
            }
        }

        public Map<Long, Pair<Path, TimeseriesMetadata>> getAllTimeseriesMetadataWithOffset() throws IOException {
            if (this.tsFileMetaData == null) {
                this.readFileMetadata();
            }
            MetadataIndexNode metadataIndexNode = this.tsFileMetaData.getMetadataIndex();
            TreeMap<Long, Pair<Path, TimeseriesMetadata>> timeseriesMetadataMap = new TreeMap<Long, Pair<Path, TimeseriesMetadata>>();
            List metadataIndexEntryList = metadataIndexNode.getChildren();
            for (int i = 0; i < metadataIndexEntryList.size(); ++i) {
                MetadataIndexEntry metadataIndexEntry = (MetadataIndexEntry)metadataIndexEntryList.get(i);
                long endOffset = this.tsFileMetaData.getMetadataIndex().getEndOffset();
                if (i != metadataIndexEntryList.size() - 1) {
                    endOffset = ((MetadataIndexEntry)metadataIndexEntryList.get(i + 1)).getOffset();
                }
                ByteBuffer buffer = this.readData(metadataIndexEntry.getOffset(), endOffset);
                this.generateMetadataIndexWithOffset(metadataIndexEntry.getOffset(), metadataIndexEntry, buffer, null, metadataIndexNode.getNodeType(), timeseriesMetadataMap, false);
            }
            return timeseriesMetadataMap;
        }
    }
}

