/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.trigger.executor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.consensus.ConfigRegionId;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.trigger.TriggerInformation;
import org.apache.iotdb.commons.trigger.TriggerTable;
import org.apache.iotdb.commons.trigger.exception.TriggerExecutionException;
import org.apache.iotdb.confignode.rpc.thrift.TTriggerState;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.pipe.PipeEnrichedInsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertMultiTabletsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsOfOneDeviceNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.trigger.executor.TriggerExecutor;
import org.apache.iotdb.db.trigger.executor.TriggerFireResult;
import org.apache.iotdb.db.trigger.service.TriggerManagementService;
import org.apache.iotdb.mpp.rpc.thrift.TFireTriggerReq;
import org.apache.iotdb.mpp.rpc.thrift.TFireTriggerResp;
import org.apache.iotdb.trigger.api.enums.FailureStrategy;
import org.apache.iotdb.trigger.api.enums.TriggerEvent;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerFireVisitor
extends PlanVisitor<TriggerFireResult, TriggerEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TriggerFireVisitor.class);
    private static final IClientManager<ConfigRegionId, ConfigNodeClient> CONFIG_NODE_CLIENT_MANAGER = ConfigNodeClientManager.getInstance();
    private static final int FIRE_RETRY_NUM = IoTDBDescriptor.getInstance().getConfig().getRetryNumToFindStatefulTrigger();

    @Override
    public TriggerFireResult process(PlanNode node, TriggerEvent context) {
        if (TriggerManagementService.getInstance().isTriggerTableEmpty()) {
            return TriggerFireResult.SUCCESS;
        }
        return node.accept(this, context);
    }

    @Override
    public TriggerFireResult visitPlan(PlanNode node, TriggerEvent context) {
        return TriggerFireResult.SUCCESS;
    }

    @Override
    public TriggerFireResult visitInsertRow(InsertRowNode node, TriggerEvent context) {
        Map<String, List<String>> triggerNameToMeasurementList = this.constructTriggerNameToMeasurementListMap(node, context);
        if (triggerNameToMeasurementList.isEmpty()) {
            return TriggerFireResult.SUCCESS;
        }
        MeasurementSchema[] measurementSchemas = node.getMeasurementSchemas();
        Map<String, Integer> measurementToSchemaIndexMap = this.constructMeasurementToSchemaIndexMap(node.getMeasurements(), measurementSchemas);
        Object[] values = node.getValues();
        long time = node.getTime();
        boolean hasFailedTrigger = false;
        for (Map.Entry<String, List<String>> entry : triggerNameToMeasurementList.entrySet()) {
            List schemas = entry.getValue().stream().map(measurement -> measurementSchemas[(Integer)measurementToSchemaIndexMap.get(measurement)]).collect(Collectors.toList());
            Tablet tablet = new Tablet(node.getDevicePath().getFullPath(), schemas, 1);
            ++tablet.rowSize;
            tablet.addTimestamp(0, time);
            for (String measurement2 : entry.getValue()) {
                tablet.addValue(measurement2, 0, values[measurementToSchemaIndexMap.get(measurement2)]);
            }
            TriggerFireResult result = this.fire(entry.getKey(), tablet, context);
            if (result.equals((Object)TriggerFireResult.TERMINATION)) {
                return result;
            }
            if (!result.equals((Object)TriggerFireResult.FAILED_NO_TERMINATION)) continue;
            hasFailedTrigger = true;
        }
        return hasFailedTrigger ? TriggerFireResult.FAILED_NO_TERMINATION : TriggerFireResult.SUCCESS;
    }

    @Override
    public TriggerFireResult visitInsertTablet(InsertTabletNode node, TriggerEvent context) {
        Map<String, List<String>> triggerNameToMeasurementList = this.constructTriggerNameToMeasurementListMap(node, context);
        if (triggerNameToMeasurementList.isEmpty()) {
            return TriggerFireResult.SUCCESS;
        }
        MeasurementSchema[] measurementSchemas = node.getMeasurementSchemas();
        Map<String, Integer> measurementToSchemaIndexMap = this.constructMeasurementToSchemaIndexMap(node.getMeasurements(), measurementSchemas);
        Object[] columns = node.getColumns();
        BitMap[] bitMaps = node.getBitMaps();
        long[] timestamps = node.getTimes();
        int rowCount = node.getRowCount();
        boolean hasFailedTrigger = false;
        for (Map.Entry<String, List<String>> entry : triggerNameToMeasurementList.entrySet()) {
            Tablet tablet;
            if (entry.getValue().size() == measurementSchemas.length) {
                tablet = new Tablet(node.getDevicePath().getFullPath(), Arrays.asList(measurementSchemas), timestamps, columns, bitMaps, rowCount);
            } else {
                List schemas = entry.getValue().stream().map(measurement -> measurementSchemas[(Integer)measurementToSchemaIndexMap.get(measurement)]).collect(Collectors.toList());
                Object[] columnsOfNewTablet = entry.getValue().stream().map(measurement -> columns[(Integer)measurementToSchemaIndexMap.get(measurement)]).toArray();
                BitMap[] bitMapsOfNewTablet = new BitMap[entry.getValue().size()];
                if (bitMaps != null) {
                    for (int i = 0; i < entry.getValue().size(); ++i) {
                        bitMapsOfNewTablet[i] = bitMaps[measurementToSchemaIndexMap.get(entry.getValue().get(i))];
                    }
                }
                tablet = new Tablet(node.getDevicePath().getFullPath(), schemas, timestamps, columnsOfNewTablet, bitMapsOfNewTablet, rowCount);
            }
            TriggerFireResult result = this.fire(entry.getKey(), tablet, context);
            if (result.equals((Object)TriggerFireResult.TERMINATION)) {
                return result;
            }
            if (!result.equals((Object)TriggerFireResult.FAILED_NO_TERMINATION)) continue;
            hasFailedTrigger = true;
        }
        return hasFailedTrigger ? TriggerFireResult.FAILED_NO_TERMINATION : TriggerFireResult.SUCCESS;
    }

    @Override
    public TriggerFireResult visitInsertRows(InsertRowsNode node, TriggerEvent context) {
        boolean hasFailedTrigger = false;
        for (InsertRowNode insertRowNode : node.getInsertRowNodeList()) {
            TriggerFireResult result = this.visitInsertRow(insertRowNode, context);
            if (result.equals((Object)TriggerFireResult.TERMINATION)) {
                return result;
            }
            if (!result.equals((Object)TriggerFireResult.FAILED_NO_TERMINATION)) continue;
            hasFailedTrigger = true;
        }
        return hasFailedTrigger ? TriggerFireResult.FAILED_NO_TERMINATION : TriggerFireResult.SUCCESS;
    }

    @Override
    public TriggerFireResult visitInsertMultiTablets(InsertMultiTabletsNode node, TriggerEvent context) {
        boolean hasFailedTrigger = false;
        for (InsertTabletNode insertTabletNode : node.getInsertTabletNodeList()) {
            TriggerFireResult result = this.visitInsertTablet(insertTabletNode, context);
            if (result.equals((Object)TriggerFireResult.TERMINATION)) {
                return result;
            }
            if (!result.equals((Object)TriggerFireResult.FAILED_NO_TERMINATION)) continue;
            hasFailedTrigger = true;
        }
        return hasFailedTrigger ? TriggerFireResult.FAILED_NO_TERMINATION : TriggerFireResult.SUCCESS;
    }

    @Override
    public TriggerFireResult visitInsertRowsOfOneDevice(InsertRowsOfOneDeviceNode node, TriggerEvent context) {
        boolean hasFailedTrigger = false;
        for (InsertRowNode insertRowNode : node.getInsertRowNodeList()) {
            TriggerFireResult result = this.visitInsertRow(insertRowNode, context);
            if (result.equals((Object)TriggerFireResult.TERMINATION)) {
                return result;
            }
            if (!result.equals((Object)TriggerFireResult.FAILED_NO_TERMINATION)) continue;
            hasFailedTrigger = true;
        }
        return hasFailedTrigger ? TriggerFireResult.FAILED_NO_TERMINATION : TriggerFireResult.SUCCESS;
    }

    @Override
    public TriggerFireResult visitPipeEnrichedInsert(PipeEnrichedInsertNode node, TriggerEvent context) {
        return node.getInsertNode().accept(this, context);
    }

    private Map<String, Integer> constructMeasurementToSchemaIndexMap(String[] measurements, MeasurementSchema[] schemas) {
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        int n = measurements.length;
        block0: for (int i = 0; i < n; ++i) {
            if (measurements[i] == null) continue;
            if (schemas[i] != null && schemas[i].getMeasurementId().equals(measurements[i])) {
                indexMap.put(measurements[i], i);
                continue;
            }
            int m = schemas.length;
            for (int j = 0; j < m; ++j) {
                if (schemas[j] == null || !schemas[j].getMeasurementId().equals(measurements[i])) continue;
                indexMap.put(measurements[i], j);
                continue block0;
            }
        }
        return indexMap;
    }

    private Map<String, List<String>> constructTriggerNameToMeasurementListMap(InsertNode node, TriggerEvent event) {
        PartialPath device = node.getDevicePath();
        ArrayList<String> measurements = new ArrayList<String>();
        for (String measurement : node.getMeasurements()) {
            if (measurement == null) continue;
            measurements.add(measurement);
        }
        List<List<String>> triggerNameLists = TriggerManagementService.getInstance().getMatchedTriggerListForPath(device, measurements);
        boolean isAllEmpty = true;
        for (List<String> triggerNameList : triggerNameLists) {
            if (triggerNameList.isEmpty()) continue;
            isAllEmpty = false;
            break;
        }
        if (isAllEmpty) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> triggerNameToPaths = new HashMap<String, List<String>>();
        TriggerTable triggerTable = TriggerManagementService.getInstance().getTriggerTable();
        int n = measurements.size();
        for (int i = 0; i < n; ++i) {
            for (String triggerName : triggerNameLists.get(i)) {
                TriggerInformation triggerInformation = triggerTable.getTriggerInformation(triggerName);
                if (!triggerInformation.getEvent().equals((Object)event) || !triggerInformation.getTriggerState().equals((Object)TTriggerState.ACTIVE)) continue;
                triggerNameToPaths.computeIfAbsent(triggerName, k -> new ArrayList()).add((String)measurements.get(i));
            }
        }
        return triggerNameToPaths;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private TriggerFireResult fire(String triggerName, Tablet tablet, TriggerEvent event) {
        TriggerFireResult result = TriggerFireResult.SUCCESS;
        for (int i = 0; i < FIRE_RETRY_NUM; ++i) {
            if (TriggerManagementService.getInstance().needToFireOnAnotherDataNode(triggerName)) {
                TDataNodeLocation tDataNodeLocation = TriggerManagementService.getInstance().getDataNodeLocationOfStatefulTrigger(triggerName);
                try (SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)Coordinator.getInstance().getInternalServiceClientManager().borrowClient((Object)tDataNodeLocation.getInternalEndPoint());){
                    TFireTriggerReq req = new TFireTriggerReq(triggerName, tablet.serialize(), event.getId());
                    TFireTriggerResp resp = client.fireTrigger(req);
                    if (resp.foundExecutor) {
                        TriggerFireResult triggerFireResult = TriggerFireResult.construct(resp.getFireResult());
                        return triggerFireResult;
                    }
                    if (this.updateLocationOfStatefulTrigger(triggerName, tDataNodeLocation.getDataNodeId())) continue;
                    Thread.sleep(4000L);
                    continue;
                }
                catch (ClientManagerException | TException e) {
                    LOGGER.warn("Error occurred when trying to fire trigger({}) on TEndPoint: {}, the cause is: {}", new Object[]{triggerName, tDataNodeLocation.getInternalEndPoint(), e});
                    this.updateLocationOfStatefulTrigger(triggerName, tDataNodeLocation.getDataNodeId());
                    continue;
                }
                catch (InterruptedException e) {
                    LOGGER.warn("{} interrupted when sleep", (Object)triggerName);
                    Thread.currentThread().interrupt();
                    continue;
                }
                catch (Exception e) {
                    LOGGER.warn("Error occurred when trying to fire trigger({}) on TEndPoint: {}, the cause is: {}", new Object[]{triggerName, tDataNodeLocation.getInternalEndPoint(), e});
                    return TriggerManagementService.getInstance().getTriggerInformation(triggerName).getFailureStrategy().equals((Object)FailureStrategy.OPTIMISTIC) ? TriggerFireResult.FAILED_NO_TERMINATION : TriggerFireResult.TERMINATION;
                }
            }
            TriggerExecutor executor = TriggerManagementService.getInstance().getExecutor(triggerName);
            if (executor == null) {
                return TriggerManagementService.getInstance().getTriggerInformation(triggerName).getFailureStrategy().equals((Object)FailureStrategy.PESSIMISTIC) ? TriggerFireResult.TERMINATION : TriggerFireResult.FAILED_NO_TERMINATION;
            }
            try {
                boolean fireResult = executor.fire(tablet, event);
                if (!fireResult) {
                    result = executor.getFailureStrategy().equals((Object)FailureStrategy.PESSIMISTIC) ? TriggerFireResult.TERMINATION : TriggerFireResult.FAILED_NO_TERMINATION;
                }
            }
            catch (TriggerExecutionException e) {
                result = executor.getFailureStrategy().equals((Object)FailureStrategy.PESSIMISTIC) ? TriggerFireResult.TERMINATION : TriggerFireResult.FAILED_NO_TERMINATION;
            }
            return result;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateLocationOfStatefulTrigger(String triggerName, int currentDataNodeId) {
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TDataNodeLocation newTDataNodeLocation = configNodeClient.getLocationOfStatefulTrigger(triggerName).getDataNodeLocation();
            if (newTDataNodeLocation != null && currentDataNodeId != newTDataNodeLocation.getDataNodeId()) {
                TriggerManagementService.getInstance().updateLocationOfStatefulTrigger(triggerName, newTDataNodeLocation);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException | ClientManagerException | TException e) {
            LOGGER.error("Failed to update location of stateful trigger({}) through config node. The cause is {}.", (Object)triggerName, (Object)e);
            return false;
        }
    }
}

