/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.ArrayList;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class TimeValuePairUtils {
    private TimeValuePairUtils() {
    }

    public static TimeValuePair getCurrentTimeValuePair(BatchData data) {
        switch (data.getDataType()) {
            case INT32: {
                return new TimeValuePair(data.currentTime(), (TsPrimitiveType)new TsPrimitiveType.TsInt(data.getInt()));
            }
            case INT64: {
                return new TimeValuePair(data.currentTime(), (TsPrimitiveType)new TsPrimitiveType.TsLong(data.getLong()));
            }
            case FLOAT: {
                return new TimeValuePair(data.currentTime(), (TsPrimitiveType)new TsPrimitiveType.TsFloat(data.getFloat()));
            }
            case DOUBLE: {
                return new TimeValuePair(data.currentTime(), (TsPrimitiveType)new TsPrimitiveType.TsDouble(data.getDouble()));
            }
            case TEXT: {
                return new TimeValuePair(data.currentTime(), (TsPrimitiveType)new TsPrimitiveType.TsBinary(data.getBinary()));
            }
            case BOOLEAN: {
                return new TimeValuePair(data.currentTime(), (TsPrimitiveType)new TsPrimitiveType.TsBoolean(data.getBoolean()));
            }
        }
        throw new UnSupportedDataTypeException(String.valueOf(data.getDataType()));
    }

    public static void setTimeValuePair(TimeValuePair from, TimeValuePair to) {
        to.setTimestamp(from.getTimestamp());
        switch (from.getValue().getDataType()) {
            case INT32: {
                to.getValue().setInt(from.getValue().getInt());
                break;
            }
            case INT64: {
                to.getValue().setLong(from.getValue().getLong());
                break;
            }
            case FLOAT: {
                to.getValue().setFloat(from.getValue().getFloat());
                break;
            }
            case DOUBLE: {
                to.getValue().setDouble(from.getValue().getDouble());
                break;
            }
            case TEXT: {
                to.getValue().setBinary(from.getValue().getBinary());
                break;
            }
            case BOOLEAN: {
                to.getValue().setBoolean(from.getValue().getBoolean());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.valueOf(from.getValue().getDataType()));
            }
        }
    }

    public static TimeValuePair getEmptyTimeValuePair(TSDataType dataType) {
        switch (dataType) {
            case FLOAT: {
                return new TimeValuePair(0L, (TsPrimitiveType)new TsPrimitiveType.TsFloat(0.0f));
            }
            case INT32: {
                return new TimeValuePair(0L, (TsPrimitiveType)new TsPrimitiveType.TsInt(0));
            }
            case INT64: {
                return new TimeValuePair(0L, (TsPrimitiveType)new TsPrimitiveType.TsLong(0L));
            }
            case BOOLEAN: {
                return new TimeValuePair(0L, (TsPrimitiveType)new TsPrimitiveType.TsBoolean(false));
            }
            case DOUBLE: {
                return new TimeValuePair(0L, (TsPrimitiveType)new TsPrimitiveType.TsDouble(0.0));
            }
            case TEXT: {
                return new TimeValuePair(0L, (TsPrimitiveType)new TsPrimitiveType.TsBinary(new Binary("", TSFileConfig.STRING_CHARSET)));
            }
        }
        throw new UnsupportedOperationException("Unrecognized datatype: " + dataType);
    }

    public static class Intervals
    extends ArrayList<Long> {
        static final Intervals ALL_INTERVAL = new Intervals(Long.MIN_VALUE, Long.MAX_VALUE);

        public Intervals() {
        }

        Intervals(long lowerBound, long upperBound) {
            this.addInterval(lowerBound, upperBound);
        }

        public int getIntervalSize() {
            return this.size() / 2;
        }

        public long getLowerBound(int index) {
            return (Long)this.get(index * 2);
        }

        public long getUpperBound(int index) {
            return (Long)this.get(index * 2 + 1);
        }

        void setLowerBound(int index, long lb) {
            this.set(index * 2, lb);
        }

        void setUpperBound(int index, long ub) {
            this.set(index * 2 + 1, ub);
        }

        public void addInterval(long lowerBound, long upperBound) {
            this.add(lowerBound);
            this.add(upperBound);
        }

        Intervals intersection(Intervals that) {
            Intervals result = new Intervals();
            int thisSize = this.getIntervalSize();
            int thatSize = that.getIntervalSize();
            for (int i = 0; i < thisSize; ++i) {
                for (int j = 0; j < thatSize; ++j) {
                    long thisLB = this.getLowerBound(i);
                    long thisUB = this.getUpperBound(i);
                    long thatLB = that.getLowerBound(i);
                    long thatUB = that.getUpperBound(i);
                    if (thisUB < thatLB) continue;
                    if (thisUB <= thatUB) {
                        result.addInterval(Math.max(thisLB, thatLB), thisUB);
                        continue;
                    }
                    if (thisLB > thatUB) continue;
                    result.addInterval(Math.max(thisLB, thatLB), thatUB);
                }
            }
            return result;
        }

        Intervals union(Intervals that) {
            if (this.isEmpty()) {
                return that;
            }
            if (that.isEmpty()) {
                return this;
            }
            Intervals result = new Intervals();
            int thisSize = this.getIntervalSize();
            int thatSize = that.getIntervalSize();
            int thisIndex = 0;
            int thatIndex = 0;
            while (thisIndex < thisSize && thatIndex < thatSize) {
                long thisLB = this.getLowerBound(thisIndex);
                long thisUB = this.getUpperBound(thisIndex);
                long thatLB = that.getLowerBound(thatIndex);
                long thatUB = that.getUpperBound(thatIndex);
                if (thisLB <= thatLB) {
                    result.mergeLast(thisLB, thisUB);
                    ++thisIndex;
                    continue;
                }
                result.mergeLast(thatLB, thatUB);
                ++thatIndex;
            }
            Intervals remainingIntervals = thisIndex < thisSize ? this : that;
            int remainingIndex = thisIndex < thisSize ? thisIndex : thatIndex;
            this.mergeRemainingIntervals(remainingIndex, remainingIntervals, result);
            return result;
        }

        private void mergeRemainingIntervals(int remainingIndex, Intervals remainingIntervals, Intervals result) {
            for (int i = remainingIndex; i < remainingIntervals.getIntervalSize(); ++i) {
                long lb = remainingIntervals.getLowerBound(i);
                long ub = remainingIntervals.getUpperBound(i);
                result.mergeLast(lb, ub);
            }
        }

        private void mergeLast(long lowerBound, long upperBound) {
            if (this.getIntervalSize() == 0) {
                this.addInterval(lowerBound, upperBound);
                return;
            }
            int lastIndex = this.getIntervalSize() - 1;
            long lastLB = this.getLowerBound(lastIndex);
            long lastUB = this.getUpperBound(lastIndex);
            if (lowerBound > lastUB + 1L) {
                this.addInterval(lowerBound, upperBound);
                return;
            }
            if (upperBound < lastLB - 1L) {
                return;
            }
            this.setLowerBound(lastIndex, Math.min(lastLB, lowerBound));
            this.setUpperBound(lastIndex, Math.max(lastUB, upperBound));
        }

        public Intervals not() {
            if (this.isEmpty()) {
                return ALL_INTERVAL;
            }
            Intervals result = new Intervals();
            long firstLB = this.getLowerBound(0);
            if (firstLB != Long.MIN_VALUE) {
                result.addInterval(Long.MIN_VALUE, firstLB - 1L);
            }
            int intervalSize = this.getIntervalSize();
            for (int i = 0; i < intervalSize - 1; ++i) {
                long nextLB;
                long currentUB = this.getUpperBound(i);
                if (currentUB + 1L > (nextLB = this.getLowerBound(i + 1)) - 1L) continue;
                result.addInterval(currentUB + 1L, nextLB - 1L);
            }
            long lastUB = this.getUpperBound(result.getIntervalSize() - 1);
            if (lastUB != Long.MAX_VALUE) {
                result.addInterval(lastUB + 1L, Long.MAX_VALUE);
            }
            return result;
        }
    }
}

