/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.columngenerator.parameter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.db.utils.columngenerator.ColumnGeneratorType;
import org.apache.iotdb.db.utils.columngenerator.parameter.SlidingTimeColumnGeneratorParameter;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public abstract class ColumnGeneratorParameter {
    protected ColumnGeneratorType generatorType;

    public ColumnGeneratorParameter(ColumnGeneratorType generatorType) {
        this.generatorType = generatorType;
    }

    public ColumnGeneratorType getGeneratorType() {
        return this.generatorType;
    }

    protected abstract void serializeAttributes(ByteBuffer var1);

    protected abstract void serializeAttributes(DataOutputStream var1) throws IOException;

    public void serialize(ByteBuffer buffer) {
        ReadWriteIOUtils.write((byte)this.generatorType.getType(), (ByteBuffer)buffer);
        this.serializeAttributes(buffer);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((byte)this.generatorType.getType(), (OutputStream)stream);
        this.serializeAttributes(stream);
    }

    public abstract List<String> getColumnNames();

    public abstract List<TSDataType> getColumnTypes();

    public boolean equals(Object obj) {
        if (!(obj instanceof ColumnGeneratorParameter)) {
            return false;
        }
        ColumnGeneratorParameter other = (ColumnGeneratorParameter)obj;
        return this.generatorType == other.generatorType;
    }

    public int hashCode() {
        return this.generatorType.hashCode();
    }

    public static ColumnGeneratorParameter deserialize(ByteBuffer byteBuffer) {
        byte type = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        if (type == ColumnGeneratorType.SLIDING_TIME.getType()) {
            return SlidingTimeColumnGeneratorParameter.deserialize(byteBuffer);
        }
        throw new UnsupportedOperationException("Unsupported ColumnGeneratorType: " + type);
    }
}

