/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.web.grafana.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.web.grafana.bean.TimeValues;
import org.apache.iotdb.web.grafana.service.DatabaseConnectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@CrossOrigin
@Controller
public class DatabaseConnectController {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseConnectController.class);
    public static final Gson GSON = new GsonBuilder().create();
    @Autowired
    private DatabaseConnectService databaseConnectService;

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public void testDataConnection(HttpServletResponse response) throws IOException {
        logger.info("Connection is ok now!");
        response.getWriter().print("I have sent a message.");
    }

    @RequestMapping(value={"/search"})
    @ResponseBody
    public String metricFindQuery() {
        JsonObject root = new JsonObject();
        List columnsName = new ArrayList();
        try {
            columnsName = this.databaseConnectService.getMetaData();
        }
        catch (Exception e) {
            logger.error("Failed to get metadata", (Throwable)e);
        }
        Collections.sort(columnsName);
        for (int i = 0; i < columnsName.size(); ++i) {
            root.addProperty(String.valueOf(i), (String)columnsName.get(i));
        }
        return root.toString();
    }

    @RequestMapping(value={"/query"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String query(@RequestBody String json) {
        String targetStr = "target";
        try {
            JsonObject jsonObject = (JsonObject)GSON.fromJson(json, JsonObject.class);
            if (Objects.isNull(jsonObject)) {
                return null;
            }
            Pair timeRange = this.getTimeFromAndTo(jsonObject);
            JsonArray array = jsonObject.getAsJsonArray("targets");
            JsonArray result = new JsonArray();
            for (int i = 0; i < array.size(); ++i) {
                JsonObject object = array.get(i).getAsJsonObject();
                if (!object.has(targetStr)) continue;
                String target = object.get(targetStr).getAsString();
                JsonObject obj = new JsonObject();
                obj.addProperty("target", target);
                String type = this.getJsonType(object);
                if ("table".equals(type)) {
                    this.setJsonTable(obj, target, timeRange);
                } else if ("timeserie".equals(type)) {
                    this.setJsonTimeseries(obj, target, timeRange);
                }
                result.add((JsonElement)obj);
            }
            logger.info("query finished");
            return result.toString();
        }
        catch (Exception e) {
            logger.error("/query failed, request body is {}", (Object)json, (Object)e);
            return null;
        }
    }

    private Pair<ZonedDateTime, ZonedDateTime> getTimeFromAndTo(JsonObject jsonObject) {
        JsonObject obj = jsonObject.getAsJsonObject("range");
        Instant from = Instant.parse(obj.get("from").getAsString());
        Instant to = Instant.parse(obj.get("to").getAsString());
        return new Pair((Object)from.atZone(ZoneId.of("Asia/Shanghai")), (Object)to.atZone(ZoneId.of("Asia/Shanghai")));
    }

    private void setJsonTable(JsonObject obj, String target, Pair<ZonedDateTime, ZonedDateTime> timeRange) {
        List timeValues = this.databaseConnectService.querySeries(target, timeRange);
        JsonArray columns = new JsonArray();
        JsonObject column = new JsonObject();
        column.addProperty("text", "Time");
        column.addProperty("type", "time");
        columns.add((JsonElement)column);
        column = new JsonObject();
        column.addProperty("text", "Number");
        column.addProperty("type", "number");
        columns.add((JsonElement)column);
        obj.add("columns", (JsonElement)columns);
        JsonArray values = new JsonArray();
        for (TimeValues tv : timeValues) {
            JsonArray value = new JsonArray();
            value.add((Number)tv.getTime());
            value.add(GSON.toJsonTree(tv.getValue()));
            values.add((JsonElement)value);
        }
        obj.add("values", (JsonElement)values);
    }

    private void setJsonTimeseries(JsonObject obj, String target, Pair<ZonedDateTime, ZonedDateTime> timeRange) {
        List timeValues = this.databaseConnectService.querySeries(target, timeRange);
        logger.info("query size: {}", (Object)timeValues.size());
        JsonArray dataPoints = new JsonArray();
        for (TimeValues tv : timeValues) {
            long time = tv.getTime();
            Object value = tv.getValue();
            JsonArray jsonArray = new JsonArray();
            jsonArray.add(GSON.toJsonTree(value));
            jsonArray.add((Number)time);
            dataPoints.add((JsonElement)jsonArray);
        }
        obj.add("datapoints", (JsonElement)dataPoints);
    }

    public String getJsonType(JsonObject jsonObject) {
        return jsonObject.get("type").getAsString();
    }
}

