/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.web.grafana.dao.impl;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.web.grafana.bean.TimeValues;
import org.apache.iotdb.web.grafana.dao.BasicDao;
import org.apache.iotdb.web.grafana.dao.impl.BasicDaoImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

/*
 * Exception performing whole class analysis ignored.
 */
@Repository
@PropertySource(value={"classpath:application.properties"})
public class BasicDaoImpl
implements BasicDao {
    private static final Logger logger = LoggerFactory.getLogger(BasicDaoImpl.class);
    private final JdbcTemplate jdbcTemplate;
    private static long timestampRadioX = -1L;
    @Value(value="${timestamp_precision}")
    private String timestampPrecision = "ms";
    @Value(value="${isDownSampling}")
    private boolean isDownSampling;
    @Value(value="${continuous_data_function}")
    private String continuousDataFunction;
    @Value(value="${discrete_data_function}")
    private String discreteDataFunction;
    @Value(value="${interval}")
    private String interval;

    @Autowired
    public BasicDaoImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<String> getMetaData() {
        return (List)this.jdbcTemplate.execute(connection -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public static void setTimestampRadioX(String timestampPrecision) {
        switch (timestampPrecision) {
            case "us": {
                timestampRadioX = 1000L;
                break;
            }
            case "ns": {
                timestampRadioX = 1000000L;
                break;
            }
            default: {
                timestampRadioX = 1L;
            }
        }
        logger.info("Use timestamp precision {}", (Object)timestampPrecision);
    }

    public List<TimeValues> querySeries(String s, Pair<ZonedDateTime, ZonedDateTime> timeRange) {
        if (timestampRadioX == -1L) {
            BasicDaoImpl.setTimestampRadioX((String)this.timestampPrecision);
        }
        try {
            return this.querySeriesInternal(s, timeRange, this.continuousDataFunction);
        }
        catch (Exception e) {
            try {
                return this.querySeriesInternal(s, timeRange, this.discreteDataFunction);
            }
            catch (Exception e2) {
                logger.warn("Even {} query did not succeed, returning NULL now", (Object)this.discreteDataFunction, (Object)e2);
                return Collections.emptyList();
            }
        }
    }

    public List<TimeValues> querySeriesInternal(String s, Pair<ZonedDateTime, ZonedDateTime> timeRange, String function) {
        long from = this.zonedCovertToLong((ZonedDateTime)timeRange.left);
        long to = this.zonedCovertToLong((ZonedDateTime)timeRange.right);
        long hours = Duration.between((Temporal)timeRange.left, (Temporal)timeRange.right).toHours();
        String sql = "SELECT ? FROM root.? WHERE time > ? and time < ?";
        Object[] params = new Object[]{s.substring(s.lastIndexOf(46) + 1), s.substring(0, s.lastIndexOf(46)), from * timestampRadioX, to * timestampRadioX};
        String columnName = "root." + s;
        String intervalLocal = this.getInterval(hours);
        if (!"".equals(intervalLocal)) {
            sql = "SELECT ?(?) FROM root.? WHERE time > ? and time < ? group by ([?, ?),?)";
            params = new Object[]{function, s.substring(s.lastIndexOf(46) + 1), s.substring(0, s.lastIndexOf(46)), from * timestampRadioX, to * timestampRadioX, from * timestampRadioX, to * timestampRadioX, intervalLocal};
            columnName = function + "(root." + s + ")";
        }
        logger.info("SQL: {}, Params: {}", (Object)sql, (Object)params);
        return this.jdbcTemplate.query(sql, params, (RowMapper)new TimeValuesRowMapper(columnName));
    }

    public String getInterval(long hours) {
        if (!this.isDownSampling || hours <= 1L) {
            return "";
        }
        if (hours < 720L && hours > 24L) {
            return "1h";
        }
        if (hours > 720L) {
            return "1d";
        }
        return this.interval;
    }

    private long zonedCovertToLong(ZonedDateTime time) {
        return time.toInstant().toEpochMilli();
    }

    static /* synthetic */ long access$000() {
        return timestampRadioX;
    }
}

