/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.web.grafana.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.web.grafana.bean.TimeValues;
import org.apache.iotdb.web.grafana.service.DatabaseConnectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@CrossOrigin
@Controller
public class DatabaseConnectController {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseConnectController.class);
    @Autowired
    private DatabaseConnectService databaseConnectService;

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public void testDataConnection(HttpServletResponse response) throws IOException {
        logger.info("Connection is ok now!");
        response.getWriter().print("I have sent a message.");
    }

    @RequestMapping(value={"/search"})
    @ResponseBody
    public String metricFindQuery(HttpServletRequest request, HttpServletResponse response) {
        HashMap target = new HashMap();
        JSONObject jsonObject = new JSONObject();
        response.setStatus(200);
        List columnsName = new ArrayList();
        try {
            columnsName = this.databaseConnectService.getMetaData();
        }
        catch (Exception e) {
            logger.error("Failed to get metadata", (Throwable)e);
        }
        Collections.sort(columnsName);
        for (int i = 0; i < columnsName.size(); ++i) {
            jsonObject.put(i + "", columnsName.get(i));
        }
        return jsonObject.toString();
    }

    @RequestMapping(value={"/query"})
    @ResponseBody
    public String query(HttpServletRequest request, HttpServletResponse response) {
        String targetStr = "target";
        response.setStatus(200);
        try {
            JSONObject jsonObject = this.getRequestBodyJson(request);
            Pair timeRange = this.getTimeFromAndTo(jsonObject);
            JSONArray array = (JSONArray)jsonObject.get((Object)"targets");
            JSONArray result = new JSONArray();
            for (int i = 0; i < array.size(); ++i) {
                JSONObject object = (JSONObject)array.get(i);
                if (!object.containsKey((Object)targetStr)) {
                    return "[]";
                }
                String target = (String)object.get((Object)targetStr);
                String type = this.getJsonType(jsonObject);
                JSONObject obj = new JSONObject();
                obj.put("target", (Object)target);
                if (type.equals("table")) {
                    this.setJsonTable(obj, target, timeRange);
                } else if (type.equals("timeserie")) {
                    this.setJsonTimeseries(obj, target, timeRange);
                }
                result.add(i, (Object)obj);
            }
            logger.info("query finished");
            return result.toString();
        }
        catch (Exception e) {
            logger.error("/query failed", (Throwable)e);
            return null;
        }
    }

    private Pair<ZonedDateTime, ZonedDateTime> getTimeFromAndTo(JSONObject jsonObject) throws JSONException {
        JSONObject obj = (JSONObject)jsonObject.get((Object)"range");
        Instant from = Instant.parse((String)obj.get((Object)"from"));
        Instant to = Instant.parse((String)obj.get((Object)"to"));
        return new Pair((Object)from.atZone(ZoneId.of("Asia/Shanghai")), (Object)to.atZone(ZoneId.of("Asia/Shanghai")));
    }

    private void setJsonTable(JSONObject obj, String target, Pair<ZonedDateTime, ZonedDateTime> timeRange) throws JSONException {
        List timeValues = this.databaseConnectService.querySeries(target, timeRange);
        JSONArray columns = new JSONArray();
        JSONObject column = new JSONObject();
        column.put("text", (Object)"Time");
        column.put("type", (Object)"time");
        columns.add((Object)column);
        column = new JSONObject();
        column.put("text", (Object)"Number");
        column.put("type", (Object)"number");
        columns.add((Object)column);
        obj.put("columns", (Object)columns);
        JSONArray values = new JSONArray();
        for (TimeValues tv : timeValues) {
            JSONArray value = new JSONArray();
            value.add((Object)tv.getTime());
            value.add((Object)Float.valueOf(tv.getValue()));
            values.add((Object)value);
        }
        obj.put("values", (Object)values);
    }

    private void setJsonTimeseries(JSONObject obj, String target, Pair<ZonedDateTime, ZonedDateTime> timeRange) throws JSONException {
        List timeValues = this.databaseConnectService.querySeries(target, timeRange);
        logger.info("query size: {}", (Object)timeValues.size());
        JSONArray dataPoints = new JSONArray();
        for (TimeValues tv : timeValues) {
            long time = tv.getTime();
            float value = tv.getValue();
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)Float.valueOf(value));
            jsonArray.add((Object)time);
            dataPoints.add((Object)jsonArray);
        }
        obj.put("datapoints", (Object)dataPoints);
    }

    public JSONObject getRequestBodyJson(HttpServletRequest request) throws JSONException {
        try {
            String line;
            BufferedReader br = request.getReader();
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            return JSON.parseObject((String)sb.toString());
        }
        catch (IOException e) {
            logger.error("getRequestBodyJson failed", (Throwable)e);
            return null;
        }
    }

    public String getJsonType(JSONObject jsonObject) throws JSONException {
        JSONArray array = (JSONArray)jsonObject.get((Object)"targets");
        JSONObject object = (JSONObject)array.get(0);
        return (String)object.get((Object)"type");
    }
}

