/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.web.grafana.dao.impl;

import java.time.ZonedDateTime;
import java.util.List;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.web.grafana.bean.TimeValues;
import org.apache.iotdb.web.grafana.dao.BasicDao;
import org.apache.iotdb.web.grafana.dao.impl.BasicDaoImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class BasicDaoImpl
implements BasicDao {
    private static final Logger logger = LoggerFactory.getLogger(BasicDaoImpl.class);
    private final JdbcTemplate jdbcTemplate;

    @Autowired
    public BasicDaoImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<String> getMetaData() {
        1 connectionCallback = new /* Unavailable Anonymous Inner Class!! */;
        return (List)this.jdbcTemplate.execute((ConnectionCallback)connectionCallback);
    }

    public List<TimeValues> querySeries(String s, Pair<ZonedDateTime, ZonedDateTime> timeRange) {
        Long from = this.zonedCovertToLong((ZonedDateTime)timeRange.left);
        Long to = this.zonedCovertToLong((ZonedDateTime)timeRange.right);
        String sql = "SELECT " + s.substring(s.lastIndexOf(46) + 1) + " FROM root." + s.substring(0, s.lastIndexOf(46)) + " WHERE time > " + from + " and time < " + to;
        logger.info(sql);
        List rows = null;
        try {
            rows = this.jdbcTemplate.query(sql, (RowMapper)new TimeValuesRowMapper("root." + s));
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return rows;
    }

    private Long zonedCovertToLong(ZonedDateTime time) {
        return time.toInstant().toEpochMilli();
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

