// Code generated by Thrift Compiler (0.14.1). DO NOT EDIT.

package cluster

import(
	"bytes"
	"context"
	"fmt"
	"time"
	"github.com/apache/thrift/lib/go/thrift"
	"rpc"

)

// (needed to ensure safety because of naive import list construction.)
var _ = thrift.ZERO
var _ = fmt.Printf
var _ = context.Background
var _ = time.Now
var _ = bytes.Equal

var _ = rpc.GoUnusedProtection__
type Int int32

func IntPtr(v Int) *Int { return &v }

type Long int64

func LongPtr(v Long) *Long { return &v }

// Attributes:
//  - Term
//  - CommitLogIndex
//  - CommitLogTerm
//  - Leader
//  - RequireIdentifier
//  - RegenerateIdentifier
//  - PartitionTableBytes
//  - Header
type HeartBeatRequest struct {
  Term Long `thrift:"term,1,required" db:"term" json:"term"`
  CommitLogIndex Long `thrift:"commitLogIndex,2,required" db:"commitLogIndex" json:"commitLogIndex"`
  CommitLogTerm Long `thrift:"commitLogTerm,3,required" db:"commitLogTerm" json:"commitLogTerm"`
  Leader *Node `thrift:"leader,4,required" db:"leader" json:"leader"`
  RequireIdentifier bool `thrift:"requireIdentifier,5,required" db:"requireIdentifier" json:"requireIdentifier"`
  RegenerateIdentifier bool `thrift:"regenerateIdentifier,6,required" db:"regenerateIdentifier" json:"regenerateIdentifier"`
  PartitionTableBytes []byte `thrift:"partitionTableBytes,7" db:"partitionTableBytes" json:"partitionTableBytes,omitempty"`
  Header *RaftNode `thrift:"header,8" db:"header" json:"header,omitempty"`
}

func NewHeartBeatRequest() *HeartBeatRequest {
  return &HeartBeatRequest{}
}


func (p *HeartBeatRequest) GetTerm() Long {
  return p.Term
}

func (p *HeartBeatRequest) GetCommitLogIndex() Long {
  return p.CommitLogIndex
}

func (p *HeartBeatRequest) GetCommitLogTerm() Long {
  return p.CommitLogTerm
}
var HeartBeatRequest_Leader_DEFAULT *Node
func (p *HeartBeatRequest) GetLeader() *Node {
  if !p.IsSetLeader() {
    return HeartBeatRequest_Leader_DEFAULT
  }
return p.Leader
}

func (p *HeartBeatRequest) GetRequireIdentifier() bool {
  return p.RequireIdentifier
}

func (p *HeartBeatRequest) GetRegenerateIdentifier() bool {
  return p.RegenerateIdentifier
}
var HeartBeatRequest_PartitionTableBytes_DEFAULT []byte

func (p *HeartBeatRequest) GetPartitionTableBytes() []byte {
  return p.PartitionTableBytes
}
var HeartBeatRequest_Header_DEFAULT *RaftNode
func (p *HeartBeatRequest) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return HeartBeatRequest_Header_DEFAULT
  }
return p.Header
}
func (p *HeartBeatRequest) IsSetLeader() bool {
  return p.Leader != nil
}

func (p *HeartBeatRequest) IsSetPartitionTableBytes() bool {
  return p.PartitionTableBytes != nil
}

func (p *HeartBeatRequest) IsSetHeader() bool {
  return p.Header != nil
}

func (p *HeartBeatRequest) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetTerm bool = false;
  var issetCommitLogIndex bool = false;
  var issetCommitLogTerm bool = false;
  var issetLeader bool = false;
  var issetRequireIdentifier bool = false;
  var issetRegenerateIdentifier bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetTerm = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetCommitLogIndex = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetCommitLogTerm = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetLeader = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetRequireIdentifier = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
        issetRegenerateIdentifier = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 8:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField8(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetTerm{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Term is not set"));
  }
  if !issetCommitLogIndex{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field CommitLogIndex is not set"));
  }
  if !issetCommitLogTerm{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field CommitLogTerm is not set"));
  }
  if !issetLeader{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Leader is not set"));
  }
  if !issetRequireIdentifier{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field RequireIdentifier is not set"));
  }
  if !issetRegenerateIdentifier{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field RegenerateIdentifier is not set"));
  }
  return nil
}

func (p *HeartBeatRequest)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  temp := Long(v)
  p.Term = temp
}
  return nil
}

func (p *HeartBeatRequest)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  temp := Long(v)
  p.CommitLogIndex = temp
}
  return nil
}

func (p *HeartBeatRequest)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  temp := Long(v)
  p.CommitLogTerm = temp
}
  return nil
}

func (p *HeartBeatRequest)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  p.Leader = &Node{}
  if err := p.Leader.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Leader), err)
  }
  return nil
}

func (p *HeartBeatRequest)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.RequireIdentifier = v
}
  return nil
}

func (p *HeartBeatRequest)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.RegenerateIdentifier = v
}
  return nil
}

func (p *HeartBeatRequest)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 7: ", err)
} else {
  p.PartitionTableBytes = v
}
  return nil
}

func (p *HeartBeatRequest)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *HeartBeatRequest) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "HeartBeatRequest"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
    if err := p.writeField8(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *HeartBeatRequest) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "term", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:term: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.Term)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.term (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:term: ", p), err) }
  return err
}

func (p *HeartBeatRequest) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "commitLogIndex", thrift.I64, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:commitLogIndex: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.CommitLogIndex)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.commitLogIndex (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:commitLogIndex: ", p), err) }
  return err
}

func (p *HeartBeatRequest) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "commitLogTerm", thrift.I64, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:commitLogTerm: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.CommitLogTerm)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.commitLogTerm (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:commitLogTerm: ", p), err) }
  return err
}

func (p *HeartBeatRequest) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "leader", thrift.STRUCT, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:leader: ", p), err) }
  if err := p.Leader.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Leader), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:leader: ", p), err) }
  return err
}

func (p *HeartBeatRequest) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "requireIdentifier", thrift.BOOL, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:requireIdentifier: ", p), err) }
  if err := oprot.WriteBool(ctx, bool(p.RequireIdentifier)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.requireIdentifier (5) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:requireIdentifier: ", p), err) }
  return err
}

func (p *HeartBeatRequest) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "regenerateIdentifier", thrift.BOOL, 6); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:regenerateIdentifier: ", p), err) }
  if err := oprot.WriteBool(ctx, bool(p.RegenerateIdentifier)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.regenerateIdentifier (6) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 6:regenerateIdentifier: ", p), err) }
  return err
}

func (p *HeartBeatRequest) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetPartitionTableBytes() {
    if err := oprot.WriteFieldBegin(ctx, "partitionTableBytes", thrift.STRING, 7); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:partitionTableBytes: ", p), err) }
    if err := oprot.WriteBinary(ctx, p.PartitionTableBytes); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.partitionTableBytes (7) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 7:partitionTableBytes: ", p), err) }
  }
  return err
}

func (p *HeartBeatRequest) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetHeader() {
    if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 8); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:header: ", p), err) }
    if err := p.Header.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 8:header: ", p), err) }
  }
  return err
}

func (p *HeartBeatRequest) Equals(other *HeartBeatRequest) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.Term != other.Term { return false }
  if p.CommitLogIndex != other.CommitLogIndex { return false }
  if p.CommitLogTerm != other.CommitLogTerm { return false }
  if !p.Leader.Equals(other.Leader) { return false }
  if p.RequireIdentifier != other.RequireIdentifier { return false }
  if p.RegenerateIdentifier != other.RegenerateIdentifier { return false }
  if bytes.Compare(p.PartitionTableBytes, other.PartitionTableBytes) != 0 { return false }
  if !p.Header.Equals(other.Header) { return false }
  return true
}

func (p *HeartBeatRequest) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("HeartBeatRequest(%+v)", *p)
}

// Attributes:
//  - Term
//  - LastLogIndex
//  - LastLogTerm
//  - Follower
//  - FollowerIdentifier
//  - RequirePartitionTable
//  - Header
//  - InstallingSnapshot
type HeartBeatResponse struct {
  Term Long `thrift:"term,1,required" db:"term" json:"term"`
  LastLogIndex *Long `thrift:"lastLogIndex,2" db:"lastLogIndex" json:"lastLogIndex,omitempty"`
  LastLogTerm *Long `thrift:"lastLogTerm,3" db:"lastLogTerm" json:"lastLogTerm,omitempty"`
  Follower *Node `thrift:"follower,4" db:"follower" json:"follower,omitempty"`
  FollowerIdentifier *Int `thrift:"followerIdentifier,5" db:"followerIdentifier" json:"followerIdentifier,omitempty"`
  RequirePartitionTable bool `thrift:"requirePartitionTable,6,required" db:"requirePartitionTable" json:"requirePartitionTable"`
  Header *Node `thrift:"header,7" db:"header" json:"header,omitempty"`
  InstallingSnapshot bool `thrift:"installingSnapshot,8,required" db:"installingSnapshot" json:"installingSnapshot"`
}

func NewHeartBeatResponse() *HeartBeatResponse {
  return &HeartBeatResponse{}
}


func (p *HeartBeatResponse) GetTerm() Long {
  return p.Term
}
var HeartBeatResponse_LastLogIndex_DEFAULT Long
func (p *HeartBeatResponse) GetLastLogIndex() Long {
  if !p.IsSetLastLogIndex() {
    return HeartBeatResponse_LastLogIndex_DEFAULT
  }
return *p.LastLogIndex
}
var HeartBeatResponse_LastLogTerm_DEFAULT Long
func (p *HeartBeatResponse) GetLastLogTerm() Long {
  if !p.IsSetLastLogTerm() {
    return HeartBeatResponse_LastLogTerm_DEFAULT
  }
return *p.LastLogTerm
}
var HeartBeatResponse_Follower_DEFAULT *Node
func (p *HeartBeatResponse) GetFollower() *Node {
  if !p.IsSetFollower() {
    return HeartBeatResponse_Follower_DEFAULT
  }
return p.Follower
}
var HeartBeatResponse_FollowerIdentifier_DEFAULT Int
func (p *HeartBeatResponse) GetFollowerIdentifier() Int {
  if !p.IsSetFollowerIdentifier() {
    return HeartBeatResponse_FollowerIdentifier_DEFAULT
  }
return *p.FollowerIdentifier
}

func (p *HeartBeatResponse) GetRequirePartitionTable() bool {
  return p.RequirePartitionTable
}
var HeartBeatResponse_Header_DEFAULT *Node
func (p *HeartBeatResponse) GetHeader() *Node {
  if !p.IsSetHeader() {
    return HeartBeatResponse_Header_DEFAULT
  }
return p.Header
}

func (p *HeartBeatResponse) GetInstallingSnapshot() bool {
  return p.InstallingSnapshot
}
func (p *HeartBeatResponse) IsSetLastLogIndex() bool {
  return p.LastLogIndex != nil
}

func (p *HeartBeatResponse) IsSetLastLogTerm() bool {
  return p.LastLogTerm != nil
}

func (p *HeartBeatResponse) IsSetFollower() bool {
  return p.Follower != nil
}

func (p *HeartBeatResponse) IsSetFollowerIdentifier() bool {
  return p.FollowerIdentifier != nil
}

func (p *HeartBeatResponse) IsSetHeader() bool {
  return p.Header != nil
}

func (p *HeartBeatResponse) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetTerm bool = false;
  var issetRequirePartitionTable bool = false;
  var issetInstallingSnapshot bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetTerm = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
        issetRequirePartitionTable = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 8:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField8(ctx, iprot); err != nil {
          return err
        }
        issetInstallingSnapshot = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetTerm{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Term is not set"));
  }
  if !issetRequirePartitionTable{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field RequirePartitionTable is not set"));
  }
  if !issetInstallingSnapshot{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field InstallingSnapshot is not set"));
  }
  return nil
}

func (p *HeartBeatResponse)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  temp := Long(v)
  p.Term = temp
}
  return nil
}

func (p *HeartBeatResponse)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  temp := Long(v)
  p.LastLogIndex = &temp
}
  return nil
}

func (p *HeartBeatResponse)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  temp := Long(v)
  p.LastLogTerm = &temp
}
  return nil
}

func (p *HeartBeatResponse)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  p.Follower = &Node{}
  if err := p.Follower.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Follower), err)
  }
  return nil
}

func (p *HeartBeatResponse)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  temp := Int(v)
  p.FollowerIdentifier = &temp
}
  return nil
}

func (p *HeartBeatResponse)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.RequirePartitionTable = v
}
  return nil
}

func (p *HeartBeatResponse)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &Node{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *HeartBeatResponse)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 8: ", err)
} else {
  p.InstallingSnapshot = v
}
  return nil
}

func (p *HeartBeatResponse) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "HeartBeatResponse"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
    if err := p.writeField8(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *HeartBeatResponse) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "term", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:term: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.Term)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.term (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:term: ", p), err) }
  return err
}

func (p *HeartBeatResponse) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetLastLogIndex() {
    if err := oprot.WriteFieldBegin(ctx, "lastLogIndex", thrift.I64, 2); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:lastLogIndex: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.LastLogIndex)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.lastLogIndex (2) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 2:lastLogIndex: ", p), err) }
  }
  return err
}

func (p *HeartBeatResponse) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetLastLogTerm() {
    if err := oprot.WriteFieldBegin(ctx, "lastLogTerm", thrift.I64, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:lastLogTerm: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.LastLogTerm)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.lastLogTerm (3) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:lastLogTerm: ", p), err) }
  }
  return err
}

func (p *HeartBeatResponse) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetFollower() {
    if err := oprot.WriteFieldBegin(ctx, "follower", thrift.STRUCT, 4); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:follower: ", p), err) }
    if err := p.Follower.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Follower), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 4:follower: ", p), err) }
  }
  return err
}

func (p *HeartBeatResponse) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetFollowerIdentifier() {
    if err := oprot.WriteFieldBegin(ctx, "followerIdentifier", thrift.I32, 5); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:followerIdentifier: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.FollowerIdentifier)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.followerIdentifier (5) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 5:followerIdentifier: ", p), err) }
  }
  return err
}

func (p *HeartBeatResponse) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "requirePartitionTable", thrift.BOOL, 6); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:requirePartitionTable: ", p), err) }
  if err := oprot.WriteBool(ctx, bool(p.RequirePartitionTable)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.requirePartitionTable (6) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 6:requirePartitionTable: ", p), err) }
  return err
}

func (p *HeartBeatResponse) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetHeader() {
    if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 7); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:header: ", p), err) }
    if err := p.Header.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 7:header: ", p), err) }
  }
  return err
}

func (p *HeartBeatResponse) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "installingSnapshot", thrift.BOOL, 8); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:installingSnapshot: ", p), err) }
  if err := oprot.WriteBool(ctx, bool(p.InstallingSnapshot)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.installingSnapshot (8) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 8:installingSnapshot: ", p), err) }
  return err
}

func (p *HeartBeatResponse) Equals(other *HeartBeatResponse) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.Term != other.Term { return false }
  if p.LastLogIndex != other.LastLogIndex {
    if p.LastLogIndex == nil || other.LastLogIndex == nil {
      return false
    }
    if (*p.LastLogIndex) != (*other.LastLogIndex) { return false }
  }
  if p.LastLogTerm != other.LastLogTerm {
    if p.LastLogTerm == nil || other.LastLogTerm == nil {
      return false
    }
    if (*p.LastLogTerm) != (*other.LastLogTerm) { return false }
  }
  if !p.Follower.Equals(other.Follower) { return false }
  if p.FollowerIdentifier != other.FollowerIdentifier {
    if p.FollowerIdentifier == nil || other.FollowerIdentifier == nil {
      return false
    }
    if (*p.FollowerIdentifier) != (*other.FollowerIdentifier) { return false }
  }
  if p.RequirePartitionTable != other.RequirePartitionTable { return false }
  if !p.Header.Equals(other.Header) { return false }
  if p.InstallingSnapshot != other.InstallingSnapshot { return false }
  return true
}

func (p *HeartBeatResponse) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("HeartBeatResponse(%+v)", *p)
}

// Attributes:
//  - Term
//  - CommitLogIndex
//  - CommitLogTerm
type RequestCommitIndexResponse struct {
  Term Long `thrift:"term,1,required" db:"term" json:"term"`
  CommitLogIndex Long `thrift:"commitLogIndex,2,required" db:"commitLogIndex" json:"commitLogIndex"`
  CommitLogTerm Long `thrift:"commitLogTerm,3,required" db:"commitLogTerm" json:"commitLogTerm"`
}

func NewRequestCommitIndexResponse() *RequestCommitIndexResponse {
  return &RequestCommitIndexResponse{}
}


func (p *RequestCommitIndexResponse) GetTerm() Long {
  return p.Term
}

func (p *RequestCommitIndexResponse) GetCommitLogIndex() Long {
  return p.CommitLogIndex
}

func (p *RequestCommitIndexResponse) GetCommitLogTerm() Long {
  return p.CommitLogTerm
}
func (p *RequestCommitIndexResponse) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetTerm bool = false;
  var issetCommitLogIndex bool = false;
  var issetCommitLogTerm bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetTerm = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetCommitLogIndex = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetCommitLogTerm = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetTerm{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Term is not set"));
  }
  if !issetCommitLogIndex{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field CommitLogIndex is not set"));
  }
  if !issetCommitLogTerm{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field CommitLogTerm is not set"));
  }
  return nil
}

func (p *RequestCommitIndexResponse)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  temp := Long(v)
  p.Term = temp
}
  return nil
}

func (p *RequestCommitIndexResponse)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  temp := Long(v)
  p.CommitLogIndex = temp
}
  return nil
}

func (p *RequestCommitIndexResponse)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  temp := Long(v)
  p.CommitLogTerm = temp
}
  return nil
}

func (p *RequestCommitIndexResponse) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "RequestCommitIndexResponse"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *RequestCommitIndexResponse) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "term", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:term: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.Term)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.term (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:term: ", p), err) }
  return err
}

func (p *RequestCommitIndexResponse) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "commitLogIndex", thrift.I64, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:commitLogIndex: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.CommitLogIndex)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.commitLogIndex (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:commitLogIndex: ", p), err) }
  return err
}

func (p *RequestCommitIndexResponse) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "commitLogTerm", thrift.I64, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:commitLogTerm: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.CommitLogTerm)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.commitLogTerm (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:commitLogTerm: ", p), err) }
  return err
}

func (p *RequestCommitIndexResponse) Equals(other *RequestCommitIndexResponse) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.Term != other.Term { return false }
  if p.CommitLogIndex != other.CommitLogIndex { return false }
  if p.CommitLogTerm != other.CommitLogTerm { return false }
  return true
}

func (p *RequestCommitIndexResponse) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("RequestCommitIndexResponse(%+v)", *p)
}

// Attributes:
//  - Term
//  - LastLogTerm
//  - LastLogIndex
//  - Elector
//  - Header
type ElectionRequest struct {
  Term Long `thrift:"term,1,required" db:"term" json:"term"`
  LastLogTerm Long `thrift:"lastLogTerm,2,required" db:"lastLogTerm" json:"lastLogTerm"`
  LastLogIndex Long `thrift:"lastLogIndex,3,required" db:"lastLogIndex" json:"lastLogIndex"`
  Elector *Node `thrift:"elector,4,required" db:"elector" json:"elector"`
  Header *RaftNode `thrift:"header,5" db:"header" json:"header,omitempty"`
}

func NewElectionRequest() *ElectionRequest {
  return &ElectionRequest{}
}


func (p *ElectionRequest) GetTerm() Long {
  return p.Term
}

func (p *ElectionRequest) GetLastLogTerm() Long {
  return p.LastLogTerm
}

func (p *ElectionRequest) GetLastLogIndex() Long {
  return p.LastLogIndex
}
var ElectionRequest_Elector_DEFAULT *Node
func (p *ElectionRequest) GetElector() *Node {
  if !p.IsSetElector() {
    return ElectionRequest_Elector_DEFAULT
  }
return p.Elector
}
var ElectionRequest_Header_DEFAULT *RaftNode
func (p *ElectionRequest) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return ElectionRequest_Header_DEFAULT
  }
return p.Header
}
func (p *ElectionRequest) IsSetElector() bool {
  return p.Elector != nil
}

func (p *ElectionRequest) IsSetHeader() bool {
  return p.Header != nil
}

func (p *ElectionRequest) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetTerm bool = false;
  var issetLastLogTerm bool = false;
  var issetLastLogIndex bool = false;
  var issetElector bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetTerm = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetLastLogTerm = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetLastLogIndex = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetElector = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetTerm{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Term is not set"));
  }
  if !issetLastLogTerm{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field LastLogTerm is not set"));
  }
  if !issetLastLogIndex{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field LastLogIndex is not set"));
  }
  if !issetElector{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Elector is not set"));
  }
  return nil
}

func (p *ElectionRequest)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  temp := Long(v)
  p.Term = temp
}
  return nil
}

func (p *ElectionRequest)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  temp := Long(v)
  p.LastLogTerm = temp
}
  return nil
}

func (p *ElectionRequest)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  temp := Long(v)
  p.LastLogIndex = temp
}
  return nil
}

func (p *ElectionRequest)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  p.Elector = &Node{}
  if err := p.Elector.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Elector), err)
  }
  return nil
}

func (p *ElectionRequest)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *ElectionRequest) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "ElectionRequest"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *ElectionRequest) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "term", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:term: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.Term)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.term (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:term: ", p), err) }
  return err
}

func (p *ElectionRequest) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "lastLogTerm", thrift.I64, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:lastLogTerm: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.LastLogTerm)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.lastLogTerm (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:lastLogTerm: ", p), err) }
  return err
}

func (p *ElectionRequest) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "lastLogIndex", thrift.I64, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:lastLogIndex: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.LastLogIndex)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.lastLogIndex (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:lastLogIndex: ", p), err) }
  return err
}

func (p *ElectionRequest) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "elector", thrift.STRUCT, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:elector: ", p), err) }
  if err := p.Elector.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Elector), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:elector: ", p), err) }
  return err
}

func (p *ElectionRequest) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetHeader() {
    if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 5); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:header: ", p), err) }
    if err := p.Header.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 5:header: ", p), err) }
  }
  return err
}

func (p *ElectionRequest) Equals(other *ElectionRequest) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.Term != other.Term { return false }
  if p.LastLogTerm != other.LastLogTerm { return false }
  if p.LastLogIndex != other.LastLogIndex { return false }
  if !p.Elector.Equals(other.Elector) { return false }
  if !p.Header.Equals(other.Header) { return false }
  return true
}

func (p *ElectionRequest) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("ElectionRequest(%+v)", *p)
}

// Attributes:
//  - Term
//  - Leader
//  - PrevLogIndex
//  - PrevLogTerm
//  - LeaderCommit
//  - Entry
//  - Header
type AppendEntryRequest struct {
  Term Long `thrift:"term,1,required" db:"term" json:"term"`
  Leader *Node `thrift:"leader,2,required" db:"leader" json:"leader"`
  PrevLogIndex Long `thrift:"prevLogIndex,3,required" db:"prevLogIndex" json:"prevLogIndex"`
  PrevLogTerm Long `thrift:"prevLogTerm,4,required" db:"prevLogTerm" json:"prevLogTerm"`
  LeaderCommit Long `thrift:"leaderCommit,5,required" db:"leaderCommit" json:"leaderCommit"`
  Entry []byte `thrift:"entry,6,required" db:"entry" json:"entry"`
  Header *RaftNode `thrift:"header,7" db:"header" json:"header,omitempty"`
}

func NewAppendEntryRequest() *AppendEntryRequest {
  return &AppendEntryRequest{}
}


func (p *AppendEntryRequest) GetTerm() Long {
  return p.Term
}
var AppendEntryRequest_Leader_DEFAULT *Node
func (p *AppendEntryRequest) GetLeader() *Node {
  if !p.IsSetLeader() {
    return AppendEntryRequest_Leader_DEFAULT
  }
return p.Leader
}

func (p *AppendEntryRequest) GetPrevLogIndex() Long {
  return p.PrevLogIndex
}

func (p *AppendEntryRequest) GetPrevLogTerm() Long {
  return p.PrevLogTerm
}

func (p *AppendEntryRequest) GetLeaderCommit() Long {
  return p.LeaderCommit
}

func (p *AppendEntryRequest) GetEntry() []byte {
  return p.Entry
}
var AppendEntryRequest_Header_DEFAULT *RaftNode
func (p *AppendEntryRequest) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return AppendEntryRequest_Header_DEFAULT
  }
return p.Header
}
func (p *AppendEntryRequest) IsSetLeader() bool {
  return p.Leader != nil
}

func (p *AppendEntryRequest) IsSetHeader() bool {
  return p.Header != nil
}

func (p *AppendEntryRequest) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetTerm bool = false;
  var issetLeader bool = false;
  var issetPrevLogIndex bool = false;
  var issetPrevLogTerm bool = false;
  var issetLeaderCommit bool = false;
  var issetEntry bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetTerm = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetLeader = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetPrevLogIndex = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetPrevLogTerm = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetLeaderCommit = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
        issetEntry = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetTerm{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Term is not set"));
  }
  if !issetLeader{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Leader is not set"));
  }
  if !issetPrevLogIndex{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PrevLogIndex is not set"));
  }
  if !issetPrevLogTerm{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PrevLogTerm is not set"));
  }
  if !issetLeaderCommit{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field LeaderCommit is not set"));
  }
  if !issetEntry{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Entry is not set"));
  }
  return nil
}

func (p *AppendEntryRequest)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  temp := Long(v)
  p.Term = temp
}
  return nil
}

func (p *AppendEntryRequest)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  p.Leader = &Node{}
  if err := p.Leader.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Leader), err)
  }
  return nil
}

func (p *AppendEntryRequest)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  temp := Long(v)
  p.PrevLogIndex = temp
}
  return nil
}

func (p *AppendEntryRequest)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  temp := Long(v)
  p.PrevLogTerm = temp
}
  return nil
}

func (p *AppendEntryRequest)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  temp := Long(v)
  p.LeaderCommit = temp
}
  return nil
}

func (p *AppendEntryRequest)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.Entry = v
}
  return nil
}

func (p *AppendEntryRequest)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *AppendEntryRequest) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "AppendEntryRequest"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *AppendEntryRequest) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "term", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:term: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.Term)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.term (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:term: ", p), err) }
  return err
}

func (p *AppendEntryRequest) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "leader", thrift.STRUCT, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:leader: ", p), err) }
  if err := p.Leader.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Leader), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:leader: ", p), err) }
  return err
}

func (p *AppendEntryRequest) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "prevLogIndex", thrift.I64, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:prevLogIndex: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.PrevLogIndex)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.prevLogIndex (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:prevLogIndex: ", p), err) }
  return err
}

func (p *AppendEntryRequest) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "prevLogTerm", thrift.I64, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:prevLogTerm: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.PrevLogTerm)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.prevLogTerm (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:prevLogTerm: ", p), err) }
  return err
}

func (p *AppendEntryRequest) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "leaderCommit", thrift.I64, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:leaderCommit: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.LeaderCommit)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.leaderCommit (5) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:leaderCommit: ", p), err) }
  return err
}

func (p *AppendEntryRequest) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "entry", thrift.STRING, 6); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:entry: ", p), err) }
  if err := oprot.WriteBinary(ctx, p.Entry); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.entry (6) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 6:entry: ", p), err) }
  return err
}

func (p *AppendEntryRequest) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetHeader() {
    if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 7); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:header: ", p), err) }
    if err := p.Header.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 7:header: ", p), err) }
  }
  return err
}

func (p *AppendEntryRequest) Equals(other *AppendEntryRequest) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.Term != other.Term { return false }
  if !p.Leader.Equals(other.Leader) { return false }
  if p.PrevLogIndex != other.PrevLogIndex { return false }
  if p.PrevLogTerm != other.PrevLogTerm { return false }
  if p.LeaderCommit != other.LeaderCommit { return false }
  if bytes.Compare(p.Entry, other.Entry) != 0 { return false }
  if !p.Header.Equals(other.Header) { return false }
  return true
}

func (p *AppendEntryRequest) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("AppendEntryRequest(%+v)", *p)
}

// Attributes:
//  - Term
//  - Leader
//  - Entries
//  - PrevLogIndex
//  - PrevLogTerm
//  - LeaderCommit
//  - Header
type AppendEntriesRequest struct {
  Term Long `thrift:"term,1,required" db:"term" json:"term"`
  Leader *Node `thrift:"leader,2,required" db:"leader" json:"leader"`
  Entries [][]byte `thrift:"entries,3,required" db:"entries" json:"entries"`
  PrevLogIndex Long `thrift:"prevLogIndex,4,required" db:"prevLogIndex" json:"prevLogIndex"`
  PrevLogTerm Long `thrift:"prevLogTerm,5,required" db:"prevLogTerm" json:"prevLogTerm"`
  LeaderCommit Long `thrift:"leaderCommit,6,required" db:"leaderCommit" json:"leaderCommit"`
  Header *RaftNode `thrift:"header,7" db:"header" json:"header,omitempty"`
}

func NewAppendEntriesRequest() *AppendEntriesRequest {
  return &AppendEntriesRequest{}
}


func (p *AppendEntriesRequest) GetTerm() Long {
  return p.Term
}
var AppendEntriesRequest_Leader_DEFAULT *Node
func (p *AppendEntriesRequest) GetLeader() *Node {
  if !p.IsSetLeader() {
    return AppendEntriesRequest_Leader_DEFAULT
  }
return p.Leader
}

func (p *AppendEntriesRequest) GetEntries() [][]byte {
  return p.Entries
}

func (p *AppendEntriesRequest) GetPrevLogIndex() Long {
  return p.PrevLogIndex
}

func (p *AppendEntriesRequest) GetPrevLogTerm() Long {
  return p.PrevLogTerm
}

func (p *AppendEntriesRequest) GetLeaderCommit() Long {
  return p.LeaderCommit
}
var AppendEntriesRequest_Header_DEFAULT *RaftNode
func (p *AppendEntriesRequest) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return AppendEntriesRequest_Header_DEFAULT
  }
return p.Header
}
func (p *AppendEntriesRequest) IsSetLeader() bool {
  return p.Leader != nil
}

func (p *AppendEntriesRequest) IsSetHeader() bool {
  return p.Header != nil
}

func (p *AppendEntriesRequest) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetTerm bool = false;
  var issetLeader bool = false;
  var issetEntries bool = false;
  var issetPrevLogIndex bool = false;
  var issetPrevLogTerm bool = false;
  var issetLeaderCommit bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetTerm = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetLeader = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetEntries = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetPrevLogIndex = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetPrevLogTerm = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
        issetLeaderCommit = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetTerm{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Term is not set"));
  }
  if !issetLeader{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Leader is not set"));
  }
  if !issetEntries{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Entries is not set"));
  }
  if !issetPrevLogIndex{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PrevLogIndex is not set"));
  }
  if !issetPrevLogTerm{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PrevLogTerm is not set"));
  }
  if !issetLeaderCommit{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field LeaderCommit is not set"));
  }
  return nil
}

func (p *AppendEntriesRequest)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  temp := Long(v)
  p.Term = temp
}
  return nil
}

func (p *AppendEntriesRequest)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  p.Leader = &Node{}
  if err := p.Leader.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Leader), err)
  }
  return nil
}

func (p *AppendEntriesRequest)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]byte, 0, size)
  p.Entries =  tSlice
  for i := 0; i < size; i ++ {
var _elem0 []byte
    if v, err := iprot.ReadBinary(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem0 = v
}
    p.Entries = append(p.Entries, _elem0)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *AppendEntriesRequest)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  temp := Long(v)
  p.PrevLogIndex = temp
}
  return nil
}

func (p *AppendEntriesRequest)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  temp := Long(v)
  p.PrevLogTerm = temp
}
  return nil
}

func (p *AppendEntriesRequest)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  temp := Long(v)
  p.LeaderCommit = temp
}
  return nil
}

func (p *AppendEntriesRequest)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *AppendEntriesRequest) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "AppendEntriesRequest"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *AppendEntriesRequest) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "term", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:term: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.Term)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.term (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:term: ", p), err) }
  return err
}

func (p *AppendEntriesRequest) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "leader", thrift.STRUCT, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:leader: ", p), err) }
  if err := p.Leader.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Leader), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:leader: ", p), err) }
  return err
}

func (p *AppendEntriesRequest) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "entries", thrift.LIST, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:entries: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Entries)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Entries {
    if err := oprot.WriteBinary(ctx, v); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:entries: ", p), err) }
  return err
}

func (p *AppendEntriesRequest) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "prevLogIndex", thrift.I64, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:prevLogIndex: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.PrevLogIndex)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.prevLogIndex (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:prevLogIndex: ", p), err) }
  return err
}

func (p *AppendEntriesRequest) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "prevLogTerm", thrift.I64, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:prevLogTerm: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.PrevLogTerm)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.prevLogTerm (5) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:prevLogTerm: ", p), err) }
  return err
}

func (p *AppendEntriesRequest) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "leaderCommit", thrift.I64, 6); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:leaderCommit: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.LeaderCommit)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.leaderCommit (6) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 6:leaderCommit: ", p), err) }
  return err
}

func (p *AppendEntriesRequest) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetHeader() {
    if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 7); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:header: ", p), err) }
    if err := p.Header.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 7:header: ", p), err) }
  }
  return err
}

func (p *AppendEntriesRequest) Equals(other *AppendEntriesRequest) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.Term != other.Term { return false }
  if !p.Leader.Equals(other.Leader) { return false }
  if len(p.Entries) != len(other.Entries) { return false }
  for i, _tgt := range p.Entries {
    _src1 := other.Entries[i]
    if bytes.Compare(_tgt, _src1) != 0 { return false }
  }
  if p.PrevLogIndex != other.PrevLogIndex { return false }
  if p.PrevLogTerm != other.PrevLogTerm { return false }
  if p.LeaderCommit != other.LeaderCommit { return false }
  if !p.Header.Equals(other.Header) { return false }
  return true
}

func (p *AppendEntriesRequest) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("AppendEntriesRequest(%+v)", *p)
}

// Attributes:
//  - RespNum
//  - PartitionTableBytes
//  - CheckStatusResponse
type AddNodeResponse struct {
  RespNum Int `thrift:"respNum,1,required" db:"respNum" json:"respNum"`
  PartitionTableBytes []byte `thrift:"partitionTableBytes,2" db:"partitionTableBytes" json:"partitionTableBytes,omitempty"`
  CheckStatusResponse *CheckStatusResponse `thrift:"checkStatusResponse,3" db:"checkStatusResponse" json:"checkStatusResponse,omitempty"`
}

func NewAddNodeResponse() *AddNodeResponse {
  return &AddNodeResponse{}
}


func (p *AddNodeResponse) GetRespNum() Int {
  return p.RespNum
}
var AddNodeResponse_PartitionTableBytes_DEFAULT []byte

func (p *AddNodeResponse) GetPartitionTableBytes() []byte {
  return p.PartitionTableBytes
}
var AddNodeResponse_CheckStatusResponse_DEFAULT *CheckStatusResponse
func (p *AddNodeResponse) GetCheckStatusResponse() *CheckStatusResponse {
  if !p.IsSetCheckStatusResponse() {
    return AddNodeResponse_CheckStatusResponse_DEFAULT
  }
return p.CheckStatusResponse
}
func (p *AddNodeResponse) IsSetPartitionTableBytes() bool {
  return p.PartitionTableBytes != nil
}

func (p *AddNodeResponse) IsSetCheckStatusResponse() bool {
  return p.CheckStatusResponse != nil
}

func (p *AddNodeResponse) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetRespNum bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetRespNum = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetRespNum{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field RespNum is not set"));
  }
  return nil
}

func (p *AddNodeResponse)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  temp := Int(v)
  p.RespNum = temp
}
  return nil
}

func (p *AddNodeResponse)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.PartitionTableBytes = v
}
  return nil
}

func (p *AddNodeResponse)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  p.CheckStatusResponse = &CheckStatusResponse{}
  if err := p.CheckStatusResponse.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.CheckStatusResponse), err)
  }
  return nil
}

func (p *AddNodeResponse) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "AddNodeResponse"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *AddNodeResponse) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "respNum", thrift.I32, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:respNum: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.RespNum)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.respNum (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:respNum: ", p), err) }
  return err
}

func (p *AddNodeResponse) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetPartitionTableBytes() {
    if err := oprot.WriteFieldBegin(ctx, "partitionTableBytes", thrift.STRING, 2); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:partitionTableBytes: ", p), err) }
    if err := oprot.WriteBinary(ctx, p.PartitionTableBytes); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.partitionTableBytes (2) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 2:partitionTableBytes: ", p), err) }
  }
  return err
}

func (p *AddNodeResponse) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetCheckStatusResponse() {
    if err := oprot.WriteFieldBegin(ctx, "checkStatusResponse", thrift.STRUCT, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:checkStatusResponse: ", p), err) }
    if err := p.CheckStatusResponse.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.CheckStatusResponse), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:checkStatusResponse: ", p), err) }
  }
  return err
}

func (p *AddNodeResponse) Equals(other *AddNodeResponse) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.RespNum != other.RespNum { return false }
  if bytes.Compare(p.PartitionTableBytes, other.PartitionTableBytes) != 0 { return false }
  if !p.CheckStatusResponse.Equals(other.CheckStatusResponse) { return false }
  return true
}

func (p *AddNodeResponse) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("AddNodeResponse(%+v)", *p)
}

// Attributes:
//  - InternalIp
//  - MetaPort
//  - NodeIdentifier
//  - DataPort
//  - ClientPort
//  - ClientIp
type Node struct {
  InternalIp string `thrift:"internalIp,1,required" db:"internalIp" json:"internalIp"`
  MetaPort Int `thrift:"metaPort,2,required" db:"metaPort" json:"metaPort"`
  NodeIdentifier Int `thrift:"nodeIdentifier,3,required" db:"nodeIdentifier" json:"nodeIdentifier"`
  DataPort Int `thrift:"dataPort,4,required" db:"dataPort" json:"dataPort"`
  ClientPort Int `thrift:"clientPort,5,required" db:"clientPort" json:"clientPort"`
  ClientIp string `thrift:"clientIp,6,required" db:"clientIp" json:"clientIp"`
}

func NewNode() *Node {
  return &Node{}
}


func (p *Node) GetInternalIp() string {
  return p.InternalIp
}

func (p *Node) GetMetaPort() Int {
  return p.MetaPort
}

func (p *Node) GetNodeIdentifier() Int {
  return p.NodeIdentifier
}

func (p *Node) GetDataPort() Int {
  return p.DataPort
}

func (p *Node) GetClientPort() Int {
  return p.ClientPort
}

func (p *Node) GetClientIp() string {
  return p.ClientIp
}
func (p *Node) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetInternalIp bool = false;
  var issetMetaPort bool = false;
  var issetNodeIdentifier bool = false;
  var issetDataPort bool = false;
  var issetClientPort bool = false;
  var issetClientIp bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetInternalIp = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetMetaPort = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetNodeIdentifier = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetDataPort = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetClientPort = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
        issetClientIp = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetInternalIp{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field InternalIp is not set"));
  }
  if !issetMetaPort{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field MetaPort is not set"));
  }
  if !issetNodeIdentifier{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NodeIdentifier is not set"));
  }
  if !issetDataPort{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DataPort is not set"));
  }
  if !issetClientPort{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ClientPort is not set"));
  }
  if !issetClientIp{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ClientIp is not set"));
  }
  return nil
}

func (p *Node)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.InternalIp = v
}
  return nil
}

func (p *Node)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  temp := Int(v)
  p.MetaPort = temp
}
  return nil
}

func (p *Node)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  temp := Int(v)
  p.NodeIdentifier = temp
}
  return nil
}

func (p *Node)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  temp := Int(v)
  p.DataPort = temp
}
  return nil
}

func (p *Node)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  temp := Int(v)
  p.ClientPort = temp
}
  return nil
}

func (p *Node)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.ClientIp = v
}
  return nil
}

func (p *Node) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "Node"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *Node) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "internalIp", thrift.STRING, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:internalIp: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.InternalIp)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.internalIp (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:internalIp: ", p), err) }
  return err
}

func (p *Node) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "metaPort", thrift.I32, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:metaPort: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.MetaPort)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.metaPort (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:metaPort: ", p), err) }
  return err
}

func (p *Node) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "nodeIdentifier", thrift.I32, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:nodeIdentifier: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.NodeIdentifier)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.nodeIdentifier (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:nodeIdentifier: ", p), err) }
  return err
}

func (p *Node) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "dataPort", thrift.I32, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:dataPort: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.DataPort)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.dataPort (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:dataPort: ", p), err) }
  return err
}

func (p *Node) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "clientPort", thrift.I32, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:clientPort: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.ClientPort)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.clientPort (5) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:clientPort: ", p), err) }
  return err
}

func (p *Node) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "clientIp", thrift.STRING, 6); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:clientIp: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.ClientIp)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.clientIp (6) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 6:clientIp: ", p), err) }
  return err
}

func (p *Node) Equals(other *Node) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.InternalIp != other.InternalIp { return false }
  if p.MetaPort != other.MetaPort { return false }
  if p.NodeIdentifier != other.NodeIdentifier { return false }
  if p.DataPort != other.DataPort { return false }
  if p.ClientPort != other.ClientPort { return false }
  if p.ClientIp != other.ClientIp { return false }
  return true
}

func (p *Node) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("Node(%+v)", *p)
}

// Attributes:
//  - Node
//  - RaftId
type RaftNode struct {
  Node *Node `thrift:"node,1,required" db:"node" json:"node"`
  RaftId Int `thrift:"raftId,2,required" db:"raftId" json:"raftId"`
}

func NewRaftNode() *RaftNode {
  return &RaftNode{}
}

var RaftNode_Node_DEFAULT *Node
func (p *RaftNode) GetNode() *Node {
  if !p.IsSetNode() {
    return RaftNode_Node_DEFAULT
  }
return p.Node
}

func (p *RaftNode) GetRaftId() Int {
  return p.RaftId
}
func (p *RaftNode) IsSetNode() bool {
  return p.Node != nil
}

func (p *RaftNode) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetNode bool = false;
  var issetRaftId bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetNode = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetRaftId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetNode{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Node is not set"));
  }
  if !issetRaftId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field RaftId is not set"));
  }
  return nil
}

func (p *RaftNode)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Node = &Node{}
  if err := p.Node.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Node), err)
  }
  return nil
}

func (p *RaftNode)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  temp := Int(v)
  p.RaftId = temp
}
  return nil
}

func (p *RaftNode) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "RaftNode"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *RaftNode) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "node", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:node: ", p), err) }
  if err := p.Node.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Node), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:node: ", p), err) }
  return err
}

func (p *RaftNode) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "raftId", thrift.I32, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:raftId: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.RaftId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.raftId (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:raftId: ", p), err) }
  return err
}

func (p *RaftNode) Equals(other *RaftNode) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if !p.Node.Equals(other.Node) { return false }
  if p.RaftId != other.RaftId { return false }
  return true
}

func (p *RaftNode) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("RaftNode(%+v)", *p)
}

// Attributes:
//  - PartitionInterval
//  - HashSalt
//  - ReplicationNumber
//  - SeedNodeList
//  - ClusterName
//  - MultiRaftFactor
type StartUpStatus struct {
  PartitionInterval Long `thrift:"partitionInterval,1,required" db:"partitionInterval" json:"partitionInterval"`
  HashSalt Int `thrift:"hashSalt,2,required" db:"hashSalt" json:"hashSalt"`
  ReplicationNumber Int `thrift:"replicationNumber,3,required" db:"replicationNumber" json:"replicationNumber"`
  SeedNodeList []*Node `thrift:"seedNodeList,4,required" db:"seedNodeList" json:"seedNodeList"`
  ClusterName string `thrift:"clusterName,5,required" db:"clusterName" json:"clusterName"`
  MultiRaftFactor Int `thrift:"multiRaftFactor,6,required" db:"multiRaftFactor" json:"multiRaftFactor"`
}

func NewStartUpStatus() *StartUpStatus {
  return &StartUpStatus{}
}


func (p *StartUpStatus) GetPartitionInterval() Long {
  return p.PartitionInterval
}

func (p *StartUpStatus) GetHashSalt() Int {
  return p.HashSalt
}

func (p *StartUpStatus) GetReplicationNumber() Int {
  return p.ReplicationNumber
}

func (p *StartUpStatus) GetSeedNodeList() []*Node {
  return p.SeedNodeList
}

func (p *StartUpStatus) GetClusterName() string {
  return p.ClusterName
}

func (p *StartUpStatus) GetMultiRaftFactor() Int {
  return p.MultiRaftFactor
}
func (p *StartUpStatus) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetPartitionInterval bool = false;
  var issetHashSalt bool = false;
  var issetReplicationNumber bool = false;
  var issetSeedNodeList bool = false;
  var issetClusterName bool = false;
  var issetMultiRaftFactor bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetPartitionInterval = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetHashSalt = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetReplicationNumber = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetSeedNodeList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetClusterName = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
        issetMultiRaftFactor = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetPartitionInterval{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PartitionInterval is not set"));
  }
  if !issetHashSalt{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field HashSalt is not set"));
  }
  if !issetReplicationNumber{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ReplicationNumber is not set"));
  }
  if !issetSeedNodeList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SeedNodeList is not set"));
  }
  if !issetClusterName{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ClusterName is not set"));
  }
  if !issetMultiRaftFactor{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field MultiRaftFactor is not set"));
  }
  return nil
}

func (p *StartUpStatus)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  temp := Long(v)
  p.PartitionInterval = temp
}
  return nil
}

func (p *StartUpStatus)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  temp := Int(v)
  p.HashSalt = temp
}
  return nil
}

func (p *StartUpStatus)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  temp := Int(v)
  p.ReplicationNumber = temp
}
  return nil
}

func (p *StartUpStatus)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]*Node, 0, size)
  p.SeedNodeList =  tSlice
  for i := 0; i < size; i ++ {
    _elem2 := &Node{}
    if err := _elem2.Read(ctx, iprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem2), err)
    }
    p.SeedNodeList = append(p.SeedNodeList, _elem2)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *StartUpStatus)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.ClusterName = v
}
  return nil
}

func (p *StartUpStatus)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  temp := Int(v)
  p.MultiRaftFactor = temp
}
  return nil
}

func (p *StartUpStatus) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "StartUpStatus"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *StartUpStatus) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "partitionInterval", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:partitionInterval: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.PartitionInterval)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.partitionInterval (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:partitionInterval: ", p), err) }
  return err
}

func (p *StartUpStatus) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "hashSalt", thrift.I32, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:hashSalt: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.HashSalt)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.hashSalt (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:hashSalt: ", p), err) }
  return err
}

func (p *StartUpStatus) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "replicationNumber", thrift.I32, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:replicationNumber: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.ReplicationNumber)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.replicationNumber (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:replicationNumber: ", p), err) }
  return err
}

func (p *StartUpStatus) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "seedNodeList", thrift.LIST, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:seedNodeList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRUCT, len(p.SeedNodeList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.SeedNodeList {
    if err := v.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
    }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:seedNodeList: ", p), err) }
  return err
}

func (p *StartUpStatus) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "clusterName", thrift.STRING, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:clusterName: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.ClusterName)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.clusterName (5) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:clusterName: ", p), err) }
  return err
}

func (p *StartUpStatus) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "multiRaftFactor", thrift.I32, 6); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:multiRaftFactor: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.MultiRaftFactor)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.multiRaftFactor (6) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 6:multiRaftFactor: ", p), err) }
  return err
}

func (p *StartUpStatus) Equals(other *StartUpStatus) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.PartitionInterval != other.PartitionInterval { return false }
  if p.HashSalt != other.HashSalt { return false }
  if p.ReplicationNumber != other.ReplicationNumber { return false }
  if len(p.SeedNodeList) != len(other.SeedNodeList) { return false }
  for i, _tgt := range p.SeedNodeList {
    _src3 := other.SeedNodeList[i]
    if !_tgt.Equals(_src3) { return false }
  }
  if p.ClusterName != other.ClusterName { return false }
  if p.MultiRaftFactor != other.MultiRaftFactor { return false }
  return true
}

func (p *StartUpStatus) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("StartUpStatus(%+v)", *p)
}

// Attributes:
//  - PartitionalIntervalEquals
//  - HashSaltEquals
//  - ReplicationNumEquals
//  - SeedNodeEquals
//  - ClusterNameEquals
//  - MultiRaftFactorEquals
type CheckStatusResponse struct {
  PartitionalIntervalEquals bool `thrift:"partitionalIntervalEquals,1,required" db:"partitionalIntervalEquals" json:"partitionalIntervalEquals"`
  HashSaltEquals bool `thrift:"hashSaltEquals,2,required" db:"hashSaltEquals" json:"hashSaltEquals"`
  ReplicationNumEquals bool `thrift:"replicationNumEquals,3,required" db:"replicationNumEquals" json:"replicationNumEquals"`
  SeedNodeEquals bool `thrift:"seedNodeEquals,4,required" db:"seedNodeEquals" json:"seedNodeEquals"`
  ClusterNameEquals bool `thrift:"clusterNameEquals,5,required" db:"clusterNameEquals" json:"clusterNameEquals"`
  MultiRaftFactorEquals bool `thrift:"multiRaftFactorEquals,6,required" db:"multiRaftFactorEquals" json:"multiRaftFactorEquals"`
}

func NewCheckStatusResponse() *CheckStatusResponse {
  return &CheckStatusResponse{}
}


func (p *CheckStatusResponse) GetPartitionalIntervalEquals() bool {
  return p.PartitionalIntervalEquals
}

func (p *CheckStatusResponse) GetHashSaltEquals() bool {
  return p.HashSaltEquals
}

func (p *CheckStatusResponse) GetReplicationNumEquals() bool {
  return p.ReplicationNumEquals
}

func (p *CheckStatusResponse) GetSeedNodeEquals() bool {
  return p.SeedNodeEquals
}

func (p *CheckStatusResponse) GetClusterNameEquals() bool {
  return p.ClusterNameEquals
}

func (p *CheckStatusResponse) GetMultiRaftFactorEquals() bool {
  return p.MultiRaftFactorEquals
}
func (p *CheckStatusResponse) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetPartitionalIntervalEquals bool = false;
  var issetHashSaltEquals bool = false;
  var issetReplicationNumEquals bool = false;
  var issetSeedNodeEquals bool = false;
  var issetClusterNameEquals bool = false;
  var issetMultiRaftFactorEquals bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetPartitionalIntervalEquals = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetHashSaltEquals = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetReplicationNumEquals = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetSeedNodeEquals = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetClusterNameEquals = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
        issetMultiRaftFactorEquals = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetPartitionalIntervalEquals{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PartitionalIntervalEquals is not set"));
  }
  if !issetHashSaltEquals{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field HashSaltEquals is not set"));
  }
  if !issetReplicationNumEquals{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ReplicationNumEquals is not set"));
  }
  if !issetSeedNodeEquals{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SeedNodeEquals is not set"));
  }
  if !issetClusterNameEquals{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ClusterNameEquals is not set"));
  }
  if !issetMultiRaftFactorEquals{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field MultiRaftFactorEquals is not set"));
  }
  return nil
}

func (p *CheckStatusResponse)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.PartitionalIntervalEquals = v
}
  return nil
}

func (p *CheckStatusResponse)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.HashSaltEquals = v
}
  return nil
}

func (p *CheckStatusResponse)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.ReplicationNumEquals = v
}
  return nil
}

func (p *CheckStatusResponse)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.SeedNodeEquals = v
}
  return nil
}

func (p *CheckStatusResponse)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.ClusterNameEquals = v
}
  return nil
}

func (p *CheckStatusResponse)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.MultiRaftFactorEquals = v
}
  return nil
}

func (p *CheckStatusResponse) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "CheckStatusResponse"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *CheckStatusResponse) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "partitionalIntervalEquals", thrift.BOOL, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:partitionalIntervalEquals: ", p), err) }
  if err := oprot.WriteBool(ctx, bool(p.PartitionalIntervalEquals)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.partitionalIntervalEquals (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:partitionalIntervalEquals: ", p), err) }
  return err
}

func (p *CheckStatusResponse) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "hashSaltEquals", thrift.BOOL, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:hashSaltEquals: ", p), err) }
  if err := oprot.WriteBool(ctx, bool(p.HashSaltEquals)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.hashSaltEquals (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:hashSaltEquals: ", p), err) }
  return err
}

func (p *CheckStatusResponse) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "replicationNumEquals", thrift.BOOL, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:replicationNumEquals: ", p), err) }
  if err := oprot.WriteBool(ctx, bool(p.ReplicationNumEquals)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.replicationNumEquals (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:replicationNumEquals: ", p), err) }
  return err
}

func (p *CheckStatusResponse) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "seedNodeEquals", thrift.BOOL, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:seedNodeEquals: ", p), err) }
  if err := oprot.WriteBool(ctx, bool(p.SeedNodeEquals)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.seedNodeEquals (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:seedNodeEquals: ", p), err) }
  return err
}

func (p *CheckStatusResponse) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "clusterNameEquals", thrift.BOOL, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:clusterNameEquals: ", p), err) }
  if err := oprot.WriteBool(ctx, bool(p.ClusterNameEquals)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.clusterNameEquals (5) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:clusterNameEquals: ", p), err) }
  return err
}

func (p *CheckStatusResponse) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "multiRaftFactorEquals", thrift.BOOL, 6); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:multiRaftFactorEquals: ", p), err) }
  if err := oprot.WriteBool(ctx, bool(p.MultiRaftFactorEquals)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.multiRaftFactorEquals (6) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 6:multiRaftFactorEquals: ", p), err) }
  return err
}

func (p *CheckStatusResponse) Equals(other *CheckStatusResponse) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.PartitionalIntervalEquals != other.PartitionalIntervalEquals { return false }
  if p.HashSaltEquals != other.HashSaltEquals { return false }
  if p.ReplicationNumEquals != other.ReplicationNumEquals { return false }
  if p.SeedNodeEquals != other.SeedNodeEquals { return false }
  if p.ClusterNameEquals != other.ClusterNameEquals { return false }
  if p.MultiRaftFactorEquals != other.MultiRaftFactorEquals { return false }
  return true
}

func (p *CheckStatusResponse) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("CheckStatusResponse(%+v)", *p)
}

// Attributes:
//  - SnapshotBytes
//  - Header
type SendSnapshotRequest struct {
  SnapshotBytes []byte `thrift:"snapshotBytes,1,required" db:"snapshotBytes" json:"snapshotBytes"`
  Header *RaftNode `thrift:"header,2" db:"header" json:"header,omitempty"`
}

func NewSendSnapshotRequest() *SendSnapshotRequest {
  return &SendSnapshotRequest{}
}


func (p *SendSnapshotRequest) GetSnapshotBytes() []byte {
  return p.SnapshotBytes
}
var SendSnapshotRequest_Header_DEFAULT *RaftNode
func (p *SendSnapshotRequest) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return SendSnapshotRequest_Header_DEFAULT
  }
return p.Header
}
func (p *SendSnapshotRequest) IsSetHeader() bool {
  return p.Header != nil
}

func (p *SendSnapshotRequest) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSnapshotBytes bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSnapshotBytes = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSnapshotBytes{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SnapshotBytes is not set"));
  }
  return nil
}

func (p *SendSnapshotRequest)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SnapshotBytes = v
}
  return nil
}

func (p *SendSnapshotRequest)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *SendSnapshotRequest) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "SendSnapshotRequest"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *SendSnapshotRequest) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "snapshotBytes", thrift.STRING, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:snapshotBytes: ", p), err) }
  if err := oprot.WriteBinary(ctx, p.SnapshotBytes); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.snapshotBytes (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:snapshotBytes: ", p), err) }
  return err
}

func (p *SendSnapshotRequest) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetHeader() {
    if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 2); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:header: ", p), err) }
    if err := p.Header.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 2:header: ", p), err) }
  }
  return err
}

func (p *SendSnapshotRequest) Equals(other *SendSnapshotRequest) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if bytes.Compare(p.SnapshotBytes, other.SnapshotBytes) != 0 { return false }
  if !p.Header.Equals(other.Header) { return false }
  return true
}

func (p *SendSnapshotRequest) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("SendSnapshotRequest(%+v)", *p)
}

// Attributes:
//  - RequiredSlots
//  - Header
//  - RequireReadOnly
type PullSnapshotRequest struct {
  RequiredSlots []Int `thrift:"requiredSlots,1,required" db:"requiredSlots" json:"requiredSlots"`
  Header *RaftNode `thrift:"header,2" db:"header" json:"header,omitempty"`
  RequireReadOnly bool `thrift:"requireReadOnly,3,required" db:"requireReadOnly" json:"requireReadOnly"`
}

func NewPullSnapshotRequest() *PullSnapshotRequest {
  return &PullSnapshotRequest{}
}


func (p *PullSnapshotRequest) GetRequiredSlots() []Int {
  return p.RequiredSlots
}
var PullSnapshotRequest_Header_DEFAULT *RaftNode
func (p *PullSnapshotRequest) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return PullSnapshotRequest_Header_DEFAULT
  }
return p.Header
}

func (p *PullSnapshotRequest) GetRequireReadOnly() bool {
  return p.RequireReadOnly
}
func (p *PullSnapshotRequest) IsSetHeader() bool {
  return p.Header != nil
}

func (p *PullSnapshotRequest) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetRequiredSlots bool = false;
  var issetRequireReadOnly bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetRequiredSlots = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetRequireReadOnly = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetRequiredSlots{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field RequiredSlots is not set"));
  }
  if !issetRequireReadOnly{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field RequireReadOnly is not set"));
  }
  return nil
}

func (p *PullSnapshotRequest)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]Int, 0, size)
  p.RequiredSlots =  tSlice
  for i := 0; i < size; i ++ {
var _elem4 Int
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    temp := Int(v)
    _elem4 = temp
}
    p.RequiredSlots = append(p.RequiredSlots, _elem4)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *PullSnapshotRequest)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *PullSnapshotRequest)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.RequireReadOnly = v
}
  return nil
}

func (p *PullSnapshotRequest) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "PullSnapshotRequest"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *PullSnapshotRequest) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "requiredSlots", thrift.LIST, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:requiredSlots: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.RequiredSlots)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.RequiredSlots {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:requiredSlots: ", p), err) }
  return err
}

func (p *PullSnapshotRequest) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetHeader() {
    if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 2); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:header: ", p), err) }
    if err := p.Header.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 2:header: ", p), err) }
  }
  return err
}

func (p *PullSnapshotRequest) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "requireReadOnly", thrift.BOOL, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:requireReadOnly: ", p), err) }
  if err := oprot.WriteBool(ctx, bool(p.RequireReadOnly)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.requireReadOnly (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:requireReadOnly: ", p), err) }
  return err
}

func (p *PullSnapshotRequest) Equals(other *PullSnapshotRequest) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if len(p.RequiredSlots) != len(other.RequiredSlots) { return false }
  for i, _tgt := range p.RequiredSlots {
    _src5 := other.RequiredSlots[i]
    if _tgt != _src5 { return false }
  }
  if !p.Header.Equals(other.Header) { return false }
  if p.RequireReadOnly != other.RequireReadOnly { return false }
  return true
}

func (p *PullSnapshotRequest) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("PullSnapshotRequest(%+v)", *p)
}

// Attributes:
//  - SnapshotBytes
type PullSnapshotResp struct {
  SnapshotBytes map[Int][]byte `thrift:"snapshotBytes,1" db:"snapshotBytes" json:"snapshotBytes,omitempty"`
}

func NewPullSnapshotResp() *PullSnapshotResp {
  return &PullSnapshotResp{}
}

var PullSnapshotResp_SnapshotBytes_DEFAULT map[Int][]byte

func (p *PullSnapshotResp) GetSnapshotBytes() map[Int][]byte {
  return p.SnapshotBytes
}
func (p *PullSnapshotResp) IsSetSnapshotBytes() bool {
  return p.SnapshotBytes != nil
}

func (p *PullSnapshotResp) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.MAP {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *PullSnapshotResp)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  _, _, size, err := iprot.ReadMapBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
  }
  tMap := make(map[Int][]byte, size)
  p.SnapshotBytes =  tMap
  for i := 0; i < size; i ++ {
var _key6 Int
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    temp := Int(v)
    _key6 = temp
}
var _val7 []byte
    if v, err := iprot.ReadBinary(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _val7 = v
}
    p.SnapshotBytes[_key6] = _val7
  }
  if err := iprot.ReadMapEnd(ctx); err != nil {
    return thrift.PrependError("error reading map end: ", err)
  }
  return nil
}

func (p *PullSnapshotResp) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "PullSnapshotResp"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *PullSnapshotResp) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSnapshotBytes() {
    if err := oprot.WriteFieldBegin(ctx, "snapshotBytes", thrift.MAP, 1); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:snapshotBytes: ", p), err) }
    if err := oprot.WriteMapBegin(ctx, thrift.I32, thrift.STRING, len(p.SnapshotBytes)); err != nil {
      return thrift.PrependError("error writing map begin: ", err)
    }
    for k, v := range p.SnapshotBytes {
      if err := oprot.WriteI32(ctx, int32(k)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
      if err := oprot.WriteBinary(ctx, v); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteMapEnd(ctx); err != nil {
      return thrift.PrependError("error writing map end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 1:snapshotBytes: ", p), err) }
  }
  return err
}

func (p *PullSnapshotResp) Equals(other *PullSnapshotResp) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if len(p.SnapshotBytes) != len(other.SnapshotBytes) { return false }
  for k, _tgt := range p.SnapshotBytes {
    _src8 := other.SnapshotBytes[k]
    if bytes.Compare(_tgt, _src8) != 0 { return false }
  }
  return true
}

func (p *PullSnapshotResp) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("PullSnapshotResp(%+v)", *p)
}

// Attributes:
//  - PlanBytes
//  - Header
type ExecutNonQueryReq struct {
  PlanBytes []byte `thrift:"planBytes,1,required" db:"planBytes" json:"planBytes"`
  Header *RaftNode `thrift:"header,2" db:"header" json:"header,omitempty"`
}

func NewExecutNonQueryReq() *ExecutNonQueryReq {
  return &ExecutNonQueryReq{}
}


func (p *ExecutNonQueryReq) GetPlanBytes() []byte {
  return p.PlanBytes
}
var ExecutNonQueryReq_Header_DEFAULT *RaftNode
func (p *ExecutNonQueryReq) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return ExecutNonQueryReq_Header_DEFAULT
  }
return p.Header
}
func (p *ExecutNonQueryReq) IsSetHeader() bool {
  return p.Header != nil
}

func (p *ExecutNonQueryReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetPlanBytes bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetPlanBytes = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetPlanBytes{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PlanBytes is not set"));
  }
  return nil
}

func (p *ExecutNonQueryReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.PlanBytes = v
}
  return nil
}

func (p *ExecutNonQueryReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *ExecutNonQueryReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "ExecutNonQueryReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *ExecutNonQueryReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "planBytes", thrift.STRING, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:planBytes: ", p), err) }
  if err := oprot.WriteBinary(ctx, p.PlanBytes); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.planBytes (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:planBytes: ", p), err) }
  return err
}

func (p *ExecutNonQueryReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetHeader() {
    if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 2); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:header: ", p), err) }
    if err := p.Header.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 2:header: ", p), err) }
  }
  return err
}

func (p *ExecutNonQueryReq) Equals(other *ExecutNonQueryReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if bytes.Compare(p.PlanBytes, other.PlanBytes) != 0 { return false }
  if !p.Header.Equals(other.Header) { return false }
  return true
}

func (p *ExecutNonQueryReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("ExecutNonQueryReq(%+v)", *p)
}

// Attributes:
//  - PrefixPaths
//  - Header
type PullSchemaRequest struct {
  PrefixPaths []string `thrift:"prefixPaths,1,required" db:"prefixPaths" json:"prefixPaths"`
  Header *RaftNode `thrift:"header,2" db:"header" json:"header,omitempty"`
}

func NewPullSchemaRequest() *PullSchemaRequest {
  return &PullSchemaRequest{}
}


func (p *PullSchemaRequest) GetPrefixPaths() []string {
  return p.PrefixPaths
}
var PullSchemaRequest_Header_DEFAULT *RaftNode
func (p *PullSchemaRequest) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return PullSchemaRequest_Header_DEFAULT
  }
return p.Header
}
func (p *PullSchemaRequest) IsSetHeader() bool {
  return p.Header != nil
}

func (p *PullSchemaRequest) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetPrefixPaths bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetPrefixPaths = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetPrefixPaths{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PrefixPaths is not set"));
  }
  return nil
}

func (p *PullSchemaRequest)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.PrefixPaths =  tSlice
  for i := 0; i < size; i ++ {
var _elem9 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem9 = v
}
    p.PrefixPaths = append(p.PrefixPaths, _elem9)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *PullSchemaRequest)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *PullSchemaRequest) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "PullSchemaRequest"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *PullSchemaRequest) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "prefixPaths", thrift.LIST, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:prefixPaths: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.PrefixPaths)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.PrefixPaths {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:prefixPaths: ", p), err) }
  return err
}

func (p *PullSchemaRequest) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetHeader() {
    if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 2); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:header: ", p), err) }
    if err := p.Header.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 2:header: ", p), err) }
  }
  return err
}

func (p *PullSchemaRequest) Equals(other *PullSchemaRequest) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if len(p.PrefixPaths) != len(other.PrefixPaths) { return false }
  for i, _tgt := range p.PrefixPaths {
    _src10 := other.PrefixPaths[i]
    if _tgt != _src10 { return false }
  }
  if !p.Header.Equals(other.Header) { return false }
  return true
}

func (p *PullSchemaRequest) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("PullSchemaRequest(%+v)", *p)
}

// Attributes:
//  - SchemaBytes
type PullSchemaResp struct {
  SchemaBytes []byte `thrift:"schemaBytes,1,required" db:"schemaBytes" json:"schemaBytes"`
}

func NewPullSchemaResp() *PullSchemaResp {
  return &PullSchemaResp{}
}


func (p *PullSchemaResp) GetSchemaBytes() []byte {
  return p.SchemaBytes
}
func (p *PullSchemaResp) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSchemaBytes bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSchemaBytes = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSchemaBytes{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SchemaBytes is not set"));
  }
  return nil
}

func (p *PullSchemaResp)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SchemaBytes = v
}
  return nil
}

func (p *PullSchemaResp) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "PullSchemaResp"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *PullSchemaResp) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "schemaBytes", thrift.STRING, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:schemaBytes: ", p), err) }
  if err := oprot.WriteBinary(ctx, p.SchemaBytes); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.schemaBytes (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:schemaBytes: ", p), err) }
  return err
}

func (p *PullSchemaResp) Equals(other *PullSchemaResp) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if bytes.Compare(p.SchemaBytes, other.SchemaBytes) != 0 { return false }
  return true
}

func (p *PullSchemaResp) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("PullSchemaResp(%+v)", *p)
}

// Attributes:
//  - Path
//  - TimeFilterBytes
//  - ValueFilterBytes
//  - QueryId
//  - Requester
//  - Header
//  - DataTypeOrdinal
//  - DeviceMeasurements
//  - Ascending
//  - FetchSize
//  - DeduplicatedPathNum
//  - RequiredSlots
type SingleSeriesQueryRequest struct {
  Path string `thrift:"path,1,required" db:"path" json:"path"`
  TimeFilterBytes []byte `thrift:"timeFilterBytes,2" db:"timeFilterBytes" json:"timeFilterBytes,omitempty"`
  ValueFilterBytes []byte `thrift:"valueFilterBytes,3" db:"valueFilterBytes" json:"valueFilterBytes,omitempty"`
  QueryId Long `thrift:"queryId,4,required" db:"queryId" json:"queryId"`
  Requester *Node `thrift:"requester,5,required" db:"requester" json:"requester"`
  Header *RaftNode `thrift:"header,6,required" db:"header" json:"header"`
  DataTypeOrdinal Int `thrift:"dataTypeOrdinal,7,required" db:"dataTypeOrdinal" json:"dataTypeOrdinal"`
  DeviceMeasurements []string `thrift:"deviceMeasurements,8,required" db:"deviceMeasurements" json:"deviceMeasurements"`
  Ascending bool `thrift:"ascending,9,required" db:"ascending" json:"ascending"`
  FetchSize Int `thrift:"fetchSize,10,required" db:"fetchSize" json:"fetchSize"`
  DeduplicatedPathNum Int `thrift:"deduplicatedPathNum,11,required" db:"deduplicatedPathNum" json:"deduplicatedPathNum"`
  RequiredSlots []Int `thrift:"requiredSlots,12" db:"requiredSlots" json:"requiredSlots,omitempty"`
}

func NewSingleSeriesQueryRequest() *SingleSeriesQueryRequest {
  return &SingleSeriesQueryRequest{}
}


func (p *SingleSeriesQueryRequest) GetPath() string {
  return p.Path
}
var SingleSeriesQueryRequest_TimeFilterBytes_DEFAULT []byte

func (p *SingleSeriesQueryRequest) GetTimeFilterBytes() []byte {
  return p.TimeFilterBytes
}
var SingleSeriesQueryRequest_ValueFilterBytes_DEFAULT []byte

func (p *SingleSeriesQueryRequest) GetValueFilterBytes() []byte {
  return p.ValueFilterBytes
}

func (p *SingleSeriesQueryRequest) GetQueryId() Long {
  return p.QueryId
}
var SingleSeriesQueryRequest_Requester_DEFAULT *Node
func (p *SingleSeriesQueryRequest) GetRequester() *Node {
  if !p.IsSetRequester() {
    return SingleSeriesQueryRequest_Requester_DEFAULT
  }
return p.Requester
}
var SingleSeriesQueryRequest_Header_DEFAULT *RaftNode
func (p *SingleSeriesQueryRequest) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return SingleSeriesQueryRequest_Header_DEFAULT
  }
return p.Header
}

func (p *SingleSeriesQueryRequest) GetDataTypeOrdinal() Int {
  return p.DataTypeOrdinal
}

func (p *SingleSeriesQueryRequest) GetDeviceMeasurements() []string {
  return p.DeviceMeasurements
}

func (p *SingleSeriesQueryRequest) GetAscending() bool {
  return p.Ascending
}

func (p *SingleSeriesQueryRequest) GetFetchSize() Int {
  return p.FetchSize
}

func (p *SingleSeriesQueryRequest) GetDeduplicatedPathNum() Int {
  return p.DeduplicatedPathNum
}
var SingleSeriesQueryRequest_RequiredSlots_DEFAULT []Int

func (p *SingleSeriesQueryRequest) GetRequiredSlots() []Int {
  return p.RequiredSlots
}
func (p *SingleSeriesQueryRequest) IsSetTimeFilterBytes() bool {
  return p.TimeFilterBytes != nil
}

func (p *SingleSeriesQueryRequest) IsSetValueFilterBytes() bool {
  return p.ValueFilterBytes != nil
}

func (p *SingleSeriesQueryRequest) IsSetRequester() bool {
  return p.Requester != nil
}

func (p *SingleSeriesQueryRequest) IsSetHeader() bool {
  return p.Header != nil
}

func (p *SingleSeriesQueryRequest) IsSetRequiredSlots() bool {
  return p.RequiredSlots != nil
}

func (p *SingleSeriesQueryRequest) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetPath bool = false;
  var issetQueryId bool = false;
  var issetRequester bool = false;
  var issetHeader bool = false;
  var issetDataTypeOrdinal bool = false;
  var issetDeviceMeasurements bool = false;
  var issetAscending bool = false;
  var issetFetchSize bool = false;
  var issetDeduplicatedPathNum bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetPath = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetQueryId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetRequester = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
        issetHeader = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
        issetDataTypeOrdinal = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 8:
      if fieldTypeId == thrift.SET {
        if err := p.ReadField8(ctx, iprot); err != nil {
          return err
        }
        issetDeviceMeasurements = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 9:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField9(ctx, iprot); err != nil {
          return err
        }
        issetAscending = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 10:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField10(ctx, iprot); err != nil {
          return err
        }
        issetFetchSize = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 11:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField11(ctx, iprot); err != nil {
          return err
        }
        issetDeduplicatedPathNum = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 12:
      if fieldTypeId == thrift.SET {
        if err := p.ReadField12(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetPath{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Path is not set"));
  }
  if !issetQueryId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field QueryId is not set"));
  }
  if !issetRequester{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Requester is not set"));
  }
  if !issetHeader{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Header is not set"));
  }
  if !issetDataTypeOrdinal{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DataTypeOrdinal is not set"));
  }
  if !issetDeviceMeasurements{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DeviceMeasurements is not set"));
  }
  if !issetAscending{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Ascending is not set"));
  }
  if !issetFetchSize{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field FetchSize is not set"));
  }
  if !issetDeduplicatedPathNum{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DeduplicatedPathNum is not set"));
  }
  return nil
}

func (p *SingleSeriesQueryRequest)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.Path = v
}
  return nil
}

func (p *SingleSeriesQueryRequest)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.TimeFilterBytes = v
}
  return nil
}

func (p *SingleSeriesQueryRequest)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.ValueFilterBytes = v
}
  return nil
}

func (p *SingleSeriesQueryRequest)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  temp := Long(v)
  p.QueryId = temp
}
  return nil
}

func (p *SingleSeriesQueryRequest)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  p.Requester = &Node{}
  if err := p.Requester.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Requester), err)
  }
  return nil
}

func (p *SingleSeriesQueryRequest)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *SingleSeriesQueryRequest)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 7: ", err)
} else {
  temp := Int(v)
  p.DataTypeOrdinal = temp
}
  return nil
}

func (p *SingleSeriesQueryRequest)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadSetBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading set begin: ", err)
  }
  tSet := make([]string, 0, size)
  p.DeviceMeasurements =  tSet
  for i := 0; i < size; i ++ {
var _elem11 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem11 = v
}
    p.DeviceMeasurements = append(p.DeviceMeasurements, _elem11)
  }
  if err := iprot.ReadSetEnd(ctx); err != nil {
    return thrift.PrependError("error reading set end: ", err)
  }
  return nil
}

func (p *SingleSeriesQueryRequest)  ReadField9(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 9: ", err)
} else {
  p.Ascending = v
}
  return nil
}

func (p *SingleSeriesQueryRequest)  ReadField10(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 10: ", err)
} else {
  temp := Int(v)
  p.FetchSize = temp
}
  return nil
}

func (p *SingleSeriesQueryRequest)  ReadField11(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 11: ", err)
} else {
  temp := Int(v)
  p.DeduplicatedPathNum = temp
}
  return nil
}

func (p *SingleSeriesQueryRequest)  ReadField12(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadSetBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading set begin: ", err)
  }
  tSet := make([]Int, 0, size)
  p.RequiredSlots =  tSet
  for i := 0; i < size; i ++ {
var _elem12 Int
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    temp := Int(v)
    _elem12 = temp
}
    p.RequiredSlots = append(p.RequiredSlots, _elem12)
  }
  if err := iprot.ReadSetEnd(ctx); err != nil {
    return thrift.PrependError("error reading set end: ", err)
  }
  return nil
}

func (p *SingleSeriesQueryRequest) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "SingleSeriesQueryRequest"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
    if err := p.writeField8(ctx, oprot); err != nil { return err }
    if err := p.writeField9(ctx, oprot); err != nil { return err }
    if err := p.writeField10(ctx, oprot); err != nil { return err }
    if err := p.writeField11(ctx, oprot); err != nil { return err }
    if err := p.writeField12(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *SingleSeriesQueryRequest) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "path", thrift.STRING, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:path: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Path)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.path (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:path: ", p), err) }
  return err
}

func (p *SingleSeriesQueryRequest) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetTimeFilterBytes() {
    if err := oprot.WriteFieldBegin(ctx, "timeFilterBytes", thrift.STRING, 2); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:timeFilterBytes: ", p), err) }
    if err := oprot.WriteBinary(ctx, p.TimeFilterBytes); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.timeFilterBytes (2) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 2:timeFilterBytes: ", p), err) }
  }
  return err
}

func (p *SingleSeriesQueryRequest) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetValueFilterBytes() {
    if err := oprot.WriteFieldBegin(ctx, "valueFilterBytes", thrift.STRING, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:valueFilterBytes: ", p), err) }
    if err := oprot.WriteBinary(ctx, p.ValueFilterBytes); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.valueFilterBytes (3) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:valueFilterBytes: ", p), err) }
  }
  return err
}

func (p *SingleSeriesQueryRequest) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "queryId", thrift.I64, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:queryId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.QueryId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.queryId (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:queryId: ", p), err) }
  return err
}

func (p *SingleSeriesQueryRequest) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "requester", thrift.STRUCT, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:requester: ", p), err) }
  if err := p.Requester.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Requester), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:requester: ", p), err) }
  return err
}

func (p *SingleSeriesQueryRequest) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 6); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:header: ", p), err) }
  if err := p.Header.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 6:header: ", p), err) }
  return err
}

func (p *SingleSeriesQueryRequest) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "dataTypeOrdinal", thrift.I32, 7); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:dataTypeOrdinal: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.DataTypeOrdinal)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.dataTypeOrdinal (7) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 7:dataTypeOrdinal: ", p), err) }
  return err
}

func (p *SingleSeriesQueryRequest) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "deviceMeasurements", thrift.SET, 8); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:deviceMeasurements: ", p), err) }
  if err := oprot.WriteSetBegin(ctx, thrift.STRING, len(p.DeviceMeasurements)); err != nil {
    return thrift.PrependError("error writing set begin: ", err)
  }
  for i := 0; i<len(p.DeviceMeasurements); i++ {
    for j := i+1; j<len(p.DeviceMeasurements); j++ {
      if func(tgt, src string) bool {
        if tgt != src { return false }
        return true
      }(p.DeviceMeasurements[i], p.DeviceMeasurements[j]) {
        return thrift.PrependError("", fmt.Errorf("%T error writing set field: slice is not unique", p.DeviceMeasurements))
      }
    }
  }
  for _, v := range p.DeviceMeasurements {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteSetEnd(ctx); err != nil {
    return thrift.PrependError("error writing set end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 8:deviceMeasurements: ", p), err) }
  return err
}

func (p *SingleSeriesQueryRequest) writeField9(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "ascending", thrift.BOOL, 9); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 9:ascending: ", p), err) }
  if err := oprot.WriteBool(ctx, bool(p.Ascending)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.ascending (9) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 9:ascending: ", p), err) }
  return err
}

func (p *SingleSeriesQueryRequest) writeField10(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "fetchSize", thrift.I32, 10); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 10:fetchSize: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.FetchSize)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.fetchSize (10) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 10:fetchSize: ", p), err) }
  return err
}

func (p *SingleSeriesQueryRequest) writeField11(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "deduplicatedPathNum", thrift.I32, 11); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 11:deduplicatedPathNum: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.DeduplicatedPathNum)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.deduplicatedPathNum (11) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 11:deduplicatedPathNum: ", p), err) }
  return err
}

func (p *SingleSeriesQueryRequest) writeField12(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetRequiredSlots() {
    if err := oprot.WriteFieldBegin(ctx, "requiredSlots", thrift.SET, 12); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 12:requiredSlots: ", p), err) }
    if err := oprot.WriteSetBegin(ctx, thrift.I32, len(p.RequiredSlots)); err != nil {
      return thrift.PrependError("error writing set begin: ", err)
    }
    for i := 0; i<len(p.RequiredSlots); i++ {
      for j := i+1; j<len(p.RequiredSlots); j++ {
        if func(tgt, src Int) bool {
          if tgt != src { return false }
          return true
        }(p.RequiredSlots[i], p.RequiredSlots[j]) {
          return thrift.PrependError("", fmt.Errorf("%T error writing set field: slice is not unique", p.RequiredSlots))
        }
      }
    }
    for _, v := range p.RequiredSlots {
      if err := oprot.WriteI32(ctx, int32(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteSetEnd(ctx); err != nil {
      return thrift.PrependError("error writing set end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 12:requiredSlots: ", p), err) }
  }
  return err
}

func (p *SingleSeriesQueryRequest) Equals(other *SingleSeriesQueryRequest) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.Path != other.Path { return false }
  if bytes.Compare(p.TimeFilterBytes, other.TimeFilterBytes) != 0 { return false }
  if bytes.Compare(p.ValueFilterBytes, other.ValueFilterBytes) != 0 { return false }
  if p.QueryId != other.QueryId { return false }
  if !p.Requester.Equals(other.Requester) { return false }
  if !p.Header.Equals(other.Header) { return false }
  if p.DataTypeOrdinal != other.DataTypeOrdinal { return false }
  if len(p.DeviceMeasurements) != len(other.DeviceMeasurements) { return false }
  for i, _tgt := range p.DeviceMeasurements {
    _src13 := other.DeviceMeasurements[i]
    if _tgt != _src13 { return false }
  }
  if p.Ascending != other.Ascending { return false }
  if p.FetchSize != other.FetchSize { return false }
  if p.DeduplicatedPathNum != other.DeduplicatedPathNum { return false }
  if len(p.RequiredSlots) != len(other.RequiredSlots) { return false }
  for i, _tgt := range p.RequiredSlots {
    _src14 := other.RequiredSlots[i]
    if _tgt != _src14 { return false }
  }
  return true
}

func (p *SingleSeriesQueryRequest) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("SingleSeriesQueryRequest(%+v)", *p)
}

// Attributes:
//  - Path
//  - TimeFilterBytes
//  - ValueFilterBytes
//  - QueryId
//  - Requester
//  - Header
//  - DataTypeOrdinal
//  - DeviceMeasurements
//  - Ascending
//  - FetchSize
//  - DeduplicatedPathNum
type MultSeriesQueryRequest struct {
  Path []string `thrift:"path,1,required" db:"path" json:"path"`
  TimeFilterBytes []byte `thrift:"timeFilterBytes,2" db:"timeFilterBytes" json:"timeFilterBytes,omitempty"`
  ValueFilterBytes []byte `thrift:"valueFilterBytes,3" db:"valueFilterBytes" json:"valueFilterBytes,omitempty"`
  QueryId Long `thrift:"queryId,4,required" db:"queryId" json:"queryId"`
  Requester *Node `thrift:"requester,5,required" db:"requester" json:"requester"`
  Header *RaftNode `thrift:"header,6,required" db:"header" json:"header"`
  DataTypeOrdinal []Int `thrift:"dataTypeOrdinal,7,required" db:"dataTypeOrdinal" json:"dataTypeOrdinal"`
  DeviceMeasurements map[string][]string `thrift:"deviceMeasurements,8,required" db:"deviceMeasurements" json:"deviceMeasurements"`
  Ascending bool `thrift:"ascending,9,required" db:"ascending" json:"ascending"`
  FetchSize Int `thrift:"fetchSize,10,required" db:"fetchSize" json:"fetchSize"`
  DeduplicatedPathNum Int `thrift:"deduplicatedPathNum,11,required" db:"deduplicatedPathNum" json:"deduplicatedPathNum"`
}

func NewMultSeriesQueryRequest() *MultSeriesQueryRequest {
  return &MultSeriesQueryRequest{}
}


func (p *MultSeriesQueryRequest) GetPath() []string {
  return p.Path
}
var MultSeriesQueryRequest_TimeFilterBytes_DEFAULT []byte

func (p *MultSeriesQueryRequest) GetTimeFilterBytes() []byte {
  return p.TimeFilterBytes
}
var MultSeriesQueryRequest_ValueFilterBytes_DEFAULT []byte

func (p *MultSeriesQueryRequest) GetValueFilterBytes() []byte {
  return p.ValueFilterBytes
}

func (p *MultSeriesQueryRequest) GetQueryId() Long {
  return p.QueryId
}
var MultSeriesQueryRequest_Requester_DEFAULT *Node
func (p *MultSeriesQueryRequest) GetRequester() *Node {
  if !p.IsSetRequester() {
    return MultSeriesQueryRequest_Requester_DEFAULT
  }
return p.Requester
}
var MultSeriesQueryRequest_Header_DEFAULT *RaftNode
func (p *MultSeriesQueryRequest) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return MultSeriesQueryRequest_Header_DEFAULT
  }
return p.Header
}

func (p *MultSeriesQueryRequest) GetDataTypeOrdinal() []Int {
  return p.DataTypeOrdinal
}

func (p *MultSeriesQueryRequest) GetDeviceMeasurements() map[string][]string {
  return p.DeviceMeasurements
}

func (p *MultSeriesQueryRequest) GetAscending() bool {
  return p.Ascending
}

func (p *MultSeriesQueryRequest) GetFetchSize() Int {
  return p.FetchSize
}

func (p *MultSeriesQueryRequest) GetDeduplicatedPathNum() Int {
  return p.DeduplicatedPathNum
}
func (p *MultSeriesQueryRequest) IsSetTimeFilterBytes() bool {
  return p.TimeFilterBytes != nil
}

func (p *MultSeriesQueryRequest) IsSetValueFilterBytes() bool {
  return p.ValueFilterBytes != nil
}

func (p *MultSeriesQueryRequest) IsSetRequester() bool {
  return p.Requester != nil
}

func (p *MultSeriesQueryRequest) IsSetHeader() bool {
  return p.Header != nil
}

func (p *MultSeriesQueryRequest) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetPath bool = false;
  var issetQueryId bool = false;
  var issetRequester bool = false;
  var issetHeader bool = false;
  var issetDataTypeOrdinal bool = false;
  var issetDeviceMeasurements bool = false;
  var issetAscending bool = false;
  var issetFetchSize bool = false;
  var issetDeduplicatedPathNum bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetPath = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetQueryId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetRequester = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
        issetHeader = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
        issetDataTypeOrdinal = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 8:
      if fieldTypeId == thrift.MAP {
        if err := p.ReadField8(ctx, iprot); err != nil {
          return err
        }
        issetDeviceMeasurements = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 9:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField9(ctx, iprot); err != nil {
          return err
        }
        issetAscending = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 10:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField10(ctx, iprot); err != nil {
          return err
        }
        issetFetchSize = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 11:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField11(ctx, iprot); err != nil {
          return err
        }
        issetDeduplicatedPathNum = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetPath{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Path is not set"));
  }
  if !issetQueryId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field QueryId is not set"));
  }
  if !issetRequester{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Requester is not set"));
  }
  if !issetHeader{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Header is not set"));
  }
  if !issetDataTypeOrdinal{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DataTypeOrdinal is not set"));
  }
  if !issetDeviceMeasurements{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DeviceMeasurements is not set"));
  }
  if !issetAscending{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Ascending is not set"));
  }
  if !issetFetchSize{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field FetchSize is not set"));
  }
  if !issetDeduplicatedPathNum{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DeduplicatedPathNum is not set"));
  }
  return nil
}

func (p *MultSeriesQueryRequest)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Path =  tSlice
  for i := 0; i < size; i ++ {
var _elem15 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem15 = v
}
    p.Path = append(p.Path, _elem15)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *MultSeriesQueryRequest)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.TimeFilterBytes = v
}
  return nil
}

func (p *MultSeriesQueryRequest)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.ValueFilterBytes = v
}
  return nil
}

func (p *MultSeriesQueryRequest)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  temp := Long(v)
  p.QueryId = temp
}
  return nil
}

func (p *MultSeriesQueryRequest)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  p.Requester = &Node{}
  if err := p.Requester.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Requester), err)
  }
  return nil
}

func (p *MultSeriesQueryRequest)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *MultSeriesQueryRequest)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]Int, 0, size)
  p.DataTypeOrdinal =  tSlice
  for i := 0; i < size; i ++ {
var _elem16 Int
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    temp := Int(v)
    _elem16 = temp
}
    p.DataTypeOrdinal = append(p.DataTypeOrdinal, _elem16)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *MultSeriesQueryRequest)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
  _, _, size, err := iprot.ReadMapBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
  }
  tMap := make(map[string][]string, size)
  p.DeviceMeasurements =  tMap
  for i := 0; i < size; i ++ {
var _key17 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _key17 = v
}
    _, size, err := iprot.ReadSetBegin(ctx)
    if err != nil {
      return thrift.PrependError("error reading set begin: ", err)
    }
    tSet := make([]string, 0, size)
    _val18 :=  tSet
    for i := 0; i < size; i ++ {
var _elem19 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _elem19 = v
}
      _val18 = append(_val18, _elem19)
    }
    if err := iprot.ReadSetEnd(ctx); err != nil {
      return thrift.PrependError("error reading set end: ", err)
    }
    p.DeviceMeasurements[_key17] = _val18
  }
  if err := iprot.ReadMapEnd(ctx); err != nil {
    return thrift.PrependError("error reading map end: ", err)
  }
  return nil
}

func (p *MultSeriesQueryRequest)  ReadField9(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 9: ", err)
} else {
  p.Ascending = v
}
  return nil
}

func (p *MultSeriesQueryRequest)  ReadField10(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 10: ", err)
} else {
  temp := Int(v)
  p.FetchSize = temp
}
  return nil
}

func (p *MultSeriesQueryRequest)  ReadField11(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 11: ", err)
} else {
  temp := Int(v)
  p.DeduplicatedPathNum = temp
}
  return nil
}

func (p *MultSeriesQueryRequest) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "MultSeriesQueryRequest"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
    if err := p.writeField8(ctx, oprot); err != nil { return err }
    if err := p.writeField9(ctx, oprot); err != nil { return err }
    if err := p.writeField10(ctx, oprot); err != nil { return err }
    if err := p.writeField11(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *MultSeriesQueryRequest) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "path", thrift.LIST, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:path: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Path)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Path {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:path: ", p), err) }
  return err
}

func (p *MultSeriesQueryRequest) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetTimeFilterBytes() {
    if err := oprot.WriteFieldBegin(ctx, "timeFilterBytes", thrift.STRING, 2); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:timeFilterBytes: ", p), err) }
    if err := oprot.WriteBinary(ctx, p.TimeFilterBytes); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.timeFilterBytes (2) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 2:timeFilterBytes: ", p), err) }
  }
  return err
}

func (p *MultSeriesQueryRequest) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetValueFilterBytes() {
    if err := oprot.WriteFieldBegin(ctx, "valueFilterBytes", thrift.STRING, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:valueFilterBytes: ", p), err) }
    if err := oprot.WriteBinary(ctx, p.ValueFilterBytes); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.valueFilterBytes (3) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:valueFilterBytes: ", p), err) }
  }
  return err
}

func (p *MultSeriesQueryRequest) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "queryId", thrift.I64, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:queryId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.QueryId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.queryId (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:queryId: ", p), err) }
  return err
}

func (p *MultSeriesQueryRequest) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "requester", thrift.STRUCT, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:requester: ", p), err) }
  if err := p.Requester.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Requester), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:requester: ", p), err) }
  return err
}

func (p *MultSeriesQueryRequest) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 6); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:header: ", p), err) }
  if err := p.Header.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 6:header: ", p), err) }
  return err
}

func (p *MultSeriesQueryRequest) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "dataTypeOrdinal", thrift.LIST, 7); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:dataTypeOrdinal: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.DataTypeOrdinal)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.DataTypeOrdinal {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 7:dataTypeOrdinal: ", p), err) }
  return err
}

func (p *MultSeriesQueryRequest) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "deviceMeasurements", thrift.MAP, 8); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:deviceMeasurements: ", p), err) }
  if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.SET, len(p.DeviceMeasurements)); err != nil {
    return thrift.PrependError("error writing map begin: ", err)
  }
  for k, v := range p.DeviceMeasurements {
    if err := oprot.WriteString(ctx, string(k)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    if err := oprot.WriteSetBegin(ctx, thrift.STRING, len(v)); err != nil {
      return thrift.PrependError("error writing set begin: ", err)
    }
    for i := 0; i<len(v); i++ {
      for j := i+1; j<len(v); j++ {
        if func(tgt, src string) bool {
          if tgt != src { return false }
          return true
        }(v[i], v[j]) {
          return thrift.PrependError("", fmt.Errorf("%T error writing set field: slice is not unique", v))
        }
      }
    }
    for _, v := range v {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteSetEnd(ctx); err != nil {
      return thrift.PrependError("error writing set end: ", err)
    }
  }
  if err := oprot.WriteMapEnd(ctx); err != nil {
    return thrift.PrependError("error writing map end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 8:deviceMeasurements: ", p), err) }
  return err
}

func (p *MultSeriesQueryRequest) writeField9(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "ascending", thrift.BOOL, 9); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 9:ascending: ", p), err) }
  if err := oprot.WriteBool(ctx, bool(p.Ascending)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.ascending (9) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 9:ascending: ", p), err) }
  return err
}

func (p *MultSeriesQueryRequest) writeField10(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "fetchSize", thrift.I32, 10); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 10:fetchSize: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.FetchSize)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.fetchSize (10) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 10:fetchSize: ", p), err) }
  return err
}

func (p *MultSeriesQueryRequest) writeField11(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "deduplicatedPathNum", thrift.I32, 11); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 11:deduplicatedPathNum: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.DeduplicatedPathNum)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.deduplicatedPathNum (11) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 11:deduplicatedPathNum: ", p), err) }
  return err
}

func (p *MultSeriesQueryRequest) Equals(other *MultSeriesQueryRequest) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if len(p.Path) != len(other.Path) { return false }
  for i, _tgt := range p.Path {
    _src20 := other.Path[i]
    if _tgt != _src20 { return false }
  }
  if bytes.Compare(p.TimeFilterBytes, other.TimeFilterBytes) != 0 { return false }
  if bytes.Compare(p.ValueFilterBytes, other.ValueFilterBytes) != 0 { return false }
  if p.QueryId != other.QueryId { return false }
  if !p.Requester.Equals(other.Requester) { return false }
  if !p.Header.Equals(other.Header) { return false }
  if len(p.DataTypeOrdinal) != len(other.DataTypeOrdinal) { return false }
  for i, _tgt := range p.DataTypeOrdinal {
    _src21 := other.DataTypeOrdinal[i]
    if _tgt != _src21 { return false }
  }
  if len(p.DeviceMeasurements) != len(other.DeviceMeasurements) { return false }
  for k, _tgt := range p.DeviceMeasurements {
    _src22 := other.DeviceMeasurements[k]
    if len(_tgt) != len(_src22) { return false }
    for i, _tgt := range _tgt {
      _src23 := _src22[i]
      if _tgt != _src23 { return false }
    }
  }
  if p.Ascending != other.Ascending { return false }
  if p.FetchSize != other.FetchSize { return false }
  if p.DeduplicatedPathNum != other.DeduplicatedPathNum { return false }
  return true
}

func (p *MultSeriesQueryRequest) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("MultSeriesQueryRequest(%+v)", *p)
}

// Attributes:
//  - Path
//  - QueryTime
//  - BeforeRange
//  - QueryId
//  - Requester
//  - Header
//  - DataTypeOrdinal
//  - DeviceMeasurements
type PreviousFillRequest struct {
  Path string `thrift:"path,1,required" db:"path" json:"path"`
  QueryTime Long `thrift:"queryTime,2,required" db:"queryTime" json:"queryTime"`
  BeforeRange Long `thrift:"beforeRange,3,required" db:"beforeRange" json:"beforeRange"`
  QueryId Long `thrift:"queryId,4,required" db:"queryId" json:"queryId"`
  Requester *Node `thrift:"requester,5,required" db:"requester" json:"requester"`
  Header *RaftNode `thrift:"header,6,required" db:"header" json:"header"`
  DataTypeOrdinal Int `thrift:"dataTypeOrdinal,7,required" db:"dataTypeOrdinal" json:"dataTypeOrdinal"`
  DeviceMeasurements []string `thrift:"deviceMeasurements,8,required" db:"deviceMeasurements" json:"deviceMeasurements"`
}

func NewPreviousFillRequest() *PreviousFillRequest {
  return &PreviousFillRequest{}
}


func (p *PreviousFillRequest) GetPath() string {
  return p.Path
}

func (p *PreviousFillRequest) GetQueryTime() Long {
  return p.QueryTime
}

func (p *PreviousFillRequest) GetBeforeRange() Long {
  return p.BeforeRange
}

func (p *PreviousFillRequest) GetQueryId() Long {
  return p.QueryId
}
var PreviousFillRequest_Requester_DEFAULT *Node
func (p *PreviousFillRequest) GetRequester() *Node {
  if !p.IsSetRequester() {
    return PreviousFillRequest_Requester_DEFAULT
  }
return p.Requester
}
var PreviousFillRequest_Header_DEFAULT *RaftNode
func (p *PreviousFillRequest) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return PreviousFillRequest_Header_DEFAULT
  }
return p.Header
}

func (p *PreviousFillRequest) GetDataTypeOrdinal() Int {
  return p.DataTypeOrdinal
}

func (p *PreviousFillRequest) GetDeviceMeasurements() []string {
  return p.DeviceMeasurements
}
func (p *PreviousFillRequest) IsSetRequester() bool {
  return p.Requester != nil
}

func (p *PreviousFillRequest) IsSetHeader() bool {
  return p.Header != nil
}

func (p *PreviousFillRequest) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetPath bool = false;
  var issetQueryTime bool = false;
  var issetBeforeRange bool = false;
  var issetQueryId bool = false;
  var issetRequester bool = false;
  var issetHeader bool = false;
  var issetDataTypeOrdinal bool = false;
  var issetDeviceMeasurements bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetPath = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetQueryTime = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetBeforeRange = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetQueryId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetRequester = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
        issetHeader = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
        issetDataTypeOrdinal = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 8:
      if fieldTypeId == thrift.SET {
        if err := p.ReadField8(ctx, iprot); err != nil {
          return err
        }
        issetDeviceMeasurements = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetPath{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Path is not set"));
  }
  if !issetQueryTime{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field QueryTime is not set"));
  }
  if !issetBeforeRange{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field BeforeRange is not set"));
  }
  if !issetQueryId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field QueryId is not set"));
  }
  if !issetRequester{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Requester is not set"));
  }
  if !issetHeader{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Header is not set"));
  }
  if !issetDataTypeOrdinal{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DataTypeOrdinal is not set"));
  }
  if !issetDeviceMeasurements{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DeviceMeasurements is not set"));
  }
  return nil
}

func (p *PreviousFillRequest)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.Path = v
}
  return nil
}

func (p *PreviousFillRequest)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  temp := Long(v)
  p.QueryTime = temp
}
  return nil
}

func (p *PreviousFillRequest)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  temp := Long(v)
  p.BeforeRange = temp
}
  return nil
}

func (p *PreviousFillRequest)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  temp := Long(v)
  p.QueryId = temp
}
  return nil
}

func (p *PreviousFillRequest)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  p.Requester = &Node{}
  if err := p.Requester.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Requester), err)
  }
  return nil
}

func (p *PreviousFillRequest)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *PreviousFillRequest)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 7: ", err)
} else {
  temp := Int(v)
  p.DataTypeOrdinal = temp
}
  return nil
}

func (p *PreviousFillRequest)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadSetBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading set begin: ", err)
  }
  tSet := make([]string, 0, size)
  p.DeviceMeasurements =  tSet
  for i := 0; i < size; i ++ {
var _elem24 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem24 = v
}
    p.DeviceMeasurements = append(p.DeviceMeasurements, _elem24)
  }
  if err := iprot.ReadSetEnd(ctx); err != nil {
    return thrift.PrependError("error reading set end: ", err)
  }
  return nil
}

func (p *PreviousFillRequest) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "PreviousFillRequest"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
    if err := p.writeField8(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *PreviousFillRequest) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "path", thrift.STRING, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:path: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Path)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.path (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:path: ", p), err) }
  return err
}

func (p *PreviousFillRequest) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "queryTime", thrift.I64, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:queryTime: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.QueryTime)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.queryTime (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:queryTime: ", p), err) }
  return err
}

func (p *PreviousFillRequest) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "beforeRange", thrift.I64, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:beforeRange: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.BeforeRange)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.beforeRange (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:beforeRange: ", p), err) }
  return err
}

func (p *PreviousFillRequest) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "queryId", thrift.I64, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:queryId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.QueryId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.queryId (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:queryId: ", p), err) }
  return err
}

func (p *PreviousFillRequest) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "requester", thrift.STRUCT, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:requester: ", p), err) }
  if err := p.Requester.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Requester), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:requester: ", p), err) }
  return err
}

func (p *PreviousFillRequest) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 6); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:header: ", p), err) }
  if err := p.Header.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 6:header: ", p), err) }
  return err
}

func (p *PreviousFillRequest) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "dataTypeOrdinal", thrift.I32, 7); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:dataTypeOrdinal: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.DataTypeOrdinal)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.dataTypeOrdinal (7) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 7:dataTypeOrdinal: ", p), err) }
  return err
}

func (p *PreviousFillRequest) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "deviceMeasurements", thrift.SET, 8); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:deviceMeasurements: ", p), err) }
  if err := oprot.WriteSetBegin(ctx, thrift.STRING, len(p.DeviceMeasurements)); err != nil {
    return thrift.PrependError("error writing set begin: ", err)
  }
  for i := 0; i<len(p.DeviceMeasurements); i++ {
    for j := i+1; j<len(p.DeviceMeasurements); j++ {
      if func(tgt, src string) bool {
        if tgt != src { return false }
        return true
      }(p.DeviceMeasurements[i], p.DeviceMeasurements[j]) {
        return thrift.PrependError("", fmt.Errorf("%T error writing set field: slice is not unique", p.DeviceMeasurements))
      }
    }
  }
  for _, v := range p.DeviceMeasurements {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteSetEnd(ctx); err != nil {
    return thrift.PrependError("error writing set end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 8:deviceMeasurements: ", p), err) }
  return err
}

func (p *PreviousFillRequest) Equals(other *PreviousFillRequest) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.Path != other.Path { return false }
  if p.QueryTime != other.QueryTime { return false }
  if p.BeforeRange != other.BeforeRange { return false }
  if p.QueryId != other.QueryId { return false }
  if !p.Requester.Equals(other.Requester) { return false }
  if !p.Header.Equals(other.Header) { return false }
  if p.DataTypeOrdinal != other.DataTypeOrdinal { return false }
  if len(p.DeviceMeasurements) != len(other.DeviceMeasurements) { return false }
  for i, _tgt := range p.DeviceMeasurements {
    _src25 := other.DeviceMeasurements[i]
    if _tgt != _src25 { return false }
  }
  return true
}

func (p *PreviousFillRequest) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("PreviousFillRequest(%+v)", *p)
}

type TNodeStatus struct {
}

func NewTNodeStatus() *TNodeStatus {
  return &TNodeStatus{}
}

func (p *TNodeStatus) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    if err := iprot.Skip(ctx, fieldTypeId); err != nil {
      return err
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TNodeStatus) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TNodeStatus"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TNodeStatus) Equals(other *TNodeStatus) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  return true
}

func (p *TNodeStatus) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TNodeStatus(%+v)", *p)
}

// Attributes:
//  - Path
//  - Aggregations
//  - DataTypeOrdinal
//  - TimeFilterBytes
//  - Header
//  - QueryId
//  - Requestor
//  - DeviceMeasurements
//  - Ascending
type GetAggrResultRequest struct {
  Path string `thrift:"path,1,required" db:"path" json:"path"`
  Aggregations []string `thrift:"aggregations,2,required" db:"aggregations" json:"aggregations"`
  DataTypeOrdinal Int `thrift:"dataTypeOrdinal,3,required" db:"dataTypeOrdinal" json:"dataTypeOrdinal"`
  TimeFilterBytes []byte `thrift:"timeFilterBytes,4" db:"timeFilterBytes" json:"timeFilterBytes,omitempty"`
  Header *RaftNode `thrift:"header,5,required" db:"header" json:"header"`
  QueryId Long `thrift:"queryId,6,required" db:"queryId" json:"queryId"`
  Requestor *Node `thrift:"requestor,7,required" db:"requestor" json:"requestor"`
  DeviceMeasurements []string `thrift:"deviceMeasurements,8,required" db:"deviceMeasurements" json:"deviceMeasurements"`
  Ascending bool `thrift:"ascending,9,required" db:"ascending" json:"ascending"`
}

func NewGetAggrResultRequest() *GetAggrResultRequest {
  return &GetAggrResultRequest{}
}


func (p *GetAggrResultRequest) GetPath() string {
  return p.Path
}

func (p *GetAggrResultRequest) GetAggregations() []string {
  return p.Aggregations
}

func (p *GetAggrResultRequest) GetDataTypeOrdinal() Int {
  return p.DataTypeOrdinal
}
var GetAggrResultRequest_TimeFilterBytes_DEFAULT []byte

func (p *GetAggrResultRequest) GetTimeFilterBytes() []byte {
  return p.TimeFilterBytes
}
var GetAggrResultRequest_Header_DEFAULT *RaftNode
func (p *GetAggrResultRequest) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return GetAggrResultRequest_Header_DEFAULT
  }
return p.Header
}

func (p *GetAggrResultRequest) GetQueryId() Long {
  return p.QueryId
}
var GetAggrResultRequest_Requestor_DEFAULT *Node
func (p *GetAggrResultRequest) GetRequestor() *Node {
  if !p.IsSetRequestor() {
    return GetAggrResultRequest_Requestor_DEFAULT
  }
return p.Requestor
}

func (p *GetAggrResultRequest) GetDeviceMeasurements() []string {
  return p.DeviceMeasurements
}

func (p *GetAggrResultRequest) GetAscending() bool {
  return p.Ascending
}
func (p *GetAggrResultRequest) IsSetTimeFilterBytes() bool {
  return p.TimeFilterBytes != nil
}

func (p *GetAggrResultRequest) IsSetHeader() bool {
  return p.Header != nil
}

func (p *GetAggrResultRequest) IsSetRequestor() bool {
  return p.Requestor != nil
}

func (p *GetAggrResultRequest) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetPath bool = false;
  var issetAggregations bool = false;
  var issetDataTypeOrdinal bool = false;
  var issetHeader bool = false;
  var issetQueryId bool = false;
  var issetRequestor bool = false;
  var issetDeviceMeasurements bool = false;
  var issetAscending bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetPath = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetAggregations = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetDataTypeOrdinal = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetHeader = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
        issetQueryId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
        issetRequestor = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 8:
      if fieldTypeId == thrift.SET {
        if err := p.ReadField8(ctx, iprot); err != nil {
          return err
        }
        issetDeviceMeasurements = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 9:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField9(ctx, iprot); err != nil {
          return err
        }
        issetAscending = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetPath{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Path is not set"));
  }
  if !issetAggregations{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Aggregations is not set"));
  }
  if !issetDataTypeOrdinal{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DataTypeOrdinal is not set"));
  }
  if !issetHeader{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Header is not set"));
  }
  if !issetQueryId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field QueryId is not set"));
  }
  if !issetRequestor{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Requestor is not set"));
  }
  if !issetDeviceMeasurements{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DeviceMeasurements is not set"));
  }
  if !issetAscending{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Ascending is not set"));
  }
  return nil
}

func (p *GetAggrResultRequest)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.Path = v
}
  return nil
}

func (p *GetAggrResultRequest)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Aggregations =  tSlice
  for i := 0; i < size; i ++ {
var _elem26 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem26 = v
}
    p.Aggregations = append(p.Aggregations, _elem26)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *GetAggrResultRequest)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  temp := Int(v)
  p.DataTypeOrdinal = temp
}
  return nil
}

func (p *GetAggrResultRequest)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.TimeFilterBytes = v
}
  return nil
}

func (p *GetAggrResultRequest)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *GetAggrResultRequest)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  temp := Long(v)
  p.QueryId = temp
}
  return nil
}

func (p *GetAggrResultRequest)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  p.Requestor = &Node{}
  if err := p.Requestor.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Requestor), err)
  }
  return nil
}

func (p *GetAggrResultRequest)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadSetBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading set begin: ", err)
  }
  tSet := make([]string, 0, size)
  p.DeviceMeasurements =  tSet
  for i := 0; i < size; i ++ {
var _elem27 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem27 = v
}
    p.DeviceMeasurements = append(p.DeviceMeasurements, _elem27)
  }
  if err := iprot.ReadSetEnd(ctx); err != nil {
    return thrift.PrependError("error reading set end: ", err)
  }
  return nil
}

func (p *GetAggrResultRequest)  ReadField9(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 9: ", err)
} else {
  p.Ascending = v
}
  return nil
}

func (p *GetAggrResultRequest) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "GetAggrResultRequest"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
    if err := p.writeField8(ctx, oprot); err != nil { return err }
    if err := p.writeField9(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *GetAggrResultRequest) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "path", thrift.STRING, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:path: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Path)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.path (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:path: ", p), err) }
  return err
}

func (p *GetAggrResultRequest) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "aggregations", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:aggregations: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Aggregations)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Aggregations {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:aggregations: ", p), err) }
  return err
}

func (p *GetAggrResultRequest) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "dataTypeOrdinal", thrift.I32, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:dataTypeOrdinal: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.DataTypeOrdinal)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.dataTypeOrdinal (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:dataTypeOrdinal: ", p), err) }
  return err
}

func (p *GetAggrResultRequest) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetTimeFilterBytes() {
    if err := oprot.WriteFieldBegin(ctx, "timeFilterBytes", thrift.STRING, 4); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:timeFilterBytes: ", p), err) }
    if err := oprot.WriteBinary(ctx, p.TimeFilterBytes); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.timeFilterBytes (4) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 4:timeFilterBytes: ", p), err) }
  }
  return err
}

func (p *GetAggrResultRequest) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:header: ", p), err) }
  if err := p.Header.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:header: ", p), err) }
  return err
}

func (p *GetAggrResultRequest) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "queryId", thrift.I64, 6); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:queryId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.QueryId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.queryId (6) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 6:queryId: ", p), err) }
  return err
}

func (p *GetAggrResultRequest) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "requestor", thrift.STRUCT, 7); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:requestor: ", p), err) }
  if err := p.Requestor.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Requestor), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 7:requestor: ", p), err) }
  return err
}

func (p *GetAggrResultRequest) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "deviceMeasurements", thrift.SET, 8); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:deviceMeasurements: ", p), err) }
  if err := oprot.WriteSetBegin(ctx, thrift.STRING, len(p.DeviceMeasurements)); err != nil {
    return thrift.PrependError("error writing set begin: ", err)
  }
  for i := 0; i<len(p.DeviceMeasurements); i++ {
    for j := i+1; j<len(p.DeviceMeasurements); j++ {
      if func(tgt, src string) bool {
        if tgt != src { return false }
        return true
      }(p.DeviceMeasurements[i], p.DeviceMeasurements[j]) {
        return thrift.PrependError("", fmt.Errorf("%T error writing set field: slice is not unique", p.DeviceMeasurements))
      }
    }
  }
  for _, v := range p.DeviceMeasurements {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteSetEnd(ctx); err != nil {
    return thrift.PrependError("error writing set end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 8:deviceMeasurements: ", p), err) }
  return err
}

func (p *GetAggrResultRequest) writeField9(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "ascending", thrift.BOOL, 9); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 9:ascending: ", p), err) }
  if err := oprot.WriteBool(ctx, bool(p.Ascending)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.ascending (9) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 9:ascending: ", p), err) }
  return err
}

func (p *GetAggrResultRequest) Equals(other *GetAggrResultRequest) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.Path != other.Path { return false }
  if len(p.Aggregations) != len(other.Aggregations) { return false }
  for i, _tgt := range p.Aggregations {
    _src28 := other.Aggregations[i]
    if _tgt != _src28 { return false }
  }
  if p.DataTypeOrdinal != other.DataTypeOrdinal { return false }
  if bytes.Compare(p.TimeFilterBytes, other.TimeFilterBytes) != 0 { return false }
  if !p.Header.Equals(other.Header) { return false }
  if p.QueryId != other.QueryId { return false }
  if !p.Requestor.Equals(other.Requestor) { return false }
  if len(p.DeviceMeasurements) != len(other.DeviceMeasurements) { return false }
  for i, _tgt := range p.DeviceMeasurements {
    _src29 := other.DeviceMeasurements[i]
    if _tgt != _src29 { return false }
  }
  if p.Ascending != other.Ascending { return false }
  return true
}

func (p *GetAggrResultRequest) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("GetAggrResultRequest(%+v)", *p)
}

// Attributes:
//  - Path
//  - DataTypeOrdinal
//  - TimeFilterBytes
//  - QueryId
//  - AggregationTypeOrdinals
//  - Header
//  - Requestor
//  - DeviceMeasurements
//  - Ascending
type GroupByRequest struct {
  Path string `thrift:"path,1,required" db:"path" json:"path"`
  DataTypeOrdinal Int `thrift:"dataTypeOrdinal,2,required" db:"dataTypeOrdinal" json:"dataTypeOrdinal"`
  TimeFilterBytes []byte `thrift:"timeFilterBytes,3" db:"timeFilterBytes" json:"timeFilterBytes,omitempty"`
  QueryId Long `thrift:"queryId,4,required" db:"queryId" json:"queryId"`
  AggregationTypeOrdinals []Int `thrift:"aggregationTypeOrdinals,5,required" db:"aggregationTypeOrdinals" json:"aggregationTypeOrdinals"`
  Header *RaftNode `thrift:"header,6,required" db:"header" json:"header"`
  Requestor *Node `thrift:"requestor,7,required" db:"requestor" json:"requestor"`
  DeviceMeasurements []string `thrift:"deviceMeasurements,8,required" db:"deviceMeasurements" json:"deviceMeasurements"`
  Ascending bool `thrift:"ascending,9,required" db:"ascending" json:"ascending"`
}

func NewGroupByRequest() *GroupByRequest {
  return &GroupByRequest{}
}


func (p *GroupByRequest) GetPath() string {
  return p.Path
}

func (p *GroupByRequest) GetDataTypeOrdinal() Int {
  return p.DataTypeOrdinal
}
var GroupByRequest_TimeFilterBytes_DEFAULT []byte

func (p *GroupByRequest) GetTimeFilterBytes() []byte {
  return p.TimeFilterBytes
}

func (p *GroupByRequest) GetQueryId() Long {
  return p.QueryId
}

func (p *GroupByRequest) GetAggregationTypeOrdinals() []Int {
  return p.AggregationTypeOrdinals
}
var GroupByRequest_Header_DEFAULT *RaftNode
func (p *GroupByRequest) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return GroupByRequest_Header_DEFAULT
  }
return p.Header
}
var GroupByRequest_Requestor_DEFAULT *Node
func (p *GroupByRequest) GetRequestor() *Node {
  if !p.IsSetRequestor() {
    return GroupByRequest_Requestor_DEFAULT
  }
return p.Requestor
}

func (p *GroupByRequest) GetDeviceMeasurements() []string {
  return p.DeviceMeasurements
}

func (p *GroupByRequest) GetAscending() bool {
  return p.Ascending
}
func (p *GroupByRequest) IsSetTimeFilterBytes() bool {
  return p.TimeFilterBytes != nil
}

func (p *GroupByRequest) IsSetHeader() bool {
  return p.Header != nil
}

func (p *GroupByRequest) IsSetRequestor() bool {
  return p.Requestor != nil
}

func (p *GroupByRequest) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetPath bool = false;
  var issetDataTypeOrdinal bool = false;
  var issetQueryId bool = false;
  var issetAggregationTypeOrdinals bool = false;
  var issetHeader bool = false;
  var issetRequestor bool = false;
  var issetDeviceMeasurements bool = false;
  var issetAscending bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetPath = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetDataTypeOrdinal = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetQueryId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetAggregationTypeOrdinals = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
        issetHeader = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
        issetRequestor = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 8:
      if fieldTypeId == thrift.SET {
        if err := p.ReadField8(ctx, iprot); err != nil {
          return err
        }
        issetDeviceMeasurements = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 9:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField9(ctx, iprot); err != nil {
          return err
        }
        issetAscending = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetPath{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Path is not set"));
  }
  if !issetDataTypeOrdinal{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DataTypeOrdinal is not set"));
  }
  if !issetQueryId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field QueryId is not set"));
  }
  if !issetAggregationTypeOrdinals{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field AggregationTypeOrdinals is not set"));
  }
  if !issetHeader{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Header is not set"));
  }
  if !issetRequestor{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Requestor is not set"));
  }
  if !issetDeviceMeasurements{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DeviceMeasurements is not set"));
  }
  if !issetAscending{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Ascending is not set"));
  }
  return nil
}

func (p *GroupByRequest)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.Path = v
}
  return nil
}

func (p *GroupByRequest)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  temp := Int(v)
  p.DataTypeOrdinal = temp
}
  return nil
}

func (p *GroupByRequest)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.TimeFilterBytes = v
}
  return nil
}

func (p *GroupByRequest)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  temp := Long(v)
  p.QueryId = temp
}
  return nil
}

func (p *GroupByRequest)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]Int, 0, size)
  p.AggregationTypeOrdinals =  tSlice
  for i := 0; i < size; i ++ {
var _elem30 Int
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    temp := Int(v)
    _elem30 = temp
}
    p.AggregationTypeOrdinals = append(p.AggregationTypeOrdinals, _elem30)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *GroupByRequest)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *GroupByRequest)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  p.Requestor = &Node{}
  if err := p.Requestor.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Requestor), err)
  }
  return nil
}

func (p *GroupByRequest)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadSetBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading set begin: ", err)
  }
  tSet := make([]string, 0, size)
  p.DeviceMeasurements =  tSet
  for i := 0; i < size; i ++ {
var _elem31 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem31 = v
}
    p.DeviceMeasurements = append(p.DeviceMeasurements, _elem31)
  }
  if err := iprot.ReadSetEnd(ctx); err != nil {
    return thrift.PrependError("error reading set end: ", err)
  }
  return nil
}

func (p *GroupByRequest)  ReadField9(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 9: ", err)
} else {
  p.Ascending = v
}
  return nil
}

func (p *GroupByRequest) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "GroupByRequest"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
    if err := p.writeField8(ctx, oprot); err != nil { return err }
    if err := p.writeField9(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *GroupByRequest) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "path", thrift.STRING, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:path: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Path)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.path (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:path: ", p), err) }
  return err
}

func (p *GroupByRequest) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "dataTypeOrdinal", thrift.I32, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:dataTypeOrdinal: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.DataTypeOrdinal)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.dataTypeOrdinal (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:dataTypeOrdinal: ", p), err) }
  return err
}

func (p *GroupByRequest) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetTimeFilterBytes() {
    if err := oprot.WriteFieldBegin(ctx, "timeFilterBytes", thrift.STRING, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:timeFilterBytes: ", p), err) }
    if err := oprot.WriteBinary(ctx, p.TimeFilterBytes); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.timeFilterBytes (3) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:timeFilterBytes: ", p), err) }
  }
  return err
}

func (p *GroupByRequest) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "queryId", thrift.I64, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:queryId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.QueryId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.queryId (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:queryId: ", p), err) }
  return err
}

func (p *GroupByRequest) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "aggregationTypeOrdinals", thrift.LIST, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:aggregationTypeOrdinals: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.AggregationTypeOrdinals)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.AggregationTypeOrdinals {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:aggregationTypeOrdinals: ", p), err) }
  return err
}

func (p *GroupByRequest) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 6); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:header: ", p), err) }
  if err := p.Header.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 6:header: ", p), err) }
  return err
}

func (p *GroupByRequest) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "requestor", thrift.STRUCT, 7); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:requestor: ", p), err) }
  if err := p.Requestor.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Requestor), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 7:requestor: ", p), err) }
  return err
}

func (p *GroupByRequest) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "deviceMeasurements", thrift.SET, 8); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:deviceMeasurements: ", p), err) }
  if err := oprot.WriteSetBegin(ctx, thrift.STRING, len(p.DeviceMeasurements)); err != nil {
    return thrift.PrependError("error writing set begin: ", err)
  }
  for i := 0; i<len(p.DeviceMeasurements); i++ {
    for j := i+1; j<len(p.DeviceMeasurements); j++ {
      if func(tgt, src string) bool {
        if tgt != src { return false }
        return true
      }(p.DeviceMeasurements[i], p.DeviceMeasurements[j]) {
        return thrift.PrependError("", fmt.Errorf("%T error writing set field: slice is not unique", p.DeviceMeasurements))
      }
    }
  }
  for _, v := range p.DeviceMeasurements {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteSetEnd(ctx); err != nil {
    return thrift.PrependError("error writing set end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 8:deviceMeasurements: ", p), err) }
  return err
}

func (p *GroupByRequest) writeField9(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "ascending", thrift.BOOL, 9); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 9:ascending: ", p), err) }
  if err := oprot.WriteBool(ctx, bool(p.Ascending)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.ascending (9) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 9:ascending: ", p), err) }
  return err
}

func (p *GroupByRequest) Equals(other *GroupByRequest) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.Path != other.Path { return false }
  if p.DataTypeOrdinal != other.DataTypeOrdinal { return false }
  if bytes.Compare(p.TimeFilterBytes, other.TimeFilterBytes) != 0 { return false }
  if p.QueryId != other.QueryId { return false }
  if len(p.AggregationTypeOrdinals) != len(other.AggregationTypeOrdinals) { return false }
  for i, _tgt := range p.AggregationTypeOrdinals {
    _src32 := other.AggregationTypeOrdinals[i]
    if _tgt != _src32 { return false }
  }
  if !p.Header.Equals(other.Header) { return false }
  if !p.Requestor.Equals(other.Requestor) { return false }
  if len(p.DeviceMeasurements) != len(other.DeviceMeasurements) { return false }
  for i, _tgt := range p.DeviceMeasurements {
    _src33 := other.DeviceMeasurements[i]
    if _tgt != _src33 { return false }
  }
  if p.Ascending != other.Ascending { return false }
  return true
}

func (p *GroupByRequest) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("GroupByRequest(%+v)", *p)
}

// Attributes:
//  - Paths
//  - DataTypeOrdinals
//  - QueryId
//  - DeviceMeasurements
//  - FilterBytes
//  - Header
//  - Requestor
type LastQueryRequest struct {
  Paths []string `thrift:"paths,1,required" db:"paths" json:"paths"`
  DataTypeOrdinals []Int `thrift:"dataTypeOrdinals,2,required" db:"dataTypeOrdinals" json:"dataTypeOrdinals"`
  QueryId Long `thrift:"queryId,3,required" db:"queryId" json:"queryId"`
  DeviceMeasurements map[string][]string `thrift:"deviceMeasurements,4,required" db:"deviceMeasurements" json:"deviceMeasurements"`
  FilterBytes []byte `thrift:"filterBytes,5" db:"filterBytes" json:"filterBytes,omitempty"`
  Header *RaftNode `thrift:"header,6,required" db:"header" json:"header"`
  Requestor *Node `thrift:"requestor,7,required" db:"requestor" json:"requestor"`
}

func NewLastQueryRequest() *LastQueryRequest {
  return &LastQueryRequest{}
}


func (p *LastQueryRequest) GetPaths() []string {
  return p.Paths
}

func (p *LastQueryRequest) GetDataTypeOrdinals() []Int {
  return p.DataTypeOrdinals
}

func (p *LastQueryRequest) GetQueryId() Long {
  return p.QueryId
}

func (p *LastQueryRequest) GetDeviceMeasurements() map[string][]string {
  return p.DeviceMeasurements
}
var LastQueryRequest_FilterBytes_DEFAULT []byte

func (p *LastQueryRequest) GetFilterBytes() []byte {
  return p.FilterBytes
}
var LastQueryRequest_Header_DEFAULT *RaftNode
func (p *LastQueryRequest) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return LastQueryRequest_Header_DEFAULT
  }
return p.Header
}
var LastQueryRequest_Requestor_DEFAULT *Node
func (p *LastQueryRequest) GetRequestor() *Node {
  if !p.IsSetRequestor() {
    return LastQueryRequest_Requestor_DEFAULT
  }
return p.Requestor
}
func (p *LastQueryRequest) IsSetFilterBytes() bool {
  return p.FilterBytes != nil
}

func (p *LastQueryRequest) IsSetHeader() bool {
  return p.Header != nil
}

func (p *LastQueryRequest) IsSetRequestor() bool {
  return p.Requestor != nil
}

func (p *LastQueryRequest) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetPaths bool = false;
  var issetDataTypeOrdinals bool = false;
  var issetQueryId bool = false;
  var issetDeviceMeasurements bool = false;
  var issetHeader bool = false;
  var issetRequestor bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetPaths = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetDataTypeOrdinals = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetQueryId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.MAP {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetDeviceMeasurements = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
        issetHeader = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
        issetRequestor = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetPaths{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Paths is not set"));
  }
  if !issetDataTypeOrdinals{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DataTypeOrdinals is not set"));
  }
  if !issetQueryId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field QueryId is not set"));
  }
  if !issetDeviceMeasurements{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DeviceMeasurements is not set"));
  }
  if !issetHeader{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Header is not set"));
  }
  if !issetRequestor{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Requestor is not set"));
  }
  return nil
}

func (p *LastQueryRequest)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Paths =  tSlice
  for i := 0; i < size; i ++ {
var _elem34 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem34 = v
}
    p.Paths = append(p.Paths, _elem34)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *LastQueryRequest)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]Int, 0, size)
  p.DataTypeOrdinals =  tSlice
  for i := 0; i < size; i ++ {
var _elem35 Int
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    temp := Int(v)
    _elem35 = temp
}
    p.DataTypeOrdinals = append(p.DataTypeOrdinals, _elem35)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *LastQueryRequest)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  temp := Long(v)
  p.QueryId = temp
}
  return nil
}

func (p *LastQueryRequest)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  _, _, size, err := iprot.ReadMapBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
  }
  tMap := make(map[string][]string, size)
  p.DeviceMeasurements =  tMap
  for i := 0; i < size; i ++ {
var _key36 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _key36 = v
}
    _, size, err := iprot.ReadSetBegin(ctx)
    if err != nil {
      return thrift.PrependError("error reading set begin: ", err)
    }
    tSet := make([]string, 0, size)
    _val37 :=  tSet
    for i := 0; i < size; i ++ {
var _elem38 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _elem38 = v
}
      _val37 = append(_val37, _elem38)
    }
    if err := iprot.ReadSetEnd(ctx); err != nil {
      return thrift.PrependError("error reading set end: ", err)
    }
    p.DeviceMeasurements[_key36] = _val37
  }
  if err := iprot.ReadMapEnd(ctx); err != nil {
    return thrift.PrependError("error reading map end: ", err)
  }
  return nil
}

func (p *LastQueryRequest)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.FilterBytes = v
}
  return nil
}

func (p *LastQueryRequest)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *LastQueryRequest)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  p.Requestor = &Node{}
  if err := p.Requestor.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Requestor), err)
  }
  return nil
}

func (p *LastQueryRequest) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "LastQueryRequest"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *LastQueryRequest) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "paths", thrift.LIST, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:paths: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Paths)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Paths {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:paths: ", p), err) }
  return err
}

func (p *LastQueryRequest) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "dataTypeOrdinals", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:dataTypeOrdinals: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.DataTypeOrdinals)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.DataTypeOrdinals {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:dataTypeOrdinals: ", p), err) }
  return err
}

func (p *LastQueryRequest) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "queryId", thrift.I64, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:queryId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.QueryId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.queryId (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:queryId: ", p), err) }
  return err
}

func (p *LastQueryRequest) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "deviceMeasurements", thrift.MAP, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:deviceMeasurements: ", p), err) }
  if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.SET, len(p.DeviceMeasurements)); err != nil {
    return thrift.PrependError("error writing map begin: ", err)
  }
  for k, v := range p.DeviceMeasurements {
    if err := oprot.WriteString(ctx, string(k)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    if err := oprot.WriteSetBegin(ctx, thrift.STRING, len(v)); err != nil {
      return thrift.PrependError("error writing set begin: ", err)
    }
    for i := 0; i<len(v); i++ {
      for j := i+1; j<len(v); j++ {
        if func(tgt, src string) bool {
          if tgt != src { return false }
          return true
        }(v[i], v[j]) {
          return thrift.PrependError("", fmt.Errorf("%T error writing set field: slice is not unique", v))
        }
      }
    }
    for _, v := range v {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteSetEnd(ctx); err != nil {
      return thrift.PrependError("error writing set end: ", err)
    }
  }
  if err := oprot.WriteMapEnd(ctx); err != nil {
    return thrift.PrependError("error writing map end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:deviceMeasurements: ", p), err) }
  return err
}

func (p *LastQueryRequest) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetFilterBytes() {
    if err := oprot.WriteFieldBegin(ctx, "filterBytes", thrift.STRING, 5); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:filterBytes: ", p), err) }
    if err := oprot.WriteBinary(ctx, p.FilterBytes); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.filterBytes (5) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 5:filterBytes: ", p), err) }
  }
  return err
}

func (p *LastQueryRequest) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 6); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:header: ", p), err) }
  if err := p.Header.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 6:header: ", p), err) }
  return err
}

func (p *LastQueryRequest) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "requestor", thrift.STRUCT, 7); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:requestor: ", p), err) }
  if err := p.Requestor.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Requestor), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 7:requestor: ", p), err) }
  return err
}

func (p *LastQueryRequest) Equals(other *LastQueryRequest) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if len(p.Paths) != len(other.Paths) { return false }
  for i, _tgt := range p.Paths {
    _src39 := other.Paths[i]
    if _tgt != _src39 { return false }
  }
  if len(p.DataTypeOrdinals) != len(other.DataTypeOrdinals) { return false }
  for i, _tgt := range p.DataTypeOrdinals {
    _src40 := other.DataTypeOrdinals[i]
    if _tgt != _src40 { return false }
  }
  if p.QueryId != other.QueryId { return false }
  if len(p.DeviceMeasurements) != len(other.DeviceMeasurements) { return false }
  for k, _tgt := range p.DeviceMeasurements {
    _src41 := other.DeviceMeasurements[k]
    if len(_tgt) != len(_src41) { return false }
    for i, _tgt := range _tgt {
      _src42 := _src41[i]
      if _tgt != _src42 { return false }
    }
  }
  if bytes.Compare(p.FilterBytes, other.FilterBytes) != 0 { return false }
  if !p.Header.Equals(other.Header) { return false }
  if !p.Requestor.Equals(other.Requestor) { return false }
  return true
}

func (p *LastQueryRequest) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("LastQueryRequest(%+v)", *p)
}

// Attributes:
//  - Paths
//  - DataTypes
//  - AliasList
//  - UnderAlignedEntity
type GetAllPathsResult_ struct {
  Paths []string `thrift:"paths,1,required" db:"paths" json:"paths"`
  DataTypes []int8 `thrift:"dataTypes,2,required" db:"dataTypes" json:"dataTypes"`
  AliasList []string `thrift:"aliasList,3" db:"aliasList" json:"aliasList,omitempty"`
  UnderAlignedEntity []bool `thrift:"underAlignedEntity,4,required" db:"underAlignedEntity" json:"underAlignedEntity"`
}

func NewGetAllPathsResult_() *GetAllPathsResult_ {
  return &GetAllPathsResult_{}
}


func (p *GetAllPathsResult_) GetPaths() []string {
  return p.Paths
}

func (p *GetAllPathsResult_) GetDataTypes() []int8 {
  return p.DataTypes
}
var GetAllPathsResult__AliasList_DEFAULT []string

func (p *GetAllPathsResult_) GetAliasList() []string {
  return p.AliasList
}

func (p *GetAllPathsResult_) GetUnderAlignedEntity() []bool {
  return p.UnderAlignedEntity
}
func (p *GetAllPathsResult_) IsSetAliasList() bool {
  return p.AliasList != nil
}

func (p *GetAllPathsResult_) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetPaths bool = false;
  var issetDataTypes bool = false;
  var issetUnderAlignedEntity bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetPaths = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetDataTypes = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetUnderAlignedEntity = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetPaths{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Paths is not set"));
  }
  if !issetDataTypes{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DataTypes is not set"));
  }
  if !issetUnderAlignedEntity{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field UnderAlignedEntity is not set"));
  }
  return nil
}

func (p *GetAllPathsResult_)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Paths =  tSlice
  for i := 0; i < size; i ++ {
var _elem43 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem43 = v
}
    p.Paths = append(p.Paths, _elem43)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *GetAllPathsResult_)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int8, 0, size)
  p.DataTypes =  tSlice
  for i := 0; i < size; i ++ {
var _elem44 int8
    if v, err := iprot.ReadByte(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    temp := int8(v)
    _elem44 = temp
}
    p.DataTypes = append(p.DataTypes, _elem44)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *GetAllPathsResult_)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.AliasList =  tSlice
  for i := 0; i < size; i ++ {
var _elem45 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem45 = v
}
    p.AliasList = append(p.AliasList, _elem45)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *GetAllPathsResult_)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]bool, 0, size)
  p.UnderAlignedEntity =  tSlice
  for i := 0; i < size; i ++ {
var _elem46 bool
    if v, err := iprot.ReadBool(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem46 = v
}
    p.UnderAlignedEntity = append(p.UnderAlignedEntity, _elem46)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *GetAllPathsResult_) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "GetAllPathsResult"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *GetAllPathsResult_) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "paths", thrift.LIST, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:paths: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Paths)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Paths {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:paths: ", p), err) }
  return err
}

func (p *GetAllPathsResult_) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "dataTypes", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:dataTypes: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.BYTE, len(p.DataTypes)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.DataTypes {
    if err := oprot.WriteByte(ctx, int8(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:dataTypes: ", p), err) }
  return err
}

func (p *GetAllPathsResult_) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetAliasList() {
    if err := oprot.WriteFieldBegin(ctx, "aliasList", thrift.LIST, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:aliasList: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.AliasList)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.AliasList {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:aliasList: ", p), err) }
  }
  return err
}

func (p *GetAllPathsResult_) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "underAlignedEntity", thrift.LIST, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:underAlignedEntity: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.BOOL, len(p.UnderAlignedEntity)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.UnderAlignedEntity {
    if err := oprot.WriteBool(ctx, bool(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:underAlignedEntity: ", p), err) }
  return err
}

func (p *GetAllPathsResult_) Equals(other *GetAllPathsResult_) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if len(p.Paths) != len(other.Paths) { return false }
  for i, _tgt := range p.Paths {
    _src47 := other.Paths[i]
    if _tgt != _src47 { return false }
  }
  if len(p.DataTypes) != len(other.DataTypes) { return false }
  for i, _tgt := range p.DataTypes {
    _src48 := other.DataTypes[i]
    if _tgt != _src48 { return false }
  }
  if len(p.AliasList) != len(other.AliasList) { return false }
  for i, _tgt := range p.AliasList {
    _src49 := other.AliasList[i]
    if _tgt != _src49 { return false }
  }
  if len(p.UnderAlignedEntity) != len(other.UnderAlignedEntity) { return false }
  for i, _tgt := range p.UnderAlignedEntity {
    _src50 := other.UnderAlignedEntity[i]
    if _tgt != _src50 { return false }
  }
  return true
}

func (p *GetAllPathsResult_) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("GetAllPathsResult_(%+v)", *p)
}

// Attributes:
//  - QueryId
//  - Header
//  - Requester
//  - PlanBinary
type MeasurementSchemaRequest struct {
  QueryId Long `thrift:"queryId,1,required" db:"queryId" json:"queryId"`
  Header *RaftNode `thrift:"header,2,required" db:"header" json:"header"`
  Requester *Node `thrift:"requester,3,required" db:"requester" json:"requester"`
  PlanBinary []byte `thrift:"planBinary,4,required" db:"planBinary" json:"planBinary"`
}

func NewMeasurementSchemaRequest() *MeasurementSchemaRequest {
  return &MeasurementSchemaRequest{}
}


func (p *MeasurementSchemaRequest) GetQueryId() Long {
  return p.QueryId
}
var MeasurementSchemaRequest_Header_DEFAULT *RaftNode
func (p *MeasurementSchemaRequest) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return MeasurementSchemaRequest_Header_DEFAULT
  }
return p.Header
}
var MeasurementSchemaRequest_Requester_DEFAULT *Node
func (p *MeasurementSchemaRequest) GetRequester() *Node {
  if !p.IsSetRequester() {
    return MeasurementSchemaRequest_Requester_DEFAULT
  }
return p.Requester
}

func (p *MeasurementSchemaRequest) GetPlanBinary() []byte {
  return p.PlanBinary
}
func (p *MeasurementSchemaRequest) IsSetHeader() bool {
  return p.Header != nil
}

func (p *MeasurementSchemaRequest) IsSetRequester() bool {
  return p.Requester != nil
}

func (p *MeasurementSchemaRequest) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetQueryId bool = false;
  var issetHeader bool = false;
  var issetRequester bool = false;
  var issetPlanBinary bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetQueryId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetHeader = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetRequester = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetPlanBinary = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetQueryId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field QueryId is not set"));
  }
  if !issetHeader{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Header is not set"));
  }
  if !issetRequester{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Requester is not set"));
  }
  if !issetPlanBinary{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PlanBinary is not set"));
  }
  return nil
}

func (p *MeasurementSchemaRequest)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  temp := Long(v)
  p.QueryId = temp
}
  return nil
}

func (p *MeasurementSchemaRequest)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *MeasurementSchemaRequest)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  p.Requester = &Node{}
  if err := p.Requester.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Requester), err)
  }
  return nil
}

func (p *MeasurementSchemaRequest)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.PlanBinary = v
}
  return nil
}

func (p *MeasurementSchemaRequest) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "MeasurementSchemaRequest"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *MeasurementSchemaRequest) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "queryId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:queryId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.QueryId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.queryId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:queryId: ", p), err) }
  return err
}

func (p *MeasurementSchemaRequest) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:header: ", p), err) }
  if err := p.Header.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:header: ", p), err) }
  return err
}

func (p *MeasurementSchemaRequest) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "requester", thrift.STRUCT, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:requester: ", p), err) }
  if err := p.Requester.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Requester), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:requester: ", p), err) }
  return err
}

func (p *MeasurementSchemaRequest) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "planBinary", thrift.STRING, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:planBinary: ", p), err) }
  if err := oprot.WriteBinary(ctx, p.PlanBinary); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.planBinary (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:planBinary: ", p), err) }
  return err
}

func (p *MeasurementSchemaRequest) Equals(other *MeasurementSchemaRequest) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.QueryId != other.QueryId { return false }
  if !p.Header.Equals(other.Header) { return false }
  if !p.Requester.Equals(other.Requester) { return false }
  if bytes.Compare(p.PlanBinary, other.PlanBinary) != 0 { return false }
  return true
}

func (p *MeasurementSchemaRequest) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("MeasurementSchemaRequest(%+v)", *p)
}

// Attributes:
//  - StartTime
//  - EndTime
//  - Nodes
type DataPartitionEntry struct {
  StartTime Long `thrift:"startTime,1,required" db:"startTime" json:"startTime"`
  EndTime Long `thrift:"endTime,2,required" db:"endTime" json:"endTime"`
  Nodes []*Node `thrift:"nodes,3,required" db:"nodes" json:"nodes"`
}

func NewDataPartitionEntry() *DataPartitionEntry {
  return &DataPartitionEntry{}
}


func (p *DataPartitionEntry) GetStartTime() Long {
  return p.StartTime
}

func (p *DataPartitionEntry) GetEndTime() Long {
  return p.EndTime
}

func (p *DataPartitionEntry) GetNodes() []*Node {
  return p.Nodes
}
func (p *DataPartitionEntry) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetStartTime bool = false;
  var issetEndTime bool = false;
  var issetNodes bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetStartTime = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetEndTime = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetNodes = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetStartTime{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field StartTime is not set"));
  }
  if !issetEndTime{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field EndTime is not set"));
  }
  if !issetNodes{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Nodes is not set"));
  }
  return nil
}

func (p *DataPartitionEntry)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  temp := Long(v)
  p.StartTime = temp
}
  return nil
}

func (p *DataPartitionEntry)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  temp := Long(v)
  p.EndTime = temp
}
  return nil
}

func (p *DataPartitionEntry)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]*Node, 0, size)
  p.Nodes =  tSlice
  for i := 0; i < size; i ++ {
    _elem51 := &Node{}
    if err := _elem51.Read(ctx, iprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem51), err)
    }
    p.Nodes = append(p.Nodes, _elem51)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *DataPartitionEntry) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "DataPartitionEntry"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *DataPartitionEntry) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "startTime", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:startTime: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.StartTime)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.startTime (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:startTime: ", p), err) }
  return err
}

func (p *DataPartitionEntry) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "endTime", thrift.I64, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:endTime: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.EndTime)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.endTime (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:endTime: ", p), err) }
  return err
}

func (p *DataPartitionEntry) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "nodes", thrift.LIST, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:nodes: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRUCT, len(p.Nodes)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Nodes {
    if err := v.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
    }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:nodes: ", p), err) }
  return err
}

func (p *DataPartitionEntry) Equals(other *DataPartitionEntry) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.StartTime != other.StartTime { return false }
  if p.EndTime != other.EndTime { return false }
  if len(p.Nodes) != len(other.Nodes) { return false }
  for i, _tgt := range p.Nodes {
    _src52 := other.Nodes[i]
    if !_tgt.Equals(_src52) { return false }
  }
  return true
}

func (p *DataPartitionEntry) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("DataPartitionEntry(%+v)", *p)
}

type RaftService interface {
  // Leader will call this method to all followers to ensure its authority.
  // <br>For the receiver,
  // The method will check the authority of the leader.
  // 
  // @param request information of the leader
  // @return if the leader is valid, HeartBeatResponse.term will set -1, and the follower will tell
  // leader its lastLogIndex; otherwise, the follower will tell the fake leader its term.
  // 
  // 
  // Parameters:
  //  - Request
  SendHeartbeat(ctx context.Context, request *HeartBeatRequest) (_r *HeartBeatResponse, _err error)
  // If a node wants to be a leader, it'll call the method to other nodes to get a vote.
  // <br>For the receiver,
  // The method will check whether the node can be a leader.
  // 
  // @param voteRequest a candidate that wants to be a leader.
  // @return -1 means agree, otherwise return the voter's term
  // 
  // 
  // Parameters:
  //  - Request
  StartElection(ctx context.Context, request *ElectionRequest) (_r Long, _err error)
  // Leader will call this method to send a batch of entries to all followers.
  // <br>For the receiver,
  // The method will check the authority of the leader and if the local log is complete.
  // If the leader is valid and local log is complete, the follower will append these entries to local log.
  // 
  // @param request entries that need to be appended and the information of the leader.
  // @return -1: agree, -2: log index mismatch , otherwise return the follower's term
  // 
  // 
  // Parameters:
  //  - Request
  AppendEntries(ctx context.Context, request *AppendEntriesRequest) (_r Long, _err error)
  // Leader will call this method to send a entry to all followers.
  // <br>For the receiver,
  // The method will check the authority of the leader and if the local log is complete.
  // If the leader is valid and local log is complete, the follower will append the entry to local log.
  // 
  // @param request entry that needs to be appended and the information of the leader.
  // @return -1: agree, -2: log index mismatch , otherwise return the follower's term
  // 
  // 
  // Parameters:
  //  - Request
  AppendEntry(ctx context.Context, request *AppendEntryRequest) (_r Long, _err error)
  // Parameters:
  //  - Request
  SendSnapshot(ctx context.Context, request *SendSnapshotRequest) (_err error)
  // Execute a binarized non-query PhysicalPlan
  // 
  // 
  // Parameters:
  //  - Request
  ExecuteNonQueryPlan(ctx context.Context, request *ExecutNonQueryReq) (_r *rpc.TSStatus, _err error)
  // Ask the leader for its commit index, used to check whether the node has caught up with the
  // leader.
  // 
  // 
  // Parameters:
  //  - Header
  RequestCommitIndex(ctx context.Context, header *RaftNode) (_r *RequestCommitIndexResponse, _err error)
  // Read a chunk of a file from the client. If the remaining of the file does not have enough
  // bytes, only the remaining will be returned.
  // Notice that when the last chunk of the file is read, the file will be deleted immediately.
  // 
  // 
  // Parameters:
  //  - FilePath
  //  - Offset
  //  - Length
  ReadFile(ctx context.Context, filePath string, offset Long, length Int) (_r []byte, _err error)
  // Test if a log of "index" and "term" exists.
  // 
  // 
  // Parameters:
  //  - Index
  //  - Term
  //  - Header
  MatchTerm(ctx context.Context, index Long, term Long, header *RaftNode) (_r bool, _err error)
  // When a follower finds that it already has a file in a snapshot locally, it calls this
  // interface to notify the leader to remove the associated hardlink.
  // 
  // 
  // Parameters:
  //  - HardLinkPath
  RemoveHardLink(ctx context.Context, hardLinkPath string) (_err error)
}

type RaftServiceClient struct {
  c thrift.TClient
  meta thrift.ResponseMeta
}

func NewRaftServiceClientFactory(t thrift.TTransport, f thrift.TProtocolFactory) *RaftServiceClient {
  return &RaftServiceClient{
    c: thrift.NewTStandardClient(f.GetProtocol(t), f.GetProtocol(t)),
  }
}

func NewRaftServiceClientProtocol(t thrift.TTransport, iprot thrift.TProtocol, oprot thrift.TProtocol) *RaftServiceClient {
  return &RaftServiceClient{
    c: thrift.NewTStandardClient(iprot, oprot),
  }
}

func NewRaftServiceClient(c thrift.TClient) *RaftServiceClient {
  return &RaftServiceClient{
    c: c,
  }
}

func (p *RaftServiceClient) Client_() thrift.TClient {
  return p.c
}

func (p *RaftServiceClient) LastResponseMeta_() thrift.ResponseMeta {
  return p.meta
}

func (p *RaftServiceClient) SetLastResponseMeta_(meta thrift.ResponseMeta) {
  p.meta = meta
}

// Leader will call this method to all followers to ensure its authority.
// <br>For the receiver,
// The method will check the authority of the leader.
// 
// @param request information of the leader
// @return if the leader is valid, HeartBeatResponse.term will set -1, and the follower will tell
// leader its lastLogIndex; otherwise, the follower will tell the fake leader its term.
// 
// 
// Parameters:
//  - Request
func (p *RaftServiceClient) SendHeartbeat(ctx context.Context, request *HeartBeatRequest) (_r *HeartBeatResponse, _err error) {
  var _args53 RaftServiceSendHeartbeatArgs
  _args53.Request = request
  var _result55 RaftServiceSendHeartbeatResult
  var _meta54 thrift.ResponseMeta
  _meta54, _err = p.Client_().Call(ctx, "sendHeartbeat", &_args53, &_result55)
  p.SetLastResponseMeta_(_meta54)
  if _err != nil {
    return
  }
  return _result55.GetSuccess(), nil
}

// If a node wants to be a leader, it'll call the method to other nodes to get a vote.
// <br>For the receiver,
// The method will check whether the node can be a leader.
// 
// @param voteRequest a candidate that wants to be a leader.
// @return -1 means agree, otherwise return the voter's term
// 
// 
// Parameters:
//  - Request
func (p *RaftServiceClient) StartElection(ctx context.Context, request *ElectionRequest) (_r Long, _err error) {
  var _args56 RaftServiceStartElectionArgs
  _args56.Request = request
  var _result58 RaftServiceStartElectionResult
  var _meta57 thrift.ResponseMeta
  _meta57, _err = p.Client_().Call(ctx, "startElection", &_args56, &_result58)
  p.SetLastResponseMeta_(_meta57)
  if _err != nil {
    return
  }
  return _result58.GetSuccess(), nil
}

// Leader will call this method to send a batch of entries to all followers.
// <br>For the receiver,
// The method will check the authority of the leader and if the local log is complete.
// If the leader is valid and local log is complete, the follower will append these entries to local log.
// 
// @param request entries that need to be appended and the information of the leader.
// @return -1: agree, -2: log index mismatch , otherwise return the follower's term
// 
// 
// Parameters:
//  - Request
func (p *RaftServiceClient) AppendEntries(ctx context.Context, request *AppendEntriesRequest) (_r Long, _err error) {
  var _args59 RaftServiceAppendEntriesArgs
  _args59.Request = request
  var _result61 RaftServiceAppendEntriesResult
  var _meta60 thrift.ResponseMeta
  _meta60, _err = p.Client_().Call(ctx, "appendEntries", &_args59, &_result61)
  p.SetLastResponseMeta_(_meta60)
  if _err != nil {
    return
  }
  return _result61.GetSuccess(), nil
}

// Leader will call this method to send a entry to all followers.
// <br>For the receiver,
// The method will check the authority of the leader and if the local log is complete.
// If the leader is valid and local log is complete, the follower will append the entry to local log.
// 
// @param request entry that needs to be appended and the information of the leader.
// @return -1: agree, -2: log index mismatch , otherwise return the follower's term
// 
// 
// Parameters:
//  - Request
func (p *RaftServiceClient) AppendEntry(ctx context.Context, request *AppendEntryRequest) (_r Long, _err error) {
  var _args62 RaftServiceAppendEntryArgs
  _args62.Request = request
  var _result64 RaftServiceAppendEntryResult
  var _meta63 thrift.ResponseMeta
  _meta63, _err = p.Client_().Call(ctx, "appendEntry", &_args62, &_result64)
  p.SetLastResponseMeta_(_meta63)
  if _err != nil {
    return
  }
  return _result64.GetSuccess(), nil
}

// Parameters:
//  - Request
func (p *RaftServiceClient) SendSnapshot(ctx context.Context, request *SendSnapshotRequest) (_err error) {
  var _args65 RaftServiceSendSnapshotArgs
  _args65.Request = request
  var _result67 RaftServiceSendSnapshotResult
  var _meta66 thrift.ResponseMeta
  _meta66, _err = p.Client_().Call(ctx, "sendSnapshot", &_args65, &_result67)
  p.SetLastResponseMeta_(_meta66)
  if _err != nil {
    return
  }
  return nil
}

// Execute a binarized non-query PhysicalPlan
// 
// 
// Parameters:
//  - Request
func (p *RaftServiceClient) ExecuteNonQueryPlan(ctx context.Context, request *ExecutNonQueryReq) (_r *rpc.TSStatus, _err error) {
  var _args68 RaftServiceExecuteNonQueryPlanArgs
  _args68.Request = request
  var _result70 RaftServiceExecuteNonQueryPlanResult
  var _meta69 thrift.ResponseMeta
  _meta69, _err = p.Client_().Call(ctx, "executeNonQueryPlan", &_args68, &_result70)
  p.SetLastResponseMeta_(_meta69)
  if _err != nil {
    return
  }
  return _result70.GetSuccess(), nil
}

// Ask the leader for its commit index, used to check whether the node has caught up with the
// leader.
// 
// 
// Parameters:
//  - Header
func (p *RaftServiceClient) RequestCommitIndex(ctx context.Context, header *RaftNode) (_r *RequestCommitIndexResponse, _err error) {
  var _args71 RaftServiceRequestCommitIndexArgs
  _args71.Header = header
  var _result73 RaftServiceRequestCommitIndexResult
  var _meta72 thrift.ResponseMeta
  _meta72, _err = p.Client_().Call(ctx, "requestCommitIndex", &_args71, &_result73)
  p.SetLastResponseMeta_(_meta72)
  if _err != nil {
    return
  }
  return _result73.GetSuccess(), nil
}

// Read a chunk of a file from the client. If the remaining of the file does not have enough
// bytes, only the remaining will be returned.
// Notice that when the last chunk of the file is read, the file will be deleted immediately.
// 
// 
// Parameters:
//  - FilePath
//  - Offset
//  - Length
func (p *RaftServiceClient) ReadFile(ctx context.Context, filePath string, offset Long, length Int) (_r []byte, _err error) {
  var _args74 RaftServiceReadFileArgs
  _args74.FilePath = filePath
  _args74.Offset = offset
  _args74.Length = length
  var _result76 RaftServiceReadFileResult
  var _meta75 thrift.ResponseMeta
  _meta75, _err = p.Client_().Call(ctx, "readFile", &_args74, &_result76)
  p.SetLastResponseMeta_(_meta75)
  if _err != nil {
    return
  }
  return _result76.GetSuccess(), nil
}

// Test if a log of "index" and "term" exists.
// 
// 
// Parameters:
//  - Index
//  - Term
//  - Header
func (p *RaftServiceClient) MatchTerm(ctx context.Context, index Long, term Long, header *RaftNode) (_r bool, _err error) {
  var _args77 RaftServiceMatchTermArgs
  _args77.Index = index
  _args77.Term = term
  _args77.Header = header
  var _result79 RaftServiceMatchTermResult
  var _meta78 thrift.ResponseMeta
  _meta78, _err = p.Client_().Call(ctx, "matchTerm", &_args77, &_result79)
  p.SetLastResponseMeta_(_meta78)
  if _err != nil {
    return
  }
  return _result79.GetSuccess(), nil
}

// When a follower finds that it already has a file in a snapshot locally, it calls this
// interface to notify the leader to remove the associated hardlink.
// 
// 
// Parameters:
//  - HardLinkPath
func (p *RaftServiceClient) RemoveHardLink(ctx context.Context, hardLinkPath string) (_err error) {
  var _args80 RaftServiceRemoveHardLinkArgs
  _args80.HardLinkPath = hardLinkPath
  var _result82 RaftServiceRemoveHardLinkResult
  var _meta81 thrift.ResponseMeta
  _meta81, _err = p.Client_().Call(ctx, "removeHardLink", &_args80, &_result82)
  p.SetLastResponseMeta_(_meta81)
  if _err != nil {
    return
  }
  return nil
}

type RaftServiceProcessor struct {
  processorMap map[string]thrift.TProcessorFunction
  handler RaftService
}

func (p *RaftServiceProcessor) AddToProcessorMap(key string, processor thrift.TProcessorFunction) {
  p.processorMap[key] = processor
}

func (p *RaftServiceProcessor) GetProcessorFunction(key string) (processor thrift.TProcessorFunction, ok bool) {
  processor, ok = p.processorMap[key]
  return processor, ok
}

func (p *RaftServiceProcessor) ProcessorMap() map[string]thrift.TProcessorFunction {
  return p.processorMap
}

func NewRaftServiceProcessor(handler RaftService) *RaftServiceProcessor {

  self83 := &RaftServiceProcessor{handler:handler, processorMap:make(map[string]thrift.TProcessorFunction)}
  self83.processorMap["sendHeartbeat"] = &raftServiceProcessorSendHeartbeat{handler:handler}
  self83.processorMap["startElection"] = &raftServiceProcessorStartElection{handler:handler}
  self83.processorMap["appendEntries"] = &raftServiceProcessorAppendEntries{handler:handler}
  self83.processorMap["appendEntry"] = &raftServiceProcessorAppendEntry{handler:handler}
  self83.processorMap["sendSnapshot"] = &raftServiceProcessorSendSnapshot{handler:handler}
  self83.processorMap["executeNonQueryPlan"] = &raftServiceProcessorExecuteNonQueryPlan{handler:handler}
  self83.processorMap["requestCommitIndex"] = &raftServiceProcessorRequestCommitIndex{handler:handler}
  self83.processorMap["readFile"] = &raftServiceProcessorReadFile{handler:handler}
  self83.processorMap["matchTerm"] = &raftServiceProcessorMatchTerm{handler:handler}
  self83.processorMap["removeHardLink"] = &raftServiceProcessorRemoveHardLink{handler:handler}
return self83
}

func (p *RaftServiceProcessor) Process(ctx context.Context, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  name, _, seqId, err2 := iprot.ReadMessageBegin(ctx)
  if err2 != nil { return false, thrift.WrapTException(err2) }
  if processor, ok := p.GetProcessorFunction(name); ok {
    return processor.Process(ctx, seqId, iprot, oprot)
  }
  iprot.Skip(ctx, thrift.STRUCT)
  iprot.ReadMessageEnd(ctx)
  x84 := thrift.NewTApplicationException(thrift.UNKNOWN_METHOD, "Unknown function " + name)
  oprot.WriteMessageBegin(ctx, name, thrift.EXCEPTION, seqId)
  x84.Write(ctx, oprot)
  oprot.WriteMessageEnd(ctx)
  oprot.Flush(ctx)
  return false, x84

}

type raftServiceProcessorSendHeartbeat struct {
  handler RaftService
}

func (p *raftServiceProcessorSendHeartbeat) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := RaftServiceSendHeartbeatArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "sendHeartbeat", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := RaftServiceSendHeartbeatResult{}
  var retval *HeartBeatResponse
  if retval, err2 = p.handler.SendHeartbeat(ctx, args.Request); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing sendHeartbeat: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "sendHeartbeat", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "sendHeartbeat", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type raftServiceProcessorStartElection struct {
  handler RaftService
}

func (p *raftServiceProcessorStartElection) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := RaftServiceStartElectionArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "startElection", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := RaftServiceStartElectionResult{}
  var retval Long
  if retval, err2 = p.handler.StartElection(ctx, args.Request); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing startElection: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "startElection", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = &retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "startElection", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type raftServiceProcessorAppendEntries struct {
  handler RaftService
}

func (p *raftServiceProcessorAppendEntries) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := RaftServiceAppendEntriesArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "appendEntries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := RaftServiceAppendEntriesResult{}
  var retval Long
  if retval, err2 = p.handler.AppendEntries(ctx, args.Request); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing appendEntries: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "appendEntries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = &retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "appendEntries", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type raftServiceProcessorAppendEntry struct {
  handler RaftService
}

func (p *raftServiceProcessorAppendEntry) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := RaftServiceAppendEntryArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "appendEntry", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := RaftServiceAppendEntryResult{}
  var retval Long
  if retval, err2 = p.handler.AppendEntry(ctx, args.Request); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing appendEntry: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "appendEntry", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = &retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "appendEntry", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type raftServiceProcessorSendSnapshot struct {
  handler RaftService
}

func (p *raftServiceProcessorSendSnapshot) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := RaftServiceSendSnapshotArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "sendSnapshot", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := RaftServiceSendSnapshotResult{}
  if err2 = p.handler.SendSnapshot(ctx, args.Request); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing sendSnapshot: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "sendSnapshot", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "sendSnapshot", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type raftServiceProcessorExecuteNonQueryPlan struct {
  handler RaftService
}

func (p *raftServiceProcessorExecuteNonQueryPlan) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := RaftServiceExecuteNonQueryPlanArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "executeNonQueryPlan", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := RaftServiceExecuteNonQueryPlanResult{}
  var retval *rpc.TSStatus
  if retval, err2 = p.handler.ExecuteNonQueryPlan(ctx, args.Request); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing executeNonQueryPlan: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "executeNonQueryPlan", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "executeNonQueryPlan", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type raftServiceProcessorRequestCommitIndex struct {
  handler RaftService
}

func (p *raftServiceProcessorRequestCommitIndex) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := RaftServiceRequestCommitIndexArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "requestCommitIndex", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := RaftServiceRequestCommitIndexResult{}
  var retval *RequestCommitIndexResponse
  if retval, err2 = p.handler.RequestCommitIndex(ctx, args.Header); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing requestCommitIndex: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "requestCommitIndex", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "requestCommitIndex", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type raftServiceProcessorReadFile struct {
  handler RaftService
}

func (p *raftServiceProcessorReadFile) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := RaftServiceReadFileArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "readFile", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := RaftServiceReadFileResult{}
  var retval []byte
  if retval, err2 = p.handler.ReadFile(ctx, args.FilePath, args.Offset, args.Length); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing readFile: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "readFile", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "readFile", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type raftServiceProcessorMatchTerm struct {
  handler RaftService
}

func (p *raftServiceProcessorMatchTerm) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := RaftServiceMatchTermArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "matchTerm", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := RaftServiceMatchTermResult{}
  var retval bool
  if retval, err2 = p.handler.MatchTerm(ctx, args.Index, args.Term, args.Header); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing matchTerm: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "matchTerm", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = &retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "matchTerm", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type raftServiceProcessorRemoveHardLink struct {
  handler RaftService
}

func (p *raftServiceProcessorRemoveHardLink) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := RaftServiceRemoveHardLinkArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "removeHardLink", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := RaftServiceRemoveHardLinkResult{}
  if err2 = p.handler.RemoveHardLink(ctx, args.HardLinkPath); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing removeHardLink: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "removeHardLink", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "removeHardLink", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}


// HELPER FUNCTIONS AND STRUCTURES

// Attributes:
//  - Request
type RaftServiceSendHeartbeatArgs struct {
  Request *HeartBeatRequest `thrift:"request,1" db:"request" json:"request"`
}

func NewRaftServiceSendHeartbeatArgs() *RaftServiceSendHeartbeatArgs {
  return &RaftServiceSendHeartbeatArgs{}
}

var RaftServiceSendHeartbeatArgs_Request_DEFAULT *HeartBeatRequest
func (p *RaftServiceSendHeartbeatArgs) GetRequest() *HeartBeatRequest {
  if !p.IsSetRequest() {
    return RaftServiceSendHeartbeatArgs_Request_DEFAULT
  }
return p.Request
}
func (p *RaftServiceSendHeartbeatArgs) IsSetRequest() bool {
  return p.Request != nil
}

func (p *RaftServiceSendHeartbeatArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *RaftServiceSendHeartbeatArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Request = &HeartBeatRequest{}
  if err := p.Request.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Request), err)
  }
  return nil
}

func (p *RaftServiceSendHeartbeatArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "sendHeartbeat_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *RaftServiceSendHeartbeatArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "request", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:request: ", p), err) }
  if err := p.Request.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Request), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:request: ", p), err) }
  return err
}

func (p *RaftServiceSendHeartbeatArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("RaftServiceSendHeartbeatArgs(%+v)", *p)
}

// Attributes:
//  - Success
type RaftServiceSendHeartbeatResult struct {
  Success *HeartBeatResponse `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewRaftServiceSendHeartbeatResult() *RaftServiceSendHeartbeatResult {
  return &RaftServiceSendHeartbeatResult{}
}

var RaftServiceSendHeartbeatResult_Success_DEFAULT *HeartBeatResponse
func (p *RaftServiceSendHeartbeatResult) GetSuccess() *HeartBeatResponse {
  if !p.IsSetSuccess() {
    return RaftServiceSendHeartbeatResult_Success_DEFAULT
  }
return p.Success
}
func (p *RaftServiceSendHeartbeatResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *RaftServiceSendHeartbeatResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *RaftServiceSendHeartbeatResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &HeartBeatResponse{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *RaftServiceSendHeartbeatResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "sendHeartbeat_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *RaftServiceSendHeartbeatResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *RaftServiceSendHeartbeatResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("RaftServiceSendHeartbeatResult(%+v)", *p)
}

// Attributes:
//  - Request
type RaftServiceStartElectionArgs struct {
  Request *ElectionRequest `thrift:"request,1" db:"request" json:"request"`
}

func NewRaftServiceStartElectionArgs() *RaftServiceStartElectionArgs {
  return &RaftServiceStartElectionArgs{}
}

var RaftServiceStartElectionArgs_Request_DEFAULT *ElectionRequest
func (p *RaftServiceStartElectionArgs) GetRequest() *ElectionRequest {
  if !p.IsSetRequest() {
    return RaftServiceStartElectionArgs_Request_DEFAULT
  }
return p.Request
}
func (p *RaftServiceStartElectionArgs) IsSetRequest() bool {
  return p.Request != nil
}

func (p *RaftServiceStartElectionArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *RaftServiceStartElectionArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Request = &ElectionRequest{}
  if err := p.Request.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Request), err)
  }
  return nil
}

func (p *RaftServiceStartElectionArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "startElection_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *RaftServiceStartElectionArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "request", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:request: ", p), err) }
  if err := p.Request.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Request), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:request: ", p), err) }
  return err
}

func (p *RaftServiceStartElectionArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("RaftServiceStartElectionArgs(%+v)", *p)
}

// Attributes:
//  - Success
type RaftServiceStartElectionResult struct {
  Success *Long `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewRaftServiceStartElectionResult() *RaftServiceStartElectionResult {
  return &RaftServiceStartElectionResult{}
}

var RaftServiceStartElectionResult_Success_DEFAULT Long
func (p *RaftServiceStartElectionResult) GetSuccess() Long {
  if !p.IsSetSuccess() {
    return RaftServiceStartElectionResult_Success_DEFAULT
  }
return *p.Success
}
func (p *RaftServiceStartElectionResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *RaftServiceStartElectionResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *RaftServiceStartElectionResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 0: ", err)
} else {
  temp := Long(v)
  p.Success = &temp
}
  return nil
}

func (p *RaftServiceStartElectionResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "startElection_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *RaftServiceStartElectionResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.I64, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.Success)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.success (0) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *RaftServiceStartElectionResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("RaftServiceStartElectionResult(%+v)", *p)
}

// Attributes:
//  - Request
type RaftServiceAppendEntriesArgs struct {
  Request *AppendEntriesRequest `thrift:"request,1" db:"request" json:"request"`
}

func NewRaftServiceAppendEntriesArgs() *RaftServiceAppendEntriesArgs {
  return &RaftServiceAppendEntriesArgs{}
}

var RaftServiceAppendEntriesArgs_Request_DEFAULT *AppendEntriesRequest
func (p *RaftServiceAppendEntriesArgs) GetRequest() *AppendEntriesRequest {
  if !p.IsSetRequest() {
    return RaftServiceAppendEntriesArgs_Request_DEFAULT
  }
return p.Request
}
func (p *RaftServiceAppendEntriesArgs) IsSetRequest() bool {
  return p.Request != nil
}

func (p *RaftServiceAppendEntriesArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *RaftServiceAppendEntriesArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Request = &AppendEntriesRequest{}
  if err := p.Request.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Request), err)
  }
  return nil
}

func (p *RaftServiceAppendEntriesArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "appendEntries_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *RaftServiceAppendEntriesArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "request", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:request: ", p), err) }
  if err := p.Request.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Request), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:request: ", p), err) }
  return err
}

func (p *RaftServiceAppendEntriesArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("RaftServiceAppendEntriesArgs(%+v)", *p)
}

// Attributes:
//  - Success
type RaftServiceAppendEntriesResult struct {
  Success *Long `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewRaftServiceAppendEntriesResult() *RaftServiceAppendEntriesResult {
  return &RaftServiceAppendEntriesResult{}
}

var RaftServiceAppendEntriesResult_Success_DEFAULT Long
func (p *RaftServiceAppendEntriesResult) GetSuccess() Long {
  if !p.IsSetSuccess() {
    return RaftServiceAppendEntriesResult_Success_DEFAULT
  }
return *p.Success
}
func (p *RaftServiceAppendEntriesResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *RaftServiceAppendEntriesResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *RaftServiceAppendEntriesResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 0: ", err)
} else {
  temp := Long(v)
  p.Success = &temp
}
  return nil
}

func (p *RaftServiceAppendEntriesResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "appendEntries_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *RaftServiceAppendEntriesResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.I64, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.Success)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.success (0) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *RaftServiceAppendEntriesResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("RaftServiceAppendEntriesResult(%+v)", *p)
}

// Attributes:
//  - Request
type RaftServiceAppendEntryArgs struct {
  Request *AppendEntryRequest `thrift:"request,1" db:"request" json:"request"`
}

func NewRaftServiceAppendEntryArgs() *RaftServiceAppendEntryArgs {
  return &RaftServiceAppendEntryArgs{}
}

var RaftServiceAppendEntryArgs_Request_DEFAULT *AppendEntryRequest
func (p *RaftServiceAppendEntryArgs) GetRequest() *AppendEntryRequest {
  if !p.IsSetRequest() {
    return RaftServiceAppendEntryArgs_Request_DEFAULT
  }
return p.Request
}
func (p *RaftServiceAppendEntryArgs) IsSetRequest() bool {
  return p.Request != nil
}

func (p *RaftServiceAppendEntryArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *RaftServiceAppendEntryArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Request = &AppendEntryRequest{}
  if err := p.Request.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Request), err)
  }
  return nil
}

func (p *RaftServiceAppendEntryArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "appendEntry_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *RaftServiceAppendEntryArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "request", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:request: ", p), err) }
  if err := p.Request.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Request), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:request: ", p), err) }
  return err
}

func (p *RaftServiceAppendEntryArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("RaftServiceAppendEntryArgs(%+v)", *p)
}

// Attributes:
//  - Success
type RaftServiceAppendEntryResult struct {
  Success *Long `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewRaftServiceAppendEntryResult() *RaftServiceAppendEntryResult {
  return &RaftServiceAppendEntryResult{}
}

var RaftServiceAppendEntryResult_Success_DEFAULT Long
func (p *RaftServiceAppendEntryResult) GetSuccess() Long {
  if !p.IsSetSuccess() {
    return RaftServiceAppendEntryResult_Success_DEFAULT
  }
return *p.Success
}
func (p *RaftServiceAppendEntryResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *RaftServiceAppendEntryResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *RaftServiceAppendEntryResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 0: ", err)
} else {
  temp := Long(v)
  p.Success = &temp
}
  return nil
}

func (p *RaftServiceAppendEntryResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "appendEntry_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *RaftServiceAppendEntryResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.I64, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.Success)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.success (0) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *RaftServiceAppendEntryResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("RaftServiceAppendEntryResult(%+v)", *p)
}

// Attributes:
//  - Request
type RaftServiceSendSnapshotArgs struct {
  Request *SendSnapshotRequest `thrift:"request,1" db:"request" json:"request"`
}

func NewRaftServiceSendSnapshotArgs() *RaftServiceSendSnapshotArgs {
  return &RaftServiceSendSnapshotArgs{}
}

var RaftServiceSendSnapshotArgs_Request_DEFAULT *SendSnapshotRequest
func (p *RaftServiceSendSnapshotArgs) GetRequest() *SendSnapshotRequest {
  if !p.IsSetRequest() {
    return RaftServiceSendSnapshotArgs_Request_DEFAULT
  }
return p.Request
}
func (p *RaftServiceSendSnapshotArgs) IsSetRequest() bool {
  return p.Request != nil
}

func (p *RaftServiceSendSnapshotArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *RaftServiceSendSnapshotArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Request = &SendSnapshotRequest{}
  if err := p.Request.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Request), err)
  }
  return nil
}

func (p *RaftServiceSendSnapshotArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "sendSnapshot_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *RaftServiceSendSnapshotArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "request", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:request: ", p), err) }
  if err := p.Request.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Request), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:request: ", p), err) }
  return err
}

func (p *RaftServiceSendSnapshotArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("RaftServiceSendSnapshotArgs(%+v)", *p)
}

type RaftServiceSendSnapshotResult struct {
}

func NewRaftServiceSendSnapshotResult() *RaftServiceSendSnapshotResult {
  return &RaftServiceSendSnapshotResult{}
}

func (p *RaftServiceSendSnapshotResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    if err := iprot.Skip(ctx, fieldTypeId); err != nil {
      return err
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *RaftServiceSendSnapshotResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "sendSnapshot_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *RaftServiceSendSnapshotResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("RaftServiceSendSnapshotResult(%+v)", *p)
}

// Attributes:
//  - Request
type RaftServiceExecuteNonQueryPlanArgs struct {
  Request *ExecutNonQueryReq `thrift:"request,1" db:"request" json:"request"`
}

func NewRaftServiceExecuteNonQueryPlanArgs() *RaftServiceExecuteNonQueryPlanArgs {
  return &RaftServiceExecuteNonQueryPlanArgs{}
}

var RaftServiceExecuteNonQueryPlanArgs_Request_DEFAULT *ExecutNonQueryReq
func (p *RaftServiceExecuteNonQueryPlanArgs) GetRequest() *ExecutNonQueryReq {
  if !p.IsSetRequest() {
    return RaftServiceExecuteNonQueryPlanArgs_Request_DEFAULT
  }
return p.Request
}
func (p *RaftServiceExecuteNonQueryPlanArgs) IsSetRequest() bool {
  return p.Request != nil
}

func (p *RaftServiceExecuteNonQueryPlanArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *RaftServiceExecuteNonQueryPlanArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Request = &ExecutNonQueryReq{}
  if err := p.Request.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Request), err)
  }
  return nil
}

func (p *RaftServiceExecuteNonQueryPlanArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeNonQueryPlan_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *RaftServiceExecuteNonQueryPlanArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "request", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:request: ", p), err) }
  if err := p.Request.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Request), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:request: ", p), err) }
  return err
}

func (p *RaftServiceExecuteNonQueryPlanArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("RaftServiceExecuteNonQueryPlanArgs(%+v)", *p)
}

// Attributes:
//  - Success
type RaftServiceExecuteNonQueryPlanResult struct {
  Success *rpc.TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewRaftServiceExecuteNonQueryPlanResult() *RaftServiceExecuteNonQueryPlanResult {
  return &RaftServiceExecuteNonQueryPlanResult{}
}

var RaftServiceExecuteNonQueryPlanResult_Success_DEFAULT *rpc.TSStatus
func (p *RaftServiceExecuteNonQueryPlanResult) GetSuccess() *rpc.TSStatus {
  if !p.IsSetSuccess() {
    return RaftServiceExecuteNonQueryPlanResult_Success_DEFAULT
  }
return p.Success
}
func (p *RaftServiceExecuteNonQueryPlanResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *RaftServiceExecuteNonQueryPlanResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *RaftServiceExecuteNonQueryPlanResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &rpc.TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *RaftServiceExecuteNonQueryPlanResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeNonQueryPlan_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *RaftServiceExecuteNonQueryPlanResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *RaftServiceExecuteNonQueryPlanResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("RaftServiceExecuteNonQueryPlanResult(%+v)", *p)
}

// Attributes:
//  - Header
type RaftServiceRequestCommitIndexArgs struct {
  Header *RaftNode `thrift:"header,1" db:"header" json:"header"`
}

func NewRaftServiceRequestCommitIndexArgs() *RaftServiceRequestCommitIndexArgs {
  return &RaftServiceRequestCommitIndexArgs{}
}

var RaftServiceRequestCommitIndexArgs_Header_DEFAULT *RaftNode
func (p *RaftServiceRequestCommitIndexArgs) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return RaftServiceRequestCommitIndexArgs_Header_DEFAULT
  }
return p.Header
}
func (p *RaftServiceRequestCommitIndexArgs) IsSetHeader() bool {
  return p.Header != nil
}

func (p *RaftServiceRequestCommitIndexArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *RaftServiceRequestCommitIndexArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *RaftServiceRequestCommitIndexArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "requestCommitIndex_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *RaftServiceRequestCommitIndexArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:header: ", p), err) }
  if err := p.Header.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:header: ", p), err) }
  return err
}

func (p *RaftServiceRequestCommitIndexArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("RaftServiceRequestCommitIndexArgs(%+v)", *p)
}

// Attributes:
//  - Success
type RaftServiceRequestCommitIndexResult struct {
  Success *RequestCommitIndexResponse `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewRaftServiceRequestCommitIndexResult() *RaftServiceRequestCommitIndexResult {
  return &RaftServiceRequestCommitIndexResult{}
}

var RaftServiceRequestCommitIndexResult_Success_DEFAULT *RequestCommitIndexResponse
func (p *RaftServiceRequestCommitIndexResult) GetSuccess() *RequestCommitIndexResponse {
  if !p.IsSetSuccess() {
    return RaftServiceRequestCommitIndexResult_Success_DEFAULT
  }
return p.Success
}
func (p *RaftServiceRequestCommitIndexResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *RaftServiceRequestCommitIndexResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *RaftServiceRequestCommitIndexResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &RequestCommitIndexResponse{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *RaftServiceRequestCommitIndexResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "requestCommitIndex_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *RaftServiceRequestCommitIndexResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *RaftServiceRequestCommitIndexResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("RaftServiceRequestCommitIndexResult(%+v)", *p)
}

// Attributes:
//  - FilePath
//  - Offset
//  - Length
type RaftServiceReadFileArgs struct {
  FilePath string `thrift:"filePath,1" db:"filePath" json:"filePath"`
  Offset Long `thrift:"offset,2" db:"offset" json:"offset"`
  Length Int `thrift:"length,3" db:"length" json:"length"`
}

func NewRaftServiceReadFileArgs() *RaftServiceReadFileArgs {
  return &RaftServiceReadFileArgs{}
}


func (p *RaftServiceReadFileArgs) GetFilePath() string {
  return p.FilePath
}

func (p *RaftServiceReadFileArgs) GetOffset() Long {
  return p.Offset
}

func (p *RaftServiceReadFileArgs) GetLength() Int {
  return p.Length
}
func (p *RaftServiceReadFileArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *RaftServiceReadFileArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.FilePath = v
}
  return nil
}

func (p *RaftServiceReadFileArgs)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  temp := Long(v)
  p.Offset = temp
}
  return nil
}

func (p *RaftServiceReadFileArgs)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  temp := Int(v)
  p.Length = temp
}
  return nil
}

func (p *RaftServiceReadFileArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "readFile_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *RaftServiceReadFileArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "filePath", thrift.STRING, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:filePath: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.FilePath)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.filePath (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:filePath: ", p), err) }
  return err
}

func (p *RaftServiceReadFileArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "offset", thrift.I64, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:offset: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.Offset)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.offset (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:offset: ", p), err) }
  return err
}

func (p *RaftServiceReadFileArgs) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "length", thrift.I32, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:length: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.Length)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.length (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:length: ", p), err) }
  return err
}

func (p *RaftServiceReadFileArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("RaftServiceReadFileArgs(%+v)", *p)
}

// Attributes:
//  - Success
type RaftServiceReadFileResult struct {
  Success []byte `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewRaftServiceReadFileResult() *RaftServiceReadFileResult {
  return &RaftServiceReadFileResult{}
}

var RaftServiceReadFileResult_Success_DEFAULT []byte

func (p *RaftServiceReadFileResult) GetSuccess() []byte {
  return p.Success
}
func (p *RaftServiceReadFileResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *RaftServiceReadFileResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *RaftServiceReadFileResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 0: ", err)
} else {
  p.Success = v
}
  return nil
}

func (p *RaftServiceReadFileResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "readFile_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *RaftServiceReadFileResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRING, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteBinary(ctx, p.Success); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.success (0) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *RaftServiceReadFileResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("RaftServiceReadFileResult(%+v)", *p)
}

// Attributes:
//  - Index
//  - Term
//  - Header
type RaftServiceMatchTermArgs struct {
  Index Long `thrift:"index,1" db:"index" json:"index"`
  Term Long `thrift:"term,2" db:"term" json:"term"`
  Header *RaftNode `thrift:"header,3" db:"header" json:"header"`
}

func NewRaftServiceMatchTermArgs() *RaftServiceMatchTermArgs {
  return &RaftServiceMatchTermArgs{}
}


func (p *RaftServiceMatchTermArgs) GetIndex() Long {
  return p.Index
}

func (p *RaftServiceMatchTermArgs) GetTerm() Long {
  return p.Term
}
var RaftServiceMatchTermArgs_Header_DEFAULT *RaftNode
func (p *RaftServiceMatchTermArgs) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return RaftServiceMatchTermArgs_Header_DEFAULT
  }
return p.Header
}
func (p *RaftServiceMatchTermArgs) IsSetHeader() bool {
  return p.Header != nil
}

func (p *RaftServiceMatchTermArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *RaftServiceMatchTermArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  temp := Long(v)
  p.Index = temp
}
  return nil
}

func (p *RaftServiceMatchTermArgs)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  temp := Long(v)
  p.Term = temp
}
  return nil
}

func (p *RaftServiceMatchTermArgs)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *RaftServiceMatchTermArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "matchTerm_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *RaftServiceMatchTermArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "index", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:index: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.Index)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.index (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:index: ", p), err) }
  return err
}

func (p *RaftServiceMatchTermArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "term", thrift.I64, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:term: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.Term)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.term (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:term: ", p), err) }
  return err
}

func (p *RaftServiceMatchTermArgs) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:header: ", p), err) }
  if err := p.Header.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:header: ", p), err) }
  return err
}

func (p *RaftServiceMatchTermArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("RaftServiceMatchTermArgs(%+v)", *p)
}

// Attributes:
//  - Success
type RaftServiceMatchTermResult struct {
  Success *bool `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewRaftServiceMatchTermResult() *RaftServiceMatchTermResult {
  return &RaftServiceMatchTermResult{}
}

var RaftServiceMatchTermResult_Success_DEFAULT bool
func (p *RaftServiceMatchTermResult) GetSuccess() bool {
  if !p.IsSetSuccess() {
    return RaftServiceMatchTermResult_Success_DEFAULT
  }
return *p.Success
}
func (p *RaftServiceMatchTermResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *RaftServiceMatchTermResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *RaftServiceMatchTermResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 0: ", err)
} else {
  p.Success = &v
}
  return nil
}

func (p *RaftServiceMatchTermResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "matchTerm_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *RaftServiceMatchTermResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.BOOL, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.Success)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.success (0) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *RaftServiceMatchTermResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("RaftServiceMatchTermResult(%+v)", *p)
}

// Attributes:
//  - HardLinkPath
type RaftServiceRemoveHardLinkArgs struct {
  HardLinkPath string `thrift:"hardLinkPath,1" db:"hardLinkPath" json:"hardLinkPath"`
}

func NewRaftServiceRemoveHardLinkArgs() *RaftServiceRemoveHardLinkArgs {
  return &RaftServiceRemoveHardLinkArgs{}
}


func (p *RaftServiceRemoveHardLinkArgs) GetHardLinkPath() string {
  return p.HardLinkPath
}
func (p *RaftServiceRemoveHardLinkArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *RaftServiceRemoveHardLinkArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.HardLinkPath = v
}
  return nil
}

func (p *RaftServiceRemoveHardLinkArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "removeHardLink_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *RaftServiceRemoveHardLinkArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "hardLinkPath", thrift.STRING, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:hardLinkPath: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.HardLinkPath)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.hardLinkPath (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:hardLinkPath: ", p), err) }
  return err
}

func (p *RaftServiceRemoveHardLinkArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("RaftServiceRemoveHardLinkArgs(%+v)", *p)
}

type RaftServiceRemoveHardLinkResult struct {
}

func NewRaftServiceRemoveHardLinkResult() *RaftServiceRemoveHardLinkResult {
  return &RaftServiceRemoveHardLinkResult{}
}

func (p *RaftServiceRemoveHardLinkResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    if err := iprot.Skip(ctx, fieldTypeId); err != nil {
      return err
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *RaftServiceRemoveHardLinkResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "removeHardLink_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *RaftServiceRemoveHardLinkResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("RaftServiceRemoveHardLinkResult(%+v)", *p)
}


type TSDataService interface {
RaftService

  // Query a time series without value filter.
  // @return a readerId >= 0 if the query succeeds, otherwise the query fails
  // TODO-Cluster: support query multiple series in a request
  // 
  // 
  // Parameters:
  //  - Request
  QuerySingleSeries(ctx context.Context, request *SingleSeriesQueryRequest) (_r Long, _err error)
  // Query mult time series without value filter.
  // @return a readerId >= 0 if the query succeeds, otherwise the query fails
  // 
  // 
  // Parameters:
  //  - Request
  QueryMultSeries(ctx context.Context, request *MultSeriesQueryRequest) (_r Long, _err error)
  // Fetch at max fetchSize time-value pairs using the resultSetId generated by querySingleSeries.
  // @return a ByteBuffer containing the serialized time-value pairs or an empty buffer if there
  // are not more results.
  // 
  // 
  // Parameters:
  //  - Header
  //  - ReaderId
  FetchSingleSeries(ctx context.Context, header *RaftNode, readerId Long) (_r []byte, _err error)
  // Fetch mult series at max fetchSize time-value pairs using the resultSetId generated by querySingleSeries.
  // @return a map containing key-value,the serialized time-value pairs or an empty buffer if there
  // are not more results.
  // 
  // 
  // Parameters:
  //  - Header
  //  - ReaderId
  //  - Paths
  FetchMultSeries(ctx context.Context, header *RaftNode, readerId Long, paths []string) (_r map[string][]byte, _err error)
  // Query a time series and generate an IReaderByTimestamp.
  // @return a readerId >= 0 if the query succeeds, otherwise the query fails
  // 
  // 
  // Parameters:
  //  - Request
  QuerySingleSeriesByTimestamp(ctx context.Context, request *SingleSeriesQueryRequest) (_r Long, _err error)
  // Fetch values at given timestamps using the resultSetId generated by
  // querySingleSeriesByTimestamp.
  // @return a ByteBuffer containing the serialized value or an empty buffer if there
  // are not more results.
  // 
  // 
  // Parameters:
  //  - Header
  //  - ReaderId
  //  - Timestamps
  FetchSingleSeriesByTimestamps(ctx context.Context, header *RaftNode, readerId Long, timestamps []Long) (_r []byte, _err error)
  // Find the local query established for the remote query and release all its resource.
  // 
  // 
  // Parameters:
  //  - Header
  //  - ThisNode
  //  - QueryId
  EndQuery(ctx context.Context, header *RaftNode, thisNode *Node, queryId Long) (_err error)
  // Given path patterns (paths with wildcard), return all paths they match.
  // 
  // 
  // Parameters:
  //  - Header
  //  - Paths
  //  - WithAlias
  GetAllPaths(ctx context.Context, header *RaftNode, paths []string, withAlias bool) (_r *GetAllPathsResult_, _err error)
  // Given path patterns (paths with wildcard), return all devices they match.
  // 
  // 
  // Parameters:
  //  - Header
  //  - Path
  //  - IsPrefixMatch
  GetAllDevices(ctx context.Context, header *RaftNode, path []string, isPrefixMatch bool) (_r []string, _err error)
  // Get the devices from the header according to the showDevicesPlan
  // 
  // 
  // Parameters:
  //  - Header
  //  - PlanBinary
  GetDevices(ctx context.Context, header *RaftNode, planBinary []byte) (_r []byte, _err error)
  // Parameters:
  //  - Header
  //  - Path
  //  - NodeLevel
  GetNodeList(ctx context.Context, header *RaftNode, path string, nodeLevel Int) (_r []string, _err error)
  // Given path patterns(paths with wildcard), return all children nodes they match
  // 
  // 
  // Parameters:
  //  - Header
  //  - Path
  GetChildNodeInNextLevel(ctx context.Context, header *RaftNode, path string) (_r []string, _err error)
  // Parameters:
  //  - Header
  //  - Path
  GetChildNodePathInNextLevel(ctx context.Context, header *RaftNode, path string) (_r []string, _err error)
  // Parameters:
  //  - Request
  GetAllMeasurementSchema(ctx context.Context, request *MeasurementSchemaRequest) (_r []byte, _err error)
  // Parameters:
  //  - Request
  GetAggrResult_(ctx context.Context, request *GetAggrResultRequest) (_r [][]byte, _err error)
  // Parameters:
  //  - Header
  //  - TimeseriesList
  GetUnregisteredTimeseries(ctx context.Context, header *RaftNode, timeseriesList []string) (_r []string, _err error)
  // Parameters:
  //  - Request
  PullSnapshot(ctx context.Context, request *PullSnapshotRequest) (_r *PullSnapshotResp, _err error)
  // Create a GroupByExecutor for a path, executing the given aggregations.
  // @return the executorId
  // 
  // 
  // Parameters:
  //  - Request
  GetGroupByExecutor(ctx context.Context, request *GroupByRequest) (_r Long, _err error)
  // Fetch the group by result in the interval [startTime, endTime) from the given executor.
  // @return the serialized AggregationResults, each is the result of one of the previously
  // required aggregations, and their orders are the same.
  // 
  // 
  // Parameters:
  //  - Header
  //  - ExecutorId
  //  - StartTime
  //  - EndTime
  GetGroupByResult_(ctx context.Context, header *RaftNode, executorId Long, startTime Long, endTime Long) (_r [][]byte, _err error)
  // Pull all timeseries schemas prefixed by a given path.
  // 
  // 
  // Parameters:
  //  - Request
  PullTimeSeriesSchema(ctx context.Context, request *PullSchemaRequest) (_r *PullSchemaResp, _err error)
  // Pull all measurement schemas prefixed by a given path.
  // 
  // 
  // Parameters:
  //  - Request
  PullMeasurementSchema(ctx context.Context, request *PullSchemaRequest) (_r *PullSchemaResp, _err error)
  // Perform a previous fill and return the timevalue pair in binary.
  // @return a binary TimeValuePair
  // 
  // 
  // Parameters:
  //  - Request
  PreviousFill(ctx context.Context, request *PreviousFillRequest) (_r []byte, _err error)
  // Query the last point of a series.
  // @return a binary TimeValuePair
  // 
  // 
  // Parameters:
  //  - Request
  Last(ctx context.Context, request *LastQueryRequest) (_r []byte, _err error)
  // Parameters:
  //  - Header
  //  - PathsToQuery
  //  - Level
  GetPathCount(ctx context.Context, header *RaftNode, pathsToQuery []string, level Int) (_r Int, _err error)
  // Parameters:
  //  - Header
  //  - PathsToQuery
  GetDeviceCount(ctx context.Context, header *RaftNode, pathsToQuery []string) (_r Int, _err error)
  // During slot transfer, when a member has pulled snapshot from a group, the member will use this
  // method to inform the group that one replica of such slots has been pulled.
  // 
  // 
  // Parameters:
  //  - Header
  //  - Slots
  OnSnapshotApplied(ctx context.Context, header *RaftNode, slots []Int) (_r bool, _err error)
  // Parameters:
  //  - Header
  //  - ExecutorId
  //  - StartTime
  //  - EndTime
  PeekNextNotNullValue(ctx context.Context, header *RaftNode, executorId Long, startTime Long, endTime Long) (_r []byte, _err error)
}

type TSDataServiceClient struct {
  *RaftServiceClient
}

func NewTSDataServiceClientFactory(t thrift.TTransport, f thrift.TProtocolFactory) *TSDataServiceClient {
  return &TSDataServiceClient{RaftServiceClient: NewRaftServiceClientFactory(t, f)}}

func NewTSDataServiceClientProtocol(t thrift.TTransport, iprot thrift.TProtocol, oprot thrift.TProtocol) *TSDataServiceClient {
  return &TSDataServiceClient{RaftServiceClient: NewRaftServiceClientProtocol(t, iprot, oprot)}
}

func NewTSDataServiceClient(c thrift.TClient) *TSDataServiceClient {
  return &TSDataServiceClient{
    RaftServiceClient: NewRaftServiceClient(c),
  }
}

// Query a time series without value filter.
// @return a readerId >= 0 if the query succeeds, otherwise the query fails
// TODO-Cluster: support query multiple series in a request
// 
// 
// Parameters:
//  - Request
func (p *TSDataServiceClient) QuerySingleSeries(ctx context.Context, request *SingleSeriesQueryRequest) (_r Long, _err error) {
  var _args139 TSDataServiceQuerySingleSeriesArgs
  _args139.Request = request
  var _result141 TSDataServiceQuerySingleSeriesResult
  var _meta140 thrift.ResponseMeta
  _meta140, _err = p.Client_().Call(ctx, "querySingleSeries", &_args139, &_result141)
  p.SetLastResponseMeta_(_meta140)
  if _err != nil {
    return
  }
  return _result141.GetSuccess(), nil
}

// Query mult time series without value filter.
// @return a readerId >= 0 if the query succeeds, otherwise the query fails
// 
// 
// Parameters:
//  - Request
func (p *TSDataServiceClient) QueryMultSeries(ctx context.Context, request *MultSeriesQueryRequest) (_r Long, _err error) {
  var _args142 TSDataServiceQueryMultSeriesArgs
  _args142.Request = request
  var _result144 TSDataServiceQueryMultSeriesResult
  var _meta143 thrift.ResponseMeta
  _meta143, _err = p.Client_().Call(ctx, "queryMultSeries", &_args142, &_result144)
  p.SetLastResponseMeta_(_meta143)
  if _err != nil {
    return
  }
  return _result144.GetSuccess(), nil
}

// Fetch at max fetchSize time-value pairs using the resultSetId generated by querySingleSeries.
// @return a ByteBuffer containing the serialized time-value pairs or an empty buffer if there
// are not more results.
// 
// 
// Parameters:
//  - Header
//  - ReaderId
func (p *TSDataServiceClient) FetchSingleSeries(ctx context.Context, header *RaftNode, readerId Long) (_r []byte, _err error) {
  var _args145 TSDataServiceFetchSingleSeriesArgs
  _args145.Header = header
  _args145.ReaderId = readerId
  var _result147 TSDataServiceFetchSingleSeriesResult
  var _meta146 thrift.ResponseMeta
  _meta146, _err = p.Client_().Call(ctx, "fetchSingleSeries", &_args145, &_result147)
  p.SetLastResponseMeta_(_meta146)
  if _err != nil {
    return
  }
  return _result147.GetSuccess(), nil
}

// Fetch mult series at max fetchSize time-value pairs using the resultSetId generated by querySingleSeries.
// @return a map containing key-value,the serialized time-value pairs or an empty buffer if there
// are not more results.
// 
// 
// Parameters:
//  - Header
//  - ReaderId
//  - Paths
func (p *TSDataServiceClient) FetchMultSeries(ctx context.Context, header *RaftNode, readerId Long, paths []string) (_r map[string][]byte, _err error) {
  var _args148 TSDataServiceFetchMultSeriesArgs
  _args148.Header = header
  _args148.ReaderId = readerId
  _args148.Paths = paths
  var _result150 TSDataServiceFetchMultSeriesResult
  var _meta149 thrift.ResponseMeta
  _meta149, _err = p.Client_().Call(ctx, "fetchMultSeries", &_args148, &_result150)
  p.SetLastResponseMeta_(_meta149)
  if _err != nil {
    return
  }
  return _result150.GetSuccess(), nil
}

// Query a time series and generate an IReaderByTimestamp.
// @return a readerId >= 0 if the query succeeds, otherwise the query fails
// 
// 
// Parameters:
//  - Request
func (p *TSDataServiceClient) QuerySingleSeriesByTimestamp(ctx context.Context, request *SingleSeriesQueryRequest) (_r Long, _err error) {
  var _args151 TSDataServiceQuerySingleSeriesByTimestampArgs
  _args151.Request = request
  var _result153 TSDataServiceQuerySingleSeriesByTimestampResult
  var _meta152 thrift.ResponseMeta
  _meta152, _err = p.Client_().Call(ctx, "querySingleSeriesByTimestamp", &_args151, &_result153)
  p.SetLastResponseMeta_(_meta152)
  if _err != nil {
    return
  }
  return _result153.GetSuccess(), nil
}

// Fetch values at given timestamps using the resultSetId generated by
// querySingleSeriesByTimestamp.
// @return a ByteBuffer containing the serialized value or an empty buffer if there
// are not more results.
// 
// 
// Parameters:
//  - Header
//  - ReaderId
//  - Timestamps
func (p *TSDataServiceClient) FetchSingleSeriesByTimestamps(ctx context.Context, header *RaftNode, readerId Long, timestamps []Long) (_r []byte, _err error) {
  var _args154 TSDataServiceFetchSingleSeriesByTimestampsArgs
  _args154.Header = header
  _args154.ReaderId = readerId
  _args154.Timestamps = timestamps
  var _result156 TSDataServiceFetchSingleSeriesByTimestampsResult
  var _meta155 thrift.ResponseMeta
  _meta155, _err = p.Client_().Call(ctx, "fetchSingleSeriesByTimestamps", &_args154, &_result156)
  p.SetLastResponseMeta_(_meta155)
  if _err != nil {
    return
  }
  return _result156.GetSuccess(), nil
}

// Find the local query established for the remote query and release all its resource.
// 
// 
// Parameters:
//  - Header
//  - ThisNode
//  - QueryId
func (p *TSDataServiceClient) EndQuery(ctx context.Context, header *RaftNode, thisNode *Node, queryId Long) (_err error) {
  var _args157 TSDataServiceEndQueryArgs
  _args157.Header = header
  _args157.ThisNode = thisNode
  _args157.QueryId = queryId
  var _result159 TSDataServiceEndQueryResult
  var _meta158 thrift.ResponseMeta
  _meta158, _err = p.Client_().Call(ctx, "endQuery", &_args157, &_result159)
  p.SetLastResponseMeta_(_meta158)
  if _err != nil {
    return
  }
  return nil
}

// Given path patterns (paths with wildcard), return all paths they match.
// 
// 
// Parameters:
//  - Header
//  - Paths
//  - WithAlias
func (p *TSDataServiceClient) GetAllPaths(ctx context.Context, header *RaftNode, paths []string, withAlias bool) (_r *GetAllPathsResult_, _err error) {
  var _args160 TSDataServiceGetAllPathsArgs
  _args160.Header = header
  _args160.Paths = paths
  _args160.WithAlias = withAlias
  var _result162 TSDataServiceGetAllPathsResult
  var _meta161 thrift.ResponseMeta
  _meta161, _err = p.Client_().Call(ctx, "getAllPaths", &_args160, &_result162)
  p.SetLastResponseMeta_(_meta161)
  if _err != nil {
    return
  }
  return _result162.GetSuccess(), nil
}

// Given path patterns (paths with wildcard), return all devices they match.
// 
// 
// Parameters:
//  - Header
//  - Path
//  - IsPrefixMatch
func (p *TSDataServiceClient) GetAllDevices(ctx context.Context, header *RaftNode, path []string, isPrefixMatch bool) (_r []string, _err error) {
  var _args163 TSDataServiceGetAllDevicesArgs
  _args163.Header = header
  _args163.Path = path
  _args163.IsPrefixMatch = isPrefixMatch
  var _result165 TSDataServiceGetAllDevicesResult
  var _meta164 thrift.ResponseMeta
  _meta164, _err = p.Client_().Call(ctx, "getAllDevices", &_args163, &_result165)
  p.SetLastResponseMeta_(_meta164)
  if _err != nil {
    return
  }
  return _result165.GetSuccess(), nil
}

// Get the devices from the header according to the showDevicesPlan
// 
// 
// Parameters:
//  - Header
//  - PlanBinary
func (p *TSDataServiceClient) GetDevices(ctx context.Context, header *RaftNode, planBinary []byte) (_r []byte, _err error) {
  var _args166 TSDataServiceGetDevicesArgs
  _args166.Header = header
  _args166.PlanBinary = planBinary
  var _result168 TSDataServiceGetDevicesResult
  var _meta167 thrift.ResponseMeta
  _meta167, _err = p.Client_().Call(ctx, "getDevices", &_args166, &_result168)
  p.SetLastResponseMeta_(_meta167)
  if _err != nil {
    return
  }
  return _result168.GetSuccess(), nil
}

// Parameters:
//  - Header
//  - Path
//  - NodeLevel
func (p *TSDataServiceClient) GetNodeList(ctx context.Context, header *RaftNode, path string, nodeLevel Int) (_r []string, _err error) {
  var _args169 TSDataServiceGetNodeListArgs
  _args169.Header = header
  _args169.Path = path
  _args169.NodeLevel = nodeLevel
  var _result171 TSDataServiceGetNodeListResult
  var _meta170 thrift.ResponseMeta
  _meta170, _err = p.Client_().Call(ctx, "getNodeList", &_args169, &_result171)
  p.SetLastResponseMeta_(_meta170)
  if _err != nil {
    return
  }
  return _result171.GetSuccess(), nil
}

// Given path patterns(paths with wildcard), return all children nodes they match
// 
// 
// Parameters:
//  - Header
//  - Path
func (p *TSDataServiceClient) GetChildNodeInNextLevel(ctx context.Context, header *RaftNode, path string) (_r []string, _err error) {
  var _args172 TSDataServiceGetChildNodeInNextLevelArgs
  _args172.Header = header
  _args172.Path = path
  var _result174 TSDataServiceGetChildNodeInNextLevelResult
  var _meta173 thrift.ResponseMeta
  _meta173, _err = p.Client_().Call(ctx, "getChildNodeInNextLevel", &_args172, &_result174)
  p.SetLastResponseMeta_(_meta173)
  if _err != nil {
    return
  }
  return _result174.GetSuccess(), nil
}

// Parameters:
//  - Header
//  - Path
func (p *TSDataServiceClient) GetChildNodePathInNextLevel(ctx context.Context, header *RaftNode, path string) (_r []string, _err error) {
  var _args175 TSDataServiceGetChildNodePathInNextLevelArgs
  _args175.Header = header
  _args175.Path = path
  var _result177 TSDataServiceGetChildNodePathInNextLevelResult
  var _meta176 thrift.ResponseMeta
  _meta176, _err = p.Client_().Call(ctx, "getChildNodePathInNextLevel", &_args175, &_result177)
  p.SetLastResponseMeta_(_meta176)
  if _err != nil {
    return
  }
  return _result177.GetSuccess(), nil
}

// Parameters:
//  - Request
func (p *TSDataServiceClient) GetAllMeasurementSchema(ctx context.Context, request *MeasurementSchemaRequest) (_r []byte, _err error) {
  var _args178 TSDataServiceGetAllMeasurementSchemaArgs
  _args178.Request = request
  var _result180 TSDataServiceGetAllMeasurementSchemaResult
  var _meta179 thrift.ResponseMeta
  _meta179, _err = p.Client_().Call(ctx, "getAllMeasurementSchema", &_args178, &_result180)
  p.SetLastResponseMeta_(_meta179)
  if _err != nil {
    return
  }
  return _result180.GetSuccess(), nil
}

// Parameters:
//  - Request
func (p *TSDataServiceClient) GetAggrResult_(ctx context.Context, request *GetAggrResultRequest) (_r [][]byte, _err error) {
  var _args181 TSDataServiceGetAggrResultArgs
  _args181.Request = request
  var _result183 TSDataServiceGetAggrResultResult
  var _meta182 thrift.ResponseMeta
  _meta182, _err = p.Client_().Call(ctx, "getAggrResult", &_args181, &_result183)
  p.SetLastResponseMeta_(_meta182)
  if _err != nil {
    return
  }
  return _result183.GetSuccess(), nil
}

// Parameters:
//  - Header
//  - TimeseriesList
func (p *TSDataServiceClient) GetUnregisteredTimeseries(ctx context.Context, header *RaftNode, timeseriesList []string) (_r []string, _err error) {
  var _args184 TSDataServiceGetUnregisteredTimeseriesArgs
  _args184.Header = header
  _args184.TimeseriesList = timeseriesList
  var _result186 TSDataServiceGetUnregisteredTimeseriesResult
  var _meta185 thrift.ResponseMeta
  _meta185, _err = p.Client_().Call(ctx, "getUnregisteredTimeseries", &_args184, &_result186)
  p.SetLastResponseMeta_(_meta185)
  if _err != nil {
    return
  }
  return _result186.GetSuccess(), nil
}

// Parameters:
//  - Request
func (p *TSDataServiceClient) PullSnapshot(ctx context.Context, request *PullSnapshotRequest) (_r *PullSnapshotResp, _err error) {
  var _args187 TSDataServicePullSnapshotArgs
  _args187.Request = request
  var _result189 TSDataServicePullSnapshotResult
  var _meta188 thrift.ResponseMeta
  _meta188, _err = p.Client_().Call(ctx, "pullSnapshot", &_args187, &_result189)
  p.SetLastResponseMeta_(_meta188)
  if _err != nil {
    return
  }
  return _result189.GetSuccess(), nil
}

// Create a GroupByExecutor for a path, executing the given aggregations.
// @return the executorId
// 
// 
// Parameters:
//  - Request
func (p *TSDataServiceClient) GetGroupByExecutor(ctx context.Context, request *GroupByRequest) (_r Long, _err error) {
  var _args190 TSDataServiceGetGroupByExecutorArgs
  _args190.Request = request
  var _result192 TSDataServiceGetGroupByExecutorResult
  var _meta191 thrift.ResponseMeta
  _meta191, _err = p.Client_().Call(ctx, "getGroupByExecutor", &_args190, &_result192)
  p.SetLastResponseMeta_(_meta191)
  if _err != nil {
    return
  }
  return _result192.GetSuccess(), nil
}

// Fetch the group by result in the interval [startTime, endTime) from the given executor.
// @return the serialized AggregationResults, each is the result of one of the previously
// required aggregations, and their orders are the same.
// 
// 
// Parameters:
//  - Header
//  - ExecutorId
//  - StartTime
//  - EndTime
func (p *TSDataServiceClient) GetGroupByResult_(ctx context.Context, header *RaftNode, executorId Long, startTime Long, endTime Long) (_r [][]byte, _err error) {
  var _args193 TSDataServiceGetGroupByResultArgs
  _args193.Header = header
  _args193.ExecutorId = executorId
  _args193.StartTime = startTime
  _args193.EndTime = endTime
  var _result195 TSDataServiceGetGroupByResultResult
  var _meta194 thrift.ResponseMeta
  _meta194, _err = p.Client_().Call(ctx, "getGroupByResult", &_args193, &_result195)
  p.SetLastResponseMeta_(_meta194)
  if _err != nil {
    return
  }
  return _result195.GetSuccess(), nil
}

// Pull all timeseries schemas prefixed by a given path.
// 
// 
// Parameters:
//  - Request
func (p *TSDataServiceClient) PullTimeSeriesSchema(ctx context.Context, request *PullSchemaRequest) (_r *PullSchemaResp, _err error) {
  var _args196 TSDataServicePullTimeSeriesSchemaArgs
  _args196.Request = request
  var _result198 TSDataServicePullTimeSeriesSchemaResult
  var _meta197 thrift.ResponseMeta
  _meta197, _err = p.Client_().Call(ctx, "pullTimeSeriesSchema", &_args196, &_result198)
  p.SetLastResponseMeta_(_meta197)
  if _err != nil {
    return
  }
  return _result198.GetSuccess(), nil
}

// Pull all measurement schemas prefixed by a given path.
// 
// 
// Parameters:
//  - Request
func (p *TSDataServiceClient) PullMeasurementSchema(ctx context.Context, request *PullSchemaRequest) (_r *PullSchemaResp, _err error) {
  var _args199 TSDataServicePullMeasurementSchemaArgs
  _args199.Request = request
  var _result201 TSDataServicePullMeasurementSchemaResult
  var _meta200 thrift.ResponseMeta
  _meta200, _err = p.Client_().Call(ctx, "pullMeasurementSchema", &_args199, &_result201)
  p.SetLastResponseMeta_(_meta200)
  if _err != nil {
    return
  }
  return _result201.GetSuccess(), nil
}

// Perform a previous fill and return the timevalue pair in binary.
// @return a binary TimeValuePair
// 
// 
// Parameters:
//  - Request
func (p *TSDataServiceClient) PreviousFill(ctx context.Context, request *PreviousFillRequest) (_r []byte, _err error) {
  var _args202 TSDataServicePreviousFillArgs
  _args202.Request = request
  var _result204 TSDataServicePreviousFillResult
  var _meta203 thrift.ResponseMeta
  _meta203, _err = p.Client_().Call(ctx, "previousFill", &_args202, &_result204)
  p.SetLastResponseMeta_(_meta203)
  if _err != nil {
    return
  }
  return _result204.GetSuccess(), nil
}

// Query the last point of a series.
// @return a binary TimeValuePair
// 
// 
// Parameters:
//  - Request
func (p *TSDataServiceClient) Last(ctx context.Context, request *LastQueryRequest) (_r []byte, _err error) {
  var _args205 TSDataServiceLastArgs
  _args205.Request = request
  var _result207 TSDataServiceLastResult
  var _meta206 thrift.ResponseMeta
  _meta206, _err = p.Client_().Call(ctx, "last", &_args205, &_result207)
  p.SetLastResponseMeta_(_meta206)
  if _err != nil {
    return
  }
  return _result207.GetSuccess(), nil
}

// Parameters:
//  - Header
//  - PathsToQuery
//  - Level
func (p *TSDataServiceClient) GetPathCount(ctx context.Context, header *RaftNode, pathsToQuery []string, level Int) (_r Int, _err error) {
  var _args208 TSDataServiceGetPathCountArgs
  _args208.Header = header
  _args208.PathsToQuery = pathsToQuery
  _args208.Level = level
  var _result210 TSDataServiceGetPathCountResult
  var _meta209 thrift.ResponseMeta
  _meta209, _err = p.Client_().Call(ctx, "getPathCount", &_args208, &_result210)
  p.SetLastResponseMeta_(_meta209)
  if _err != nil {
    return
  }
  return _result210.GetSuccess(), nil
}

// Parameters:
//  - Header
//  - PathsToQuery
func (p *TSDataServiceClient) GetDeviceCount(ctx context.Context, header *RaftNode, pathsToQuery []string) (_r Int, _err error) {
  var _args211 TSDataServiceGetDeviceCountArgs
  _args211.Header = header
  _args211.PathsToQuery = pathsToQuery
  var _result213 TSDataServiceGetDeviceCountResult
  var _meta212 thrift.ResponseMeta
  _meta212, _err = p.Client_().Call(ctx, "getDeviceCount", &_args211, &_result213)
  p.SetLastResponseMeta_(_meta212)
  if _err != nil {
    return
  }
  return _result213.GetSuccess(), nil
}

// During slot transfer, when a member has pulled snapshot from a group, the member will use this
// method to inform the group that one replica of such slots has been pulled.
// 
// 
// Parameters:
//  - Header
//  - Slots
func (p *TSDataServiceClient) OnSnapshotApplied(ctx context.Context, header *RaftNode, slots []Int) (_r bool, _err error) {
  var _args214 TSDataServiceOnSnapshotAppliedArgs
  _args214.Header = header
  _args214.Slots = slots
  var _result216 TSDataServiceOnSnapshotAppliedResult
  var _meta215 thrift.ResponseMeta
  _meta215, _err = p.Client_().Call(ctx, "onSnapshotApplied", &_args214, &_result216)
  p.SetLastResponseMeta_(_meta215)
  if _err != nil {
    return
  }
  return _result216.GetSuccess(), nil
}

// Parameters:
//  - Header
//  - ExecutorId
//  - StartTime
//  - EndTime
func (p *TSDataServiceClient) PeekNextNotNullValue(ctx context.Context, header *RaftNode, executorId Long, startTime Long, endTime Long) (_r []byte, _err error) {
  var _args217 TSDataServicePeekNextNotNullValueArgs
  _args217.Header = header
  _args217.ExecutorId = executorId
  _args217.StartTime = startTime
  _args217.EndTime = endTime
  var _result219 TSDataServicePeekNextNotNullValueResult
  var _meta218 thrift.ResponseMeta
  _meta218, _err = p.Client_().Call(ctx, "peekNextNotNullValue", &_args217, &_result219)
  p.SetLastResponseMeta_(_meta218)
  if _err != nil {
    return
  }
  return _result219.GetSuccess(), nil
}

type TSDataServiceProcessor struct {
  *RaftServiceProcessor
}

func NewTSDataServiceProcessor(handler TSDataService) *TSDataServiceProcessor {
  self220 := &TSDataServiceProcessor{NewRaftServiceProcessor(handler)}
  self220.AddToProcessorMap("querySingleSeries", &tSDataServiceProcessorQuerySingleSeries{handler:handler})
  self220.AddToProcessorMap("queryMultSeries", &tSDataServiceProcessorQueryMultSeries{handler:handler})
  self220.AddToProcessorMap("fetchSingleSeries", &tSDataServiceProcessorFetchSingleSeries{handler:handler})
  self220.AddToProcessorMap("fetchMultSeries", &tSDataServiceProcessorFetchMultSeries{handler:handler})
  self220.AddToProcessorMap("querySingleSeriesByTimestamp", &tSDataServiceProcessorQuerySingleSeriesByTimestamp{handler:handler})
  self220.AddToProcessorMap("fetchSingleSeriesByTimestamps", &tSDataServiceProcessorFetchSingleSeriesByTimestamps{handler:handler})
  self220.AddToProcessorMap("endQuery", &tSDataServiceProcessorEndQuery{handler:handler})
  self220.AddToProcessorMap("getAllPaths", &tSDataServiceProcessorGetAllPaths{handler:handler})
  self220.AddToProcessorMap("getAllDevices", &tSDataServiceProcessorGetAllDevices{handler:handler})
  self220.AddToProcessorMap("getDevices", &tSDataServiceProcessorGetDevices{handler:handler})
  self220.AddToProcessorMap("getNodeList", &tSDataServiceProcessorGetNodeList{handler:handler})
  self220.AddToProcessorMap("getChildNodeInNextLevel", &tSDataServiceProcessorGetChildNodeInNextLevel{handler:handler})
  self220.AddToProcessorMap("getChildNodePathInNextLevel", &tSDataServiceProcessorGetChildNodePathInNextLevel{handler:handler})
  self220.AddToProcessorMap("getAllMeasurementSchema", &tSDataServiceProcessorGetAllMeasurementSchema{handler:handler})
  self220.AddToProcessorMap("getAggrResult", &tSDataServiceProcessorGetAggrResult_{handler:handler})
  self220.AddToProcessorMap("getUnregisteredTimeseries", &tSDataServiceProcessorGetUnregisteredTimeseries{handler:handler})
  self220.AddToProcessorMap("pullSnapshot", &tSDataServiceProcessorPullSnapshot{handler:handler})
  self220.AddToProcessorMap("getGroupByExecutor", &tSDataServiceProcessorGetGroupByExecutor{handler:handler})
  self220.AddToProcessorMap("getGroupByResult", &tSDataServiceProcessorGetGroupByResult_{handler:handler})
  self220.AddToProcessorMap("pullTimeSeriesSchema", &tSDataServiceProcessorPullTimeSeriesSchema{handler:handler})
  self220.AddToProcessorMap("pullMeasurementSchema", &tSDataServiceProcessorPullMeasurementSchema{handler:handler})
  self220.AddToProcessorMap("previousFill", &tSDataServiceProcessorPreviousFill{handler:handler})
  self220.AddToProcessorMap("last", &tSDataServiceProcessorLast{handler:handler})
  self220.AddToProcessorMap("getPathCount", &tSDataServiceProcessorGetPathCount{handler:handler})
  self220.AddToProcessorMap("getDeviceCount", &tSDataServiceProcessorGetDeviceCount{handler:handler})
  self220.AddToProcessorMap("onSnapshotApplied", &tSDataServiceProcessorOnSnapshotApplied{handler:handler})
  self220.AddToProcessorMap("peekNextNotNullValue", &tSDataServiceProcessorPeekNextNotNullValue{handler:handler})
  return self220
}

type tSDataServiceProcessorQuerySingleSeries struct {
  handler TSDataService
}

func (p *tSDataServiceProcessorQuerySingleSeries) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSDataServiceQuerySingleSeriesArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "querySingleSeries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSDataServiceQuerySingleSeriesResult{}
  var retval Long
  if retval, err2 = p.handler.QuerySingleSeries(ctx, args.Request); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing querySingleSeries: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "querySingleSeries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = &retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "querySingleSeries", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSDataServiceProcessorQueryMultSeries struct {
  handler TSDataService
}

func (p *tSDataServiceProcessorQueryMultSeries) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSDataServiceQueryMultSeriesArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "queryMultSeries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSDataServiceQueryMultSeriesResult{}
  var retval Long
  if retval, err2 = p.handler.QueryMultSeries(ctx, args.Request); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing queryMultSeries: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "queryMultSeries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = &retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "queryMultSeries", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSDataServiceProcessorFetchSingleSeries struct {
  handler TSDataService
}

func (p *tSDataServiceProcessorFetchSingleSeries) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSDataServiceFetchSingleSeriesArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "fetchSingleSeries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSDataServiceFetchSingleSeriesResult{}
  var retval []byte
  if retval, err2 = p.handler.FetchSingleSeries(ctx, args.Header, args.ReaderId); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing fetchSingleSeries: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "fetchSingleSeries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "fetchSingleSeries", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSDataServiceProcessorFetchMultSeries struct {
  handler TSDataService
}

func (p *tSDataServiceProcessorFetchMultSeries) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSDataServiceFetchMultSeriesArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "fetchMultSeries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSDataServiceFetchMultSeriesResult{}
  var retval map[string][]byte
  if retval, err2 = p.handler.FetchMultSeries(ctx, args.Header, args.ReaderId, args.Paths); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing fetchMultSeries: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "fetchMultSeries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "fetchMultSeries", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSDataServiceProcessorQuerySingleSeriesByTimestamp struct {
  handler TSDataService
}

func (p *tSDataServiceProcessorQuerySingleSeriesByTimestamp) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSDataServiceQuerySingleSeriesByTimestampArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "querySingleSeriesByTimestamp", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSDataServiceQuerySingleSeriesByTimestampResult{}
  var retval Long
  if retval, err2 = p.handler.QuerySingleSeriesByTimestamp(ctx, args.Request); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing querySingleSeriesByTimestamp: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "querySingleSeriesByTimestamp", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = &retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "querySingleSeriesByTimestamp", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSDataServiceProcessorFetchSingleSeriesByTimestamps struct {
  handler TSDataService
}

func (p *tSDataServiceProcessorFetchSingleSeriesByTimestamps) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSDataServiceFetchSingleSeriesByTimestampsArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "fetchSingleSeriesByTimestamps", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSDataServiceFetchSingleSeriesByTimestampsResult{}
  var retval []byte
  if retval, err2 = p.handler.FetchSingleSeriesByTimestamps(ctx, args.Header, args.ReaderId, args.Timestamps); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing fetchSingleSeriesByTimestamps: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "fetchSingleSeriesByTimestamps", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "fetchSingleSeriesByTimestamps", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSDataServiceProcessorEndQuery struct {
  handler TSDataService
}

func (p *tSDataServiceProcessorEndQuery) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSDataServiceEndQueryArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "endQuery", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSDataServiceEndQueryResult{}
  if err2 = p.handler.EndQuery(ctx, args.Header, args.ThisNode, args.QueryId); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing endQuery: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "endQuery", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "endQuery", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSDataServiceProcessorGetAllPaths struct {
  handler TSDataService
}

func (p *tSDataServiceProcessorGetAllPaths) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSDataServiceGetAllPathsArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "getAllPaths", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSDataServiceGetAllPathsResult{}
  var retval *GetAllPathsResult_
  if retval, err2 = p.handler.GetAllPaths(ctx, args.Header, args.Paths, args.WithAlias); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getAllPaths: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "getAllPaths", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "getAllPaths", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSDataServiceProcessorGetAllDevices struct {
  handler TSDataService
}

func (p *tSDataServiceProcessorGetAllDevices) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSDataServiceGetAllDevicesArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "getAllDevices", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSDataServiceGetAllDevicesResult{}
  var retval []string
  if retval, err2 = p.handler.GetAllDevices(ctx, args.Header, args.Path, args.IsPrefixMatch); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getAllDevices: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "getAllDevices", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "getAllDevices", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSDataServiceProcessorGetDevices struct {
  handler TSDataService
}

func (p *tSDataServiceProcessorGetDevices) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSDataServiceGetDevicesArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "getDevices", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSDataServiceGetDevicesResult{}
  var retval []byte
  if retval, err2 = p.handler.GetDevices(ctx, args.Header, args.PlanBinary); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getDevices: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "getDevices", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "getDevices", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSDataServiceProcessorGetNodeList struct {
  handler TSDataService
}

func (p *tSDataServiceProcessorGetNodeList) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSDataServiceGetNodeListArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "getNodeList", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSDataServiceGetNodeListResult{}
  var retval []string
  if retval, err2 = p.handler.GetNodeList(ctx, args.Header, args.Path, args.NodeLevel); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getNodeList: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "getNodeList", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "getNodeList", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSDataServiceProcessorGetChildNodeInNextLevel struct {
  handler TSDataService
}

func (p *tSDataServiceProcessorGetChildNodeInNextLevel) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSDataServiceGetChildNodeInNextLevelArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "getChildNodeInNextLevel", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSDataServiceGetChildNodeInNextLevelResult{}
  var retval []string
  if retval, err2 = p.handler.GetChildNodeInNextLevel(ctx, args.Header, args.Path); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getChildNodeInNextLevel: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "getChildNodeInNextLevel", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "getChildNodeInNextLevel", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSDataServiceProcessorGetChildNodePathInNextLevel struct {
  handler TSDataService
}

func (p *tSDataServiceProcessorGetChildNodePathInNextLevel) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSDataServiceGetChildNodePathInNextLevelArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "getChildNodePathInNextLevel", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSDataServiceGetChildNodePathInNextLevelResult{}
  var retval []string
  if retval, err2 = p.handler.GetChildNodePathInNextLevel(ctx, args.Header, args.Path); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getChildNodePathInNextLevel: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "getChildNodePathInNextLevel", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "getChildNodePathInNextLevel", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSDataServiceProcessorGetAllMeasurementSchema struct {
  handler TSDataService
}

func (p *tSDataServiceProcessorGetAllMeasurementSchema) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSDataServiceGetAllMeasurementSchemaArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "getAllMeasurementSchema", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSDataServiceGetAllMeasurementSchemaResult{}
  var retval []byte
  if retval, err2 = p.handler.GetAllMeasurementSchema(ctx, args.Request); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getAllMeasurementSchema: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "getAllMeasurementSchema", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "getAllMeasurementSchema", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSDataServiceProcessorGetAggrResult_ struct {
  handler TSDataService
}

func (p *tSDataServiceProcessorGetAggrResult_) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSDataServiceGetAggrResultArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "getAggrResult", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSDataServiceGetAggrResultResult{}
  var retval [][]byte
  if retval, err2 = p.handler.GetAggrResult_(ctx, args.Request); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getAggrResult: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "getAggrResult", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "getAggrResult", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSDataServiceProcessorGetUnregisteredTimeseries struct {
  handler TSDataService
}

func (p *tSDataServiceProcessorGetUnregisteredTimeseries) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSDataServiceGetUnregisteredTimeseriesArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "getUnregisteredTimeseries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSDataServiceGetUnregisteredTimeseriesResult{}
  var retval []string
  if retval, err2 = p.handler.GetUnregisteredTimeseries(ctx, args.Header, args.TimeseriesList); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getUnregisteredTimeseries: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "getUnregisteredTimeseries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "getUnregisteredTimeseries", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSDataServiceProcessorPullSnapshot struct {
  handler TSDataService
}

func (p *tSDataServiceProcessorPullSnapshot) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSDataServicePullSnapshotArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "pullSnapshot", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSDataServicePullSnapshotResult{}
  var retval *PullSnapshotResp
  if retval, err2 = p.handler.PullSnapshot(ctx, args.Request); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing pullSnapshot: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "pullSnapshot", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "pullSnapshot", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSDataServiceProcessorGetGroupByExecutor struct {
  handler TSDataService
}

func (p *tSDataServiceProcessorGetGroupByExecutor) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSDataServiceGetGroupByExecutorArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "getGroupByExecutor", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSDataServiceGetGroupByExecutorResult{}
  var retval Long
  if retval, err2 = p.handler.GetGroupByExecutor(ctx, args.Request); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getGroupByExecutor: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "getGroupByExecutor", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = &retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "getGroupByExecutor", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSDataServiceProcessorGetGroupByResult_ struct {
  handler TSDataService
}

func (p *tSDataServiceProcessorGetGroupByResult_) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSDataServiceGetGroupByResultArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "getGroupByResult", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSDataServiceGetGroupByResultResult{}
  var retval [][]byte
  if retval, err2 = p.handler.GetGroupByResult_(ctx, args.Header, args.ExecutorId, args.StartTime, args.EndTime); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getGroupByResult: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "getGroupByResult", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "getGroupByResult", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSDataServiceProcessorPullTimeSeriesSchema struct {
  handler TSDataService
}

func (p *tSDataServiceProcessorPullTimeSeriesSchema) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSDataServicePullTimeSeriesSchemaArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "pullTimeSeriesSchema", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSDataServicePullTimeSeriesSchemaResult{}
  var retval *PullSchemaResp
  if retval, err2 = p.handler.PullTimeSeriesSchema(ctx, args.Request); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing pullTimeSeriesSchema: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "pullTimeSeriesSchema", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "pullTimeSeriesSchema", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSDataServiceProcessorPullMeasurementSchema struct {
  handler TSDataService
}

func (p *tSDataServiceProcessorPullMeasurementSchema) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSDataServicePullMeasurementSchemaArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "pullMeasurementSchema", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSDataServicePullMeasurementSchemaResult{}
  var retval *PullSchemaResp
  if retval, err2 = p.handler.PullMeasurementSchema(ctx, args.Request); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing pullMeasurementSchema: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "pullMeasurementSchema", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "pullMeasurementSchema", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSDataServiceProcessorPreviousFill struct {
  handler TSDataService
}

func (p *tSDataServiceProcessorPreviousFill) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSDataServicePreviousFillArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "previousFill", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSDataServicePreviousFillResult{}
  var retval []byte
  if retval, err2 = p.handler.PreviousFill(ctx, args.Request); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing previousFill: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "previousFill", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "previousFill", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSDataServiceProcessorLast struct {
  handler TSDataService
}

func (p *tSDataServiceProcessorLast) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSDataServiceLastArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "last", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSDataServiceLastResult{}
  var retval []byte
  if retval, err2 = p.handler.Last(ctx, args.Request); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing last: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "last", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "last", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSDataServiceProcessorGetPathCount struct {
  handler TSDataService
}

func (p *tSDataServiceProcessorGetPathCount) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSDataServiceGetPathCountArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "getPathCount", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSDataServiceGetPathCountResult{}
  var retval Int
  if retval, err2 = p.handler.GetPathCount(ctx, args.Header, args.PathsToQuery, args.Level); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getPathCount: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "getPathCount", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = &retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "getPathCount", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSDataServiceProcessorGetDeviceCount struct {
  handler TSDataService
}

func (p *tSDataServiceProcessorGetDeviceCount) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSDataServiceGetDeviceCountArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "getDeviceCount", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSDataServiceGetDeviceCountResult{}
  var retval Int
  if retval, err2 = p.handler.GetDeviceCount(ctx, args.Header, args.PathsToQuery); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getDeviceCount: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "getDeviceCount", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = &retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "getDeviceCount", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSDataServiceProcessorOnSnapshotApplied struct {
  handler TSDataService
}

func (p *tSDataServiceProcessorOnSnapshotApplied) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSDataServiceOnSnapshotAppliedArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "onSnapshotApplied", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSDataServiceOnSnapshotAppliedResult{}
  var retval bool
  if retval, err2 = p.handler.OnSnapshotApplied(ctx, args.Header, args.Slots); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing onSnapshotApplied: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "onSnapshotApplied", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = &retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "onSnapshotApplied", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSDataServiceProcessorPeekNextNotNullValue struct {
  handler TSDataService
}

func (p *tSDataServiceProcessorPeekNextNotNullValue) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSDataServicePeekNextNotNullValueArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "peekNextNotNullValue", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSDataServicePeekNextNotNullValueResult{}
  var retval []byte
  if retval, err2 = p.handler.PeekNextNotNullValue(ctx, args.Header, args.ExecutorId, args.StartTime, args.EndTime); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing peekNextNotNullValue: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "peekNextNotNullValue", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "peekNextNotNullValue", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}


// HELPER FUNCTIONS AND STRUCTURES

// Attributes:
//  - Request
type TSDataServiceQuerySingleSeriesArgs struct {
  Request *SingleSeriesQueryRequest `thrift:"request,1" db:"request" json:"request"`
}

func NewTSDataServiceQuerySingleSeriesArgs() *TSDataServiceQuerySingleSeriesArgs {
  return &TSDataServiceQuerySingleSeriesArgs{}
}

var TSDataServiceQuerySingleSeriesArgs_Request_DEFAULT *SingleSeriesQueryRequest
func (p *TSDataServiceQuerySingleSeriesArgs) GetRequest() *SingleSeriesQueryRequest {
  if !p.IsSetRequest() {
    return TSDataServiceQuerySingleSeriesArgs_Request_DEFAULT
  }
return p.Request
}
func (p *TSDataServiceQuerySingleSeriesArgs) IsSetRequest() bool {
  return p.Request != nil
}

func (p *TSDataServiceQuerySingleSeriesArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceQuerySingleSeriesArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Request = &SingleSeriesQueryRequest{}
  if err := p.Request.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Request), err)
  }
  return nil
}

func (p *TSDataServiceQuerySingleSeriesArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "querySingleSeries_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceQuerySingleSeriesArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "request", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:request: ", p), err) }
  if err := p.Request.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Request), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:request: ", p), err) }
  return err
}

func (p *TSDataServiceQuerySingleSeriesArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceQuerySingleSeriesArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSDataServiceQuerySingleSeriesResult struct {
  Success *Long `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSDataServiceQuerySingleSeriesResult() *TSDataServiceQuerySingleSeriesResult {
  return &TSDataServiceQuerySingleSeriesResult{}
}

var TSDataServiceQuerySingleSeriesResult_Success_DEFAULT Long
func (p *TSDataServiceQuerySingleSeriesResult) GetSuccess() Long {
  if !p.IsSetSuccess() {
    return TSDataServiceQuerySingleSeriesResult_Success_DEFAULT
  }
return *p.Success
}
func (p *TSDataServiceQuerySingleSeriesResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSDataServiceQuerySingleSeriesResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceQuerySingleSeriesResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 0: ", err)
} else {
  temp := Long(v)
  p.Success = &temp
}
  return nil
}

func (p *TSDataServiceQuerySingleSeriesResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "querySingleSeries_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceQuerySingleSeriesResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.I64, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.Success)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.success (0) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSDataServiceQuerySingleSeriesResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceQuerySingleSeriesResult(%+v)", *p)
}

// Attributes:
//  - Request
type TSDataServiceQueryMultSeriesArgs struct {
  Request *MultSeriesQueryRequest `thrift:"request,1" db:"request" json:"request"`
}

func NewTSDataServiceQueryMultSeriesArgs() *TSDataServiceQueryMultSeriesArgs {
  return &TSDataServiceQueryMultSeriesArgs{}
}

var TSDataServiceQueryMultSeriesArgs_Request_DEFAULT *MultSeriesQueryRequest
func (p *TSDataServiceQueryMultSeriesArgs) GetRequest() *MultSeriesQueryRequest {
  if !p.IsSetRequest() {
    return TSDataServiceQueryMultSeriesArgs_Request_DEFAULT
  }
return p.Request
}
func (p *TSDataServiceQueryMultSeriesArgs) IsSetRequest() bool {
  return p.Request != nil
}

func (p *TSDataServiceQueryMultSeriesArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceQueryMultSeriesArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Request = &MultSeriesQueryRequest{}
  if err := p.Request.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Request), err)
  }
  return nil
}

func (p *TSDataServiceQueryMultSeriesArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "queryMultSeries_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceQueryMultSeriesArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "request", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:request: ", p), err) }
  if err := p.Request.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Request), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:request: ", p), err) }
  return err
}

func (p *TSDataServiceQueryMultSeriesArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceQueryMultSeriesArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSDataServiceQueryMultSeriesResult struct {
  Success *Long `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSDataServiceQueryMultSeriesResult() *TSDataServiceQueryMultSeriesResult {
  return &TSDataServiceQueryMultSeriesResult{}
}

var TSDataServiceQueryMultSeriesResult_Success_DEFAULT Long
func (p *TSDataServiceQueryMultSeriesResult) GetSuccess() Long {
  if !p.IsSetSuccess() {
    return TSDataServiceQueryMultSeriesResult_Success_DEFAULT
  }
return *p.Success
}
func (p *TSDataServiceQueryMultSeriesResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSDataServiceQueryMultSeriesResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceQueryMultSeriesResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 0: ", err)
} else {
  temp := Long(v)
  p.Success = &temp
}
  return nil
}

func (p *TSDataServiceQueryMultSeriesResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "queryMultSeries_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceQueryMultSeriesResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.I64, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.Success)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.success (0) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSDataServiceQueryMultSeriesResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceQueryMultSeriesResult(%+v)", *p)
}

// Attributes:
//  - Header
//  - ReaderId
type TSDataServiceFetchSingleSeriesArgs struct {
  Header *RaftNode `thrift:"header,1" db:"header" json:"header"`
  ReaderId Long `thrift:"readerId,2" db:"readerId" json:"readerId"`
}

func NewTSDataServiceFetchSingleSeriesArgs() *TSDataServiceFetchSingleSeriesArgs {
  return &TSDataServiceFetchSingleSeriesArgs{}
}

var TSDataServiceFetchSingleSeriesArgs_Header_DEFAULT *RaftNode
func (p *TSDataServiceFetchSingleSeriesArgs) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return TSDataServiceFetchSingleSeriesArgs_Header_DEFAULT
  }
return p.Header
}

func (p *TSDataServiceFetchSingleSeriesArgs) GetReaderId() Long {
  return p.ReaderId
}
func (p *TSDataServiceFetchSingleSeriesArgs) IsSetHeader() bool {
  return p.Header != nil
}

func (p *TSDataServiceFetchSingleSeriesArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceFetchSingleSeriesArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *TSDataServiceFetchSingleSeriesArgs)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  temp := Long(v)
  p.ReaderId = temp
}
  return nil
}

func (p *TSDataServiceFetchSingleSeriesArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "fetchSingleSeries_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceFetchSingleSeriesArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:header: ", p), err) }
  if err := p.Header.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:header: ", p), err) }
  return err
}

func (p *TSDataServiceFetchSingleSeriesArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "readerId", thrift.I64, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:readerId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.ReaderId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.readerId (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:readerId: ", p), err) }
  return err
}

func (p *TSDataServiceFetchSingleSeriesArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceFetchSingleSeriesArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSDataServiceFetchSingleSeriesResult struct {
  Success []byte `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSDataServiceFetchSingleSeriesResult() *TSDataServiceFetchSingleSeriesResult {
  return &TSDataServiceFetchSingleSeriesResult{}
}

var TSDataServiceFetchSingleSeriesResult_Success_DEFAULT []byte

func (p *TSDataServiceFetchSingleSeriesResult) GetSuccess() []byte {
  return p.Success
}
func (p *TSDataServiceFetchSingleSeriesResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSDataServiceFetchSingleSeriesResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceFetchSingleSeriesResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 0: ", err)
} else {
  p.Success = v
}
  return nil
}

func (p *TSDataServiceFetchSingleSeriesResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "fetchSingleSeries_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceFetchSingleSeriesResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRING, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteBinary(ctx, p.Success); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.success (0) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSDataServiceFetchSingleSeriesResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceFetchSingleSeriesResult(%+v)", *p)
}

// Attributes:
//  - Header
//  - ReaderId
//  - Paths
type TSDataServiceFetchMultSeriesArgs struct {
  Header *RaftNode `thrift:"header,1" db:"header" json:"header"`
  ReaderId Long `thrift:"readerId,2" db:"readerId" json:"readerId"`
  Paths []string `thrift:"paths,3" db:"paths" json:"paths"`
}

func NewTSDataServiceFetchMultSeriesArgs() *TSDataServiceFetchMultSeriesArgs {
  return &TSDataServiceFetchMultSeriesArgs{}
}

var TSDataServiceFetchMultSeriesArgs_Header_DEFAULT *RaftNode
func (p *TSDataServiceFetchMultSeriesArgs) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return TSDataServiceFetchMultSeriesArgs_Header_DEFAULT
  }
return p.Header
}

func (p *TSDataServiceFetchMultSeriesArgs) GetReaderId() Long {
  return p.ReaderId
}

func (p *TSDataServiceFetchMultSeriesArgs) GetPaths() []string {
  return p.Paths
}
func (p *TSDataServiceFetchMultSeriesArgs) IsSetHeader() bool {
  return p.Header != nil
}

func (p *TSDataServiceFetchMultSeriesArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceFetchMultSeriesArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *TSDataServiceFetchMultSeriesArgs)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  temp := Long(v)
  p.ReaderId = temp
}
  return nil
}

func (p *TSDataServiceFetchMultSeriesArgs)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Paths =  tSlice
  for i := 0; i < size; i ++ {
var _elem221 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem221 = v
}
    p.Paths = append(p.Paths, _elem221)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSDataServiceFetchMultSeriesArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "fetchMultSeries_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceFetchMultSeriesArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:header: ", p), err) }
  if err := p.Header.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:header: ", p), err) }
  return err
}

func (p *TSDataServiceFetchMultSeriesArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "readerId", thrift.I64, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:readerId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.ReaderId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.readerId (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:readerId: ", p), err) }
  return err
}

func (p *TSDataServiceFetchMultSeriesArgs) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "paths", thrift.LIST, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:paths: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Paths)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Paths {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:paths: ", p), err) }
  return err
}

func (p *TSDataServiceFetchMultSeriesArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceFetchMultSeriesArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSDataServiceFetchMultSeriesResult struct {
  Success map[string][]byte `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSDataServiceFetchMultSeriesResult() *TSDataServiceFetchMultSeriesResult {
  return &TSDataServiceFetchMultSeriesResult{}
}

var TSDataServiceFetchMultSeriesResult_Success_DEFAULT map[string][]byte

func (p *TSDataServiceFetchMultSeriesResult) GetSuccess() map[string][]byte {
  return p.Success
}
func (p *TSDataServiceFetchMultSeriesResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSDataServiceFetchMultSeriesResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.MAP {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceFetchMultSeriesResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  _, _, size, err := iprot.ReadMapBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
  }
  tMap := make(map[string][]byte, size)
  p.Success =  tMap
  for i := 0; i < size; i ++ {
var _key222 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _key222 = v
}
var _val223 []byte
    if v, err := iprot.ReadBinary(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _val223 = v
}
    p.Success[_key222] = _val223
  }
  if err := iprot.ReadMapEnd(ctx); err != nil {
    return thrift.PrependError("error reading map end: ", err)
  }
  return nil
}

func (p *TSDataServiceFetchMultSeriesResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "fetchMultSeries_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceFetchMultSeriesResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.MAP, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(p.Success)); err != nil {
      return thrift.PrependError("error writing map begin: ", err)
    }
    for k, v := range p.Success {
      if err := oprot.WriteString(ctx, string(k)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
      if err := oprot.WriteBinary(ctx, v); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteMapEnd(ctx); err != nil {
      return thrift.PrependError("error writing map end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSDataServiceFetchMultSeriesResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceFetchMultSeriesResult(%+v)", *p)
}

// Attributes:
//  - Request
type TSDataServiceQuerySingleSeriesByTimestampArgs struct {
  Request *SingleSeriesQueryRequest `thrift:"request,1" db:"request" json:"request"`
}

func NewTSDataServiceQuerySingleSeriesByTimestampArgs() *TSDataServiceQuerySingleSeriesByTimestampArgs {
  return &TSDataServiceQuerySingleSeriesByTimestampArgs{}
}

var TSDataServiceQuerySingleSeriesByTimestampArgs_Request_DEFAULT *SingleSeriesQueryRequest
func (p *TSDataServiceQuerySingleSeriesByTimestampArgs) GetRequest() *SingleSeriesQueryRequest {
  if !p.IsSetRequest() {
    return TSDataServiceQuerySingleSeriesByTimestampArgs_Request_DEFAULT
  }
return p.Request
}
func (p *TSDataServiceQuerySingleSeriesByTimestampArgs) IsSetRequest() bool {
  return p.Request != nil
}

func (p *TSDataServiceQuerySingleSeriesByTimestampArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceQuerySingleSeriesByTimestampArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Request = &SingleSeriesQueryRequest{}
  if err := p.Request.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Request), err)
  }
  return nil
}

func (p *TSDataServiceQuerySingleSeriesByTimestampArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "querySingleSeriesByTimestamp_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceQuerySingleSeriesByTimestampArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "request", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:request: ", p), err) }
  if err := p.Request.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Request), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:request: ", p), err) }
  return err
}

func (p *TSDataServiceQuerySingleSeriesByTimestampArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceQuerySingleSeriesByTimestampArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSDataServiceQuerySingleSeriesByTimestampResult struct {
  Success *Long `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSDataServiceQuerySingleSeriesByTimestampResult() *TSDataServiceQuerySingleSeriesByTimestampResult {
  return &TSDataServiceQuerySingleSeriesByTimestampResult{}
}

var TSDataServiceQuerySingleSeriesByTimestampResult_Success_DEFAULT Long
func (p *TSDataServiceQuerySingleSeriesByTimestampResult) GetSuccess() Long {
  if !p.IsSetSuccess() {
    return TSDataServiceQuerySingleSeriesByTimestampResult_Success_DEFAULT
  }
return *p.Success
}
func (p *TSDataServiceQuerySingleSeriesByTimestampResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSDataServiceQuerySingleSeriesByTimestampResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceQuerySingleSeriesByTimestampResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 0: ", err)
} else {
  temp := Long(v)
  p.Success = &temp
}
  return nil
}

func (p *TSDataServiceQuerySingleSeriesByTimestampResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "querySingleSeriesByTimestamp_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceQuerySingleSeriesByTimestampResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.I64, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.Success)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.success (0) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSDataServiceQuerySingleSeriesByTimestampResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceQuerySingleSeriesByTimestampResult(%+v)", *p)
}

// Attributes:
//  - Header
//  - ReaderId
//  - Timestamps
type TSDataServiceFetchSingleSeriesByTimestampsArgs struct {
  Header *RaftNode `thrift:"header,1" db:"header" json:"header"`
  ReaderId Long `thrift:"readerId,2" db:"readerId" json:"readerId"`
  Timestamps []Long `thrift:"timestamps,3" db:"timestamps" json:"timestamps"`
}

func NewTSDataServiceFetchSingleSeriesByTimestampsArgs() *TSDataServiceFetchSingleSeriesByTimestampsArgs {
  return &TSDataServiceFetchSingleSeriesByTimestampsArgs{}
}

var TSDataServiceFetchSingleSeriesByTimestampsArgs_Header_DEFAULT *RaftNode
func (p *TSDataServiceFetchSingleSeriesByTimestampsArgs) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return TSDataServiceFetchSingleSeriesByTimestampsArgs_Header_DEFAULT
  }
return p.Header
}

func (p *TSDataServiceFetchSingleSeriesByTimestampsArgs) GetReaderId() Long {
  return p.ReaderId
}

func (p *TSDataServiceFetchSingleSeriesByTimestampsArgs) GetTimestamps() []Long {
  return p.Timestamps
}
func (p *TSDataServiceFetchSingleSeriesByTimestampsArgs) IsSetHeader() bool {
  return p.Header != nil
}

func (p *TSDataServiceFetchSingleSeriesByTimestampsArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceFetchSingleSeriesByTimestampsArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *TSDataServiceFetchSingleSeriesByTimestampsArgs)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  temp := Long(v)
  p.ReaderId = temp
}
  return nil
}

func (p *TSDataServiceFetchSingleSeriesByTimestampsArgs)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]Long, 0, size)
  p.Timestamps =  tSlice
  for i := 0; i < size; i ++ {
var _elem224 Long
    if v, err := iprot.ReadI64(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    temp := Long(v)
    _elem224 = temp
}
    p.Timestamps = append(p.Timestamps, _elem224)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSDataServiceFetchSingleSeriesByTimestampsArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "fetchSingleSeriesByTimestamps_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceFetchSingleSeriesByTimestampsArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:header: ", p), err) }
  if err := p.Header.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:header: ", p), err) }
  return err
}

func (p *TSDataServiceFetchSingleSeriesByTimestampsArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "readerId", thrift.I64, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:readerId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.ReaderId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.readerId (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:readerId: ", p), err) }
  return err
}

func (p *TSDataServiceFetchSingleSeriesByTimestampsArgs) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "timestamps", thrift.LIST, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:timestamps: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I64, len(p.Timestamps)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Timestamps {
    if err := oprot.WriteI64(ctx, int64(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:timestamps: ", p), err) }
  return err
}

func (p *TSDataServiceFetchSingleSeriesByTimestampsArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceFetchSingleSeriesByTimestampsArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSDataServiceFetchSingleSeriesByTimestampsResult struct {
  Success []byte `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSDataServiceFetchSingleSeriesByTimestampsResult() *TSDataServiceFetchSingleSeriesByTimestampsResult {
  return &TSDataServiceFetchSingleSeriesByTimestampsResult{}
}

var TSDataServiceFetchSingleSeriesByTimestampsResult_Success_DEFAULT []byte

func (p *TSDataServiceFetchSingleSeriesByTimestampsResult) GetSuccess() []byte {
  return p.Success
}
func (p *TSDataServiceFetchSingleSeriesByTimestampsResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSDataServiceFetchSingleSeriesByTimestampsResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceFetchSingleSeriesByTimestampsResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 0: ", err)
} else {
  p.Success = v
}
  return nil
}

func (p *TSDataServiceFetchSingleSeriesByTimestampsResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "fetchSingleSeriesByTimestamps_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceFetchSingleSeriesByTimestampsResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRING, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteBinary(ctx, p.Success); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.success (0) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSDataServiceFetchSingleSeriesByTimestampsResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceFetchSingleSeriesByTimestampsResult(%+v)", *p)
}

// Attributes:
//  - Header
//  - ThisNode
//  - QueryId
type TSDataServiceEndQueryArgs struct {
  Header *RaftNode `thrift:"header,1" db:"header" json:"header"`
  // unused field # 2
  ThisNode *Node `thrift:"thisNode,3" db:"thisNode" json:"thisNode"`
  QueryId Long `thrift:"queryId,4" db:"queryId" json:"queryId"`
}

func NewTSDataServiceEndQueryArgs() *TSDataServiceEndQueryArgs {
  return &TSDataServiceEndQueryArgs{}
}

var TSDataServiceEndQueryArgs_Header_DEFAULT *RaftNode
func (p *TSDataServiceEndQueryArgs) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return TSDataServiceEndQueryArgs_Header_DEFAULT
  }
return p.Header
}
var TSDataServiceEndQueryArgs_ThisNode_DEFAULT *Node
func (p *TSDataServiceEndQueryArgs) GetThisNode() *Node {
  if !p.IsSetThisNode() {
    return TSDataServiceEndQueryArgs_ThisNode_DEFAULT
  }
return p.ThisNode
}

func (p *TSDataServiceEndQueryArgs) GetQueryId() Long {
  return p.QueryId
}
func (p *TSDataServiceEndQueryArgs) IsSetHeader() bool {
  return p.Header != nil
}

func (p *TSDataServiceEndQueryArgs) IsSetThisNode() bool {
  return p.ThisNode != nil
}

func (p *TSDataServiceEndQueryArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceEndQueryArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *TSDataServiceEndQueryArgs)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  p.ThisNode = &Node{}
  if err := p.ThisNode.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.ThisNode), err)
  }
  return nil
}

func (p *TSDataServiceEndQueryArgs)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  temp := Long(v)
  p.QueryId = temp
}
  return nil
}

func (p *TSDataServiceEndQueryArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "endQuery_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceEndQueryArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:header: ", p), err) }
  if err := p.Header.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:header: ", p), err) }
  return err
}

func (p *TSDataServiceEndQueryArgs) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "thisNode", thrift.STRUCT, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:thisNode: ", p), err) }
  if err := p.ThisNode.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.ThisNode), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:thisNode: ", p), err) }
  return err
}

func (p *TSDataServiceEndQueryArgs) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "queryId", thrift.I64, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:queryId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.QueryId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.queryId (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:queryId: ", p), err) }
  return err
}

func (p *TSDataServiceEndQueryArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceEndQueryArgs(%+v)", *p)
}

type TSDataServiceEndQueryResult struct {
}

func NewTSDataServiceEndQueryResult() *TSDataServiceEndQueryResult {
  return &TSDataServiceEndQueryResult{}
}

func (p *TSDataServiceEndQueryResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    if err := iprot.Skip(ctx, fieldTypeId); err != nil {
      return err
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceEndQueryResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "endQuery_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceEndQueryResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceEndQueryResult(%+v)", *p)
}

// Attributes:
//  - Header
//  - Paths
//  - WithAlias
type TSDataServiceGetAllPathsArgs struct {
  Header *RaftNode `thrift:"header,1" db:"header" json:"header"`
  Paths []string `thrift:"paths,2" db:"paths" json:"paths"`
  WithAlias bool `thrift:"withAlias,3" db:"withAlias" json:"withAlias"`
}

func NewTSDataServiceGetAllPathsArgs() *TSDataServiceGetAllPathsArgs {
  return &TSDataServiceGetAllPathsArgs{}
}

var TSDataServiceGetAllPathsArgs_Header_DEFAULT *RaftNode
func (p *TSDataServiceGetAllPathsArgs) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return TSDataServiceGetAllPathsArgs_Header_DEFAULT
  }
return p.Header
}

func (p *TSDataServiceGetAllPathsArgs) GetPaths() []string {
  return p.Paths
}

func (p *TSDataServiceGetAllPathsArgs) GetWithAlias() bool {
  return p.WithAlias
}
func (p *TSDataServiceGetAllPathsArgs) IsSetHeader() bool {
  return p.Header != nil
}

func (p *TSDataServiceGetAllPathsArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceGetAllPathsArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *TSDataServiceGetAllPathsArgs)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Paths =  tSlice
  for i := 0; i < size; i ++ {
var _elem225 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem225 = v
}
    p.Paths = append(p.Paths, _elem225)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSDataServiceGetAllPathsArgs)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.WithAlias = v
}
  return nil
}

func (p *TSDataServiceGetAllPathsArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getAllPaths_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceGetAllPathsArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:header: ", p), err) }
  if err := p.Header.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:header: ", p), err) }
  return err
}

func (p *TSDataServiceGetAllPathsArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "paths", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:paths: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Paths)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Paths {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:paths: ", p), err) }
  return err
}

func (p *TSDataServiceGetAllPathsArgs) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "withAlias", thrift.BOOL, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:withAlias: ", p), err) }
  if err := oprot.WriteBool(ctx, bool(p.WithAlias)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.withAlias (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:withAlias: ", p), err) }
  return err
}

func (p *TSDataServiceGetAllPathsArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceGetAllPathsArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSDataServiceGetAllPathsResult struct {
  Success *GetAllPathsResult_ `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSDataServiceGetAllPathsResult() *TSDataServiceGetAllPathsResult {
  return &TSDataServiceGetAllPathsResult{}
}

var TSDataServiceGetAllPathsResult_Success_DEFAULT *GetAllPathsResult_
func (p *TSDataServiceGetAllPathsResult) GetSuccess() *GetAllPathsResult_ {
  if !p.IsSetSuccess() {
    return TSDataServiceGetAllPathsResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSDataServiceGetAllPathsResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSDataServiceGetAllPathsResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceGetAllPathsResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &GetAllPathsResult_{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSDataServiceGetAllPathsResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getAllPaths_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceGetAllPathsResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSDataServiceGetAllPathsResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceGetAllPathsResult(%+v)", *p)
}

// Attributes:
//  - Header
//  - Path
//  - IsPrefixMatch
type TSDataServiceGetAllDevicesArgs struct {
  Header *RaftNode `thrift:"header,1" db:"header" json:"header"`
  Path []string `thrift:"path,2" db:"path" json:"path"`
  IsPrefixMatch bool `thrift:"isPrefixMatch,3" db:"isPrefixMatch" json:"isPrefixMatch"`
}

func NewTSDataServiceGetAllDevicesArgs() *TSDataServiceGetAllDevicesArgs {
  return &TSDataServiceGetAllDevicesArgs{}
}

var TSDataServiceGetAllDevicesArgs_Header_DEFAULT *RaftNode
func (p *TSDataServiceGetAllDevicesArgs) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return TSDataServiceGetAllDevicesArgs_Header_DEFAULT
  }
return p.Header
}

func (p *TSDataServiceGetAllDevicesArgs) GetPath() []string {
  return p.Path
}

func (p *TSDataServiceGetAllDevicesArgs) GetIsPrefixMatch() bool {
  return p.IsPrefixMatch
}
func (p *TSDataServiceGetAllDevicesArgs) IsSetHeader() bool {
  return p.Header != nil
}

func (p *TSDataServiceGetAllDevicesArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceGetAllDevicesArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *TSDataServiceGetAllDevicesArgs)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Path =  tSlice
  for i := 0; i < size; i ++ {
var _elem226 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem226 = v
}
    p.Path = append(p.Path, _elem226)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSDataServiceGetAllDevicesArgs)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.IsPrefixMatch = v
}
  return nil
}

func (p *TSDataServiceGetAllDevicesArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getAllDevices_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceGetAllDevicesArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:header: ", p), err) }
  if err := p.Header.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:header: ", p), err) }
  return err
}

func (p *TSDataServiceGetAllDevicesArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "path", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:path: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Path)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Path {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:path: ", p), err) }
  return err
}

func (p *TSDataServiceGetAllDevicesArgs) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "isPrefixMatch", thrift.BOOL, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:isPrefixMatch: ", p), err) }
  if err := oprot.WriteBool(ctx, bool(p.IsPrefixMatch)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.isPrefixMatch (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:isPrefixMatch: ", p), err) }
  return err
}

func (p *TSDataServiceGetAllDevicesArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceGetAllDevicesArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSDataServiceGetAllDevicesResult struct {
  Success []string `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSDataServiceGetAllDevicesResult() *TSDataServiceGetAllDevicesResult {
  return &TSDataServiceGetAllDevicesResult{}
}

var TSDataServiceGetAllDevicesResult_Success_DEFAULT []string

func (p *TSDataServiceGetAllDevicesResult) GetSuccess() []string {
  return p.Success
}
func (p *TSDataServiceGetAllDevicesResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSDataServiceGetAllDevicesResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.SET {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceGetAllDevicesResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadSetBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading set begin: ", err)
  }
  tSet := make([]string, 0, size)
  p.Success =  tSet
  for i := 0; i < size; i ++ {
var _elem227 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem227 = v
}
    p.Success = append(p.Success, _elem227)
  }
  if err := iprot.ReadSetEnd(ctx); err != nil {
    return thrift.PrependError("error reading set end: ", err)
  }
  return nil
}

func (p *TSDataServiceGetAllDevicesResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getAllDevices_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceGetAllDevicesResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.SET, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteSetBegin(ctx, thrift.STRING, len(p.Success)); err != nil {
      return thrift.PrependError("error writing set begin: ", err)
    }
    for i := 0; i<len(p.Success); i++ {
      for j := i+1; j<len(p.Success); j++ {
        if func(tgt, src string) bool {
          if tgt != src { return false }
          return true
        }(p.Success[i], p.Success[j]) {
          return thrift.PrependError("", fmt.Errorf("%T error writing set field: slice is not unique", p.Success))
        }
      }
    }
    for _, v := range p.Success {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteSetEnd(ctx); err != nil {
      return thrift.PrependError("error writing set end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSDataServiceGetAllDevicesResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceGetAllDevicesResult(%+v)", *p)
}

// Attributes:
//  - Header
//  - PlanBinary
type TSDataServiceGetDevicesArgs struct {
  Header *RaftNode `thrift:"header,1" db:"header" json:"header"`
  PlanBinary []byte `thrift:"planBinary,2" db:"planBinary" json:"planBinary"`
}

func NewTSDataServiceGetDevicesArgs() *TSDataServiceGetDevicesArgs {
  return &TSDataServiceGetDevicesArgs{}
}

var TSDataServiceGetDevicesArgs_Header_DEFAULT *RaftNode
func (p *TSDataServiceGetDevicesArgs) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return TSDataServiceGetDevicesArgs_Header_DEFAULT
  }
return p.Header
}

func (p *TSDataServiceGetDevicesArgs) GetPlanBinary() []byte {
  return p.PlanBinary
}
func (p *TSDataServiceGetDevicesArgs) IsSetHeader() bool {
  return p.Header != nil
}

func (p *TSDataServiceGetDevicesArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceGetDevicesArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *TSDataServiceGetDevicesArgs)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.PlanBinary = v
}
  return nil
}

func (p *TSDataServiceGetDevicesArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getDevices_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceGetDevicesArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:header: ", p), err) }
  if err := p.Header.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:header: ", p), err) }
  return err
}

func (p *TSDataServiceGetDevicesArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "planBinary", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:planBinary: ", p), err) }
  if err := oprot.WriteBinary(ctx, p.PlanBinary); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.planBinary (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:planBinary: ", p), err) }
  return err
}

func (p *TSDataServiceGetDevicesArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceGetDevicesArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSDataServiceGetDevicesResult struct {
  Success []byte `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSDataServiceGetDevicesResult() *TSDataServiceGetDevicesResult {
  return &TSDataServiceGetDevicesResult{}
}

var TSDataServiceGetDevicesResult_Success_DEFAULT []byte

func (p *TSDataServiceGetDevicesResult) GetSuccess() []byte {
  return p.Success
}
func (p *TSDataServiceGetDevicesResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSDataServiceGetDevicesResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceGetDevicesResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 0: ", err)
} else {
  p.Success = v
}
  return nil
}

func (p *TSDataServiceGetDevicesResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getDevices_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceGetDevicesResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRING, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteBinary(ctx, p.Success); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.success (0) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSDataServiceGetDevicesResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceGetDevicesResult(%+v)", *p)
}

// Attributes:
//  - Header
//  - Path
//  - NodeLevel
type TSDataServiceGetNodeListArgs struct {
  Header *RaftNode `thrift:"header,1" db:"header" json:"header"`
  Path string `thrift:"path,2" db:"path" json:"path"`
  NodeLevel Int `thrift:"nodeLevel,3" db:"nodeLevel" json:"nodeLevel"`
}

func NewTSDataServiceGetNodeListArgs() *TSDataServiceGetNodeListArgs {
  return &TSDataServiceGetNodeListArgs{}
}

var TSDataServiceGetNodeListArgs_Header_DEFAULT *RaftNode
func (p *TSDataServiceGetNodeListArgs) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return TSDataServiceGetNodeListArgs_Header_DEFAULT
  }
return p.Header
}

func (p *TSDataServiceGetNodeListArgs) GetPath() string {
  return p.Path
}

func (p *TSDataServiceGetNodeListArgs) GetNodeLevel() Int {
  return p.NodeLevel
}
func (p *TSDataServiceGetNodeListArgs) IsSetHeader() bool {
  return p.Header != nil
}

func (p *TSDataServiceGetNodeListArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceGetNodeListArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *TSDataServiceGetNodeListArgs)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.Path = v
}
  return nil
}

func (p *TSDataServiceGetNodeListArgs)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  temp := Int(v)
  p.NodeLevel = temp
}
  return nil
}

func (p *TSDataServiceGetNodeListArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getNodeList_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceGetNodeListArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:header: ", p), err) }
  if err := p.Header.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:header: ", p), err) }
  return err
}

func (p *TSDataServiceGetNodeListArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "path", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:path: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Path)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.path (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:path: ", p), err) }
  return err
}

func (p *TSDataServiceGetNodeListArgs) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "nodeLevel", thrift.I32, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:nodeLevel: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.NodeLevel)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.nodeLevel (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:nodeLevel: ", p), err) }
  return err
}

func (p *TSDataServiceGetNodeListArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceGetNodeListArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSDataServiceGetNodeListResult struct {
  Success []string `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSDataServiceGetNodeListResult() *TSDataServiceGetNodeListResult {
  return &TSDataServiceGetNodeListResult{}
}

var TSDataServiceGetNodeListResult_Success_DEFAULT []string

func (p *TSDataServiceGetNodeListResult) GetSuccess() []string {
  return p.Success
}
func (p *TSDataServiceGetNodeListResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSDataServiceGetNodeListResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceGetNodeListResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Success =  tSlice
  for i := 0; i < size; i ++ {
var _elem228 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem228 = v
}
    p.Success = append(p.Success, _elem228)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSDataServiceGetNodeListResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getNodeList_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceGetNodeListResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.LIST, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Success)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.Success {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSDataServiceGetNodeListResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceGetNodeListResult(%+v)", *p)
}

// Attributes:
//  - Header
//  - Path
type TSDataServiceGetChildNodeInNextLevelArgs struct {
  Header *RaftNode `thrift:"header,1" db:"header" json:"header"`
  Path string `thrift:"path,2" db:"path" json:"path"`
}

func NewTSDataServiceGetChildNodeInNextLevelArgs() *TSDataServiceGetChildNodeInNextLevelArgs {
  return &TSDataServiceGetChildNodeInNextLevelArgs{}
}

var TSDataServiceGetChildNodeInNextLevelArgs_Header_DEFAULT *RaftNode
func (p *TSDataServiceGetChildNodeInNextLevelArgs) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return TSDataServiceGetChildNodeInNextLevelArgs_Header_DEFAULT
  }
return p.Header
}

func (p *TSDataServiceGetChildNodeInNextLevelArgs) GetPath() string {
  return p.Path
}
func (p *TSDataServiceGetChildNodeInNextLevelArgs) IsSetHeader() bool {
  return p.Header != nil
}

func (p *TSDataServiceGetChildNodeInNextLevelArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceGetChildNodeInNextLevelArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *TSDataServiceGetChildNodeInNextLevelArgs)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.Path = v
}
  return nil
}

func (p *TSDataServiceGetChildNodeInNextLevelArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getChildNodeInNextLevel_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceGetChildNodeInNextLevelArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:header: ", p), err) }
  if err := p.Header.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:header: ", p), err) }
  return err
}

func (p *TSDataServiceGetChildNodeInNextLevelArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "path", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:path: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Path)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.path (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:path: ", p), err) }
  return err
}

func (p *TSDataServiceGetChildNodeInNextLevelArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceGetChildNodeInNextLevelArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSDataServiceGetChildNodeInNextLevelResult struct {
  Success []string `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSDataServiceGetChildNodeInNextLevelResult() *TSDataServiceGetChildNodeInNextLevelResult {
  return &TSDataServiceGetChildNodeInNextLevelResult{}
}

var TSDataServiceGetChildNodeInNextLevelResult_Success_DEFAULT []string

func (p *TSDataServiceGetChildNodeInNextLevelResult) GetSuccess() []string {
  return p.Success
}
func (p *TSDataServiceGetChildNodeInNextLevelResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSDataServiceGetChildNodeInNextLevelResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.SET {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceGetChildNodeInNextLevelResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadSetBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading set begin: ", err)
  }
  tSet := make([]string, 0, size)
  p.Success =  tSet
  for i := 0; i < size; i ++ {
var _elem229 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem229 = v
}
    p.Success = append(p.Success, _elem229)
  }
  if err := iprot.ReadSetEnd(ctx); err != nil {
    return thrift.PrependError("error reading set end: ", err)
  }
  return nil
}

func (p *TSDataServiceGetChildNodeInNextLevelResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getChildNodeInNextLevel_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceGetChildNodeInNextLevelResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.SET, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteSetBegin(ctx, thrift.STRING, len(p.Success)); err != nil {
      return thrift.PrependError("error writing set begin: ", err)
    }
    for i := 0; i<len(p.Success); i++ {
      for j := i+1; j<len(p.Success); j++ {
        if func(tgt, src string) bool {
          if tgt != src { return false }
          return true
        }(p.Success[i], p.Success[j]) {
          return thrift.PrependError("", fmt.Errorf("%T error writing set field: slice is not unique", p.Success))
        }
      }
    }
    for _, v := range p.Success {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteSetEnd(ctx); err != nil {
      return thrift.PrependError("error writing set end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSDataServiceGetChildNodeInNextLevelResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceGetChildNodeInNextLevelResult(%+v)", *p)
}

// Attributes:
//  - Header
//  - Path
type TSDataServiceGetChildNodePathInNextLevelArgs struct {
  Header *RaftNode `thrift:"header,1" db:"header" json:"header"`
  Path string `thrift:"path,2" db:"path" json:"path"`
}

func NewTSDataServiceGetChildNodePathInNextLevelArgs() *TSDataServiceGetChildNodePathInNextLevelArgs {
  return &TSDataServiceGetChildNodePathInNextLevelArgs{}
}

var TSDataServiceGetChildNodePathInNextLevelArgs_Header_DEFAULT *RaftNode
func (p *TSDataServiceGetChildNodePathInNextLevelArgs) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return TSDataServiceGetChildNodePathInNextLevelArgs_Header_DEFAULT
  }
return p.Header
}

func (p *TSDataServiceGetChildNodePathInNextLevelArgs) GetPath() string {
  return p.Path
}
func (p *TSDataServiceGetChildNodePathInNextLevelArgs) IsSetHeader() bool {
  return p.Header != nil
}

func (p *TSDataServiceGetChildNodePathInNextLevelArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceGetChildNodePathInNextLevelArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *TSDataServiceGetChildNodePathInNextLevelArgs)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.Path = v
}
  return nil
}

func (p *TSDataServiceGetChildNodePathInNextLevelArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getChildNodePathInNextLevel_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceGetChildNodePathInNextLevelArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:header: ", p), err) }
  if err := p.Header.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:header: ", p), err) }
  return err
}

func (p *TSDataServiceGetChildNodePathInNextLevelArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "path", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:path: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Path)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.path (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:path: ", p), err) }
  return err
}

func (p *TSDataServiceGetChildNodePathInNextLevelArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceGetChildNodePathInNextLevelArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSDataServiceGetChildNodePathInNextLevelResult struct {
  Success []string `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSDataServiceGetChildNodePathInNextLevelResult() *TSDataServiceGetChildNodePathInNextLevelResult {
  return &TSDataServiceGetChildNodePathInNextLevelResult{}
}

var TSDataServiceGetChildNodePathInNextLevelResult_Success_DEFAULT []string

func (p *TSDataServiceGetChildNodePathInNextLevelResult) GetSuccess() []string {
  return p.Success
}
func (p *TSDataServiceGetChildNodePathInNextLevelResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSDataServiceGetChildNodePathInNextLevelResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.SET {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceGetChildNodePathInNextLevelResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadSetBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading set begin: ", err)
  }
  tSet := make([]string, 0, size)
  p.Success =  tSet
  for i := 0; i < size; i ++ {
var _elem230 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem230 = v
}
    p.Success = append(p.Success, _elem230)
  }
  if err := iprot.ReadSetEnd(ctx); err != nil {
    return thrift.PrependError("error reading set end: ", err)
  }
  return nil
}

func (p *TSDataServiceGetChildNodePathInNextLevelResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getChildNodePathInNextLevel_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceGetChildNodePathInNextLevelResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.SET, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteSetBegin(ctx, thrift.STRING, len(p.Success)); err != nil {
      return thrift.PrependError("error writing set begin: ", err)
    }
    for i := 0; i<len(p.Success); i++ {
      for j := i+1; j<len(p.Success); j++ {
        if func(tgt, src string) bool {
          if tgt != src { return false }
          return true
        }(p.Success[i], p.Success[j]) {
          return thrift.PrependError("", fmt.Errorf("%T error writing set field: slice is not unique", p.Success))
        }
      }
    }
    for _, v := range p.Success {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteSetEnd(ctx); err != nil {
      return thrift.PrependError("error writing set end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSDataServiceGetChildNodePathInNextLevelResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceGetChildNodePathInNextLevelResult(%+v)", *p)
}

// Attributes:
//  - Request
type TSDataServiceGetAllMeasurementSchemaArgs struct {
  Request *MeasurementSchemaRequest `thrift:"request,1" db:"request" json:"request"`
}

func NewTSDataServiceGetAllMeasurementSchemaArgs() *TSDataServiceGetAllMeasurementSchemaArgs {
  return &TSDataServiceGetAllMeasurementSchemaArgs{}
}

var TSDataServiceGetAllMeasurementSchemaArgs_Request_DEFAULT *MeasurementSchemaRequest
func (p *TSDataServiceGetAllMeasurementSchemaArgs) GetRequest() *MeasurementSchemaRequest {
  if !p.IsSetRequest() {
    return TSDataServiceGetAllMeasurementSchemaArgs_Request_DEFAULT
  }
return p.Request
}
func (p *TSDataServiceGetAllMeasurementSchemaArgs) IsSetRequest() bool {
  return p.Request != nil
}

func (p *TSDataServiceGetAllMeasurementSchemaArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceGetAllMeasurementSchemaArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Request = &MeasurementSchemaRequest{}
  if err := p.Request.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Request), err)
  }
  return nil
}

func (p *TSDataServiceGetAllMeasurementSchemaArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getAllMeasurementSchema_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceGetAllMeasurementSchemaArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "request", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:request: ", p), err) }
  if err := p.Request.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Request), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:request: ", p), err) }
  return err
}

func (p *TSDataServiceGetAllMeasurementSchemaArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceGetAllMeasurementSchemaArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSDataServiceGetAllMeasurementSchemaResult struct {
  Success []byte `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSDataServiceGetAllMeasurementSchemaResult() *TSDataServiceGetAllMeasurementSchemaResult {
  return &TSDataServiceGetAllMeasurementSchemaResult{}
}

var TSDataServiceGetAllMeasurementSchemaResult_Success_DEFAULT []byte

func (p *TSDataServiceGetAllMeasurementSchemaResult) GetSuccess() []byte {
  return p.Success
}
func (p *TSDataServiceGetAllMeasurementSchemaResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSDataServiceGetAllMeasurementSchemaResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceGetAllMeasurementSchemaResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 0: ", err)
} else {
  p.Success = v
}
  return nil
}

func (p *TSDataServiceGetAllMeasurementSchemaResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getAllMeasurementSchema_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceGetAllMeasurementSchemaResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRING, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteBinary(ctx, p.Success); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.success (0) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSDataServiceGetAllMeasurementSchemaResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceGetAllMeasurementSchemaResult(%+v)", *p)
}

// Attributes:
//  - Request
type TSDataServiceGetAggrResultArgs struct {
  Request *GetAggrResultRequest `thrift:"request,1" db:"request" json:"request"`
}

func NewTSDataServiceGetAggrResultArgs() *TSDataServiceGetAggrResultArgs {
  return &TSDataServiceGetAggrResultArgs{}
}

var TSDataServiceGetAggrResultArgs_Request_DEFAULT *GetAggrResultRequest
func (p *TSDataServiceGetAggrResultArgs) GetRequest() *GetAggrResultRequest {
  if !p.IsSetRequest() {
    return TSDataServiceGetAggrResultArgs_Request_DEFAULT
  }
return p.Request
}
func (p *TSDataServiceGetAggrResultArgs) IsSetRequest() bool {
  return p.Request != nil
}

func (p *TSDataServiceGetAggrResultArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceGetAggrResultArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Request = &GetAggrResultRequest{}
  if err := p.Request.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Request), err)
  }
  return nil
}

func (p *TSDataServiceGetAggrResultArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getAggrResult_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceGetAggrResultArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "request", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:request: ", p), err) }
  if err := p.Request.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Request), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:request: ", p), err) }
  return err
}

func (p *TSDataServiceGetAggrResultArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceGetAggrResultArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSDataServiceGetAggrResultResult struct {
  Success [][]byte `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSDataServiceGetAggrResultResult() *TSDataServiceGetAggrResultResult {
  return &TSDataServiceGetAggrResultResult{}
}

var TSDataServiceGetAggrResultResult_Success_DEFAULT [][]byte

func (p *TSDataServiceGetAggrResultResult) GetSuccess() [][]byte {
  return p.Success
}
func (p *TSDataServiceGetAggrResultResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSDataServiceGetAggrResultResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceGetAggrResultResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]byte, 0, size)
  p.Success =  tSlice
  for i := 0; i < size; i ++ {
var _elem231 []byte
    if v, err := iprot.ReadBinary(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem231 = v
}
    p.Success = append(p.Success, _elem231)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSDataServiceGetAggrResultResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getAggrResult_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceGetAggrResultResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.LIST, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Success)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.Success {
      if err := oprot.WriteBinary(ctx, v); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSDataServiceGetAggrResultResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceGetAggrResultResult(%+v)", *p)
}

// Attributes:
//  - Header
//  - TimeseriesList
type TSDataServiceGetUnregisteredTimeseriesArgs struct {
  Header *RaftNode `thrift:"header,1" db:"header" json:"header"`
  TimeseriesList []string `thrift:"timeseriesList,2" db:"timeseriesList" json:"timeseriesList"`
}

func NewTSDataServiceGetUnregisteredTimeseriesArgs() *TSDataServiceGetUnregisteredTimeseriesArgs {
  return &TSDataServiceGetUnregisteredTimeseriesArgs{}
}

var TSDataServiceGetUnregisteredTimeseriesArgs_Header_DEFAULT *RaftNode
func (p *TSDataServiceGetUnregisteredTimeseriesArgs) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return TSDataServiceGetUnregisteredTimeseriesArgs_Header_DEFAULT
  }
return p.Header
}

func (p *TSDataServiceGetUnregisteredTimeseriesArgs) GetTimeseriesList() []string {
  return p.TimeseriesList
}
func (p *TSDataServiceGetUnregisteredTimeseriesArgs) IsSetHeader() bool {
  return p.Header != nil
}

func (p *TSDataServiceGetUnregisteredTimeseriesArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceGetUnregisteredTimeseriesArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *TSDataServiceGetUnregisteredTimeseriesArgs)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.TimeseriesList =  tSlice
  for i := 0; i < size; i ++ {
var _elem232 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem232 = v
}
    p.TimeseriesList = append(p.TimeseriesList, _elem232)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSDataServiceGetUnregisteredTimeseriesArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getUnregisteredTimeseries_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceGetUnregisteredTimeseriesArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:header: ", p), err) }
  if err := p.Header.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:header: ", p), err) }
  return err
}

func (p *TSDataServiceGetUnregisteredTimeseriesArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "timeseriesList", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:timeseriesList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.TimeseriesList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.TimeseriesList {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:timeseriesList: ", p), err) }
  return err
}

func (p *TSDataServiceGetUnregisteredTimeseriesArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceGetUnregisteredTimeseriesArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSDataServiceGetUnregisteredTimeseriesResult struct {
  Success []string `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSDataServiceGetUnregisteredTimeseriesResult() *TSDataServiceGetUnregisteredTimeseriesResult {
  return &TSDataServiceGetUnregisteredTimeseriesResult{}
}

var TSDataServiceGetUnregisteredTimeseriesResult_Success_DEFAULT []string

func (p *TSDataServiceGetUnregisteredTimeseriesResult) GetSuccess() []string {
  return p.Success
}
func (p *TSDataServiceGetUnregisteredTimeseriesResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSDataServiceGetUnregisteredTimeseriesResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceGetUnregisteredTimeseriesResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Success =  tSlice
  for i := 0; i < size; i ++ {
var _elem233 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem233 = v
}
    p.Success = append(p.Success, _elem233)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSDataServiceGetUnregisteredTimeseriesResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getUnregisteredTimeseries_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceGetUnregisteredTimeseriesResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.LIST, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Success)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.Success {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSDataServiceGetUnregisteredTimeseriesResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceGetUnregisteredTimeseriesResult(%+v)", *p)
}

// Attributes:
//  - Request
type TSDataServicePullSnapshotArgs struct {
  Request *PullSnapshotRequest `thrift:"request,1" db:"request" json:"request"`
}

func NewTSDataServicePullSnapshotArgs() *TSDataServicePullSnapshotArgs {
  return &TSDataServicePullSnapshotArgs{}
}

var TSDataServicePullSnapshotArgs_Request_DEFAULT *PullSnapshotRequest
func (p *TSDataServicePullSnapshotArgs) GetRequest() *PullSnapshotRequest {
  if !p.IsSetRequest() {
    return TSDataServicePullSnapshotArgs_Request_DEFAULT
  }
return p.Request
}
func (p *TSDataServicePullSnapshotArgs) IsSetRequest() bool {
  return p.Request != nil
}

func (p *TSDataServicePullSnapshotArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServicePullSnapshotArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Request = &PullSnapshotRequest{}
  if err := p.Request.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Request), err)
  }
  return nil
}

func (p *TSDataServicePullSnapshotArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "pullSnapshot_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServicePullSnapshotArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "request", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:request: ", p), err) }
  if err := p.Request.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Request), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:request: ", p), err) }
  return err
}

func (p *TSDataServicePullSnapshotArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServicePullSnapshotArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSDataServicePullSnapshotResult struct {
  Success *PullSnapshotResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSDataServicePullSnapshotResult() *TSDataServicePullSnapshotResult {
  return &TSDataServicePullSnapshotResult{}
}

var TSDataServicePullSnapshotResult_Success_DEFAULT *PullSnapshotResp
func (p *TSDataServicePullSnapshotResult) GetSuccess() *PullSnapshotResp {
  if !p.IsSetSuccess() {
    return TSDataServicePullSnapshotResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSDataServicePullSnapshotResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSDataServicePullSnapshotResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServicePullSnapshotResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &PullSnapshotResp{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSDataServicePullSnapshotResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "pullSnapshot_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServicePullSnapshotResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSDataServicePullSnapshotResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServicePullSnapshotResult(%+v)", *p)
}

// Attributes:
//  - Request
type TSDataServiceGetGroupByExecutorArgs struct {
  Request *GroupByRequest `thrift:"request,1" db:"request" json:"request"`
}

func NewTSDataServiceGetGroupByExecutorArgs() *TSDataServiceGetGroupByExecutorArgs {
  return &TSDataServiceGetGroupByExecutorArgs{}
}

var TSDataServiceGetGroupByExecutorArgs_Request_DEFAULT *GroupByRequest
func (p *TSDataServiceGetGroupByExecutorArgs) GetRequest() *GroupByRequest {
  if !p.IsSetRequest() {
    return TSDataServiceGetGroupByExecutorArgs_Request_DEFAULT
  }
return p.Request
}
func (p *TSDataServiceGetGroupByExecutorArgs) IsSetRequest() bool {
  return p.Request != nil
}

func (p *TSDataServiceGetGroupByExecutorArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceGetGroupByExecutorArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Request = &GroupByRequest{}
  if err := p.Request.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Request), err)
  }
  return nil
}

func (p *TSDataServiceGetGroupByExecutorArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getGroupByExecutor_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceGetGroupByExecutorArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "request", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:request: ", p), err) }
  if err := p.Request.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Request), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:request: ", p), err) }
  return err
}

func (p *TSDataServiceGetGroupByExecutorArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceGetGroupByExecutorArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSDataServiceGetGroupByExecutorResult struct {
  Success *Long `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSDataServiceGetGroupByExecutorResult() *TSDataServiceGetGroupByExecutorResult {
  return &TSDataServiceGetGroupByExecutorResult{}
}

var TSDataServiceGetGroupByExecutorResult_Success_DEFAULT Long
func (p *TSDataServiceGetGroupByExecutorResult) GetSuccess() Long {
  if !p.IsSetSuccess() {
    return TSDataServiceGetGroupByExecutorResult_Success_DEFAULT
  }
return *p.Success
}
func (p *TSDataServiceGetGroupByExecutorResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSDataServiceGetGroupByExecutorResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceGetGroupByExecutorResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 0: ", err)
} else {
  temp := Long(v)
  p.Success = &temp
}
  return nil
}

func (p *TSDataServiceGetGroupByExecutorResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getGroupByExecutor_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceGetGroupByExecutorResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.I64, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.Success)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.success (0) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSDataServiceGetGroupByExecutorResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceGetGroupByExecutorResult(%+v)", *p)
}

// Attributes:
//  - Header
//  - ExecutorId
//  - StartTime
//  - EndTime
type TSDataServiceGetGroupByResultArgs struct {
  Header *RaftNode `thrift:"header,1" db:"header" json:"header"`
  // unused field # 2
  ExecutorId Long `thrift:"executorId,3" db:"executorId" json:"executorId"`
  StartTime Long `thrift:"startTime,4" db:"startTime" json:"startTime"`
  EndTime Long `thrift:"endTime,5" db:"endTime" json:"endTime"`
}

func NewTSDataServiceGetGroupByResultArgs() *TSDataServiceGetGroupByResultArgs {
  return &TSDataServiceGetGroupByResultArgs{}
}

var TSDataServiceGetGroupByResultArgs_Header_DEFAULT *RaftNode
func (p *TSDataServiceGetGroupByResultArgs) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return TSDataServiceGetGroupByResultArgs_Header_DEFAULT
  }
return p.Header
}

func (p *TSDataServiceGetGroupByResultArgs) GetExecutorId() Long {
  return p.ExecutorId
}

func (p *TSDataServiceGetGroupByResultArgs) GetStartTime() Long {
  return p.StartTime
}

func (p *TSDataServiceGetGroupByResultArgs) GetEndTime() Long {
  return p.EndTime
}
func (p *TSDataServiceGetGroupByResultArgs) IsSetHeader() bool {
  return p.Header != nil
}

func (p *TSDataServiceGetGroupByResultArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceGetGroupByResultArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *TSDataServiceGetGroupByResultArgs)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  temp := Long(v)
  p.ExecutorId = temp
}
  return nil
}

func (p *TSDataServiceGetGroupByResultArgs)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  temp := Long(v)
  p.StartTime = temp
}
  return nil
}

func (p *TSDataServiceGetGroupByResultArgs)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  temp := Long(v)
  p.EndTime = temp
}
  return nil
}

func (p *TSDataServiceGetGroupByResultArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getGroupByResult_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceGetGroupByResultArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:header: ", p), err) }
  if err := p.Header.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:header: ", p), err) }
  return err
}

func (p *TSDataServiceGetGroupByResultArgs) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "executorId", thrift.I64, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:executorId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.ExecutorId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.executorId (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:executorId: ", p), err) }
  return err
}

func (p *TSDataServiceGetGroupByResultArgs) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "startTime", thrift.I64, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:startTime: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.StartTime)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.startTime (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:startTime: ", p), err) }
  return err
}

func (p *TSDataServiceGetGroupByResultArgs) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "endTime", thrift.I64, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:endTime: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.EndTime)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.endTime (5) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:endTime: ", p), err) }
  return err
}

func (p *TSDataServiceGetGroupByResultArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceGetGroupByResultArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSDataServiceGetGroupByResultResult struct {
  Success [][]byte `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSDataServiceGetGroupByResultResult() *TSDataServiceGetGroupByResultResult {
  return &TSDataServiceGetGroupByResultResult{}
}

var TSDataServiceGetGroupByResultResult_Success_DEFAULT [][]byte

func (p *TSDataServiceGetGroupByResultResult) GetSuccess() [][]byte {
  return p.Success
}
func (p *TSDataServiceGetGroupByResultResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSDataServiceGetGroupByResultResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceGetGroupByResultResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]byte, 0, size)
  p.Success =  tSlice
  for i := 0; i < size; i ++ {
var _elem234 []byte
    if v, err := iprot.ReadBinary(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem234 = v
}
    p.Success = append(p.Success, _elem234)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSDataServiceGetGroupByResultResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getGroupByResult_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceGetGroupByResultResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.LIST, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Success)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.Success {
      if err := oprot.WriteBinary(ctx, v); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSDataServiceGetGroupByResultResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceGetGroupByResultResult(%+v)", *p)
}

// Attributes:
//  - Request
type TSDataServicePullTimeSeriesSchemaArgs struct {
  Request *PullSchemaRequest `thrift:"request,1" db:"request" json:"request"`
}

func NewTSDataServicePullTimeSeriesSchemaArgs() *TSDataServicePullTimeSeriesSchemaArgs {
  return &TSDataServicePullTimeSeriesSchemaArgs{}
}

var TSDataServicePullTimeSeriesSchemaArgs_Request_DEFAULT *PullSchemaRequest
func (p *TSDataServicePullTimeSeriesSchemaArgs) GetRequest() *PullSchemaRequest {
  if !p.IsSetRequest() {
    return TSDataServicePullTimeSeriesSchemaArgs_Request_DEFAULT
  }
return p.Request
}
func (p *TSDataServicePullTimeSeriesSchemaArgs) IsSetRequest() bool {
  return p.Request != nil
}

func (p *TSDataServicePullTimeSeriesSchemaArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServicePullTimeSeriesSchemaArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Request = &PullSchemaRequest{}
  if err := p.Request.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Request), err)
  }
  return nil
}

func (p *TSDataServicePullTimeSeriesSchemaArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "pullTimeSeriesSchema_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServicePullTimeSeriesSchemaArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "request", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:request: ", p), err) }
  if err := p.Request.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Request), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:request: ", p), err) }
  return err
}

func (p *TSDataServicePullTimeSeriesSchemaArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServicePullTimeSeriesSchemaArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSDataServicePullTimeSeriesSchemaResult struct {
  Success *PullSchemaResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSDataServicePullTimeSeriesSchemaResult() *TSDataServicePullTimeSeriesSchemaResult {
  return &TSDataServicePullTimeSeriesSchemaResult{}
}

var TSDataServicePullTimeSeriesSchemaResult_Success_DEFAULT *PullSchemaResp
func (p *TSDataServicePullTimeSeriesSchemaResult) GetSuccess() *PullSchemaResp {
  if !p.IsSetSuccess() {
    return TSDataServicePullTimeSeriesSchemaResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSDataServicePullTimeSeriesSchemaResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSDataServicePullTimeSeriesSchemaResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServicePullTimeSeriesSchemaResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &PullSchemaResp{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSDataServicePullTimeSeriesSchemaResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "pullTimeSeriesSchema_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServicePullTimeSeriesSchemaResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSDataServicePullTimeSeriesSchemaResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServicePullTimeSeriesSchemaResult(%+v)", *p)
}

// Attributes:
//  - Request
type TSDataServicePullMeasurementSchemaArgs struct {
  Request *PullSchemaRequest `thrift:"request,1" db:"request" json:"request"`
}

func NewTSDataServicePullMeasurementSchemaArgs() *TSDataServicePullMeasurementSchemaArgs {
  return &TSDataServicePullMeasurementSchemaArgs{}
}

var TSDataServicePullMeasurementSchemaArgs_Request_DEFAULT *PullSchemaRequest
func (p *TSDataServicePullMeasurementSchemaArgs) GetRequest() *PullSchemaRequest {
  if !p.IsSetRequest() {
    return TSDataServicePullMeasurementSchemaArgs_Request_DEFAULT
  }
return p.Request
}
func (p *TSDataServicePullMeasurementSchemaArgs) IsSetRequest() bool {
  return p.Request != nil
}

func (p *TSDataServicePullMeasurementSchemaArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServicePullMeasurementSchemaArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Request = &PullSchemaRequest{}
  if err := p.Request.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Request), err)
  }
  return nil
}

func (p *TSDataServicePullMeasurementSchemaArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "pullMeasurementSchema_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServicePullMeasurementSchemaArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "request", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:request: ", p), err) }
  if err := p.Request.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Request), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:request: ", p), err) }
  return err
}

func (p *TSDataServicePullMeasurementSchemaArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServicePullMeasurementSchemaArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSDataServicePullMeasurementSchemaResult struct {
  Success *PullSchemaResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSDataServicePullMeasurementSchemaResult() *TSDataServicePullMeasurementSchemaResult {
  return &TSDataServicePullMeasurementSchemaResult{}
}

var TSDataServicePullMeasurementSchemaResult_Success_DEFAULT *PullSchemaResp
func (p *TSDataServicePullMeasurementSchemaResult) GetSuccess() *PullSchemaResp {
  if !p.IsSetSuccess() {
    return TSDataServicePullMeasurementSchemaResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSDataServicePullMeasurementSchemaResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSDataServicePullMeasurementSchemaResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServicePullMeasurementSchemaResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &PullSchemaResp{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSDataServicePullMeasurementSchemaResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "pullMeasurementSchema_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServicePullMeasurementSchemaResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSDataServicePullMeasurementSchemaResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServicePullMeasurementSchemaResult(%+v)", *p)
}

// Attributes:
//  - Request
type TSDataServicePreviousFillArgs struct {
  Request *PreviousFillRequest `thrift:"request,1" db:"request" json:"request"`
}

func NewTSDataServicePreviousFillArgs() *TSDataServicePreviousFillArgs {
  return &TSDataServicePreviousFillArgs{}
}

var TSDataServicePreviousFillArgs_Request_DEFAULT *PreviousFillRequest
func (p *TSDataServicePreviousFillArgs) GetRequest() *PreviousFillRequest {
  if !p.IsSetRequest() {
    return TSDataServicePreviousFillArgs_Request_DEFAULT
  }
return p.Request
}
func (p *TSDataServicePreviousFillArgs) IsSetRequest() bool {
  return p.Request != nil
}

func (p *TSDataServicePreviousFillArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServicePreviousFillArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Request = &PreviousFillRequest{}
  if err := p.Request.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Request), err)
  }
  return nil
}

func (p *TSDataServicePreviousFillArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "previousFill_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServicePreviousFillArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "request", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:request: ", p), err) }
  if err := p.Request.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Request), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:request: ", p), err) }
  return err
}

func (p *TSDataServicePreviousFillArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServicePreviousFillArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSDataServicePreviousFillResult struct {
  Success []byte `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSDataServicePreviousFillResult() *TSDataServicePreviousFillResult {
  return &TSDataServicePreviousFillResult{}
}

var TSDataServicePreviousFillResult_Success_DEFAULT []byte

func (p *TSDataServicePreviousFillResult) GetSuccess() []byte {
  return p.Success
}
func (p *TSDataServicePreviousFillResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSDataServicePreviousFillResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServicePreviousFillResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 0: ", err)
} else {
  p.Success = v
}
  return nil
}

func (p *TSDataServicePreviousFillResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "previousFill_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServicePreviousFillResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRING, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteBinary(ctx, p.Success); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.success (0) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSDataServicePreviousFillResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServicePreviousFillResult(%+v)", *p)
}

// Attributes:
//  - Request
type TSDataServiceLastArgs struct {
  Request *LastQueryRequest `thrift:"request,1" db:"request" json:"request"`
}

func NewTSDataServiceLastArgs() *TSDataServiceLastArgs {
  return &TSDataServiceLastArgs{}
}

var TSDataServiceLastArgs_Request_DEFAULT *LastQueryRequest
func (p *TSDataServiceLastArgs) GetRequest() *LastQueryRequest {
  if !p.IsSetRequest() {
    return TSDataServiceLastArgs_Request_DEFAULT
  }
return p.Request
}
func (p *TSDataServiceLastArgs) IsSetRequest() bool {
  return p.Request != nil
}

func (p *TSDataServiceLastArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceLastArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Request = &LastQueryRequest{}
  if err := p.Request.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Request), err)
  }
  return nil
}

func (p *TSDataServiceLastArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "last_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceLastArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "request", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:request: ", p), err) }
  if err := p.Request.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Request), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:request: ", p), err) }
  return err
}

func (p *TSDataServiceLastArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceLastArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSDataServiceLastResult struct {
  Success []byte `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSDataServiceLastResult() *TSDataServiceLastResult {
  return &TSDataServiceLastResult{}
}

var TSDataServiceLastResult_Success_DEFAULT []byte

func (p *TSDataServiceLastResult) GetSuccess() []byte {
  return p.Success
}
func (p *TSDataServiceLastResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSDataServiceLastResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceLastResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 0: ", err)
} else {
  p.Success = v
}
  return nil
}

func (p *TSDataServiceLastResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "last_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceLastResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRING, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteBinary(ctx, p.Success); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.success (0) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSDataServiceLastResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceLastResult(%+v)", *p)
}

// Attributes:
//  - Header
//  - PathsToQuery
//  - Level
type TSDataServiceGetPathCountArgs struct {
  Header *RaftNode `thrift:"header,1" db:"header" json:"header"`
  PathsToQuery []string `thrift:"pathsToQuery,2" db:"pathsToQuery" json:"pathsToQuery"`
  Level Int `thrift:"level,3" db:"level" json:"level"`
}

func NewTSDataServiceGetPathCountArgs() *TSDataServiceGetPathCountArgs {
  return &TSDataServiceGetPathCountArgs{}
}

var TSDataServiceGetPathCountArgs_Header_DEFAULT *RaftNode
func (p *TSDataServiceGetPathCountArgs) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return TSDataServiceGetPathCountArgs_Header_DEFAULT
  }
return p.Header
}

func (p *TSDataServiceGetPathCountArgs) GetPathsToQuery() []string {
  return p.PathsToQuery
}

func (p *TSDataServiceGetPathCountArgs) GetLevel() Int {
  return p.Level
}
func (p *TSDataServiceGetPathCountArgs) IsSetHeader() bool {
  return p.Header != nil
}

func (p *TSDataServiceGetPathCountArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceGetPathCountArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *TSDataServiceGetPathCountArgs)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.PathsToQuery =  tSlice
  for i := 0; i < size; i ++ {
var _elem235 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem235 = v
}
    p.PathsToQuery = append(p.PathsToQuery, _elem235)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSDataServiceGetPathCountArgs)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  temp := Int(v)
  p.Level = temp
}
  return nil
}

func (p *TSDataServiceGetPathCountArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getPathCount_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceGetPathCountArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:header: ", p), err) }
  if err := p.Header.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:header: ", p), err) }
  return err
}

func (p *TSDataServiceGetPathCountArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "pathsToQuery", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:pathsToQuery: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.PathsToQuery)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.PathsToQuery {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:pathsToQuery: ", p), err) }
  return err
}

func (p *TSDataServiceGetPathCountArgs) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "level", thrift.I32, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:level: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.Level)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.level (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:level: ", p), err) }
  return err
}

func (p *TSDataServiceGetPathCountArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceGetPathCountArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSDataServiceGetPathCountResult struct {
  Success *Int `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSDataServiceGetPathCountResult() *TSDataServiceGetPathCountResult {
  return &TSDataServiceGetPathCountResult{}
}

var TSDataServiceGetPathCountResult_Success_DEFAULT Int
func (p *TSDataServiceGetPathCountResult) GetSuccess() Int {
  if !p.IsSetSuccess() {
    return TSDataServiceGetPathCountResult_Success_DEFAULT
  }
return *p.Success
}
func (p *TSDataServiceGetPathCountResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSDataServiceGetPathCountResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceGetPathCountResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 0: ", err)
} else {
  temp := Int(v)
  p.Success = &temp
}
  return nil
}

func (p *TSDataServiceGetPathCountResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getPathCount_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceGetPathCountResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.I32, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.Success)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.success (0) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSDataServiceGetPathCountResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceGetPathCountResult(%+v)", *p)
}

// Attributes:
//  - Header
//  - PathsToQuery
type TSDataServiceGetDeviceCountArgs struct {
  Header *RaftNode `thrift:"header,1" db:"header" json:"header"`
  PathsToQuery []string `thrift:"pathsToQuery,2" db:"pathsToQuery" json:"pathsToQuery"`
}

func NewTSDataServiceGetDeviceCountArgs() *TSDataServiceGetDeviceCountArgs {
  return &TSDataServiceGetDeviceCountArgs{}
}

var TSDataServiceGetDeviceCountArgs_Header_DEFAULT *RaftNode
func (p *TSDataServiceGetDeviceCountArgs) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return TSDataServiceGetDeviceCountArgs_Header_DEFAULT
  }
return p.Header
}

func (p *TSDataServiceGetDeviceCountArgs) GetPathsToQuery() []string {
  return p.PathsToQuery
}
func (p *TSDataServiceGetDeviceCountArgs) IsSetHeader() bool {
  return p.Header != nil
}

func (p *TSDataServiceGetDeviceCountArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceGetDeviceCountArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *TSDataServiceGetDeviceCountArgs)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.PathsToQuery =  tSlice
  for i := 0; i < size; i ++ {
var _elem236 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem236 = v
}
    p.PathsToQuery = append(p.PathsToQuery, _elem236)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSDataServiceGetDeviceCountArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getDeviceCount_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceGetDeviceCountArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:header: ", p), err) }
  if err := p.Header.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:header: ", p), err) }
  return err
}

func (p *TSDataServiceGetDeviceCountArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "pathsToQuery", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:pathsToQuery: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.PathsToQuery)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.PathsToQuery {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:pathsToQuery: ", p), err) }
  return err
}

func (p *TSDataServiceGetDeviceCountArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceGetDeviceCountArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSDataServiceGetDeviceCountResult struct {
  Success *Int `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSDataServiceGetDeviceCountResult() *TSDataServiceGetDeviceCountResult {
  return &TSDataServiceGetDeviceCountResult{}
}

var TSDataServiceGetDeviceCountResult_Success_DEFAULT Int
func (p *TSDataServiceGetDeviceCountResult) GetSuccess() Int {
  if !p.IsSetSuccess() {
    return TSDataServiceGetDeviceCountResult_Success_DEFAULT
  }
return *p.Success
}
func (p *TSDataServiceGetDeviceCountResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSDataServiceGetDeviceCountResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceGetDeviceCountResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 0: ", err)
} else {
  temp := Int(v)
  p.Success = &temp
}
  return nil
}

func (p *TSDataServiceGetDeviceCountResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getDeviceCount_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceGetDeviceCountResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.I32, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.Success)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.success (0) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSDataServiceGetDeviceCountResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceGetDeviceCountResult(%+v)", *p)
}

// Attributes:
//  - Header
//  - Slots
type TSDataServiceOnSnapshotAppliedArgs struct {
  Header *RaftNode `thrift:"header,1" db:"header" json:"header"`
  Slots []Int `thrift:"slots,2" db:"slots" json:"slots"`
}

func NewTSDataServiceOnSnapshotAppliedArgs() *TSDataServiceOnSnapshotAppliedArgs {
  return &TSDataServiceOnSnapshotAppliedArgs{}
}

var TSDataServiceOnSnapshotAppliedArgs_Header_DEFAULT *RaftNode
func (p *TSDataServiceOnSnapshotAppliedArgs) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return TSDataServiceOnSnapshotAppliedArgs_Header_DEFAULT
  }
return p.Header
}

func (p *TSDataServiceOnSnapshotAppliedArgs) GetSlots() []Int {
  return p.Slots
}
func (p *TSDataServiceOnSnapshotAppliedArgs) IsSetHeader() bool {
  return p.Header != nil
}

func (p *TSDataServiceOnSnapshotAppliedArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceOnSnapshotAppliedArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *TSDataServiceOnSnapshotAppliedArgs)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]Int, 0, size)
  p.Slots =  tSlice
  for i := 0; i < size; i ++ {
var _elem237 Int
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    temp := Int(v)
    _elem237 = temp
}
    p.Slots = append(p.Slots, _elem237)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSDataServiceOnSnapshotAppliedArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "onSnapshotApplied_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceOnSnapshotAppliedArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:header: ", p), err) }
  if err := p.Header.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:header: ", p), err) }
  return err
}

func (p *TSDataServiceOnSnapshotAppliedArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "slots", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:slots: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.Slots)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Slots {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:slots: ", p), err) }
  return err
}

func (p *TSDataServiceOnSnapshotAppliedArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceOnSnapshotAppliedArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSDataServiceOnSnapshotAppliedResult struct {
  Success *bool `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSDataServiceOnSnapshotAppliedResult() *TSDataServiceOnSnapshotAppliedResult {
  return &TSDataServiceOnSnapshotAppliedResult{}
}

var TSDataServiceOnSnapshotAppliedResult_Success_DEFAULT bool
func (p *TSDataServiceOnSnapshotAppliedResult) GetSuccess() bool {
  if !p.IsSetSuccess() {
    return TSDataServiceOnSnapshotAppliedResult_Success_DEFAULT
  }
return *p.Success
}
func (p *TSDataServiceOnSnapshotAppliedResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSDataServiceOnSnapshotAppliedResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServiceOnSnapshotAppliedResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 0: ", err)
} else {
  p.Success = &v
}
  return nil
}

func (p *TSDataServiceOnSnapshotAppliedResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "onSnapshotApplied_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServiceOnSnapshotAppliedResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.BOOL, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.Success)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.success (0) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSDataServiceOnSnapshotAppliedResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServiceOnSnapshotAppliedResult(%+v)", *p)
}

// Attributes:
//  - Header
//  - ExecutorId
//  - StartTime
//  - EndTime
type TSDataServicePeekNextNotNullValueArgs struct {
  Header *RaftNode `thrift:"header,1" db:"header" json:"header"`
  ExecutorId Long `thrift:"executorId,2" db:"executorId" json:"executorId"`
  StartTime Long `thrift:"startTime,3" db:"startTime" json:"startTime"`
  EndTime Long `thrift:"endTime,4" db:"endTime" json:"endTime"`
}

func NewTSDataServicePeekNextNotNullValueArgs() *TSDataServicePeekNextNotNullValueArgs {
  return &TSDataServicePeekNextNotNullValueArgs{}
}

var TSDataServicePeekNextNotNullValueArgs_Header_DEFAULT *RaftNode
func (p *TSDataServicePeekNextNotNullValueArgs) GetHeader() *RaftNode {
  if !p.IsSetHeader() {
    return TSDataServicePeekNextNotNullValueArgs_Header_DEFAULT
  }
return p.Header
}

func (p *TSDataServicePeekNextNotNullValueArgs) GetExecutorId() Long {
  return p.ExecutorId
}

func (p *TSDataServicePeekNextNotNullValueArgs) GetStartTime() Long {
  return p.StartTime
}

func (p *TSDataServicePeekNextNotNullValueArgs) GetEndTime() Long {
  return p.EndTime
}
func (p *TSDataServicePeekNextNotNullValueArgs) IsSetHeader() bool {
  return p.Header != nil
}

func (p *TSDataServicePeekNextNotNullValueArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServicePeekNextNotNullValueArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Header = &RaftNode{}
  if err := p.Header.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Header), err)
  }
  return nil
}

func (p *TSDataServicePeekNextNotNullValueArgs)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  temp := Long(v)
  p.ExecutorId = temp
}
  return nil
}

func (p *TSDataServicePeekNextNotNullValueArgs)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  temp := Long(v)
  p.StartTime = temp
}
  return nil
}

func (p *TSDataServicePeekNextNotNullValueArgs)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  temp := Long(v)
  p.EndTime = temp
}
  return nil
}

func (p *TSDataServicePeekNextNotNullValueArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "peekNextNotNullValue_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServicePeekNextNotNullValueArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "header", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:header: ", p), err) }
  if err := p.Header.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Header), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:header: ", p), err) }
  return err
}

func (p *TSDataServicePeekNextNotNullValueArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "executorId", thrift.I64, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:executorId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.ExecutorId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.executorId (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:executorId: ", p), err) }
  return err
}

func (p *TSDataServicePeekNextNotNullValueArgs) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "startTime", thrift.I64, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:startTime: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.StartTime)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.startTime (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:startTime: ", p), err) }
  return err
}

func (p *TSDataServicePeekNextNotNullValueArgs) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "endTime", thrift.I64, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:endTime: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.EndTime)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.endTime (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:endTime: ", p), err) }
  return err
}

func (p *TSDataServicePeekNextNotNullValueArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServicePeekNextNotNullValueArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSDataServicePeekNextNotNullValueResult struct {
  Success []byte `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSDataServicePeekNextNotNullValueResult() *TSDataServicePeekNextNotNullValueResult {
  return &TSDataServicePeekNextNotNullValueResult{}
}

var TSDataServicePeekNextNotNullValueResult_Success_DEFAULT []byte

func (p *TSDataServicePeekNextNotNullValueResult) GetSuccess() []byte {
  return p.Success
}
func (p *TSDataServicePeekNextNotNullValueResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSDataServicePeekNextNotNullValueResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSDataServicePeekNextNotNullValueResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 0: ", err)
} else {
  p.Success = v
}
  return nil
}

func (p *TSDataServicePeekNextNotNullValueResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "peekNextNotNullValue_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDataServicePeekNextNotNullValueResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRING, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteBinary(ctx, p.Success); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.success (0) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSDataServicePeekNextNotNullValueResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDataServicePeekNextNotNullValueResult(%+v)", *p)
}


type TSMetaService interface {
RaftService

  // Node which is not leader will call this method to try to add itself into the cluster as a new node.
  // <br>For the receiver,
  // If the local node is leader, it'll check whether the cluster can add this new node;
  // otherwise, the local node will transfer the request to the leader.
  // 
  // @param node a new node that needs to be added
  // 
  // 
  // Parameters:
  //  - Node
  //  - StartUpStatus
  AddNode(ctx context.Context, node *Node, startUpStatus *StartUpStatus) (_r *AddNodeResponse, _err error)
  // Parameters:
  //  - StartUpStatus
  CheckStatus(ctx context.Context, startUpStatus *StartUpStatus) (_r *CheckStatusResponse, _err error)
  // Remove a node from the cluster. If the node is not in the cluster or the cluster size will
  // less than replication number, the request will be rejected.
  // return -1(RESPONSE_AGREE) or -3(RESPONSE_REJECT) or -9(RESPONSE_CLUSTER_TOO_SMALL)
  // 
  // 
  // Parameters:
  //  - Node
  RemoveNode(ctx context.Context, node *Node) (_r Long, _err error)
  // When a node is removed from the cluster, if it is not the meta leader, it cannot receive
  // the commit command by heartbeat since it has been removed, so the leader should tell it
  // directly that it is no longer in the cluster.
  // 
  // 
  // Parameters:
  //  - RemoveNodeLog
  Exile(ctx context.Context, removeNodeLog []byte) (_err error)
  QueryNodeStatus(ctx context.Context) (_r *TNodeStatus, _err error)
  // Check whether this node is alive.
  // 
  CheckAlive(ctx context.Context) (_r *Node, _err error)
  // Collect the info of data migration, which will decide that if users can change membership.
  // 
  CollectMigrationStatus(ctx context.Context) (_r []byte, _err error)
  // When a node starts, it send handshakes to all other nodes so they know the node is alive
  // again. Notice that heartbeats exists only between leaders and followers, so coordinators
  // cannot know when another node resumes, and handshakes are mainly used to update node status
  // on coordinator side.
  // 
  // 
  // Parameters:
  //  - Sender
  Handshake(ctx context.Context, sender *Node) (_err error)
}

type TSMetaServiceClient struct {
  *RaftServiceClient
}

func NewTSMetaServiceClientFactory(t thrift.TTransport, f thrift.TProtocolFactory) *TSMetaServiceClient {
  return &TSMetaServiceClient{RaftServiceClient: NewRaftServiceClientFactory(t, f)}}

func NewTSMetaServiceClientProtocol(t thrift.TTransport, iprot thrift.TProtocol, oprot thrift.TProtocol) *TSMetaServiceClient {
  return &TSMetaServiceClient{RaftServiceClient: NewRaftServiceClientProtocol(t, iprot, oprot)}
}

func NewTSMetaServiceClient(c thrift.TClient) *TSMetaServiceClient {
  return &TSMetaServiceClient{
    RaftServiceClient: NewRaftServiceClient(c),
  }
}

// Node which is not leader will call this method to try to add itself into the cluster as a new node.
// <br>For the receiver,
// If the local node is leader, it'll check whether the cluster can add this new node;
// otherwise, the local node will transfer the request to the leader.
// 
// @param node a new node that needs to be added
// 
// 
// Parameters:
//  - Node
//  - StartUpStatus
func (p *TSMetaServiceClient) AddNode(ctx context.Context, node *Node, startUpStatus *StartUpStatus) (_r *AddNodeResponse, _err error) {
  var _args526 TSMetaServiceAddNodeArgs
  _args526.Node = node
  _args526.StartUpStatus = startUpStatus
  var _result528 TSMetaServiceAddNodeResult
  var _meta527 thrift.ResponseMeta
  _meta527, _err = p.Client_().Call(ctx, "addNode", &_args526, &_result528)
  p.SetLastResponseMeta_(_meta527)
  if _err != nil {
    return
  }
  return _result528.GetSuccess(), nil
}

// Parameters:
//  - StartUpStatus
func (p *TSMetaServiceClient) CheckStatus(ctx context.Context, startUpStatus *StartUpStatus) (_r *CheckStatusResponse, _err error) {
  var _args529 TSMetaServiceCheckStatusArgs
  _args529.StartUpStatus = startUpStatus
  var _result531 TSMetaServiceCheckStatusResult
  var _meta530 thrift.ResponseMeta
  _meta530, _err = p.Client_().Call(ctx, "checkStatus", &_args529, &_result531)
  p.SetLastResponseMeta_(_meta530)
  if _err != nil {
    return
  }
  return _result531.GetSuccess(), nil
}

// Remove a node from the cluster. If the node is not in the cluster or the cluster size will
// less than replication number, the request will be rejected.
// return -1(RESPONSE_AGREE) or -3(RESPONSE_REJECT) or -9(RESPONSE_CLUSTER_TOO_SMALL)
// 
// 
// Parameters:
//  - Node
func (p *TSMetaServiceClient) RemoveNode(ctx context.Context, node *Node) (_r Long, _err error) {
  var _args532 TSMetaServiceRemoveNodeArgs
  _args532.Node = node
  var _result534 TSMetaServiceRemoveNodeResult
  var _meta533 thrift.ResponseMeta
  _meta533, _err = p.Client_().Call(ctx, "removeNode", &_args532, &_result534)
  p.SetLastResponseMeta_(_meta533)
  if _err != nil {
    return
  }
  return _result534.GetSuccess(), nil
}

// When a node is removed from the cluster, if it is not the meta leader, it cannot receive
// the commit command by heartbeat since it has been removed, so the leader should tell it
// directly that it is no longer in the cluster.
// 
// 
// Parameters:
//  - RemoveNodeLog
func (p *TSMetaServiceClient) Exile(ctx context.Context, removeNodeLog []byte) (_err error) {
  var _args535 TSMetaServiceExileArgs
  _args535.RemoveNodeLog = removeNodeLog
  var _result537 TSMetaServiceExileResult
  var _meta536 thrift.ResponseMeta
  _meta536, _err = p.Client_().Call(ctx, "exile", &_args535, &_result537)
  p.SetLastResponseMeta_(_meta536)
  if _err != nil {
    return
  }
  return nil
}

func (p *TSMetaServiceClient) QueryNodeStatus(ctx context.Context) (_r *TNodeStatus, _err error) {
  var _args538 TSMetaServiceQueryNodeStatusArgs
  var _result540 TSMetaServiceQueryNodeStatusResult
  var _meta539 thrift.ResponseMeta
  _meta539, _err = p.Client_().Call(ctx, "queryNodeStatus", &_args538, &_result540)
  p.SetLastResponseMeta_(_meta539)
  if _err != nil {
    return
  }
  return _result540.GetSuccess(), nil
}

// Check whether this node is alive.
// 
func (p *TSMetaServiceClient) CheckAlive(ctx context.Context) (_r *Node, _err error) {
  var _args541 TSMetaServiceCheckAliveArgs
  var _result543 TSMetaServiceCheckAliveResult
  var _meta542 thrift.ResponseMeta
  _meta542, _err = p.Client_().Call(ctx, "checkAlive", &_args541, &_result543)
  p.SetLastResponseMeta_(_meta542)
  if _err != nil {
    return
  }
  return _result543.GetSuccess(), nil
}

// Collect the info of data migration, which will decide that if users can change membership.
// 
func (p *TSMetaServiceClient) CollectMigrationStatus(ctx context.Context) (_r []byte, _err error) {
  var _args544 TSMetaServiceCollectMigrationStatusArgs
  var _result546 TSMetaServiceCollectMigrationStatusResult
  var _meta545 thrift.ResponseMeta
  _meta545, _err = p.Client_().Call(ctx, "collectMigrationStatus", &_args544, &_result546)
  p.SetLastResponseMeta_(_meta545)
  if _err != nil {
    return
  }
  return _result546.GetSuccess(), nil
}

// When a node starts, it send handshakes to all other nodes so they know the node is alive
// again. Notice that heartbeats exists only between leaders and followers, so coordinators
// cannot know when another node resumes, and handshakes are mainly used to update node status
// on coordinator side.
// 
// 
// Parameters:
//  - Sender
func (p *TSMetaServiceClient) Handshake(ctx context.Context, sender *Node) (_err error) {
  var _args547 TSMetaServiceHandshakeArgs
  _args547.Sender = sender
  var _result549 TSMetaServiceHandshakeResult
  var _meta548 thrift.ResponseMeta
  _meta548, _err = p.Client_().Call(ctx, "handshake", &_args547, &_result549)
  p.SetLastResponseMeta_(_meta548)
  if _err != nil {
    return
  }
  return nil
}

type TSMetaServiceProcessor struct {
  *RaftServiceProcessor
}

func NewTSMetaServiceProcessor(handler TSMetaService) *TSMetaServiceProcessor {
  self550 := &TSMetaServiceProcessor{NewRaftServiceProcessor(handler)}
  self550.AddToProcessorMap("addNode", &tSMetaServiceProcessorAddNode{handler:handler})
  self550.AddToProcessorMap("checkStatus", &tSMetaServiceProcessorCheckStatus{handler:handler})
  self550.AddToProcessorMap("removeNode", &tSMetaServiceProcessorRemoveNode{handler:handler})
  self550.AddToProcessorMap("exile", &tSMetaServiceProcessorExile{handler:handler})
  self550.AddToProcessorMap("queryNodeStatus", &tSMetaServiceProcessorQueryNodeStatus{handler:handler})
  self550.AddToProcessorMap("checkAlive", &tSMetaServiceProcessorCheckAlive{handler:handler})
  self550.AddToProcessorMap("collectMigrationStatus", &tSMetaServiceProcessorCollectMigrationStatus{handler:handler})
  self550.AddToProcessorMap("handshake", &tSMetaServiceProcessorHandshake{handler:handler})
  return self550
}

type tSMetaServiceProcessorAddNode struct {
  handler TSMetaService
}

func (p *tSMetaServiceProcessorAddNode) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSMetaServiceAddNodeArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "addNode", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSMetaServiceAddNodeResult{}
  var retval *AddNodeResponse
  if retval, err2 = p.handler.AddNode(ctx, args.Node, args.StartUpStatus); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing addNode: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "addNode", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "addNode", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSMetaServiceProcessorCheckStatus struct {
  handler TSMetaService
}

func (p *tSMetaServiceProcessorCheckStatus) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSMetaServiceCheckStatusArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "checkStatus", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSMetaServiceCheckStatusResult{}
  var retval *CheckStatusResponse
  if retval, err2 = p.handler.CheckStatus(ctx, args.StartUpStatus); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing checkStatus: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "checkStatus", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "checkStatus", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSMetaServiceProcessorRemoveNode struct {
  handler TSMetaService
}

func (p *tSMetaServiceProcessorRemoveNode) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSMetaServiceRemoveNodeArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "removeNode", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSMetaServiceRemoveNodeResult{}
  var retval Long
  if retval, err2 = p.handler.RemoveNode(ctx, args.Node); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing removeNode: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "removeNode", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = &retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "removeNode", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSMetaServiceProcessorExile struct {
  handler TSMetaService
}

func (p *tSMetaServiceProcessorExile) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSMetaServiceExileArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "exile", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSMetaServiceExileResult{}
  if err2 = p.handler.Exile(ctx, args.RemoveNodeLog); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing exile: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "exile", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "exile", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSMetaServiceProcessorQueryNodeStatus struct {
  handler TSMetaService
}

func (p *tSMetaServiceProcessorQueryNodeStatus) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSMetaServiceQueryNodeStatusArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "queryNodeStatus", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSMetaServiceQueryNodeStatusResult{}
  var retval *TNodeStatus
  if retval, err2 = p.handler.QueryNodeStatus(ctx); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing queryNodeStatus: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "queryNodeStatus", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "queryNodeStatus", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSMetaServiceProcessorCheckAlive struct {
  handler TSMetaService
}

func (p *tSMetaServiceProcessorCheckAlive) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSMetaServiceCheckAliveArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "checkAlive", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSMetaServiceCheckAliveResult{}
  var retval *Node
  if retval, err2 = p.handler.CheckAlive(ctx); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing checkAlive: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "checkAlive", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "checkAlive", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSMetaServiceProcessorCollectMigrationStatus struct {
  handler TSMetaService
}

func (p *tSMetaServiceProcessorCollectMigrationStatus) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSMetaServiceCollectMigrationStatusArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "collectMigrationStatus", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSMetaServiceCollectMigrationStatusResult{}
  var retval []byte
  if retval, err2 = p.handler.CollectMigrationStatus(ctx); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing collectMigrationStatus: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "collectMigrationStatus", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "collectMigrationStatus", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSMetaServiceProcessorHandshake struct {
  handler TSMetaService
}

func (p *tSMetaServiceProcessorHandshake) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSMetaServiceHandshakeArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "handshake", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSMetaServiceHandshakeResult{}
  if err2 = p.handler.Handshake(ctx, args.Sender); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing handshake: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "handshake", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "handshake", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}


// HELPER FUNCTIONS AND STRUCTURES

// Attributes:
//  - Node
//  - StartUpStatus
type TSMetaServiceAddNodeArgs struct {
  Node *Node `thrift:"node,1" db:"node" json:"node"`
  StartUpStatus *StartUpStatus `thrift:"startUpStatus,2" db:"startUpStatus" json:"startUpStatus"`
}

func NewTSMetaServiceAddNodeArgs() *TSMetaServiceAddNodeArgs {
  return &TSMetaServiceAddNodeArgs{}
}

var TSMetaServiceAddNodeArgs_Node_DEFAULT *Node
func (p *TSMetaServiceAddNodeArgs) GetNode() *Node {
  if !p.IsSetNode() {
    return TSMetaServiceAddNodeArgs_Node_DEFAULT
  }
return p.Node
}
var TSMetaServiceAddNodeArgs_StartUpStatus_DEFAULT *StartUpStatus
func (p *TSMetaServiceAddNodeArgs) GetStartUpStatus() *StartUpStatus {
  if !p.IsSetStartUpStatus() {
    return TSMetaServiceAddNodeArgs_StartUpStatus_DEFAULT
  }
return p.StartUpStatus
}
func (p *TSMetaServiceAddNodeArgs) IsSetNode() bool {
  return p.Node != nil
}

func (p *TSMetaServiceAddNodeArgs) IsSetStartUpStatus() bool {
  return p.StartUpStatus != nil
}

func (p *TSMetaServiceAddNodeArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSMetaServiceAddNodeArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Node = &Node{}
  if err := p.Node.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Node), err)
  }
  return nil
}

func (p *TSMetaServiceAddNodeArgs)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  p.StartUpStatus = &StartUpStatus{}
  if err := p.StartUpStatus.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.StartUpStatus), err)
  }
  return nil
}

func (p *TSMetaServiceAddNodeArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "addNode_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSMetaServiceAddNodeArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "node", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:node: ", p), err) }
  if err := p.Node.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Node), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:node: ", p), err) }
  return err
}

func (p *TSMetaServiceAddNodeArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "startUpStatus", thrift.STRUCT, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:startUpStatus: ", p), err) }
  if err := p.StartUpStatus.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.StartUpStatus), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:startUpStatus: ", p), err) }
  return err
}

func (p *TSMetaServiceAddNodeArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSMetaServiceAddNodeArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSMetaServiceAddNodeResult struct {
  Success *AddNodeResponse `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSMetaServiceAddNodeResult() *TSMetaServiceAddNodeResult {
  return &TSMetaServiceAddNodeResult{}
}

var TSMetaServiceAddNodeResult_Success_DEFAULT *AddNodeResponse
func (p *TSMetaServiceAddNodeResult) GetSuccess() *AddNodeResponse {
  if !p.IsSetSuccess() {
    return TSMetaServiceAddNodeResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSMetaServiceAddNodeResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSMetaServiceAddNodeResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSMetaServiceAddNodeResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &AddNodeResponse{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSMetaServiceAddNodeResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "addNode_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSMetaServiceAddNodeResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSMetaServiceAddNodeResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSMetaServiceAddNodeResult(%+v)", *p)
}

// Attributes:
//  - StartUpStatus
type TSMetaServiceCheckStatusArgs struct {
  StartUpStatus *StartUpStatus `thrift:"startUpStatus,1" db:"startUpStatus" json:"startUpStatus"`
}

func NewTSMetaServiceCheckStatusArgs() *TSMetaServiceCheckStatusArgs {
  return &TSMetaServiceCheckStatusArgs{}
}

var TSMetaServiceCheckStatusArgs_StartUpStatus_DEFAULT *StartUpStatus
func (p *TSMetaServiceCheckStatusArgs) GetStartUpStatus() *StartUpStatus {
  if !p.IsSetStartUpStatus() {
    return TSMetaServiceCheckStatusArgs_StartUpStatus_DEFAULT
  }
return p.StartUpStatus
}
func (p *TSMetaServiceCheckStatusArgs) IsSetStartUpStatus() bool {
  return p.StartUpStatus != nil
}

func (p *TSMetaServiceCheckStatusArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSMetaServiceCheckStatusArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.StartUpStatus = &StartUpStatus{}
  if err := p.StartUpStatus.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.StartUpStatus), err)
  }
  return nil
}

func (p *TSMetaServiceCheckStatusArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "checkStatus_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSMetaServiceCheckStatusArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "startUpStatus", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:startUpStatus: ", p), err) }
  if err := p.StartUpStatus.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.StartUpStatus), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:startUpStatus: ", p), err) }
  return err
}

func (p *TSMetaServiceCheckStatusArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSMetaServiceCheckStatusArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSMetaServiceCheckStatusResult struct {
  Success *CheckStatusResponse `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSMetaServiceCheckStatusResult() *TSMetaServiceCheckStatusResult {
  return &TSMetaServiceCheckStatusResult{}
}

var TSMetaServiceCheckStatusResult_Success_DEFAULT *CheckStatusResponse
func (p *TSMetaServiceCheckStatusResult) GetSuccess() *CheckStatusResponse {
  if !p.IsSetSuccess() {
    return TSMetaServiceCheckStatusResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSMetaServiceCheckStatusResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSMetaServiceCheckStatusResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSMetaServiceCheckStatusResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &CheckStatusResponse{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSMetaServiceCheckStatusResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "checkStatus_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSMetaServiceCheckStatusResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSMetaServiceCheckStatusResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSMetaServiceCheckStatusResult(%+v)", *p)
}

// Attributes:
//  - Node
type TSMetaServiceRemoveNodeArgs struct {
  Node *Node `thrift:"node,1" db:"node" json:"node"`
}

func NewTSMetaServiceRemoveNodeArgs() *TSMetaServiceRemoveNodeArgs {
  return &TSMetaServiceRemoveNodeArgs{}
}

var TSMetaServiceRemoveNodeArgs_Node_DEFAULT *Node
func (p *TSMetaServiceRemoveNodeArgs) GetNode() *Node {
  if !p.IsSetNode() {
    return TSMetaServiceRemoveNodeArgs_Node_DEFAULT
  }
return p.Node
}
func (p *TSMetaServiceRemoveNodeArgs) IsSetNode() bool {
  return p.Node != nil
}

func (p *TSMetaServiceRemoveNodeArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSMetaServiceRemoveNodeArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Node = &Node{}
  if err := p.Node.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Node), err)
  }
  return nil
}

func (p *TSMetaServiceRemoveNodeArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "removeNode_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSMetaServiceRemoveNodeArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "node", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:node: ", p), err) }
  if err := p.Node.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Node), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:node: ", p), err) }
  return err
}

func (p *TSMetaServiceRemoveNodeArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSMetaServiceRemoveNodeArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSMetaServiceRemoveNodeResult struct {
  Success *Long `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSMetaServiceRemoveNodeResult() *TSMetaServiceRemoveNodeResult {
  return &TSMetaServiceRemoveNodeResult{}
}

var TSMetaServiceRemoveNodeResult_Success_DEFAULT Long
func (p *TSMetaServiceRemoveNodeResult) GetSuccess() Long {
  if !p.IsSetSuccess() {
    return TSMetaServiceRemoveNodeResult_Success_DEFAULT
  }
return *p.Success
}
func (p *TSMetaServiceRemoveNodeResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSMetaServiceRemoveNodeResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSMetaServiceRemoveNodeResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 0: ", err)
} else {
  temp := Long(v)
  p.Success = &temp
}
  return nil
}

func (p *TSMetaServiceRemoveNodeResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "removeNode_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSMetaServiceRemoveNodeResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.I64, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.Success)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.success (0) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSMetaServiceRemoveNodeResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSMetaServiceRemoveNodeResult(%+v)", *p)
}

// Attributes:
//  - RemoveNodeLog
type TSMetaServiceExileArgs struct {
  RemoveNodeLog []byte `thrift:"removeNodeLog,1" db:"removeNodeLog" json:"removeNodeLog"`
}

func NewTSMetaServiceExileArgs() *TSMetaServiceExileArgs {
  return &TSMetaServiceExileArgs{}
}


func (p *TSMetaServiceExileArgs) GetRemoveNodeLog() []byte {
  return p.RemoveNodeLog
}
func (p *TSMetaServiceExileArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSMetaServiceExileArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.RemoveNodeLog = v
}
  return nil
}

func (p *TSMetaServiceExileArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "exile_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSMetaServiceExileArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "removeNodeLog", thrift.STRING, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:removeNodeLog: ", p), err) }
  if err := oprot.WriteBinary(ctx, p.RemoveNodeLog); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.removeNodeLog (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:removeNodeLog: ", p), err) }
  return err
}

func (p *TSMetaServiceExileArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSMetaServiceExileArgs(%+v)", *p)
}

type TSMetaServiceExileResult struct {
}

func NewTSMetaServiceExileResult() *TSMetaServiceExileResult {
  return &TSMetaServiceExileResult{}
}

func (p *TSMetaServiceExileResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    if err := iprot.Skip(ctx, fieldTypeId); err != nil {
      return err
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSMetaServiceExileResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "exile_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSMetaServiceExileResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSMetaServiceExileResult(%+v)", *p)
}

type TSMetaServiceQueryNodeStatusArgs struct {
}

func NewTSMetaServiceQueryNodeStatusArgs() *TSMetaServiceQueryNodeStatusArgs {
  return &TSMetaServiceQueryNodeStatusArgs{}
}

func (p *TSMetaServiceQueryNodeStatusArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    if err := iprot.Skip(ctx, fieldTypeId); err != nil {
      return err
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSMetaServiceQueryNodeStatusArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "queryNodeStatus_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSMetaServiceQueryNodeStatusArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSMetaServiceQueryNodeStatusArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSMetaServiceQueryNodeStatusResult struct {
  Success *TNodeStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSMetaServiceQueryNodeStatusResult() *TSMetaServiceQueryNodeStatusResult {
  return &TSMetaServiceQueryNodeStatusResult{}
}

var TSMetaServiceQueryNodeStatusResult_Success_DEFAULT *TNodeStatus
func (p *TSMetaServiceQueryNodeStatusResult) GetSuccess() *TNodeStatus {
  if !p.IsSetSuccess() {
    return TSMetaServiceQueryNodeStatusResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSMetaServiceQueryNodeStatusResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSMetaServiceQueryNodeStatusResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSMetaServiceQueryNodeStatusResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TNodeStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSMetaServiceQueryNodeStatusResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "queryNodeStatus_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSMetaServiceQueryNodeStatusResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSMetaServiceQueryNodeStatusResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSMetaServiceQueryNodeStatusResult(%+v)", *p)
}

type TSMetaServiceCheckAliveArgs struct {
}

func NewTSMetaServiceCheckAliveArgs() *TSMetaServiceCheckAliveArgs {
  return &TSMetaServiceCheckAliveArgs{}
}

func (p *TSMetaServiceCheckAliveArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    if err := iprot.Skip(ctx, fieldTypeId); err != nil {
      return err
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSMetaServiceCheckAliveArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "checkAlive_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSMetaServiceCheckAliveArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSMetaServiceCheckAliveArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSMetaServiceCheckAliveResult struct {
  Success *Node `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSMetaServiceCheckAliveResult() *TSMetaServiceCheckAliveResult {
  return &TSMetaServiceCheckAliveResult{}
}

var TSMetaServiceCheckAliveResult_Success_DEFAULT *Node
func (p *TSMetaServiceCheckAliveResult) GetSuccess() *Node {
  if !p.IsSetSuccess() {
    return TSMetaServiceCheckAliveResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSMetaServiceCheckAliveResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSMetaServiceCheckAliveResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSMetaServiceCheckAliveResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &Node{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSMetaServiceCheckAliveResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "checkAlive_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSMetaServiceCheckAliveResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSMetaServiceCheckAliveResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSMetaServiceCheckAliveResult(%+v)", *p)
}

type TSMetaServiceCollectMigrationStatusArgs struct {
}

func NewTSMetaServiceCollectMigrationStatusArgs() *TSMetaServiceCollectMigrationStatusArgs {
  return &TSMetaServiceCollectMigrationStatusArgs{}
}

func (p *TSMetaServiceCollectMigrationStatusArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    if err := iprot.Skip(ctx, fieldTypeId); err != nil {
      return err
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSMetaServiceCollectMigrationStatusArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "collectMigrationStatus_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSMetaServiceCollectMigrationStatusArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSMetaServiceCollectMigrationStatusArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSMetaServiceCollectMigrationStatusResult struct {
  Success []byte `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSMetaServiceCollectMigrationStatusResult() *TSMetaServiceCollectMigrationStatusResult {
  return &TSMetaServiceCollectMigrationStatusResult{}
}

var TSMetaServiceCollectMigrationStatusResult_Success_DEFAULT []byte

func (p *TSMetaServiceCollectMigrationStatusResult) GetSuccess() []byte {
  return p.Success
}
func (p *TSMetaServiceCollectMigrationStatusResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSMetaServiceCollectMigrationStatusResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSMetaServiceCollectMigrationStatusResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 0: ", err)
} else {
  p.Success = v
}
  return nil
}

func (p *TSMetaServiceCollectMigrationStatusResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "collectMigrationStatus_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSMetaServiceCollectMigrationStatusResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRING, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteBinary(ctx, p.Success); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.success (0) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSMetaServiceCollectMigrationStatusResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSMetaServiceCollectMigrationStatusResult(%+v)", *p)
}

// Attributes:
//  - Sender
type TSMetaServiceHandshakeArgs struct {
  Sender *Node `thrift:"sender,1" db:"sender" json:"sender"`
}

func NewTSMetaServiceHandshakeArgs() *TSMetaServiceHandshakeArgs {
  return &TSMetaServiceHandshakeArgs{}
}

var TSMetaServiceHandshakeArgs_Sender_DEFAULT *Node
func (p *TSMetaServiceHandshakeArgs) GetSender() *Node {
  if !p.IsSetSender() {
    return TSMetaServiceHandshakeArgs_Sender_DEFAULT
  }
return p.Sender
}
func (p *TSMetaServiceHandshakeArgs) IsSetSender() bool {
  return p.Sender != nil
}

func (p *TSMetaServiceHandshakeArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSMetaServiceHandshakeArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Sender = &Node{}
  if err := p.Sender.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Sender), err)
  }
  return nil
}

func (p *TSMetaServiceHandshakeArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "handshake_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSMetaServiceHandshakeArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sender", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sender: ", p), err) }
  if err := p.Sender.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Sender), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sender: ", p), err) }
  return err
}

func (p *TSMetaServiceHandshakeArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSMetaServiceHandshakeArgs(%+v)", *p)
}

type TSMetaServiceHandshakeResult struct {
}

func NewTSMetaServiceHandshakeResult() *TSMetaServiceHandshakeResult {
  return &TSMetaServiceHandshakeResult{}
}

func (p *TSMetaServiceHandshakeResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    if err := iprot.Skip(ctx, fieldTypeId); err != nil {
      return err
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSMetaServiceHandshakeResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "handshake_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSMetaServiceHandshakeResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSMetaServiceHandshakeResult(%+v)", *p)
}


type ClusterInfoService interface {  //for cluster maintainer.
  //The interface will replace the JMX based NodeTool APIs.
  //

  // Get physical hash ring
  GetRing(ctx context.Context) (_r []*Node, _err error)
  // Get data partition information of input path and time range.
  // @param path input path
  // @return data partition information
  // 
  // Parameters:
  //  - Path
  //  - StartTime
  //  - EndTime
  GetDataPartition(ctx context.Context, path string, startTime Long, endTime Long) (_r []*DataPartitionEntry, _err error)
  // Get metadata partition information of input path
  // 
  // @param path input path
  // @return metadata partition information
  // 
  // Parameters:
  //  - Path
  GetMetaPartition(ctx context.Context, path string) (_r []*Node, _err error)
  // Get status of all nodes
  // 
  // @return key: node, value: 0(live), 1(offline), 2(joining), 3(leaving)
  GetAllNodeStatus(ctx context.Context) (_r map[*Node]Int, _err error)
  // @return A multi-line string with each line representing the total time consumption, invocation
  //     number, and average time consumption.
  GetInstrumentingInfo(ctx context.Context) (_r string, _err error)
}

//for cluster maintainer.
//The interface will replace the JMX based NodeTool APIs.
//
type ClusterInfoServiceClient struct {
  c thrift.TClient
  meta thrift.ResponseMeta
}

func NewClusterInfoServiceClientFactory(t thrift.TTransport, f thrift.TProtocolFactory) *ClusterInfoServiceClient {
  return &ClusterInfoServiceClient{
    c: thrift.NewTStandardClient(f.GetProtocol(t), f.GetProtocol(t)),
  }
}

func NewClusterInfoServiceClientProtocol(t thrift.TTransport, iprot thrift.TProtocol, oprot thrift.TProtocol) *ClusterInfoServiceClient {
  return &ClusterInfoServiceClient{
    c: thrift.NewTStandardClient(iprot, oprot),
  }
}

func NewClusterInfoServiceClient(c thrift.TClient) *ClusterInfoServiceClient {
  return &ClusterInfoServiceClient{
    c: c,
  }
}

func (p *ClusterInfoServiceClient) Client_() thrift.TClient {
  return p.c
}

func (p *ClusterInfoServiceClient) LastResponseMeta_() thrift.ResponseMeta {
  return p.meta
}

func (p *ClusterInfoServiceClient) SetLastResponseMeta_(meta thrift.ResponseMeta) {
  p.meta = meta
}

// Get physical hash ring
func (p *ClusterInfoServiceClient) GetRing(ctx context.Context) (_r []*Node, _err error) {
  var _args636 ClusterInfoServiceGetRingArgs
  var _result638 ClusterInfoServiceGetRingResult
  var _meta637 thrift.ResponseMeta
  _meta637, _err = p.Client_().Call(ctx, "getRing", &_args636, &_result638)
  p.SetLastResponseMeta_(_meta637)
  if _err != nil {
    return
  }
  return _result638.GetSuccess(), nil
}

// Get data partition information of input path and time range.
// @param path input path
// @return data partition information
// 
// Parameters:
//  - Path
//  - StartTime
//  - EndTime
func (p *ClusterInfoServiceClient) GetDataPartition(ctx context.Context, path string, startTime Long, endTime Long) (_r []*DataPartitionEntry, _err error) {
  var _args639 ClusterInfoServiceGetDataPartitionArgs
  _args639.Path = path
  _args639.StartTime = startTime
  _args639.EndTime = endTime
  var _result641 ClusterInfoServiceGetDataPartitionResult
  var _meta640 thrift.ResponseMeta
  _meta640, _err = p.Client_().Call(ctx, "getDataPartition", &_args639, &_result641)
  p.SetLastResponseMeta_(_meta640)
  if _err != nil {
    return
  }
  return _result641.GetSuccess(), nil
}

// Get metadata partition information of input path
// 
// @param path input path
// @return metadata partition information
// 
// Parameters:
//  - Path
func (p *ClusterInfoServiceClient) GetMetaPartition(ctx context.Context, path string) (_r []*Node, _err error) {
  var _args642 ClusterInfoServiceGetMetaPartitionArgs
  _args642.Path = path
  var _result644 ClusterInfoServiceGetMetaPartitionResult
  var _meta643 thrift.ResponseMeta
  _meta643, _err = p.Client_().Call(ctx, "getMetaPartition", &_args642, &_result644)
  p.SetLastResponseMeta_(_meta643)
  if _err != nil {
    return
  }
  return _result644.GetSuccess(), nil
}

// Get status of all nodes
// 
// @return key: node, value: 0(live), 1(offline), 2(joining), 3(leaving)
func (p *ClusterInfoServiceClient) GetAllNodeStatus(ctx context.Context) (_r map[*Node]Int, _err error) {
  var _args645 ClusterInfoServiceGetAllNodeStatusArgs
  var _result647 ClusterInfoServiceGetAllNodeStatusResult
  var _meta646 thrift.ResponseMeta
  _meta646, _err = p.Client_().Call(ctx, "getAllNodeStatus", &_args645, &_result647)
  p.SetLastResponseMeta_(_meta646)
  if _err != nil {
    return
  }
  return _result647.GetSuccess(), nil
}

// @return A multi-line string with each line representing the total time consumption, invocation
//     number, and average time consumption.
func (p *ClusterInfoServiceClient) GetInstrumentingInfo(ctx context.Context) (_r string, _err error) {
  var _args648 ClusterInfoServiceGetInstrumentingInfoArgs
  var _result650 ClusterInfoServiceGetInstrumentingInfoResult
  var _meta649 thrift.ResponseMeta
  _meta649, _err = p.Client_().Call(ctx, "getInstrumentingInfo", &_args648, &_result650)
  p.SetLastResponseMeta_(_meta649)
  if _err != nil {
    return
  }
  return _result650.GetSuccess(), nil
}

type ClusterInfoServiceProcessor struct {
  processorMap map[string]thrift.TProcessorFunction
  handler ClusterInfoService
}

func (p *ClusterInfoServiceProcessor) AddToProcessorMap(key string, processor thrift.TProcessorFunction) {
  p.processorMap[key] = processor
}

func (p *ClusterInfoServiceProcessor) GetProcessorFunction(key string) (processor thrift.TProcessorFunction, ok bool) {
  processor, ok = p.processorMap[key]
  return processor, ok
}

func (p *ClusterInfoServiceProcessor) ProcessorMap() map[string]thrift.TProcessorFunction {
  return p.processorMap
}

func NewClusterInfoServiceProcessor(handler ClusterInfoService) *ClusterInfoServiceProcessor {

  self651 := &ClusterInfoServiceProcessor{handler:handler, processorMap:make(map[string]thrift.TProcessorFunction)}
  self651.processorMap["getRing"] = &clusterInfoServiceProcessorGetRing{handler:handler}
  self651.processorMap["getDataPartition"] = &clusterInfoServiceProcessorGetDataPartition{handler:handler}
  self651.processorMap["getMetaPartition"] = &clusterInfoServiceProcessorGetMetaPartition{handler:handler}
  self651.processorMap["getAllNodeStatus"] = &clusterInfoServiceProcessorGetAllNodeStatus{handler:handler}
  self651.processorMap["getInstrumentingInfo"] = &clusterInfoServiceProcessorGetInstrumentingInfo{handler:handler}
return self651
}

func (p *ClusterInfoServiceProcessor) Process(ctx context.Context, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  name, _, seqId, err2 := iprot.ReadMessageBegin(ctx)
  if err2 != nil { return false, thrift.WrapTException(err2) }
  if processor, ok := p.GetProcessorFunction(name); ok {
    return processor.Process(ctx, seqId, iprot, oprot)
  }
  iprot.Skip(ctx, thrift.STRUCT)
  iprot.ReadMessageEnd(ctx)
  x652 := thrift.NewTApplicationException(thrift.UNKNOWN_METHOD, "Unknown function " + name)
  oprot.WriteMessageBegin(ctx, name, thrift.EXCEPTION, seqId)
  x652.Write(ctx, oprot)
  oprot.WriteMessageEnd(ctx)
  oprot.Flush(ctx)
  return false, x652

}

type clusterInfoServiceProcessorGetRing struct {
  handler ClusterInfoService
}

func (p *clusterInfoServiceProcessorGetRing) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := ClusterInfoServiceGetRingArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "getRing", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := ClusterInfoServiceGetRingResult{}
  var retval []*Node
  if retval, err2 = p.handler.GetRing(ctx); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getRing: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "getRing", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "getRing", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type clusterInfoServiceProcessorGetDataPartition struct {
  handler ClusterInfoService
}

func (p *clusterInfoServiceProcessorGetDataPartition) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := ClusterInfoServiceGetDataPartitionArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "getDataPartition", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := ClusterInfoServiceGetDataPartitionResult{}
  var retval []*DataPartitionEntry
  if retval, err2 = p.handler.GetDataPartition(ctx, args.Path, args.StartTime, args.EndTime); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getDataPartition: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "getDataPartition", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "getDataPartition", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type clusterInfoServiceProcessorGetMetaPartition struct {
  handler ClusterInfoService
}

func (p *clusterInfoServiceProcessorGetMetaPartition) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := ClusterInfoServiceGetMetaPartitionArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "getMetaPartition", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := ClusterInfoServiceGetMetaPartitionResult{}
  var retval []*Node
  if retval, err2 = p.handler.GetMetaPartition(ctx, args.Path); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getMetaPartition: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "getMetaPartition", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "getMetaPartition", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type clusterInfoServiceProcessorGetAllNodeStatus struct {
  handler ClusterInfoService
}

func (p *clusterInfoServiceProcessorGetAllNodeStatus) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := ClusterInfoServiceGetAllNodeStatusArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "getAllNodeStatus", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := ClusterInfoServiceGetAllNodeStatusResult{}
  var retval map[*Node]Int
  if retval, err2 = p.handler.GetAllNodeStatus(ctx); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getAllNodeStatus: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "getAllNodeStatus", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "getAllNodeStatus", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type clusterInfoServiceProcessorGetInstrumentingInfo struct {
  handler ClusterInfoService
}

func (p *clusterInfoServiceProcessorGetInstrumentingInfo) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := ClusterInfoServiceGetInstrumentingInfoArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "getInstrumentingInfo", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := ClusterInfoServiceGetInstrumentingInfoResult{}
  var retval string
  if retval, err2 = p.handler.GetInstrumentingInfo(ctx); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getInstrumentingInfo: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "getInstrumentingInfo", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = &retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "getInstrumentingInfo", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}


// HELPER FUNCTIONS AND STRUCTURES

type ClusterInfoServiceGetRingArgs struct {
}

func NewClusterInfoServiceGetRingArgs() *ClusterInfoServiceGetRingArgs {
  return &ClusterInfoServiceGetRingArgs{}
}

func (p *ClusterInfoServiceGetRingArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    if err := iprot.Skip(ctx, fieldTypeId); err != nil {
      return err
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *ClusterInfoServiceGetRingArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getRing_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *ClusterInfoServiceGetRingArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("ClusterInfoServiceGetRingArgs(%+v)", *p)
}

// Attributes:
//  - Success
type ClusterInfoServiceGetRingResult struct {
  Success []*Node `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewClusterInfoServiceGetRingResult() *ClusterInfoServiceGetRingResult {
  return &ClusterInfoServiceGetRingResult{}
}

var ClusterInfoServiceGetRingResult_Success_DEFAULT []*Node

func (p *ClusterInfoServiceGetRingResult) GetSuccess() []*Node {
  return p.Success
}
func (p *ClusterInfoServiceGetRingResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *ClusterInfoServiceGetRingResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *ClusterInfoServiceGetRingResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]*Node, 0, size)
  p.Success =  tSlice
  for i := 0; i < size; i ++ {
    _elem653 := &Node{}
    if err := _elem653.Read(ctx, iprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem653), err)
    }
    p.Success = append(p.Success, _elem653)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *ClusterInfoServiceGetRingResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getRing_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *ClusterInfoServiceGetRingResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.LIST, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.STRUCT, len(p.Success)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.Success {
      if err := v.Write(ctx, oprot); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
      }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *ClusterInfoServiceGetRingResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("ClusterInfoServiceGetRingResult(%+v)", *p)
}

// Attributes:
//  - Path
//  - StartTime
//  - EndTime
type ClusterInfoServiceGetDataPartitionArgs struct {
  Path string `thrift:"path,1" db:"path" json:"path"`
  StartTime Long `thrift:"startTime,2" db:"startTime" json:"startTime"`
  EndTime Long `thrift:"endTime,3" db:"endTime" json:"endTime"`
}

func NewClusterInfoServiceGetDataPartitionArgs() *ClusterInfoServiceGetDataPartitionArgs {
  return &ClusterInfoServiceGetDataPartitionArgs{}
}


func (p *ClusterInfoServiceGetDataPartitionArgs) GetPath() string {
  return p.Path
}

func (p *ClusterInfoServiceGetDataPartitionArgs) GetStartTime() Long {
  return p.StartTime
}

func (p *ClusterInfoServiceGetDataPartitionArgs) GetEndTime() Long {
  return p.EndTime
}
func (p *ClusterInfoServiceGetDataPartitionArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *ClusterInfoServiceGetDataPartitionArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.Path = v
}
  return nil
}

func (p *ClusterInfoServiceGetDataPartitionArgs)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  temp := Long(v)
  p.StartTime = temp
}
  return nil
}

func (p *ClusterInfoServiceGetDataPartitionArgs)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  temp := Long(v)
  p.EndTime = temp
}
  return nil
}

func (p *ClusterInfoServiceGetDataPartitionArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getDataPartition_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *ClusterInfoServiceGetDataPartitionArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "path", thrift.STRING, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:path: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Path)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.path (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:path: ", p), err) }
  return err
}

func (p *ClusterInfoServiceGetDataPartitionArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "startTime", thrift.I64, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:startTime: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.StartTime)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.startTime (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:startTime: ", p), err) }
  return err
}

func (p *ClusterInfoServiceGetDataPartitionArgs) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "endTime", thrift.I64, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:endTime: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.EndTime)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.endTime (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:endTime: ", p), err) }
  return err
}

func (p *ClusterInfoServiceGetDataPartitionArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("ClusterInfoServiceGetDataPartitionArgs(%+v)", *p)
}

// Attributes:
//  - Success
type ClusterInfoServiceGetDataPartitionResult struct {
  Success []*DataPartitionEntry `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewClusterInfoServiceGetDataPartitionResult() *ClusterInfoServiceGetDataPartitionResult {
  return &ClusterInfoServiceGetDataPartitionResult{}
}

var ClusterInfoServiceGetDataPartitionResult_Success_DEFAULT []*DataPartitionEntry

func (p *ClusterInfoServiceGetDataPartitionResult) GetSuccess() []*DataPartitionEntry {
  return p.Success
}
func (p *ClusterInfoServiceGetDataPartitionResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *ClusterInfoServiceGetDataPartitionResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *ClusterInfoServiceGetDataPartitionResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]*DataPartitionEntry, 0, size)
  p.Success =  tSlice
  for i := 0; i < size; i ++ {
    _elem654 := &DataPartitionEntry{}
    if err := _elem654.Read(ctx, iprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem654), err)
    }
    p.Success = append(p.Success, _elem654)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *ClusterInfoServiceGetDataPartitionResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getDataPartition_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *ClusterInfoServiceGetDataPartitionResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.LIST, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.STRUCT, len(p.Success)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.Success {
      if err := v.Write(ctx, oprot); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
      }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *ClusterInfoServiceGetDataPartitionResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("ClusterInfoServiceGetDataPartitionResult(%+v)", *p)
}

// Attributes:
//  - Path
type ClusterInfoServiceGetMetaPartitionArgs struct {
  Path string `thrift:"path,1" db:"path" json:"path"`
}

func NewClusterInfoServiceGetMetaPartitionArgs() *ClusterInfoServiceGetMetaPartitionArgs {
  return &ClusterInfoServiceGetMetaPartitionArgs{}
}


func (p *ClusterInfoServiceGetMetaPartitionArgs) GetPath() string {
  return p.Path
}
func (p *ClusterInfoServiceGetMetaPartitionArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *ClusterInfoServiceGetMetaPartitionArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.Path = v
}
  return nil
}

func (p *ClusterInfoServiceGetMetaPartitionArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getMetaPartition_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *ClusterInfoServiceGetMetaPartitionArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "path", thrift.STRING, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:path: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Path)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.path (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:path: ", p), err) }
  return err
}

func (p *ClusterInfoServiceGetMetaPartitionArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("ClusterInfoServiceGetMetaPartitionArgs(%+v)", *p)
}

// Attributes:
//  - Success
type ClusterInfoServiceGetMetaPartitionResult struct {
  Success []*Node `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewClusterInfoServiceGetMetaPartitionResult() *ClusterInfoServiceGetMetaPartitionResult {
  return &ClusterInfoServiceGetMetaPartitionResult{}
}

var ClusterInfoServiceGetMetaPartitionResult_Success_DEFAULT []*Node

func (p *ClusterInfoServiceGetMetaPartitionResult) GetSuccess() []*Node {
  return p.Success
}
func (p *ClusterInfoServiceGetMetaPartitionResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *ClusterInfoServiceGetMetaPartitionResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *ClusterInfoServiceGetMetaPartitionResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]*Node, 0, size)
  p.Success =  tSlice
  for i := 0; i < size; i ++ {
    _elem655 := &Node{}
    if err := _elem655.Read(ctx, iprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem655), err)
    }
    p.Success = append(p.Success, _elem655)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *ClusterInfoServiceGetMetaPartitionResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getMetaPartition_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *ClusterInfoServiceGetMetaPartitionResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.LIST, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.STRUCT, len(p.Success)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.Success {
      if err := v.Write(ctx, oprot); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
      }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *ClusterInfoServiceGetMetaPartitionResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("ClusterInfoServiceGetMetaPartitionResult(%+v)", *p)
}

type ClusterInfoServiceGetAllNodeStatusArgs struct {
}

func NewClusterInfoServiceGetAllNodeStatusArgs() *ClusterInfoServiceGetAllNodeStatusArgs {
  return &ClusterInfoServiceGetAllNodeStatusArgs{}
}

func (p *ClusterInfoServiceGetAllNodeStatusArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    if err := iprot.Skip(ctx, fieldTypeId); err != nil {
      return err
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *ClusterInfoServiceGetAllNodeStatusArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getAllNodeStatus_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *ClusterInfoServiceGetAllNodeStatusArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("ClusterInfoServiceGetAllNodeStatusArgs(%+v)", *p)
}

// Attributes:
//  - Success
type ClusterInfoServiceGetAllNodeStatusResult struct {
  Success map[*Node]Int `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewClusterInfoServiceGetAllNodeStatusResult() *ClusterInfoServiceGetAllNodeStatusResult {
  return &ClusterInfoServiceGetAllNodeStatusResult{}
}

var ClusterInfoServiceGetAllNodeStatusResult_Success_DEFAULT map[*Node]Int

func (p *ClusterInfoServiceGetAllNodeStatusResult) GetSuccess() map[*Node]Int {
  return p.Success
}
func (p *ClusterInfoServiceGetAllNodeStatusResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *ClusterInfoServiceGetAllNodeStatusResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.MAP {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *ClusterInfoServiceGetAllNodeStatusResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  _, _, size, err := iprot.ReadMapBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
  }
  tMap := make(map[*Node]Int, size)
  p.Success =  tMap
  for i := 0; i < size; i ++ {
    _key656 := &Node{}
    if err := _key656.Read(ctx, iprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _key656), err)
    }
var _val657 Int
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    temp := Int(v)
    _val657 = temp
}
    p.Success[_key656] = _val657
  }
  if err := iprot.ReadMapEnd(ctx); err != nil {
    return thrift.PrependError("error reading map end: ", err)
  }
  return nil
}

func (p *ClusterInfoServiceGetAllNodeStatusResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getAllNodeStatus_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *ClusterInfoServiceGetAllNodeStatusResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.MAP, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteMapBegin(ctx, thrift.STRUCT, thrift.I32, len(p.Success)); err != nil {
      return thrift.PrependError("error writing map begin: ", err)
    }
    for k, v := range p.Success {
      if err := k.Write(ctx, oprot); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", k), err)
      }
      if err := oprot.WriteI32(ctx, int32(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteMapEnd(ctx); err != nil {
      return thrift.PrependError("error writing map end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *ClusterInfoServiceGetAllNodeStatusResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("ClusterInfoServiceGetAllNodeStatusResult(%+v)", *p)
}

type ClusterInfoServiceGetInstrumentingInfoArgs struct {
}

func NewClusterInfoServiceGetInstrumentingInfoArgs() *ClusterInfoServiceGetInstrumentingInfoArgs {
  return &ClusterInfoServiceGetInstrumentingInfoArgs{}
}

func (p *ClusterInfoServiceGetInstrumentingInfoArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    if err := iprot.Skip(ctx, fieldTypeId); err != nil {
      return err
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *ClusterInfoServiceGetInstrumentingInfoArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getInstrumentingInfo_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *ClusterInfoServiceGetInstrumentingInfoArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("ClusterInfoServiceGetInstrumentingInfoArgs(%+v)", *p)
}

// Attributes:
//  - Success
type ClusterInfoServiceGetInstrumentingInfoResult struct {
  Success *string `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewClusterInfoServiceGetInstrumentingInfoResult() *ClusterInfoServiceGetInstrumentingInfoResult {
  return &ClusterInfoServiceGetInstrumentingInfoResult{}
}

var ClusterInfoServiceGetInstrumentingInfoResult_Success_DEFAULT string
func (p *ClusterInfoServiceGetInstrumentingInfoResult) GetSuccess() string {
  if !p.IsSetSuccess() {
    return ClusterInfoServiceGetInstrumentingInfoResult_Success_DEFAULT
  }
return *p.Success
}
func (p *ClusterInfoServiceGetInstrumentingInfoResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *ClusterInfoServiceGetInstrumentingInfoResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *ClusterInfoServiceGetInstrumentingInfoResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 0: ", err)
} else {
  p.Success = &v
}
  return nil
}

func (p *ClusterInfoServiceGetInstrumentingInfoResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getInstrumentingInfo_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *ClusterInfoServiceGetInstrumentingInfoResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRING, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.Success)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.success (0) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *ClusterInfoServiceGetInstrumentingInfoResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("ClusterInfoServiceGetInstrumentingInfoResult(%+v)", *p)
}


