// Code generated by Thrift Compiler (0.14.1). DO NOT EDIT.

package main

import (
	"context"
	"flag"
	"fmt"
	"math"
	"net"
	"net/url"
	"os"
	"strconv"
	"strings"
	"github.com/apache/thrift/lib/go/thrift"
	"rpc"
	"cluster"
)

var _ = rpc.GoUnusedProtection__
var _ = cluster.GoUnusedProtection__

func Usage() {
  fmt.Fprintln(os.Stderr, "Usage of ", os.Args[0], " [-h host:port] [-u url] [-f[ramed]] function [arg1 [arg2...]]:")
  flag.PrintDefaults()
  fmt.Fprintln(os.Stderr, "\nFunctions:")
  fmt.Fprintln(os.Stderr, "  HeartBeatResponse sendHeartbeat(HeartBeatRequest request)")
  fmt.Fprintln(os.Stderr, "  long startElection(ElectionRequest request)")
  fmt.Fprintln(os.Stderr, "  long appendEntries(AppendEntriesRequest request)")
  fmt.Fprintln(os.Stderr, "  long appendEntry(AppendEntryRequest request)")
  fmt.Fprintln(os.Stderr, "  void sendSnapshot(SendSnapshotRequest request)")
  fmt.Fprintln(os.Stderr, "  TSStatus executeNonQueryPlan(ExecutNonQueryReq request)")
  fmt.Fprintln(os.Stderr, "  RequestCommitIndexResponse requestCommitIndex(RaftNode header)")
  fmt.Fprintln(os.Stderr, "  string readFile(string filePath, long offset, int length)")
  fmt.Fprintln(os.Stderr, "  bool matchTerm(long index, long term, RaftNode header)")
  fmt.Fprintln(os.Stderr, "  void removeHardLink(string hardLinkPath)")
  fmt.Fprintln(os.Stderr)
  os.Exit(0)
}

type httpHeaders map[string]string

func (h httpHeaders) String() string {
  var m map[string]string = h
  return fmt.Sprintf("%s", m)
}

func (h httpHeaders) Set(value string) error {
  parts := strings.Split(value, ": ")
  if len(parts) != 2 {
    return fmt.Errorf("header should be of format 'Key: Value'")
  }
  h[parts[0]] = parts[1]
  return nil
}

func main() {
  flag.Usage = Usage
  var host string
  var port int
  var protocol string
  var urlString string
  var framed bool
  var useHttp bool
  headers := make(httpHeaders)
  var parsedUrl *url.URL
  var trans thrift.TTransport
  _ = strconv.Atoi
  _ = math.Abs
  flag.Usage = Usage
  flag.StringVar(&host, "h", "localhost", "Specify host and port")
  flag.IntVar(&port, "p", 9090, "Specify port")
  flag.StringVar(&protocol, "P", "binary", "Specify the protocol (binary, compact, simplejson, json)")
  flag.StringVar(&urlString, "u", "", "Specify the url")
  flag.BoolVar(&framed, "framed", false, "Use framed transport")
  flag.BoolVar(&useHttp, "http", false, "Use http")
  flag.Var(headers, "H", "Headers to set on the http(s) request (e.g. -H \"Key: Value\")")
  flag.Parse()
  
  if len(urlString) > 0 {
    var err error
    parsedUrl, err = url.Parse(urlString)
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
    host = parsedUrl.Host
    useHttp = len(parsedUrl.Scheme) <= 0 || parsedUrl.Scheme == "http" || parsedUrl.Scheme == "https"
  } else if useHttp {
    _, err := url.Parse(fmt.Sprint("http://", host, ":", port))
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
  }
  
  cmd := flag.Arg(0)
  var err error
  if useHttp {
    trans, err = thrift.NewTHttpClient(parsedUrl.String())
    if len(headers) > 0 {
      httptrans := trans.(*thrift.THttpClient)
      for key, value := range headers {
        httptrans.SetHeader(key, value)
      }
    }
  } else {
    portStr := fmt.Sprint(port)
    if strings.Contains(host, ":") {
           host, portStr, err = net.SplitHostPort(host)
           if err != nil {
                   fmt.Fprintln(os.Stderr, "error with host:", err)
                   os.Exit(1)
           }
    }
    trans, err = thrift.NewTSocket(net.JoinHostPort(host, portStr))
    if err != nil {
      fmt.Fprintln(os.Stderr, "error resolving address:", err)
      os.Exit(1)
    }
    if framed {
      trans = thrift.NewTFramedTransport(trans)
    }
  }
  if err != nil {
    fmt.Fprintln(os.Stderr, "Error creating transport", err)
    os.Exit(1)
  }
  defer trans.Close()
  var protocolFactory thrift.TProtocolFactory
  switch protocol {
  case "compact":
    protocolFactory = thrift.NewTCompactProtocolFactory()
    break
  case "simplejson":
    protocolFactory = thrift.NewTSimpleJSONProtocolFactory()
    break
  case "json":
    protocolFactory = thrift.NewTJSONProtocolFactory()
    break
  case "binary", "":
    protocolFactory = thrift.NewTBinaryProtocolFactoryDefault()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid protocol specified: ", protocol)
    Usage()
    os.Exit(1)
  }
  iprot := protocolFactory.GetProtocol(trans)
  oprot := protocolFactory.GetProtocol(trans)
  client := cluster.NewRaftServiceClient(thrift.NewTStandardClient(iprot, oprot))
  if err := trans.Open(); err != nil {
    fmt.Fprintln(os.Stderr, "Error opening socket to ", host, ":", port, " ", err)
    os.Exit(1)
  }
  
  switch cmd {
  case "sendHeartbeat":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SendHeartbeat requires 1 args")
      flag.Usage()
    }
    arg85 := flag.Arg(1)
    mbTrans86 := thrift.NewTMemoryBufferLen(len(arg85))
    defer mbTrans86.Close()
    _, err87 := mbTrans86.WriteString(arg85)
    if err87 != nil {
      Usage()
      return
    }
    factory88 := thrift.NewTJSONProtocolFactory()
    jsProt89 := factory88.GetProtocol(mbTrans86)
    argvalue0 := cluster.NewHeartBeatRequest()
    err90 := argvalue0.Read(context.Background(), jsProt89)
    if err90 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.SendHeartbeat(context.Background(), value0))
    fmt.Print("\n")
    break
  case "startElection":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "StartElection requires 1 args")
      flag.Usage()
    }
    arg91 := flag.Arg(1)
    mbTrans92 := thrift.NewTMemoryBufferLen(len(arg91))
    defer mbTrans92.Close()
    _, err93 := mbTrans92.WriteString(arg91)
    if err93 != nil {
      Usage()
      return
    }
    factory94 := thrift.NewTJSONProtocolFactory()
    jsProt95 := factory94.GetProtocol(mbTrans92)
    argvalue0 := cluster.NewElectionRequest()
    err96 := argvalue0.Read(context.Background(), jsProt95)
    if err96 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.StartElection(context.Background(), value0))
    fmt.Print("\n")
    break
  case "appendEntries":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "AppendEntries requires 1 args")
      flag.Usage()
    }
    arg97 := flag.Arg(1)
    mbTrans98 := thrift.NewTMemoryBufferLen(len(arg97))
    defer mbTrans98.Close()
    _, err99 := mbTrans98.WriteString(arg97)
    if err99 != nil {
      Usage()
      return
    }
    factory100 := thrift.NewTJSONProtocolFactory()
    jsProt101 := factory100.GetProtocol(mbTrans98)
    argvalue0 := cluster.NewAppendEntriesRequest()
    err102 := argvalue0.Read(context.Background(), jsProt101)
    if err102 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.AppendEntries(context.Background(), value0))
    fmt.Print("\n")
    break
  case "appendEntry":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "AppendEntry requires 1 args")
      flag.Usage()
    }
    arg103 := flag.Arg(1)
    mbTrans104 := thrift.NewTMemoryBufferLen(len(arg103))
    defer mbTrans104.Close()
    _, err105 := mbTrans104.WriteString(arg103)
    if err105 != nil {
      Usage()
      return
    }
    factory106 := thrift.NewTJSONProtocolFactory()
    jsProt107 := factory106.GetProtocol(mbTrans104)
    argvalue0 := cluster.NewAppendEntryRequest()
    err108 := argvalue0.Read(context.Background(), jsProt107)
    if err108 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.AppendEntry(context.Background(), value0))
    fmt.Print("\n")
    break
  case "sendSnapshot":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SendSnapshot requires 1 args")
      flag.Usage()
    }
    arg109 := flag.Arg(1)
    mbTrans110 := thrift.NewTMemoryBufferLen(len(arg109))
    defer mbTrans110.Close()
    _, err111 := mbTrans110.WriteString(arg109)
    if err111 != nil {
      Usage()
      return
    }
    factory112 := thrift.NewTJSONProtocolFactory()
    jsProt113 := factory112.GetProtocol(mbTrans110)
    argvalue0 := cluster.NewSendSnapshotRequest()
    err114 := argvalue0.Read(context.Background(), jsProt113)
    if err114 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.SendSnapshot(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeNonQueryPlan":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteNonQueryPlan requires 1 args")
      flag.Usage()
    }
    arg115 := flag.Arg(1)
    mbTrans116 := thrift.NewTMemoryBufferLen(len(arg115))
    defer mbTrans116.Close()
    _, err117 := mbTrans116.WriteString(arg115)
    if err117 != nil {
      Usage()
      return
    }
    factory118 := thrift.NewTJSONProtocolFactory()
    jsProt119 := factory118.GetProtocol(mbTrans116)
    argvalue0 := cluster.NewExecutNonQueryReq()
    err120 := argvalue0.Read(context.Background(), jsProt119)
    if err120 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteNonQueryPlan(context.Background(), value0))
    fmt.Print("\n")
    break
  case "requestCommitIndex":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "RequestCommitIndex requires 1 args")
      flag.Usage()
    }
    arg121 := flag.Arg(1)
    mbTrans122 := thrift.NewTMemoryBufferLen(len(arg121))
    defer mbTrans122.Close()
    _, err123 := mbTrans122.WriteString(arg121)
    if err123 != nil {
      Usage()
      return
    }
    factory124 := thrift.NewTJSONProtocolFactory()
    jsProt125 := factory124.GetProtocol(mbTrans122)
    argvalue0 := cluster.NewRaftNode()
    err126 := argvalue0.Read(context.Background(), jsProt125)
    if err126 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.RequestCommitIndex(context.Background(), value0))
    fmt.Print("\n")
    break
  case "readFile":
    if flag.NArg() - 1 != 3 {
      fmt.Fprintln(os.Stderr, "ReadFile requires 3 args")
      flag.Usage()
    }
    argvalue0 := flag.Arg(1)
    value0 := argvalue0
    argvalue1, err128 := (strconv.ParseInt(flag.Arg(2), 10, 64))
    if err128 != nil {
      Usage()
      return
    }
    value1 := cluster.Long(argvalue1)
    tmp2, err129 := (strconv.Atoi(flag.Arg(3)))
    if err129 != nil {
      Usage()
      return
    }
    argvalue2 := int32(tmp2)
    value2 := cluster.Int(argvalue2)
    fmt.Print(client.ReadFile(context.Background(), value0, value1, value2))
    fmt.Print("\n")
    break
  case "matchTerm":
    if flag.NArg() - 1 != 3 {
      fmt.Fprintln(os.Stderr, "MatchTerm requires 3 args")
      flag.Usage()
    }
    argvalue0, err130 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err130 != nil {
      Usage()
      return
    }
    value0 := cluster.Long(argvalue0)
    argvalue1, err131 := (strconv.ParseInt(flag.Arg(2), 10, 64))
    if err131 != nil {
      Usage()
      return
    }
    value1 := cluster.Long(argvalue1)
    arg132 := flag.Arg(3)
    mbTrans133 := thrift.NewTMemoryBufferLen(len(arg132))
    defer mbTrans133.Close()
    _, err134 := mbTrans133.WriteString(arg132)
    if err134 != nil {
      Usage()
      return
    }
    factory135 := thrift.NewTJSONProtocolFactory()
    jsProt136 := factory135.GetProtocol(mbTrans133)
    argvalue2 := cluster.NewRaftNode()
    err137 := argvalue2.Read(context.Background(), jsProt136)
    if err137 != nil {
      Usage()
      return
    }
    value2 := argvalue2
    fmt.Print(client.MatchTerm(context.Background(), value0, value1, value2))
    fmt.Print("\n")
    break
  case "removeHardLink":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "RemoveHardLink requires 1 args")
      flag.Usage()
    }
    argvalue0 := flag.Arg(1)
    value0 := argvalue0
    fmt.Print(client.RemoveHardLink(context.Background(), value0))
    fmt.Print("\n")
    break
  case "":
    Usage()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid function ", cmd)
  }
}
