// Code generated by Thrift Compiler (0.14.1). DO NOT EDIT.

package main

import (
	"context"
	"flag"
	"fmt"
	"math"
	"net"
	"net/url"
	"os"
	"strconv"
	"strings"
	"github.com/apache/thrift/lib/go/thrift"
	"rpc"
	"cluster"
)

var _ = rpc.GoUnusedProtection__
var _ = cluster.GoUnusedProtection__

func Usage() {
  fmt.Fprintln(os.Stderr, "Usage of ", os.Args[0], " [-h host:port] [-u url] [-f[ramed]] function [arg1 [arg2...]]:")
  flag.PrintDefaults()
  fmt.Fprintln(os.Stderr, "\nFunctions:")
  fmt.Fprintln(os.Stderr, "  long querySingleSeries(SingleSeriesQueryRequest request)")
  fmt.Fprintln(os.Stderr, "  long queryMultSeries(MultSeriesQueryRequest request)")
  fmt.Fprintln(os.Stderr, "  string fetchSingleSeries(RaftNode header, long readerId)")
  fmt.Fprintln(os.Stderr, "   fetchMultSeries(RaftNode header, long readerId,  paths)")
  fmt.Fprintln(os.Stderr, "  long querySingleSeriesByTimestamp(SingleSeriesQueryRequest request)")
  fmt.Fprintln(os.Stderr, "  string fetchSingleSeriesByTimestamps(RaftNode header, long readerId,  timestamps)")
  fmt.Fprintln(os.Stderr, "  void endQuery(RaftNode header, Node thisNode, long queryId)")
  fmt.Fprintln(os.Stderr, "  GetAllPathsResult getAllPaths(RaftNode header,  paths, bool withAlias)")
  fmt.Fprintln(os.Stderr, "   getAllDevices(RaftNode header,  path, bool isPrefixMatch)")
  fmt.Fprintln(os.Stderr, "  string getDevices(RaftNode header, string planBinary)")
  fmt.Fprintln(os.Stderr, "   getNodeList(RaftNode header, string path, int nodeLevel)")
  fmt.Fprintln(os.Stderr, "   getChildNodeInNextLevel(RaftNode header, string path)")
  fmt.Fprintln(os.Stderr, "   getChildNodePathInNextLevel(RaftNode header, string path)")
  fmt.Fprintln(os.Stderr, "  string getAllMeasurementSchema(MeasurementSchemaRequest request)")
  fmt.Fprintln(os.Stderr, "   getAggrResult(GetAggrResultRequest request)")
  fmt.Fprintln(os.Stderr, "   getUnregisteredTimeseries(RaftNode header,  timeseriesList)")
  fmt.Fprintln(os.Stderr, "  PullSnapshotResp pullSnapshot(PullSnapshotRequest request)")
  fmt.Fprintln(os.Stderr, "  long getGroupByExecutor(GroupByRequest request)")
  fmt.Fprintln(os.Stderr, "   getGroupByResult(RaftNode header, long executorId, long startTime, long endTime)")
  fmt.Fprintln(os.Stderr, "  PullSchemaResp pullTimeSeriesSchema(PullSchemaRequest request)")
  fmt.Fprintln(os.Stderr, "  PullSchemaResp pullMeasurementSchema(PullSchemaRequest request)")
  fmt.Fprintln(os.Stderr, "  string previousFill(PreviousFillRequest request)")
  fmt.Fprintln(os.Stderr, "  string last(LastQueryRequest request)")
  fmt.Fprintln(os.Stderr, "  int getPathCount(RaftNode header,  pathsToQuery, int level)")
  fmt.Fprintln(os.Stderr, "  int getDeviceCount(RaftNode header,  pathsToQuery)")
  fmt.Fprintln(os.Stderr, "  bool onSnapshotApplied(RaftNode header,  slots)")
  fmt.Fprintln(os.Stderr, "  string peekNextNotNullValue(RaftNode header, long executorId, long startTime, long endTime)")
  fmt.Fprintln(os.Stderr, "  HeartBeatResponse sendHeartbeat(HeartBeatRequest request)")
  fmt.Fprintln(os.Stderr, "  long startElection(ElectionRequest request)")
  fmt.Fprintln(os.Stderr, "  long appendEntries(AppendEntriesRequest request)")
  fmt.Fprintln(os.Stderr, "  long appendEntry(AppendEntryRequest request)")
  fmt.Fprintln(os.Stderr, "  void sendSnapshot(SendSnapshotRequest request)")
  fmt.Fprintln(os.Stderr, "  TSStatus executeNonQueryPlan(ExecutNonQueryReq request)")
  fmt.Fprintln(os.Stderr, "  RequestCommitIndexResponse requestCommitIndex(RaftNode header)")
  fmt.Fprintln(os.Stderr, "  string readFile(string filePath, long offset, int length)")
  fmt.Fprintln(os.Stderr, "  bool matchTerm(long index, long term, RaftNode header)")
  fmt.Fprintln(os.Stderr, "  void removeHardLink(string hardLinkPath)")
  fmt.Fprintln(os.Stderr)
  os.Exit(0)
}

type httpHeaders map[string]string

func (h httpHeaders) String() string {
  var m map[string]string = h
  return fmt.Sprintf("%s", m)
}

func (h httpHeaders) Set(value string) error {
  parts := strings.Split(value, ": ")
  if len(parts) != 2 {
    return fmt.Errorf("header should be of format 'Key: Value'")
  }
  h[parts[0]] = parts[1]
  return nil
}

func main() {
  flag.Usage = Usage
  var host string
  var port int
  var protocol string
  var urlString string
  var framed bool
  var useHttp bool
  headers := make(httpHeaders)
  var parsedUrl *url.URL
  var trans thrift.TTransport
  _ = strconv.Atoi
  _ = math.Abs
  flag.Usage = Usage
  flag.StringVar(&host, "h", "localhost", "Specify host and port")
  flag.IntVar(&port, "p", 9090, "Specify port")
  flag.StringVar(&protocol, "P", "binary", "Specify the protocol (binary, compact, simplejson, json)")
  flag.StringVar(&urlString, "u", "", "Specify the url")
  flag.BoolVar(&framed, "framed", false, "Use framed transport")
  flag.BoolVar(&useHttp, "http", false, "Use http")
  flag.Var(headers, "H", "Headers to set on the http(s) request (e.g. -H \"Key: Value\")")
  flag.Parse()
  
  if len(urlString) > 0 {
    var err error
    parsedUrl, err = url.Parse(urlString)
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
    host = parsedUrl.Host
    useHttp = len(parsedUrl.Scheme) <= 0 || parsedUrl.Scheme == "http" || parsedUrl.Scheme == "https"
  } else if useHttp {
    _, err := url.Parse(fmt.Sprint("http://", host, ":", port))
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
  }
  
  cmd := flag.Arg(0)
  var err error
  if useHttp {
    trans, err = thrift.NewTHttpClient(parsedUrl.String())
    if len(headers) > 0 {
      httptrans := trans.(*thrift.THttpClient)
      for key, value := range headers {
        httptrans.SetHeader(key, value)
      }
    }
  } else {
    portStr := fmt.Sprint(port)
    if strings.Contains(host, ":") {
           host, portStr, err = net.SplitHostPort(host)
           if err != nil {
                   fmt.Fprintln(os.Stderr, "error with host:", err)
                   os.Exit(1)
           }
    }
    trans, err = thrift.NewTSocket(net.JoinHostPort(host, portStr))
    if err != nil {
      fmt.Fprintln(os.Stderr, "error resolving address:", err)
      os.Exit(1)
    }
    if framed {
      trans = thrift.NewTFramedTransport(trans)
    }
  }
  if err != nil {
    fmt.Fprintln(os.Stderr, "Error creating transport", err)
    os.Exit(1)
  }
  defer trans.Close()
  var protocolFactory thrift.TProtocolFactory
  switch protocol {
  case "compact":
    protocolFactory = thrift.NewTCompactProtocolFactory()
    break
  case "simplejson":
    protocolFactory = thrift.NewTSimpleJSONProtocolFactory()
    break
  case "json":
    protocolFactory = thrift.NewTJSONProtocolFactory()
    break
  case "binary", "":
    protocolFactory = thrift.NewTBinaryProtocolFactoryDefault()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid protocol specified: ", protocol)
    Usage()
    os.Exit(1)
  }
  iprot := protocolFactory.GetProtocol(trans)
  oprot := protocolFactory.GetProtocol(trans)
  client := cluster.NewTSDataServiceClient(thrift.NewTStandardClient(iprot, oprot))
  if err := trans.Open(); err != nil {
    fmt.Fprintln(os.Stderr, "Error opening socket to ", host, ":", port, " ", err)
    os.Exit(1)
  }
  
  switch cmd {
  case "querySingleSeries":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "QuerySingleSeries requires 1 args")
      flag.Usage()
    }
    arg238 := flag.Arg(1)
    mbTrans239 := thrift.NewTMemoryBufferLen(len(arg238))
    defer mbTrans239.Close()
    _, err240 := mbTrans239.WriteString(arg238)
    if err240 != nil {
      Usage()
      return
    }
    factory241 := thrift.NewTJSONProtocolFactory()
    jsProt242 := factory241.GetProtocol(mbTrans239)
    argvalue0 := cluster.NewSingleSeriesQueryRequest()
    err243 := argvalue0.Read(context.Background(), jsProt242)
    if err243 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.QuerySingleSeries(context.Background(), value0))
    fmt.Print("\n")
    break
  case "queryMultSeries":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "QueryMultSeries requires 1 args")
      flag.Usage()
    }
    arg244 := flag.Arg(1)
    mbTrans245 := thrift.NewTMemoryBufferLen(len(arg244))
    defer mbTrans245.Close()
    _, err246 := mbTrans245.WriteString(arg244)
    if err246 != nil {
      Usage()
      return
    }
    factory247 := thrift.NewTJSONProtocolFactory()
    jsProt248 := factory247.GetProtocol(mbTrans245)
    argvalue0 := cluster.NewMultSeriesQueryRequest()
    err249 := argvalue0.Read(context.Background(), jsProt248)
    if err249 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.QueryMultSeries(context.Background(), value0))
    fmt.Print("\n")
    break
  case "fetchSingleSeries":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "FetchSingleSeries requires 2 args")
      flag.Usage()
    }
    arg250 := flag.Arg(1)
    mbTrans251 := thrift.NewTMemoryBufferLen(len(arg250))
    defer mbTrans251.Close()
    _, err252 := mbTrans251.WriteString(arg250)
    if err252 != nil {
      Usage()
      return
    }
    factory253 := thrift.NewTJSONProtocolFactory()
    jsProt254 := factory253.GetProtocol(mbTrans251)
    argvalue0 := cluster.NewRaftNode()
    err255 := argvalue0.Read(context.Background(), jsProt254)
    if err255 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1, err256 := (strconv.ParseInt(flag.Arg(2), 10, 64))
    if err256 != nil {
      Usage()
      return
    }
    value1 := cluster.Long(argvalue1)
    fmt.Print(client.FetchSingleSeries(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "fetchMultSeries":
    if flag.NArg() - 1 != 3 {
      fmt.Fprintln(os.Stderr, "FetchMultSeries requires 3 args")
      flag.Usage()
    }
    arg257 := flag.Arg(1)
    mbTrans258 := thrift.NewTMemoryBufferLen(len(arg257))
    defer mbTrans258.Close()
    _, err259 := mbTrans258.WriteString(arg257)
    if err259 != nil {
      Usage()
      return
    }
    factory260 := thrift.NewTJSONProtocolFactory()
    jsProt261 := factory260.GetProtocol(mbTrans258)
    argvalue0 := cluster.NewRaftNode()
    err262 := argvalue0.Read(context.Background(), jsProt261)
    if err262 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1, err263 := (strconv.ParseInt(flag.Arg(2), 10, 64))
    if err263 != nil {
      Usage()
      return
    }
    value1 := cluster.Long(argvalue1)
    arg264 := flag.Arg(3)
    mbTrans265 := thrift.NewTMemoryBufferLen(len(arg264))
    defer mbTrans265.Close()
    _, err266 := mbTrans265.WriteString(arg264)
    if err266 != nil { 
      Usage()
      return
    }
    factory267 := thrift.NewTJSONProtocolFactory()
    jsProt268 := factory267.GetProtocol(mbTrans265)
    containerStruct2 := cluster.NewTSDataServiceFetchMultSeriesArgs()
    err269 := containerStruct2.ReadField3(context.Background(), jsProt268)
    if err269 != nil {
      Usage()
      return
    }
    argvalue2 := containerStruct2.Paths
    value2 := argvalue2
    fmt.Print(client.FetchMultSeries(context.Background(), value0, value1, value2))
    fmt.Print("\n")
    break
  case "querySingleSeriesByTimestamp":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "QuerySingleSeriesByTimestamp requires 1 args")
      flag.Usage()
    }
    arg270 := flag.Arg(1)
    mbTrans271 := thrift.NewTMemoryBufferLen(len(arg270))
    defer mbTrans271.Close()
    _, err272 := mbTrans271.WriteString(arg270)
    if err272 != nil {
      Usage()
      return
    }
    factory273 := thrift.NewTJSONProtocolFactory()
    jsProt274 := factory273.GetProtocol(mbTrans271)
    argvalue0 := cluster.NewSingleSeriesQueryRequest()
    err275 := argvalue0.Read(context.Background(), jsProt274)
    if err275 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.QuerySingleSeriesByTimestamp(context.Background(), value0))
    fmt.Print("\n")
    break
  case "fetchSingleSeriesByTimestamps":
    if flag.NArg() - 1 != 3 {
      fmt.Fprintln(os.Stderr, "FetchSingleSeriesByTimestamps requires 3 args")
      flag.Usage()
    }
    arg276 := flag.Arg(1)
    mbTrans277 := thrift.NewTMemoryBufferLen(len(arg276))
    defer mbTrans277.Close()
    _, err278 := mbTrans277.WriteString(arg276)
    if err278 != nil {
      Usage()
      return
    }
    factory279 := thrift.NewTJSONProtocolFactory()
    jsProt280 := factory279.GetProtocol(mbTrans277)
    argvalue0 := cluster.NewRaftNode()
    err281 := argvalue0.Read(context.Background(), jsProt280)
    if err281 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1, err282 := (strconv.ParseInt(flag.Arg(2), 10, 64))
    if err282 != nil {
      Usage()
      return
    }
    value1 := cluster.Long(argvalue1)
    arg283 := flag.Arg(3)
    mbTrans284 := thrift.NewTMemoryBufferLen(len(arg283))
    defer mbTrans284.Close()
    _, err285 := mbTrans284.WriteString(arg283)
    if err285 != nil { 
      Usage()
      return
    }
    factory286 := thrift.NewTJSONProtocolFactory()
    jsProt287 := factory286.GetProtocol(mbTrans284)
    containerStruct2 := cluster.NewTSDataServiceFetchSingleSeriesByTimestampsArgs()
    err288 := containerStruct2.ReadField3(context.Background(), jsProt287)
    if err288 != nil {
      Usage()
      return
    }
    argvalue2 := containerStruct2.Timestamps
    value2 := argvalue2
    fmt.Print(client.FetchSingleSeriesByTimestamps(context.Background(), value0, value1, value2))
    fmt.Print("\n")
    break
  case "endQuery":
    if flag.NArg() - 1 != 3 {
      fmt.Fprintln(os.Stderr, "EndQuery requires 3 args")
      flag.Usage()
    }
    arg289 := flag.Arg(1)
    mbTrans290 := thrift.NewTMemoryBufferLen(len(arg289))
    defer mbTrans290.Close()
    _, err291 := mbTrans290.WriteString(arg289)
    if err291 != nil {
      Usage()
      return
    }
    factory292 := thrift.NewTJSONProtocolFactory()
    jsProt293 := factory292.GetProtocol(mbTrans290)
    argvalue0 := cluster.NewRaftNode()
    err294 := argvalue0.Read(context.Background(), jsProt293)
    if err294 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    arg295 := flag.Arg(2)
    mbTrans296 := thrift.NewTMemoryBufferLen(len(arg295))
    defer mbTrans296.Close()
    _, err297 := mbTrans296.WriteString(arg295)
    if err297 != nil {
      Usage()
      return
    }
    factory298 := thrift.NewTJSONProtocolFactory()
    jsProt299 := factory298.GetProtocol(mbTrans296)
    argvalue1 := cluster.NewNode()
    err300 := argvalue1.Read(context.Background(), jsProt299)
    if err300 != nil {
      Usage()
      return
    }
    value1 := argvalue1
    argvalue2, err301 := (strconv.ParseInt(flag.Arg(3), 10, 64))
    if err301 != nil {
      Usage()
      return
    }
    value2 := cluster.Long(argvalue2)
    fmt.Print(client.EndQuery(context.Background(), value0, value1, value2))
    fmt.Print("\n")
    break
  case "getAllPaths":
    if flag.NArg() - 1 != 3 {
      fmt.Fprintln(os.Stderr, "GetAllPaths requires 3 args")
      flag.Usage()
    }
    arg302 := flag.Arg(1)
    mbTrans303 := thrift.NewTMemoryBufferLen(len(arg302))
    defer mbTrans303.Close()
    _, err304 := mbTrans303.WriteString(arg302)
    if err304 != nil {
      Usage()
      return
    }
    factory305 := thrift.NewTJSONProtocolFactory()
    jsProt306 := factory305.GetProtocol(mbTrans303)
    argvalue0 := cluster.NewRaftNode()
    err307 := argvalue0.Read(context.Background(), jsProt306)
    if err307 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    arg308 := flag.Arg(2)
    mbTrans309 := thrift.NewTMemoryBufferLen(len(arg308))
    defer mbTrans309.Close()
    _, err310 := mbTrans309.WriteString(arg308)
    if err310 != nil { 
      Usage()
      return
    }
    factory311 := thrift.NewTJSONProtocolFactory()
    jsProt312 := factory311.GetProtocol(mbTrans309)
    containerStruct1 := cluster.NewTSDataServiceGetAllPathsArgs()
    err313 := containerStruct1.ReadField2(context.Background(), jsProt312)
    if err313 != nil {
      Usage()
      return
    }
    argvalue1 := containerStruct1.Paths
    value1 := argvalue1
    argvalue2 := flag.Arg(3) == "true"
    value2 := argvalue2
    fmt.Print(client.GetAllPaths(context.Background(), value0, value1, value2))
    fmt.Print("\n")
    break
  case "getAllDevices":
    if flag.NArg() - 1 != 3 {
      fmt.Fprintln(os.Stderr, "GetAllDevices requires 3 args")
      flag.Usage()
    }
    arg315 := flag.Arg(1)
    mbTrans316 := thrift.NewTMemoryBufferLen(len(arg315))
    defer mbTrans316.Close()
    _, err317 := mbTrans316.WriteString(arg315)
    if err317 != nil {
      Usage()
      return
    }
    factory318 := thrift.NewTJSONProtocolFactory()
    jsProt319 := factory318.GetProtocol(mbTrans316)
    argvalue0 := cluster.NewRaftNode()
    err320 := argvalue0.Read(context.Background(), jsProt319)
    if err320 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    arg321 := flag.Arg(2)
    mbTrans322 := thrift.NewTMemoryBufferLen(len(arg321))
    defer mbTrans322.Close()
    _, err323 := mbTrans322.WriteString(arg321)
    if err323 != nil { 
      Usage()
      return
    }
    factory324 := thrift.NewTJSONProtocolFactory()
    jsProt325 := factory324.GetProtocol(mbTrans322)
    containerStruct1 := cluster.NewTSDataServiceGetAllDevicesArgs()
    err326 := containerStruct1.ReadField2(context.Background(), jsProt325)
    if err326 != nil {
      Usage()
      return
    }
    argvalue1 := containerStruct1.Path
    value1 := argvalue1
    argvalue2 := flag.Arg(3) == "true"
    value2 := argvalue2
    fmt.Print(client.GetAllDevices(context.Background(), value0, value1, value2))
    fmt.Print("\n")
    break
  case "getDevices":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "GetDevices requires 2 args")
      flag.Usage()
    }
    arg328 := flag.Arg(1)
    mbTrans329 := thrift.NewTMemoryBufferLen(len(arg328))
    defer mbTrans329.Close()
    _, err330 := mbTrans329.WriteString(arg328)
    if err330 != nil {
      Usage()
      return
    }
    factory331 := thrift.NewTJSONProtocolFactory()
    jsProt332 := factory331.GetProtocol(mbTrans329)
    argvalue0 := cluster.NewRaftNode()
    err333 := argvalue0.Read(context.Background(), jsProt332)
    if err333 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1 := []byte(flag.Arg(2))
    value1 := argvalue1
    fmt.Print(client.GetDevices(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "getNodeList":
    if flag.NArg() - 1 != 3 {
      fmt.Fprintln(os.Stderr, "GetNodeList requires 3 args")
      flag.Usage()
    }
    arg335 := flag.Arg(1)
    mbTrans336 := thrift.NewTMemoryBufferLen(len(arg335))
    defer mbTrans336.Close()
    _, err337 := mbTrans336.WriteString(arg335)
    if err337 != nil {
      Usage()
      return
    }
    factory338 := thrift.NewTJSONProtocolFactory()
    jsProt339 := factory338.GetProtocol(mbTrans336)
    argvalue0 := cluster.NewRaftNode()
    err340 := argvalue0.Read(context.Background(), jsProt339)
    if err340 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1 := flag.Arg(2)
    value1 := argvalue1
    tmp2, err342 := (strconv.Atoi(flag.Arg(3)))
    if err342 != nil {
      Usage()
      return
    }
    argvalue2 := int32(tmp2)
    value2 := cluster.Int(argvalue2)
    fmt.Print(client.GetNodeList(context.Background(), value0, value1, value2))
    fmt.Print("\n")
    break
  case "getChildNodeInNextLevel":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "GetChildNodeInNextLevel requires 2 args")
      flag.Usage()
    }
    arg343 := flag.Arg(1)
    mbTrans344 := thrift.NewTMemoryBufferLen(len(arg343))
    defer mbTrans344.Close()
    _, err345 := mbTrans344.WriteString(arg343)
    if err345 != nil {
      Usage()
      return
    }
    factory346 := thrift.NewTJSONProtocolFactory()
    jsProt347 := factory346.GetProtocol(mbTrans344)
    argvalue0 := cluster.NewRaftNode()
    err348 := argvalue0.Read(context.Background(), jsProt347)
    if err348 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1 := flag.Arg(2)
    value1 := argvalue1
    fmt.Print(client.GetChildNodeInNextLevel(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "getChildNodePathInNextLevel":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "GetChildNodePathInNextLevel requires 2 args")
      flag.Usage()
    }
    arg350 := flag.Arg(1)
    mbTrans351 := thrift.NewTMemoryBufferLen(len(arg350))
    defer mbTrans351.Close()
    _, err352 := mbTrans351.WriteString(arg350)
    if err352 != nil {
      Usage()
      return
    }
    factory353 := thrift.NewTJSONProtocolFactory()
    jsProt354 := factory353.GetProtocol(mbTrans351)
    argvalue0 := cluster.NewRaftNode()
    err355 := argvalue0.Read(context.Background(), jsProt354)
    if err355 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1 := flag.Arg(2)
    value1 := argvalue1
    fmt.Print(client.GetChildNodePathInNextLevel(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "getAllMeasurementSchema":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "GetAllMeasurementSchema requires 1 args")
      flag.Usage()
    }
    arg357 := flag.Arg(1)
    mbTrans358 := thrift.NewTMemoryBufferLen(len(arg357))
    defer mbTrans358.Close()
    _, err359 := mbTrans358.WriteString(arg357)
    if err359 != nil {
      Usage()
      return
    }
    factory360 := thrift.NewTJSONProtocolFactory()
    jsProt361 := factory360.GetProtocol(mbTrans358)
    argvalue0 := cluster.NewMeasurementSchemaRequest()
    err362 := argvalue0.Read(context.Background(), jsProt361)
    if err362 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.GetAllMeasurementSchema(context.Background(), value0))
    fmt.Print("\n")
    break
  case "getAggrResult":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "GetAggrResult_ requires 1 args")
      flag.Usage()
    }
    arg363 := flag.Arg(1)
    mbTrans364 := thrift.NewTMemoryBufferLen(len(arg363))
    defer mbTrans364.Close()
    _, err365 := mbTrans364.WriteString(arg363)
    if err365 != nil {
      Usage()
      return
    }
    factory366 := thrift.NewTJSONProtocolFactory()
    jsProt367 := factory366.GetProtocol(mbTrans364)
    argvalue0 := cluster.NewGetAggrResultRequest()
    err368 := argvalue0.Read(context.Background(), jsProt367)
    if err368 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.GetAggrResult_(context.Background(), value0))
    fmt.Print("\n")
    break
  case "getUnregisteredTimeseries":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "GetUnregisteredTimeseries requires 2 args")
      flag.Usage()
    }
    arg369 := flag.Arg(1)
    mbTrans370 := thrift.NewTMemoryBufferLen(len(arg369))
    defer mbTrans370.Close()
    _, err371 := mbTrans370.WriteString(arg369)
    if err371 != nil {
      Usage()
      return
    }
    factory372 := thrift.NewTJSONProtocolFactory()
    jsProt373 := factory372.GetProtocol(mbTrans370)
    argvalue0 := cluster.NewRaftNode()
    err374 := argvalue0.Read(context.Background(), jsProt373)
    if err374 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    arg375 := flag.Arg(2)
    mbTrans376 := thrift.NewTMemoryBufferLen(len(arg375))
    defer mbTrans376.Close()
    _, err377 := mbTrans376.WriteString(arg375)
    if err377 != nil { 
      Usage()
      return
    }
    factory378 := thrift.NewTJSONProtocolFactory()
    jsProt379 := factory378.GetProtocol(mbTrans376)
    containerStruct1 := cluster.NewTSDataServiceGetUnregisteredTimeseriesArgs()
    err380 := containerStruct1.ReadField2(context.Background(), jsProt379)
    if err380 != nil {
      Usage()
      return
    }
    argvalue1 := containerStruct1.TimeseriesList
    value1 := argvalue1
    fmt.Print(client.GetUnregisteredTimeseries(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "pullSnapshot":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "PullSnapshot requires 1 args")
      flag.Usage()
    }
    arg381 := flag.Arg(1)
    mbTrans382 := thrift.NewTMemoryBufferLen(len(arg381))
    defer mbTrans382.Close()
    _, err383 := mbTrans382.WriteString(arg381)
    if err383 != nil {
      Usage()
      return
    }
    factory384 := thrift.NewTJSONProtocolFactory()
    jsProt385 := factory384.GetProtocol(mbTrans382)
    argvalue0 := cluster.NewPullSnapshotRequest()
    err386 := argvalue0.Read(context.Background(), jsProt385)
    if err386 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.PullSnapshot(context.Background(), value0))
    fmt.Print("\n")
    break
  case "getGroupByExecutor":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "GetGroupByExecutor requires 1 args")
      flag.Usage()
    }
    arg387 := flag.Arg(1)
    mbTrans388 := thrift.NewTMemoryBufferLen(len(arg387))
    defer mbTrans388.Close()
    _, err389 := mbTrans388.WriteString(arg387)
    if err389 != nil {
      Usage()
      return
    }
    factory390 := thrift.NewTJSONProtocolFactory()
    jsProt391 := factory390.GetProtocol(mbTrans388)
    argvalue0 := cluster.NewGroupByRequest()
    err392 := argvalue0.Read(context.Background(), jsProt391)
    if err392 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.GetGroupByExecutor(context.Background(), value0))
    fmt.Print("\n")
    break
  case "getGroupByResult":
    if flag.NArg() - 1 != 4 {
      fmt.Fprintln(os.Stderr, "GetGroupByResult_ requires 4 args")
      flag.Usage()
    }
    arg393 := flag.Arg(1)
    mbTrans394 := thrift.NewTMemoryBufferLen(len(arg393))
    defer mbTrans394.Close()
    _, err395 := mbTrans394.WriteString(arg393)
    if err395 != nil {
      Usage()
      return
    }
    factory396 := thrift.NewTJSONProtocolFactory()
    jsProt397 := factory396.GetProtocol(mbTrans394)
    argvalue0 := cluster.NewRaftNode()
    err398 := argvalue0.Read(context.Background(), jsProt397)
    if err398 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1, err399 := (strconv.ParseInt(flag.Arg(2), 10, 64))
    if err399 != nil {
      Usage()
      return
    }
    value1 := cluster.Long(argvalue1)
    argvalue2, err400 := (strconv.ParseInt(flag.Arg(3), 10, 64))
    if err400 != nil {
      Usage()
      return
    }
    value2 := cluster.Long(argvalue2)
    argvalue3, err401 := (strconv.ParseInt(flag.Arg(4), 10, 64))
    if err401 != nil {
      Usage()
      return
    }
    value3 := cluster.Long(argvalue3)
    fmt.Print(client.GetGroupByResult_(context.Background(), value0, value1, value2, value3))
    fmt.Print("\n")
    break
  case "pullTimeSeriesSchema":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "PullTimeSeriesSchema requires 1 args")
      flag.Usage()
    }
    arg402 := flag.Arg(1)
    mbTrans403 := thrift.NewTMemoryBufferLen(len(arg402))
    defer mbTrans403.Close()
    _, err404 := mbTrans403.WriteString(arg402)
    if err404 != nil {
      Usage()
      return
    }
    factory405 := thrift.NewTJSONProtocolFactory()
    jsProt406 := factory405.GetProtocol(mbTrans403)
    argvalue0 := cluster.NewPullSchemaRequest()
    err407 := argvalue0.Read(context.Background(), jsProt406)
    if err407 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.PullTimeSeriesSchema(context.Background(), value0))
    fmt.Print("\n")
    break
  case "pullMeasurementSchema":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "PullMeasurementSchema requires 1 args")
      flag.Usage()
    }
    arg408 := flag.Arg(1)
    mbTrans409 := thrift.NewTMemoryBufferLen(len(arg408))
    defer mbTrans409.Close()
    _, err410 := mbTrans409.WriteString(arg408)
    if err410 != nil {
      Usage()
      return
    }
    factory411 := thrift.NewTJSONProtocolFactory()
    jsProt412 := factory411.GetProtocol(mbTrans409)
    argvalue0 := cluster.NewPullSchemaRequest()
    err413 := argvalue0.Read(context.Background(), jsProt412)
    if err413 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.PullMeasurementSchema(context.Background(), value0))
    fmt.Print("\n")
    break
  case "previousFill":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "PreviousFill requires 1 args")
      flag.Usage()
    }
    arg414 := flag.Arg(1)
    mbTrans415 := thrift.NewTMemoryBufferLen(len(arg414))
    defer mbTrans415.Close()
    _, err416 := mbTrans415.WriteString(arg414)
    if err416 != nil {
      Usage()
      return
    }
    factory417 := thrift.NewTJSONProtocolFactory()
    jsProt418 := factory417.GetProtocol(mbTrans415)
    argvalue0 := cluster.NewPreviousFillRequest()
    err419 := argvalue0.Read(context.Background(), jsProt418)
    if err419 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.PreviousFill(context.Background(), value0))
    fmt.Print("\n")
    break
  case "last":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "Last requires 1 args")
      flag.Usage()
    }
    arg420 := flag.Arg(1)
    mbTrans421 := thrift.NewTMemoryBufferLen(len(arg420))
    defer mbTrans421.Close()
    _, err422 := mbTrans421.WriteString(arg420)
    if err422 != nil {
      Usage()
      return
    }
    factory423 := thrift.NewTJSONProtocolFactory()
    jsProt424 := factory423.GetProtocol(mbTrans421)
    argvalue0 := cluster.NewLastQueryRequest()
    err425 := argvalue0.Read(context.Background(), jsProt424)
    if err425 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.Last(context.Background(), value0))
    fmt.Print("\n")
    break
  case "getPathCount":
    if flag.NArg() - 1 != 3 {
      fmt.Fprintln(os.Stderr, "GetPathCount requires 3 args")
      flag.Usage()
    }
    arg426 := flag.Arg(1)
    mbTrans427 := thrift.NewTMemoryBufferLen(len(arg426))
    defer mbTrans427.Close()
    _, err428 := mbTrans427.WriteString(arg426)
    if err428 != nil {
      Usage()
      return
    }
    factory429 := thrift.NewTJSONProtocolFactory()
    jsProt430 := factory429.GetProtocol(mbTrans427)
    argvalue0 := cluster.NewRaftNode()
    err431 := argvalue0.Read(context.Background(), jsProt430)
    if err431 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    arg432 := flag.Arg(2)
    mbTrans433 := thrift.NewTMemoryBufferLen(len(arg432))
    defer mbTrans433.Close()
    _, err434 := mbTrans433.WriteString(arg432)
    if err434 != nil { 
      Usage()
      return
    }
    factory435 := thrift.NewTJSONProtocolFactory()
    jsProt436 := factory435.GetProtocol(mbTrans433)
    containerStruct1 := cluster.NewTSDataServiceGetPathCountArgs()
    err437 := containerStruct1.ReadField2(context.Background(), jsProt436)
    if err437 != nil {
      Usage()
      return
    }
    argvalue1 := containerStruct1.PathsToQuery
    value1 := argvalue1
    tmp2, err438 := (strconv.Atoi(flag.Arg(3)))
    if err438 != nil {
      Usage()
      return
    }
    argvalue2 := int32(tmp2)
    value2 := cluster.Int(argvalue2)
    fmt.Print(client.GetPathCount(context.Background(), value0, value1, value2))
    fmt.Print("\n")
    break
  case "getDeviceCount":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "GetDeviceCount requires 2 args")
      flag.Usage()
    }
    arg439 := flag.Arg(1)
    mbTrans440 := thrift.NewTMemoryBufferLen(len(arg439))
    defer mbTrans440.Close()
    _, err441 := mbTrans440.WriteString(arg439)
    if err441 != nil {
      Usage()
      return
    }
    factory442 := thrift.NewTJSONProtocolFactory()
    jsProt443 := factory442.GetProtocol(mbTrans440)
    argvalue0 := cluster.NewRaftNode()
    err444 := argvalue0.Read(context.Background(), jsProt443)
    if err444 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    arg445 := flag.Arg(2)
    mbTrans446 := thrift.NewTMemoryBufferLen(len(arg445))
    defer mbTrans446.Close()
    _, err447 := mbTrans446.WriteString(arg445)
    if err447 != nil { 
      Usage()
      return
    }
    factory448 := thrift.NewTJSONProtocolFactory()
    jsProt449 := factory448.GetProtocol(mbTrans446)
    containerStruct1 := cluster.NewTSDataServiceGetDeviceCountArgs()
    err450 := containerStruct1.ReadField2(context.Background(), jsProt449)
    if err450 != nil {
      Usage()
      return
    }
    argvalue1 := containerStruct1.PathsToQuery
    value1 := argvalue1
    fmt.Print(client.GetDeviceCount(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "onSnapshotApplied":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "OnSnapshotApplied requires 2 args")
      flag.Usage()
    }
    arg451 := flag.Arg(1)
    mbTrans452 := thrift.NewTMemoryBufferLen(len(arg451))
    defer mbTrans452.Close()
    _, err453 := mbTrans452.WriteString(arg451)
    if err453 != nil {
      Usage()
      return
    }
    factory454 := thrift.NewTJSONProtocolFactory()
    jsProt455 := factory454.GetProtocol(mbTrans452)
    argvalue0 := cluster.NewRaftNode()
    err456 := argvalue0.Read(context.Background(), jsProt455)
    if err456 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    arg457 := flag.Arg(2)
    mbTrans458 := thrift.NewTMemoryBufferLen(len(arg457))
    defer mbTrans458.Close()
    _, err459 := mbTrans458.WriteString(arg457)
    if err459 != nil { 
      Usage()
      return
    }
    factory460 := thrift.NewTJSONProtocolFactory()
    jsProt461 := factory460.GetProtocol(mbTrans458)
    containerStruct1 := cluster.NewTSDataServiceOnSnapshotAppliedArgs()
    err462 := containerStruct1.ReadField2(context.Background(), jsProt461)
    if err462 != nil {
      Usage()
      return
    }
    argvalue1 := containerStruct1.Slots
    value1 := argvalue1
    fmt.Print(client.OnSnapshotApplied(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "peekNextNotNullValue":
    if flag.NArg() - 1 != 4 {
      fmt.Fprintln(os.Stderr, "PeekNextNotNullValue requires 4 args")
      flag.Usage()
    }
    arg463 := flag.Arg(1)
    mbTrans464 := thrift.NewTMemoryBufferLen(len(arg463))
    defer mbTrans464.Close()
    _, err465 := mbTrans464.WriteString(arg463)
    if err465 != nil {
      Usage()
      return
    }
    factory466 := thrift.NewTJSONProtocolFactory()
    jsProt467 := factory466.GetProtocol(mbTrans464)
    argvalue0 := cluster.NewRaftNode()
    err468 := argvalue0.Read(context.Background(), jsProt467)
    if err468 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1, err469 := (strconv.ParseInt(flag.Arg(2), 10, 64))
    if err469 != nil {
      Usage()
      return
    }
    value1 := cluster.Long(argvalue1)
    argvalue2, err470 := (strconv.ParseInt(flag.Arg(3), 10, 64))
    if err470 != nil {
      Usage()
      return
    }
    value2 := cluster.Long(argvalue2)
    argvalue3, err471 := (strconv.ParseInt(flag.Arg(4), 10, 64))
    if err471 != nil {
      Usage()
      return
    }
    value3 := cluster.Long(argvalue3)
    fmt.Print(client.PeekNextNotNullValue(context.Background(), value0, value1, value2, value3))
    fmt.Print("\n")
    break
  case "sendHeartbeat":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SendHeartbeat requires 1 args")
      flag.Usage()
    }
    arg472 := flag.Arg(1)
    mbTrans473 := thrift.NewTMemoryBufferLen(len(arg472))
    defer mbTrans473.Close()
    _, err474 := mbTrans473.WriteString(arg472)
    if err474 != nil {
      Usage()
      return
    }
    factory475 := thrift.NewTJSONProtocolFactory()
    jsProt476 := factory475.GetProtocol(mbTrans473)
    argvalue0 := cluster.NewHeartBeatRequest()
    err477 := argvalue0.Read(context.Background(), jsProt476)
    if err477 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.SendHeartbeat(context.Background(), value0))
    fmt.Print("\n")
    break
  case "startElection":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "StartElection requires 1 args")
      flag.Usage()
    }
    arg478 := flag.Arg(1)
    mbTrans479 := thrift.NewTMemoryBufferLen(len(arg478))
    defer mbTrans479.Close()
    _, err480 := mbTrans479.WriteString(arg478)
    if err480 != nil {
      Usage()
      return
    }
    factory481 := thrift.NewTJSONProtocolFactory()
    jsProt482 := factory481.GetProtocol(mbTrans479)
    argvalue0 := cluster.NewElectionRequest()
    err483 := argvalue0.Read(context.Background(), jsProt482)
    if err483 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.StartElection(context.Background(), value0))
    fmt.Print("\n")
    break
  case "appendEntries":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "AppendEntries requires 1 args")
      flag.Usage()
    }
    arg484 := flag.Arg(1)
    mbTrans485 := thrift.NewTMemoryBufferLen(len(arg484))
    defer mbTrans485.Close()
    _, err486 := mbTrans485.WriteString(arg484)
    if err486 != nil {
      Usage()
      return
    }
    factory487 := thrift.NewTJSONProtocolFactory()
    jsProt488 := factory487.GetProtocol(mbTrans485)
    argvalue0 := cluster.NewAppendEntriesRequest()
    err489 := argvalue0.Read(context.Background(), jsProt488)
    if err489 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.AppendEntries(context.Background(), value0))
    fmt.Print("\n")
    break
  case "appendEntry":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "AppendEntry requires 1 args")
      flag.Usage()
    }
    arg490 := flag.Arg(1)
    mbTrans491 := thrift.NewTMemoryBufferLen(len(arg490))
    defer mbTrans491.Close()
    _, err492 := mbTrans491.WriteString(arg490)
    if err492 != nil {
      Usage()
      return
    }
    factory493 := thrift.NewTJSONProtocolFactory()
    jsProt494 := factory493.GetProtocol(mbTrans491)
    argvalue0 := cluster.NewAppendEntryRequest()
    err495 := argvalue0.Read(context.Background(), jsProt494)
    if err495 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.AppendEntry(context.Background(), value0))
    fmt.Print("\n")
    break
  case "sendSnapshot":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SendSnapshot requires 1 args")
      flag.Usage()
    }
    arg496 := flag.Arg(1)
    mbTrans497 := thrift.NewTMemoryBufferLen(len(arg496))
    defer mbTrans497.Close()
    _, err498 := mbTrans497.WriteString(arg496)
    if err498 != nil {
      Usage()
      return
    }
    factory499 := thrift.NewTJSONProtocolFactory()
    jsProt500 := factory499.GetProtocol(mbTrans497)
    argvalue0 := cluster.NewSendSnapshotRequest()
    err501 := argvalue0.Read(context.Background(), jsProt500)
    if err501 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.SendSnapshot(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeNonQueryPlan":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteNonQueryPlan requires 1 args")
      flag.Usage()
    }
    arg502 := flag.Arg(1)
    mbTrans503 := thrift.NewTMemoryBufferLen(len(arg502))
    defer mbTrans503.Close()
    _, err504 := mbTrans503.WriteString(arg502)
    if err504 != nil {
      Usage()
      return
    }
    factory505 := thrift.NewTJSONProtocolFactory()
    jsProt506 := factory505.GetProtocol(mbTrans503)
    argvalue0 := cluster.NewExecutNonQueryReq()
    err507 := argvalue0.Read(context.Background(), jsProt506)
    if err507 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteNonQueryPlan(context.Background(), value0))
    fmt.Print("\n")
    break
  case "requestCommitIndex":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "RequestCommitIndex requires 1 args")
      flag.Usage()
    }
    arg508 := flag.Arg(1)
    mbTrans509 := thrift.NewTMemoryBufferLen(len(arg508))
    defer mbTrans509.Close()
    _, err510 := mbTrans509.WriteString(arg508)
    if err510 != nil {
      Usage()
      return
    }
    factory511 := thrift.NewTJSONProtocolFactory()
    jsProt512 := factory511.GetProtocol(mbTrans509)
    argvalue0 := cluster.NewRaftNode()
    err513 := argvalue0.Read(context.Background(), jsProt512)
    if err513 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.RequestCommitIndex(context.Background(), value0))
    fmt.Print("\n")
    break
  case "readFile":
    if flag.NArg() - 1 != 3 {
      fmt.Fprintln(os.Stderr, "ReadFile requires 3 args")
      flag.Usage()
    }
    argvalue0 := flag.Arg(1)
    value0 := argvalue0
    argvalue1, err515 := (strconv.ParseInt(flag.Arg(2), 10, 64))
    if err515 != nil {
      Usage()
      return
    }
    value1 := cluster.Long(argvalue1)
    tmp2, err516 := (strconv.Atoi(flag.Arg(3)))
    if err516 != nil {
      Usage()
      return
    }
    argvalue2 := int32(tmp2)
    value2 := cluster.Int(argvalue2)
    fmt.Print(client.ReadFile(context.Background(), value0, value1, value2))
    fmt.Print("\n")
    break
  case "matchTerm":
    if flag.NArg() - 1 != 3 {
      fmt.Fprintln(os.Stderr, "MatchTerm requires 3 args")
      flag.Usage()
    }
    argvalue0, err517 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err517 != nil {
      Usage()
      return
    }
    value0 := cluster.Long(argvalue0)
    argvalue1, err518 := (strconv.ParseInt(flag.Arg(2), 10, 64))
    if err518 != nil {
      Usage()
      return
    }
    value1 := cluster.Long(argvalue1)
    arg519 := flag.Arg(3)
    mbTrans520 := thrift.NewTMemoryBufferLen(len(arg519))
    defer mbTrans520.Close()
    _, err521 := mbTrans520.WriteString(arg519)
    if err521 != nil {
      Usage()
      return
    }
    factory522 := thrift.NewTJSONProtocolFactory()
    jsProt523 := factory522.GetProtocol(mbTrans520)
    argvalue2 := cluster.NewRaftNode()
    err524 := argvalue2.Read(context.Background(), jsProt523)
    if err524 != nil {
      Usage()
      return
    }
    value2 := argvalue2
    fmt.Print(client.MatchTerm(context.Background(), value0, value1, value2))
    fmt.Print("\n")
    break
  case "removeHardLink":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "RemoveHardLink requires 1 args")
      flag.Usage()
    }
    argvalue0 := flag.Arg(1)
    value0 := argvalue0
    fmt.Print(client.RemoveHardLink(context.Background(), value0))
    fmt.Print("\n")
    break
  case "":
    Usage()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid function ", cmd)
  }
}
