// Code generated by Thrift Compiler (0.14.1). DO NOT EDIT.

package main

import (
	"context"
	"flag"
	"fmt"
	"math"
	"net"
	"net/url"
	"os"
	"strconv"
	"strings"
	"github.com/apache/thrift/lib/go/thrift"
	"rpc"
	"cluster"
)

var _ = rpc.GoUnusedProtection__
var _ = cluster.GoUnusedProtection__

func Usage() {
  fmt.Fprintln(os.Stderr, "Usage of ", os.Args[0], " [-h host:port] [-u url] [-f[ramed]] function [arg1 [arg2...]]:")
  flag.PrintDefaults()
  fmt.Fprintln(os.Stderr, "\nFunctions:")
  fmt.Fprintln(os.Stderr, "  AddNodeResponse addNode(Node node, StartUpStatus startUpStatus)")
  fmt.Fprintln(os.Stderr, "  CheckStatusResponse checkStatus(StartUpStatus startUpStatus)")
  fmt.Fprintln(os.Stderr, "  long removeNode(Node node)")
  fmt.Fprintln(os.Stderr, "  void exile(string removeNodeLog)")
  fmt.Fprintln(os.Stderr, "  TNodeStatus queryNodeStatus()")
  fmt.Fprintln(os.Stderr, "  Node checkAlive()")
  fmt.Fprintln(os.Stderr, "  string collectMigrationStatus()")
  fmt.Fprintln(os.Stderr, "  void handshake(Node sender)")
  fmt.Fprintln(os.Stderr, "  HeartBeatResponse sendHeartbeat(HeartBeatRequest request)")
  fmt.Fprintln(os.Stderr, "  long startElection(ElectionRequest request)")
  fmt.Fprintln(os.Stderr, "  long appendEntries(AppendEntriesRequest request)")
  fmt.Fprintln(os.Stderr, "  long appendEntry(AppendEntryRequest request)")
  fmt.Fprintln(os.Stderr, "  void sendSnapshot(SendSnapshotRequest request)")
  fmt.Fprintln(os.Stderr, "  TSStatus executeNonQueryPlan(ExecutNonQueryReq request)")
  fmt.Fprintln(os.Stderr, "  RequestCommitIndexResponse requestCommitIndex(RaftNode header)")
  fmt.Fprintln(os.Stderr, "  string readFile(string filePath, long offset, int length)")
  fmt.Fprintln(os.Stderr, "  bool matchTerm(long index, long term, RaftNode header)")
  fmt.Fprintln(os.Stderr, "  void removeHardLink(string hardLinkPath)")
  fmt.Fprintln(os.Stderr)
  os.Exit(0)
}

type httpHeaders map[string]string

func (h httpHeaders) String() string {
  var m map[string]string = h
  return fmt.Sprintf("%s", m)
}

func (h httpHeaders) Set(value string) error {
  parts := strings.Split(value, ": ")
  if len(parts) != 2 {
    return fmt.Errorf("header should be of format 'Key: Value'")
  }
  h[parts[0]] = parts[1]
  return nil
}

func main() {
  flag.Usage = Usage
  var host string
  var port int
  var protocol string
  var urlString string
  var framed bool
  var useHttp bool
  headers := make(httpHeaders)
  var parsedUrl *url.URL
  var trans thrift.TTransport
  _ = strconv.Atoi
  _ = math.Abs
  flag.Usage = Usage
  flag.StringVar(&host, "h", "localhost", "Specify host and port")
  flag.IntVar(&port, "p", 9090, "Specify port")
  flag.StringVar(&protocol, "P", "binary", "Specify the protocol (binary, compact, simplejson, json)")
  flag.StringVar(&urlString, "u", "", "Specify the url")
  flag.BoolVar(&framed, "framed", false, "Use framed transport")
  flag.BoolVar(&useHttp, "http", false, "Use http")
  flag.Var(headers, "H", "Headers to set on the http(s) request (e.g. -H \"Key: Value\")")
  flag.Parse()
  
  if len(urlString) > 0 {
    var err error
    parsedUrl, err = url.Parse(urlString)
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
    host = parsedUrl.Host
    useHttp = len(parsedUrl.Scheme) <= 0 || parsedUrl.Scheme == "http" || parsedUrl.Scheme == "https"
  } else if useHttp {
    _, err := url.Parse(fmt.Sprint("http://", host, ":", port))
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
  }
  
  cmd := flag.Arg(0)
  var err error
  if useHttp {
    trans, err = thrift.NewTHttpClient(parsedUrl.String())
    if len(headers) > 0 {
      httptrans := trans.(*thrift.THttpClient)
      for key, value := range headers {
        httptrans.SetHeader(key, value)
      }
    }
  } else {
    portStr := fmt.Sprint(port)
    if strings.Contains(host, ":") {
           host, portStr, err = net.SplitHostPort(host)
           if err != nil {
                   fmt.Fprintln(os.Stderr, "error with host:", err)
                   os.Exit(1)
           }
    }
    trans, err = thrift.NewTSocket(net.JoinHostPort(host, portStr))
    if err != nil {
      fmt.Fprintln(os.Stderr, "error resolving address:", err)
      os.Exit(1)
    }
    if framed {
      trans = thrift.NewTFramedTransport(trans)
    }
  }
  if err != nil {
    fmt.Fprintln(os.Stderr, "Error creating transport", err)
    os.Exit(1)
  }
  defer trans.Close()
  var protocolFactory thrift.TProtocolFactory
  switch protocol {
  case "compact":
    protocolFactory = thrift.NewTCompactProtocolFactory()
    break
  case "simplejson":
    protocolFactory = thrift.NewTSimpleJSONProtocolFactory()
    break
  case "json":
    protocolFactory = thrift.NewTJSONProtocolFactory()
    break
  case "binary", "":
    protocolFactory = thrift.NewTBinaryProtocolFactoryDefault()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid protocol specified: ", protocol)
    Usage()
    os.Exit(1)
  }
  iprot := protocolFactory.GetProtocol(trans)
  oprot := protocolFactory.GetProtocol(trans)
  client := cluster.NewTSMetaServiceClient(thrift.NewTStandardClient(iprot, oprot))
  if err := trans.Open(); err != nil {
    fmt.Fprintln(os.Stderr, "Error opening socket to ", host, ":", port, " ", err)
    os.Exit(1)
  }
  
  switch cmd {
  case "addNode":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "AddNode requires 2 args")
      flag.Usage()
    }
    arg551 := flag.Arg(1)
    mbTrans552 := thrift.NewTMemoryBufferLen(len(arg551))
    defer mbTrans552.Close()
    _, err553 := mbTrans552.WriteString(arg551)
    if err553 != nil {
      Usage()
      return
    }
    factory554 := thrift.NewTJSONProtocolFactory()
    jsProt555 := factory554.GetProtocol(mbTrans552)
    argvalue0 := cluster.NewNode()
    err556 := argvalue0.Read(context.Background(), jsProt555)
    if err556 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    arg557 := flag.Arg(2)
    mbTrans558 := thrift.NewTMemoryBufferLen(len(arg557))
    defer mbTrans558.Close()
    _, err559 := mbTrans558.WriteString(arg557)
    if err559 != nil {
      Usage()
      return
    }
    factory560 := thrift.NewTJSONProtocolFactory()
    jsProt561 := factory560.GetProtocol(mbTrans558)
    argvalue1 := cluster.NewStartUpStatus()
    err562 := argvalue1.Read(context.Background(), jsProt561)
    if err562 != nil {
      Usage()
      return
    }
    value1 := argvalue1
    fmt.Print(client.AddNode(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "checkStatus":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CheckStatus requires 1 args")
      flag.Usage()
    }
    arg563 := flag.Arg(1)
    mbTrans564 := thrift.NewTMemoryBufferLen(len(arg563))
    defer mbTrans564.Close()
    _, err565 := mbTrans564.WriteString(arg563)
    if err565 != nil {
      Usage()
      return
    }
    factory566 := thrift.NewTJSONProtocolFactory()
    jsProt567 := factory566.GetProtocol(mbTrans564)
    argvalue0 := cluster.NewStartUpStatus()
    err568 := argvalue0.Read(context.Background(), jsProt567)
    if err568 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CheckStatus(context.Background(), value0))
    fmt.Print("\n")
    break
  case "removeNode":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "RemoveNode requires 1 args")
      flag.Usage()
    }
    arg569 := flag.Arg(1)
    mbTrans570 := thrift.NewTMemoryBufferLen(len(arg569))
    defer mbTrans570.Close()
    _, err571 := mbTrans570.WriteString(arg569)
    if err571 != nil {
      Usage()
      return
    }
    factory572 := thrift.NewTJSONProtocolFactory()
    jsProt573 := factory572.GetProtocol(mbTrans570)
    argvalue0 := cluster.NewNode()
    err574 := argvalue0.Read(context.Background(), jsProt573)
    if err574 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.RemoveNode(context.Background(), value0))
    fmt.Print("\n")
    break
  case "exile":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "Exile requires 1 args")
      flag.Usage()
    }
    argvalue0 := []byte(flag.Arg(1))
    value0 := argvalue0
    fmt.Print(client.Exile(context.Background(), value0))
    fmt.Print("\n")
    break
  case "queryNodeStatus":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "QueryNodeStatus requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.QueryNodeStatus(context.Background()))
    fmt.Print("\n")
    break
  case "checkAlive":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "CheckAlive requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.CheckAlive(context.Background()))
    fmt.Print("\n")
    break
  case "collectMigrationStatus":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "CollectMigrationStatus requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.CollectMigrationStatus(context.Background()))
    fmt.Print("\n")
    break
  case "handshake":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "Handshake requires 1 args")
      flag.Usage()
    }
    arg576 := flag.Arg(1)
    mbTrans577 := thrift.NewTMemoryBufferLen(len(arg576))
    defer mbTrans577.Close()
    _, err578 := mbTrans577.WriteString(arg576)
    if err578 != nil {
      Usage()
      return
    }
    factory579 := thrift.NewTJSONProtocolFactory()
    jsProt580 := factory579.GetProtocol(mbTrans577)
    argvalue0 := cluster.NewNode()
    err581 := argvalue0.Read(context.Background(), jsProt580)
    if err581 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.Handshake(context.Background(), value0))
    fmt.Print("\n")
    break
  case "sendHeartbeat":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SendHeartbeat requires 1 args")
      flag.Usage()
    }
    arg582 := flag.Arg(1)
    mbTrans583 := thrift.NewTMemoryBufferLen(len(arg582))
    defer mbTrans583.Close()
    _, err584 := mbTrans583.WriteString(arg582)
    if err584 != nil {
      Usage()
      return
    }
    factory585 := thrift.NewTJSONProtocolFactory()
    jsProt586 := factory585.GetProtocol(mbTrans583)
    argvalue0 := cluster.NewHeartBeatRequest()
    err587 := argvalue0.Read(context.Background(), jsProt586)
    if err587 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.SendHeartbeat(context.Background(), value0))
    fmt.Print("\n")
    break
  case "startElection":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "StartElection requires 1 args")
      flag.Usage()
    }
    arg588 := flag.Arg(1)
    mbTrans589 := thrift.NewTMemoryBufferLen(len(arg588))
    defer mbTrans589.Close()
    _, err590 := mbTrans589.WriteString(arg588)
    if err590 != nil {
      Usage()
      return
    }
    factory591 := thrift.NewTJSONProtocolFactory()
    jsProt592 := factory591.GetProtocol(mbTrans589)
    argvalue0 := cluster.NewElectionRequest()
    err593 := argvalue0.Read(context.Background(), jsProt592)
    if err593 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.StartElection(context.Background(), value0))
    fmt.Print("\n")
    break
  case "appendEntries":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "AppendEntries requires 1 args")
      flag.Usage()
    }
    arg594 := flag.Arg(1)
    mbTrans595 := thrift.NewTMemoryBufferLen(len(arg594))
    defer mbTrans595.Close()
    _, err596 := mbTrans595.WriteString(arg594)
    if err596 != nil {
      Usage()
      return
    }
    factory597 := thrift.NewTJSONProtocolFactory()
    jsProt598 := factory597.GetProtocol(mbTrans595)
    argvalue0 := cluster.NewAppendEntriesRequest()
    err599 := argvalue0.Read(context.Background(), jsProt598)
    if err599 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.AppendEntries(context.Background(), value0))
    fmt.Print("\n")
    break
  case "appendEntry":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "AppendEntry requires 1 args")
      flag.Usage()
    }
    arg600 := flag.Arg(1)
    mbTrans601 := thrift.NewTMemoryBufferLen(len(arg600))
    defer mbTrans601.Close()
    _, err602 := mbTrans601.WriteString(arg600)
    if err602 != nil {
      Usage()
      return
    }
    factory603 := thrift.NewTJSONProtocolFactory()
    jsProt604 := factory603.GetProtocol(mbTrans601)
    argvalue0 := cluster.NewAppendEntryRequest()
    err605 := argvalue0.Read(context.Background(), jsProt604)
    if err605 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.AppendEntry(context.Background(), value0))
    fmt.Print("\n")
    break
  case "sendSnapshot":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SendSnapshot requires 1 args")
      flag.Usage()
    }
    arg606 := flag.Arg(1)
    mbTrans607 := thrift.NewTMemoryBufferLen(len(arg606))
    defer mbTrans607.Close()
    _, err608 := mbTrans607.WriteString(arg606)
    if err608 != nil {
      Usage()
      return
    }
    factory609 := thrift.NewTJSONProtocolFactory()
    jsProt610 := factory609.GetProtocol(mbTrans607)
    argvalue0 := cluster.NewSendSnapshotRequest()
    err611 := argvalue0.Read(context.Background(), jsProt610)
    if err611 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.SendSnapshot(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeNonQueryPlan":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteNonQueryPlan requires 1 args")
      flag.Usage()
    }
    arg612 := flag.Arg(1)
    mbTrans613 := thrift.NewTMemoryBufferLen(len(arg612))
    defer mbTrans613.Close()
    _, err614 := mbTrans613.WriteString(arg612)
    if err614 != nil {
      Usage()
      return
    }
    factory615 := thrift.NewTJSONProtocolFactory()
    jsProt616 := factory615.GetProtocol(mbTrans613)
    argvalue0 := cluster.NewExecutNonQueryReq()
    err617 := argvalue0.Read(context.Background(), jsProt616)
    if err617 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteNonQueryPlan(context.Background(), value0))
    fmt.Print("\n")
    break
  case "requestCommitIndex":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "RequestCommitIndex requires 1 args")
      flag.Usage()
    }
    arg618 := flag.Arg(1)
    mbTrans619 := thrift.NewTMemoryBufferLen(len(arg618))
    defer mbTrans619.Close()
    _, err620 := mbTrans619.WriteString(arg618)
    if err620 != nil {
      Usage()
      return
    }
    factory621 := thrift.NewTJSONProtocolFactory()
    jsProt622 := factory621.GetProtocol(mbTrans619)
    argvalue0 := cluster.NewRaftNode()
    err623 := argvalue0.Read(context.Background(), jsProt622)
    if err623 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.RequestCommitIndex(context.Background(), value0))
    fmt.Print("\n")
    break
  case "readFile":
    if flag.NArg() - 1 != 3 {
      fmt.Fprintln(os.Stderr, "ReadFile requires 3 args")
      flag.Usage()
    }
    argvalue0 := flag.Arg(1)
    value0 := argvalue0
    argvalue1, err625 := (strconv.ParseInt(flag.Arg(2), 10, 64))
    if err625 != nil {
      Usage()
      return
    }
    value1 := cluster.Long(argvalue1)
    tmp2, err626 := (strconv.Atoi(flag.Arg(3)))
    if err626 != nil {
      Usage()
      return
    }
    argvalue2 := int32(tmp2)
    value2 := cluster.Int(argvalue2)
    fmt.Print(client.ReadFile(context.Background(), value0, value1, value2))
    fmt.Print("\n")
    break
  case "matchTerm":
    if flag.NArg() - 1 != 3 {
      fmt.Fprintln(os.Stderr, "MatchTerm requires 3 args")
      flag.Usage()
    }
    argvalue0, err627 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err627 != nil {
      Usage()
      return
    }
    value0 := cluster.Long(argvalue0)
    argvalue1, err628 := (strconv.ParseInt(flag.Arg(2), 10, 64))
    if err628 != nil {
      Usage()
      return
    }
    value1 := cluster.Long(argvalue1)
    arg629 := flag.Arg(3)
    mbTrans630 := thrift.NewTMemoryBufferLen(len(arg629))
    defer mbTrans630.Close()
    _, err631 := mbTrans630.WriteString(arg629)
    if err631 != nil {
      Usage()
      return
    }
    factory632 := thrift.NewTJSONProtocolFactory()
    jsProt633 := factory632.GetProtocol(mbTrans630)
    argvalue2 := cluster.NewRaftNode()
    err634 := argvalue2.Read(context.Background(), jsProt633)
    if err634 != nil {
      Usage()
      return
    }
    value2 := argvalue2
    fmt.Print(client.MatchTerm(context.Background(), value0, value1, value2))
    fmt.Print("\n")
    break
  case "removeHardLink":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "RemoveHardLink requires 1 args")
      flag.Usage()
    }
    argvalue0 := flag.Arg(1)
    value0 := argvalue0
    fmt.Print(client.RemoveHardLink(context.Background(), value0))
    fmt.Print("\n")
    break
  case "":
    Usage()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid function ", cmd)
  }
}
