/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.rabbitmq.Constant;
import org.apache.iotdb.rabbitmq.RabbitMQChannelUtils;
import org.apache.iotdb.rabbitmq.RabbitMQProducer;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQConsumer {
    private static final Logger logger = LoggerFactory.getLogger(RabbitMQProducer.class);

    public static void main(String[] args) throws Exception {
        final Session session = new Session("localhost", 6667, "root", "root");
        session.open();
        session.setStorageGroup("root.vehicle");
        for (String[] timeseries : Constant.TIMESERIESLIST) {
            RabbitMQConsumer.createTimeseries(session, timeseries);
        }
        final RabbitMQConsumer consumer = new RabbitMQConsumer();
        Channel channel = RabbitMQChannelUtils.getChannelInstance("RabbitMQ-Connection");
        AMQP.Queue.DeclareOk declareOk = channel.queueDeclare("IoTDB_Topic_Queue", true, false, false, new HashMap());
        channel.exchangeDeclare("RabbitMQ-Test", BuiltinExchangeType.TOPIC);
        channel.queueBind(declareOk.getQueue(), "RabbitMQ-Test", "IoTDB.#", new HashMap());
        DefaultConsumer defaultConsumer = new DefaultConsumer(channel){

            public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
                logger.info(consumerTag + ", " + envelope.toString() + ", " + properties.toString());
                try {
                    consumer.insert(session, new String(body));
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        };
        channel.basicConsume(declareOk.getQueue(), true, "IoTDB_CONSUMER_TAG", (Consumer)defaultConsumer);
    }

    private static void createTimeseries(Session session, String[] timeseries) throws StatementExecutionException, IoTDBConnectionException {
        String timeseriesId = timeseries[0];
        TSDataType dataType = TSDataType.valueOf((String)timeseries[1]);
        TSEncoding encoding = TSEncoding.valueOf((String)timeseries[2]);
        CompressionType compressionType = CompressionType.valueOf((String)timeseries[3]);
        session.createTimeseries(timeseriesId, dataType, encoding, compressionType);
    }

    private void insert(Session session, String data) throws IoTDBConnectionException, StatementExecutionException {
        String[] dataArray = data.split(",");
        String device = dataArray[0];
        long time = Long.parseLong(dataArray[1]);
        List<String> measurements = Arrays.asList(dataArray[2].split(":"));
        ArrayList<TSDataType> types = new ArrayList<TSDataType>();
        for (String type : dataArray[3].split(":")) {
            types.add(TSDataType.valueOf((String)type));
        }
        ArrayList<Object> values = new ArrayList<Object>();
        String[] valuesStr = dataArray[4].split(":");
        block9: for (int i = 0; i < valuesStr.length; ++i) {
            switch ((TSDataType)types.get(i)) {
                case INT64: {
                    values.add(Long.parseLong(valuesStr[i]));
                    continue block9;
                }
                case DOUBLE: {
                    values.add(Double.parseDouble(valuesStr[i]));
                    continue block9;
                }
                case INT32: {
                    values.add(Integer.parseInt(valuesStr[i]));
                    continue block9;
                }
                case TEXT: {
                    values.add(valuesStr[i]);
                    continue block9;
                }
                case FLOAT: {
                    values.add(Float.valueOf(Float.parseFloat(valuesStr[i])));
                    continue block9;
                }
                case BOOLEAN: {
                    values.add(Boolean.parseBoolean(valuesStr[i]));
                }
            }
        }
        session.insertRecord(device, time, measurements, types, values);
    }
}

