/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import org.apache.iotdb.rabbitmq.Constant;
import org.apache.iotdb.rabbitmq.RabbitMQChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQProducer {
    private static final Logger logger = LoggerFactory.getLogger(RabbitMQProducer.class);

    public static void main(String[] args) throws IOException, TimeoutException {
        Channel channel = RabbitMQChannelUtils.getChannelInstance("RabbitMQ-Connection");
        channel.exchangeDeclare("RabbitMQ-Test", BuiltinExchangeType.TOPIC);
        AMQP.BasicProperties basicProperties = new AMQP.BasicProperties().builder().deliveryMode(Integer.valueOf(2)).contentType("UTF-8").build();
        for (int i = 0; i < Constant.ALL_DATA.length; ++i) {
            String key = String.format("%s.%s", "IoTDB", Objects.toString(i));
            channel.basicPublish("RabbitMQ-Test", key, false, basicProperties, Constant.ALL_DATA[i].getBytes());
            logger.info(Constant.ALL_DATA[i]);
        }
    }
}

