/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.spark.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.spark.db.IoTDBOptions;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class DataFrameTools$ {
    public static DataFrameTools$ MODULE$;

    static {
        new DataFrameTools$();
    }

    public void insertDataFrame(IoTDBOptions options, Dataset<Row> dataframe) {
        String[] filteredColumns = (String[])((Object[])new String[]{"Time", "Device"});
        Tuple2[] sensorTypes = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataframe.dtypes())).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DataFrameTools$.$anonfun$insertDataFrame$1(filteredColumns, x)));
        dataframe.repartition(new StringOps(Predef$.MODULE$.augmentString(options.numPartition())).toInt()).sortWithinPartitions((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{dataframe.col("Device")})).foreachPartition((Function1 & Serializable & scala.Serializable)partition -> {
            DataFrameTools$.$anonfun$insertDataFrame$2(options, sensorTypes, partition);
            return BoxedUnit.UNIT;
        });
    }

    public Object typeTrans(String value, TSDataType dataType) {
        TSDataType tSDataType = dataType;
        Object object = TSDataType.TEXT.equals(tSDataType) ? value : (TSDataType.BOOLEAN.equals(tSDataType) ? (Serializable)Boolean.valueOf(value) : (Serializable)(TSDataType.INT32.equals(tSDataType) ? (Number)Integer.valueOf(value) : (Number)(TSDataType.INT64.equals(tSDataType) ? (Number)Long.valueOf(value) : (Number)(TSDataType.FLOAT.equals(tSDataType) ? (Number)Float.valueOf(value) : (Number)(TSDataType.DOUBLE.equals(tSDataType) ? Double.valueOf(value) : null)))));
        return object;
    }

    public TSDataType getType(String typeStr) {
        String string = typeStr;
        Object object = "StringType".equals(string) ? TSDataType.TEXT : ("BooleanType".equals(string) ? TSDataType.BOOLEAN : ("IntegerType".equals(string) ? TSDataType.INT32 : ("LongType".equals(string) ? TSDataType.INT64 : ("FloatType".equals(string) ? TSDataType.FLOAT : ("DoubleType".equals(string) ? TSDataType.DOUBLE : null)))));
        return object;
    }

    public void insertAndEmptyDataSet(Session session, String device, ArrayList<Long> times, ArrayList<List<String>> measurementsList, ArrayList<List<TSDataType>> typesList, ArrayList<List<Object>> valuesList) {
        block0: {
            if (valuesList.isEmpty()) break block0;
            session.insertRecordsOfOneDevice(device, times, measurementsList, typesList, valuesList);
            times.clear();
            measurementsList.clear();
            typesList.clear();
            valuesList.clear();
        }
    }

    public static final /* synthetic */ boolean $anonfun$insertDataFrame$1(String[] filteredColumns$1, Tuple2 x) {
        return !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredColumns$1)).contains(x._1());
    }

    public static final /* synthetic */ void $anonfun$insertDataFrame$3(ObjectRef device$1, Session session$1, ArrayList times$1, ArrayList measurementsList$1, ArrayList typesList$1, ArrayList valuesList$1, IntRef currentSize$1, Tuple2[] sensorTypes$1, int batchSize$1, Row record) {
        block4: {
            if ("".equals((String)device$1.elem)) {
                device$1.elem = record.get(1).toString();
            } else if (!((String)device$1.elem).equals(record.get(1).toString())) {
                MODULE$.insertAndEmptyDataSet(session$1, (String)device$1.elem, times$1, measurementsList$1, typesList$1, valuesList$1);
                device$1.elem = record.get(1).toString();
                currentSize$1.elem = 0;
            }
            ArrayList measurements = new ArrayList();
            ArrayList types = new ArrayList();
            ArrayList values = new ArrayList();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(2), record.length()).withFilter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> record.get(i) != null).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> {
                Object value = MODULE$.typeTrans(record.get(i).toString(), MODULE$.getType((String)sensorTypes$1[i - 2]._2()));
                values.add(value);
                measurements.add(sensorTypes$1[i - 2]._1());
                return types.add(MODULE$.getType((String)sensorTypes$1[i - 2]._2()));
            });
            if (!values.isEmpty()) {
                times$1.add(Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)record.get(0))));
                measurementsList$1.add(measurements);
                typesList$1.add(types);
                valuesList$1.add(values);
                ++currentSize$1.elem;
            }
            if (currentSize$1.elem < batchSize$1) break block4;
            MODULE$.insertAndEmptyDataSet(session$1, (String)device$1.elem, times$1, measurementsList$1, typesList$1, valuesList$1);
            currentSize$1.elem = 0;
        }
    }

    public static final /* synthetic */ void $anonfun$insertDataFrame$2(IoTDBOptions options$1, Tuple2[] sensorTypes$1, Iterator partition) {
        String[] hostPort = options$1.url().split("//")[1].replace("/", "").split(":");
        Session session = new Session(hostPort[0], new StringOps(Predef$.MODULE$.augmentString(hostPort[1])).toInt(), options$1.user(), options$1.password());
        session.open();
        ObjectRef device = ObjectRef.create((Object)"");
        ArrayList<Long> times = new ArrayList<Long>();
        ArrayList<List<String>> measurementsList = new ArrayList<List<String>>();
        ArrayList<List<TSDataType>> typesList = new ArrayList<List<TSDataType>>();
        ArrayList<List<Object>> valuesList = new ArrayList<List<Object>>();
        int batchSize = 1000;
        IntRef currentSize = IntRef.create((int)0);
        partition.foreach((Function1 & Serializable & scala.Serializable)record -> {
            DataFrameTools$.$anonfun$insertDataFrame$3(device, session, times, measurementsList, typesList, valuesList, currentSize, sensorTypes$1, batchSize, record);
            return BoxedUnit.UNIT;
        });
        MODULE$.insertAndEmptyDataSet(session, (String)device.elem, times, measurementsList, typesList, valuesList);
        session.close();
    }

    private DataFrameTools$() {
        MODULE$ = this;
    }
}

