/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jpa.eclipselink;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.core.config.IsisConfiguration;
import org.apache.isis.persistence.jpa.eclipselink.config.ElSettings;
import org.apache.isis.persistence.jpa.integration.IsisModulePersistenceJpaIntegration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.orm.jpa.JpaBaseConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.orm.jpa.vendor.AbstractJpaVendorAdapter;
import org.springframework.orm.jpa.vendor.EclipseLinkJpaDialect;
import org.springframework.orm.jpa.vendor.EclipseLinkJpaVendorAdapter;
import org.springframework.transaction.jta.JtaTransactionManager;

@Configuration
@Import(value={IsisModulePersistenceJpaIntegration.class})
@EnableConfigurationProperties(value={ElSettings.class})
public class IsisModulePersistenceJpaEclipselink
extends JpaBaseConfiguration {
    private static final Logger log = LogManager.getLogger(IsisModulePersistenceJpaEclipselink.class);
    @Inject
    private ElSettings elSettings;

    protected IsisModulePersistenceJpaEclipselink(IsisConfiguration isisConfiguration, DataSource dataSource, JpaProperties properties, ObjectProvider<JtaTransactionManager> jtaTransactionManager) {
        super(IsisModulePersistenceJpaEclipselink.autoCreateSchemas(dataSource, isisConfiguration), IsisModulePersistenceJpaEclipselink.addAdditionalOrmFiles(properties, isisConfiguration), jtaTransactionManager);
    }

    protected AbstractJpaVendorAdapter createJpaVendorAdapter() {
        return new EclipseLinkJpaVendorAdapter(){
            private final EclipseLinkJpaDialect jpaDialect;
            {
                this.jpaDialect = IsisModulePersistenceJpaEclipselink.this.eclipselinkJpaDialect();
            }

            public EclipseLinkJpaDialect getJpaDialect() {
                return this.jpaDialect;
            }
        };
    }

    protected Map<String, Object> getVendorProperties() {
        return this.elSettings.asMap();
    }

    protected static DataSource autoCreateSchemas(DataSource dataSource, IsisConfiguration isisConfiguration) {
        IsisConfiguration.Persistence.Schema persistenceSchemaConf = isisConfiguration.getPersistence().getSchema();
        if (!persistenceSchemaConf.getAutoCreateSchemas().isEmpty()) {
            log.info("about to create db schema(s) {}", (Object)persistenceSchemaConf.getAutoCreateSchemas());
            try (Connection con = dataSource.getConnection();){
                Statement s = con.createStatement();
                for (String schema : persistenceSchemaConf.getAutoCreateSchemas()) {
                    s.execute(String.format(persistenceSchemaConf.getCreateSchemaSqlTemplate(), schema));
                }
            }
        }
        return dataSource;
    }

    protected static JpaProperties addAdditionalOrmFiles(JpaProperties properties, IsisConfiguration isisConfiguration) {
        IsisConfiguration.Persistence.Schema persistenceSchemaConf = isisConfiguration.getPersistence().getSchema();
        persistenceSchemaConf.getAdditionalOrmFiles().forEach(schema -> properties.getMappingResources().add(String.format("META-INF/orm-%s.xml", schema)));
        if (!properties.getMappingResources().isEmpty()) {
            log.info("using mapping-resources {}", (Object)properties.getMappingResources());
        }
        return properties;
    }

    private EclipseLinkJpaDialect eclipselinkJpaDialect() {
        final SQLExceptionTranslator jdbcExceptionTranslator = IsisModulePersistenceJpaEclipselink.newJdbcExceptionTranslator(this.getDataSource());
        return new EclipseLinkJpaDialect(){

            public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
                DataAccessException translatedEx;
                if (ex instanceof DataAccessException) {
                    return (DataAccessException)ex;
                }
                if (this.getJdbcExceptionTranslator() != null && ex.getCause() instanceof SQLException && (translatedEx = this.getJdbcExceptionTranslator().translate("JPA operation: " + ex.getMessage(), this.extractSqlStringFromException(ex), (SQLException)ex.getCause())) != null) {
                    return translatedEx;
                }
                translatedEx = super.translateExceptionIfPossible(ex);
                if ((translatedEx == null || JpaSystemException.class.equals(translatedEx.getClass())) && this.getJdbcExceptionTranslator() != null) {
                    DataAccessException translatedSqlEx = _Exceptions.streamCausalChain((Throwable)ex).filter(nextEx -> nextEx instanceof SQLException).map(SQLException.class::cast).map(nextEx -> this.getJdbcExceptionTranslator().translate("JPA operation: " + nextEx.getMessage(), this.extractSqlStringFromException((Throwable)nextEx), nextEx)).findFirst().orElse(null);
                    if (translatedSqlEx != null) {
                        return translatedSqlEx;
                    }
                }
                return translatedEx;
            }

            private String extractSqlStringFromException(Throwable ex) {
                return null;
            }

            private SQLExceptionTranslator getJdbcExceptionTranslator() {
                return jdbcExceptionTranslator;
            }
        };
    }

    private static SQLExceptionTranslator newJdbcExceptionTranslator(Object connectionFactory) {
        if (connectionFactory instanceof DataSource) {
            return new SQLErrorCodeSQLExceptionTranslator((DataSource)connectionFactory);
        }
        return new SQLStateSQLExceptionTranslator();
    }
}

