/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jpa.eclipselink.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.isis.applib.services.inject.ServiceInjector;
import org.apache.isis.commons.internal.base._Lazy;
import org.apache.isis.persistence.jpa.eclipselink.inject.BeanManagerForEntityListeners;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@Named(value="isis.persistence.jpa.ElSettings")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="Eclipselink")
@ConfigurationProperties(prefix="", ignoreUnknownFields=true)
public class ElSettings {
    @Inject
    private Provider<ServiceInjector> serviceInjectorProvider;
    private Map<String, String> eclipselink = Collections.emptyMap();
    private final _Lazy<Map<String, Object>> map = _Lazy.threadSafe(this::createMap);

    public Map<String, Object> asMap() {
        return (Map)this.map.get();
    }

    protected Map<String, Object> createMap() {
        HashMap<String, Object> jpaProps = new HashMap<String, Object>();
        jpaProps.put("eclipselink.weaving", "false");
        jpaProps.put("eclipselink.ddl-generation", "create-or-extend-tables");
        jpaProps.put("javax.persistence.bean.manager", new BeanManagerForEntityListeners(this.serviceInjectorProvider));
        this.getEclipselink().forEach((k, v) -> jpaProps.put("eclipselink." + k, v));
        return jpaProps;
    }

    public Map<String, String> getEclipselink() {
        return this.eclipselink;
    }

    public void setEclipselink(Map<String, String> eclipselink) {
        this.eclipselink = eclipselink;
    }
}

