/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.actionresponse;

import lombok.NonNull;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.value.OpenUrlStrategy;
import org.apache.isis.viewer.wicket.model.util.PageParameterUtils;
import org.apache.isis.viewer.wicket.ui.actionresponse.ActionResultResponseHandlingStrategy;
import org.apache.isis.viewer.wicket.ui.actionresponse.PageRedirectRequest;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.component.IRequestablePage;

public class ActionResultResponse {
    private final ActionResultResponseHandlingStrategy handlingStrategy;
    private final IRequestHandler handler;
    private final PageRedirectRequest<?> pageRedirect;
    private final AjaxRequestTarget target;
    private final String url;

    public static ActionResultResponse withHandler(IRequestHandler handler) {
        return new ActionResultResponse(ActionResultResponseHandlingStrategy.SCHEDULE_HANDLER, handler, null, null, null);
    }

    public static ActionResultResponse toPage(PageRedirectRequest<?> page) {
        return new ActionResultResponse(ActionResultResponseHandlingStrategy.REDIRECT_TO_PAGE, null, page, null, null);
    }

    public static <T extends IRequestablePage> ActionResultResponse toPage(@NonNull Class<T> pageClass, @NonNull Bookmark bookmark) {
        if (pageClass == null) {
            throw new NullPointerException("pageClass is marked non-null but is null");
        }
        if (bookmark == null) {
            throw new NullPointerException("bookmark is marked non-null but is null");
        }
        return ActionResultResponse.toPage(PageRedirectRequest.forPageClass(pageClass, PageParameterUtils.createPageParametersForBookmark((Bookmark)bookmark)));
    }

    public static <T extends IRequestablePage> ActionResultResponse toPage(@NonNull Class<T> pageClass, @NonNull T pageInstance) {
        if (pageClass == null) {
            throw new NullPointerException("pageClass is marked non-null but is null");
        }
        if (pageInstance == null) {
            throw new NullPointerException("pageInstance is marked non-null but is null");
        }
        return ActionResultResponse.toPage(PageRedirectRequest.forPage(pageClass, pageInstance));
    }

    public static <T extends IRequestablePage> ActionResultResponse toPage(@NonNull Class<T> pageClass) {
        if (pageClass == null) {
            throw new NullPointerException("pageClass is marked non-null but is null");
        }
        return ActionResultResponse.toPage(PageRedirectRequest.forPageClass(pageClass));
    }

    public static ActionResultResponse openUrlInBrowser(AjaxRequestTarget target, String url, @NonNull OpenUrlStrategy openUrlStrategy) {
        if (openUrlStrategy == null) {
            throw new NullPointerException("openUrlStrategy is marked non-null but is null");
        }
        return new ActionResultResponse(openUrlStrategy.isNewWindow() ? ActionResultResponseHandlingStrategy.OPEN_URL_IN_NEW_BROWSER_WINDOW : ActionResultResponseHandlingStrategy.OPEN_URL_IN_SAME_BROWSER_WINDOW, null, null, target, url);
    }

    private ActionResultResponse(ActionResultResponseHandlingStrategy strategy, IRequestHandler handler, PageRedirectRequest<?> pageRedirect, AjaxRequestTarget target, String url) {
        this.handlingStrategy = strategy;
        this.handler = handler;
        this.pageRedirect = pageRedirect;
        this.target = target;
        this.url = url;
    }

    public ActionResultResponseHandlingStrategy getHandlingStrategy() {
        return this.handlingStrategy;
    }

    public IRequestHandler getHandler() {
        return this.handler;
    }

    public PageRedirectRequest<?> getPageRedirect() {
        return this.pageRedirect;
    }

    public AjaxRequestTarget getTarget() {
        return this.target;
    }

    public String getUrl() {
        return this.url;
    }

    public String toString() {
        return String.format("ActionResultResponse[handlingStrategy=%s,requestHandler=%s,pageRedirect=%s,ajaxTarget=%s,url=%s]", this.handlingStrategy.name(), this.handler, this.pageRedirect, this.target, this.url);
    }

    public String toStringMultiline() {
        return String.format("ActionResultResponse {\n\thandlingStrategy=%s,\n\trequestHandler=%s,\n\tpageRedirect=%s,\n\tajaxTarget=%s,\n\turl=%s\n}", this.handlingStrategy.name(), this.handler, this.pageRedirect, this.target, this.url);
    }
}

