/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.actionresponse;

import java.time.Duration;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.viewer.wicket.model.models.RedirectRequestHandlerWithOpenUrlStrategy;
import org.apache.isis.viewer.wicket.model.models.VoidModel;
import org.apache.isis.viewer.wicket.ui.actionresponse.ActionResultResponse;
import org.apache.isis.viewer.wicket.ui.pages.voidreturn.VoidReturnPage;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.util.resource.IResourceStream;

public enum ActionResultResponseHandlingStrategy {
    REDIRECT_TO_VOID{

        @Override
        public void handleResults(MetaModelContext commonContext, ActionResultResponse resultResponse) {
            RequestCycle requestCycle = RequestCycle.get();
            requestCycle.setResponsePage((IRequestablePage)new VoidReturnPage(new VoidModel(commonContext)));
        }
    }
    ,
    REDIRECT_TO_PAGE{

        @Override
        public void handleResults(MetaModelContext commonContext, ActionResultResponse resultResponse) {
            commonContext.getTransactionService().flushTransaction();
            resultResponse.getPageRedirect().applyTo(RequestCycle.get());
        }
    }
    ,
    SCHEDULE_HANDLER{

        @Override
        public void handleResults(MetaModelContext commonContext, ActionResultResponse resultResponse) {
            RequestCycle requestCycle = RequestCycle.get();
            AjaxRequestTarget target = requestCycle.find(AjaxRequestTarget.class).orElse(null);
            if (target == null) {
                requestCycle.scheduleRequestHandlerAfterCurrent(resultResponse.getHandler());
            } else {
                IRequestHandler requestHandler = resultResponse.getHandler();
                if (requestHandler instanceof ResourceStreamRequestHandler) {
                    ResourceStreamRequestHandler scheduledHandler = (ResourceStreamRequestHandler)requestHandler;
                    StreamAfterAjaxResponseBehavior streamingBehavior = new StreamAfterAjaxResponseBehavior(scheduledHandler);
                    Page page = target.getPage();
                    page.add(new Behavior[]{streamingBehavior});
                    CharSequence callbackUrl = streamingBehavior.getCallbackUrl();
                    ActionResultResponseHandlingStrategy.scheduleJs(target, ActionResultResponseHandlingStrategy.javascriptFor_sameWindow(callbackUrl), 10);
                } else if (requestHandler instanceof RedirectRequestHandlerWithOpenUrlStrategy) {
                    RedirectRequestHandlerWithOpenUrlStrategy redirectHandler = (RedirectRequestHandlerWithOpenUrlStrategy)requestHandler;
                    String url = redirectHandler.getRedirectUrl();
                    String fullUrl = 3.expanded(requestCycle, url);
                    if (redirectHandler.getOpenUrlStrategy().isNewWindow()) {
                        ActionResultResponseHandlingStrategy.scheduleJs(target, ActionResultResponseHandlingStrategy.javascriptFor_newWindow(fullUrl), 100);
                    } else {
                        ActionResultResponseHandlingStrategy.scheduleJs(target, ActionResultResponseHandlingStrategy.javascriptFor_sameWindow(fullUrl), 100);
                    }
                } else {
                    throw _Exceptions.unrecoverable((String)"no logic implemented to handle IRequestHandler of type %s", (Object[])new Object[]{requestHandler.getClass().getName()});
                }
            }
        }
    }
    ,
    OPEN_URL_IN_NEW_BROWSER_WINDOW{

        @Override
        public void handleResults(MetaModelContext commonContext, ActionResultResponse resultResponse) {
            AjaxRequestTarget target = resultResponse.getTarget();
            String url = resultResponse.getUrl();
            RequestCycle requestCycle = RequestCycle.get();
            String fullUrl = 4.expanded(requestCycle, url);
            ActionResultResponseHandlingStrategy.scheduleJs(target, ActionResultResponseHandlingStrategy.javascriptFor_newWindow(fullUrl), 100);
        }
    }
    ,
    OPEN_URL_IN_SAME_BROWSER_WINDOW{

        @Override
        public void handleResults(MetaModelContext commonContext, ActionResultResponse resultResponse) {
            AjaxRequestTarget target = resultResponse.getTarget();
            String url = resultResponse.getUrl();
            RequestCycle requestCycle = RequestCycle.get();
            String fullUrl = 5.expanded(requestCycle, url);
            ActionResultResponseHandlingStrategy.scheduleJs(target, ActionResultResponseHandlingStrategy.javascriptFor_sameWindow(fullUrl), 100);
        }
    };


    public abstract void handleResults(MetaModelContext var1, ActionResultResponse var2);

    public static String expanded(RequestCycle requestCycle, String url) {
        String urlStr = ActionResultResponseHandlingStrategy.expanded(url);
        return requestCycle.getUrlRenderer().renderFullUrl(Url.parse((CharSequence)urlStr));
    }

    public static String expanded(String urlStr) {
        if (urlStr.contains("antiCache=${currentTimeMillis}")) {
            urlStr = urlStr.replace("antiCache=${currentTimeMillis}", "antiCache=" + System.currentTimeMillis());
        }
        return urlStr;
    }

    private static String javascriptFor_newWindow(CharSequence url) {
        return "function(){Wicket.Event.publish(Isis.Topic.OPEN_IN_NEW_TAB, '" + url + "');}";
    }

    private static String javascriptFor_sameWindow(CharSequence url) {
        return "\"window.location.href='" + url + "'\"";
    }

    private static void scheduleJs(AjaxRequestTarget target, String js, int millis) {
        target.appendJavaScript((CharSequence)String.format("setTimeout(%s, %d);", js, millis));
    }

    private static class StreamAfterAjaxResponseBehavior
    extends AbstractAjaxBehavior {
        private static final long serialVersionUID = 1L;
        private final String fileName;
        private final IResourceStream resourceStream;
        private final Duration cacheDuration;

        public StreamAfterAjaxResponseBehavior(ResourceStreamRequestHandler scheduledHandler) {
            this.fileName = scheduledHandler.getFileName();
            this.resourceStream = scheduledHandler.getResourceStream();
            this.cacheDuration = scheduledHandler.getCacheDuration();
        }

        public void onRequest() {
            ResourceStreamRequestHandler handler = new ResourceStreamRequestHandler(this.resourceStream, this.fileName);
            handler.setCacheDuration(this.cacheDuration);
            handler.setContentDisposition(ContentDisposition.ATTACHMENT);
            Component page = this.getComponent();
            page.getRequestCycle().scheduleRequestHandlerAfterCurrent((IRequestHandler)handler);
            page.remove(new Behavior[]{this});
        }
    }
}

