/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components;

import org.apache.isis.core.config.IsisConfiguration;
import org.apache.isis.core.config.viewer.web.WebAppContextPath;
import org.apache.isis.core.metamodel.context.HasMetaModelContext;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.viewer.wicket.model.util.WktContext;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;

public abstract class LabelBase
extends Label
implements HasMetaModelContext {
    private static final long serialVersionUID = 1L;
    private transient IsisConfiguration isisConfiguration;
    private transient WebAppContextPath webAppContextPath;
    private transient MetaModelContext commonContext;

    public LabelBase(String id) {
        super(id);
    }

    public LabelBase(String id, IModel<?> model) {
        super(id, model);
    }

    public MetaModelContext getMetaModelContext() {
        this.commonContext = WktContext.computeIfAbsent((MetaModelContext)this.commonContext);
        return this.commonContext;
    }

    public IsisConfiguration getIsisConfiguration() {
        this.isisConfiguration = this.computeIfAbsent(IsisConfiguration.class, this.isisConfiguration);
        return this.isisConfiguration;
    }

    public WebAppContextPath getWebAppContextPath() {
        this.webAppContextPath = this.computeIfAbsent(WebAppContextPath.class, this.webAppContextPath);
        return this.webAppContextPath;
    }

    private <X> X computeIfAbsent(Class<X> type, X existingIfAny) {
        return (X)(existingIfAny != null ? existingIfAny : this.getMetaModelContext().lookupServiceElseFail(type));
    }
}

