/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.actionmenu;

import lombok.NonNull;
import org.apache.isis.applib.layout.component.CssClassFaPosition;
import org.apache.isis.viewer.commons.model.decorators.IconDecorator;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;

public class CssClassFaBehavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final IconDecorator.FontAwesomeDecorationModel fontAwesomeDecorationModel;

    public void beforeRender(Component component) {
        super.beforeRender(component);
        CssClassFaPosition position = this.fontAwesomeDecorationModel.getPosition();
        if (position == null || CssClassFaPosition.LEFT == position) {
            String cssClassFa = this.fontAwesomeDecorationModel.getCssClassesSpaceSeparated();
            component.getResponse().write((CharSequence)("<span class=\"" + cssClassFa + " fontAwesomeIcon\"></span>"));
        }
    }

    public void afterRender(Component component) {
        CssClassFaPosition position = this.fontAwesomeDecorationModel.getPosition();
        if (CssClassFaPosition.RIGHT == position) {
            String cssClassFa = this.fontAwesomeDecorationModel.getCssClassesSpaceSeparated();
            component.getResponse().write((CharSequence)("<span class=\"" + cssClassFa + " fontAwesomeIcon\"></span>"));
        }
        super.afterRender(component);
    }

    public CssClassFaBehavior(@NonNull IconDecorator.FontAwesomeDecorationModel fontAwesomeDecorationModel) {
        if (fontAwesomeDecorationModel == null) {
            throw new NullPointerException("fontAwesomeDecorationModel is marked non-null but is null");
        }
        this.fontAwesomeDecorationModel = fontAwesomeDecorationModel;
    }
}

