/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.actionmenu.serviceactions;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.viewer.commons.model.decorators.DisablingDecorator;
import org.apache.isis.viewer.commons.model.decorators.IconDecorator;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.serviceactions.CssSubMenuItemsPanel;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.isis.viewer.wicket.ui.util.WktComponents;
import org.apache.isis.viewer.wicket.ui.util.WktDecorators;
import org.apache.isis.viewer.wicket.ui.util.WktTooltips;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

class CssMenuItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ID_MENU_LINK = "menuLink";
    private static final String ID_MENU_LABEL = "menuLabel";
    private static final String ID_SUB_MENU_ITEMS = "subMenuItems";
    private final String name;
    private LinkAndLabel linkAndLabel;
    private final List<CssMenuItem> subMenuItems = _Lists.newArrayList();
    private CssMenuItem parent;
    private final MenuItemType itemType;

    public static CssMenuItem newMenuItem(String name) {
        return new CssMenuItem(name, MenuItemType.ACTION_OR_SUBMENU_CONTAINER);
    }

    private CssMenuItem(String name, MenuItemType itemType) {
        this.name = name;
        this.itemType = itemType;
    }

    protected void addSubMenuItem(CssMenuItem cssMenuItem) {
        this.subMenuItems.add(cssMenuItem);
    }

    public List<CssMenuItem> getSubMenuItems() {
        return Collections.unmodifiableList(this.subMenuItems);
    }

    public void replaceSubMenuItems(List<CssMenuItem> menuItems) {
        this.subMenuItems.clear();
        this.subMenuItems.addAll(menuItems);
    }

    public boolean hasSubMenuItems() {
        return this.subMenuItems.size() > 0;
    }

    void addTo(MarkupContainer markupContainer) {
        Component menuItemComponent = this.addMenuItemComponentTo(markupContainer);
        this.addSubMenuItemComponentsIfAnyTo(markupContainer);
        this.addCssClassAttributesIfRequired(menuItemComponent);
    }

    private Component addMenuItemComponentTo(MarkupContainer markupContainer) {
        LinkAndLabel linkAndLabel = this.getLinkAndLabel();
        ObjectAction actionMeta = this.getLinkAndLabel().getManagedAction().getAction();
        AjaxLink actionLink = this.getLinkAndLabel().getUiComponent();
        Label label = Wkt.labelAdd(markupContainer, ID_MENU_LABEL, (IModel<String>)((IModel & Serializable)this::getName));
        if (actionLink != null) {
            markupContainer.add(new Component[]{actionLink});
            actionLink.add(new Component[]{label});
            linkAndLabel.getDescription().ifPresent(describedAs -> WktTooltips.addTooltip(actionLink, describedAs));
            if (ObjectAction.Util.returnsBlobOrClob((ObjectAction)actionMeta)) {
                Wkt.cssAppend(actionLink, "noVeil");
            }
            if (actionMeta.isPrototype()) {
                Wkt.cssAppend(actionLink, "prototype");
            }
            linkAndLabel.getAdditionalCssClass().ifPresent(cssClass -> Wkt.cssAppend(actionLink, cssClass));
            Wkt.cssAppend(actionLink, linkAndLabel.getFeatureIdentifier());
            Optional fontAwesome = this.getLinkAndLabel().getFontAwesomeUiModel();
            WktDecorators.getIcon().decorate((Component)label, (Optional<IconDecorator.FontAwesomeDecorationModel>)fontAwesome);
            linkAndLabel.getDisableUiModel().ifPresent(disableUiModel -> WktDecorators.getDisable().decorate((Component)actionLink, (DisablingDecorator.DisablingDecorationModel)disableUiModel));
            WktComponents.permanentlyHide(markupContainer, ID_MENU_LABEL);
            return actionLink;
        }
        WktComponents.permanentlyHide(markupContainer, ID_MENU_LINK);
        linkAndLabel.getDisableUiModel().ifPresent(disableUiModel -> WktTooltips.addTooltip(label, disableUiModel.getReason()));
        label.add(new Behavior[]{new AttributeModifier("class", (IModel)Model.of((Serializable)((Object)"disabled")))});
        markupContainer.add(new Component[]{label});
        return label;
    }

    private void addSubMenuItemComponentsIfAnyTo(MarkupContainer menuItemMarkup) {
        List<CssMenuItem> subMenuItems = this.getSubMenuItems();
        if (subMenuItems.isEmpty()) {
            WktComponents.permanentlyHide(menuItemMarkup, ID_SUB_MENU_ITEMS);
        } else {
            menuItemMarkup.add(new Component[]{new CssSubMenuItemsPanel(ID_SUB_MENU_ITEMS, subMenuItems)});
        }
    }

    private void addCssClassAttributesIfRequired(Component linkComponent) {
        if (!this.hasSubMenuItems()) {
            return;
        }
        Wkt.cssAppend(linkComponent, this.hasParent() ? "parent" : "top-parent");
    }

    protected void setParent(CssMenuItem parent) {
        this.parent = parent;
        parent.addSubMenuItem((CssMenuItem)_Casts.uncheckedCast((Object)this));
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public static CssMenuItem newSpacer() {
        return new CssMenuItem("---", MenuItemType.SPACER);
    }

    public static CssMenuItem newSectionLabel(String named) {
        return new CssMenuItem(named, MenuItemType.SECTION_LABEL);
    }

    public String getName() {
        return this.name;
    }

    public LinkAndLabel getLinkAndLabel() {
        return this.linkAndLabel;
    }

    public void setLinkAndLabel(LinkAndLabel linkAndLabel) {
        this.linkAndLabel = linkAndLabel;
    }

    public CssMenuItem getParent() {
        return this.parent;
    }

    public MenuItemType getItemType() {
        return this.itemType;
    }

    public static enum MenuItemType {
        SPACER,
        SECTION_LABEL,
        ACTION_OR_SUBMENU_CONTAINER;


        boolean isActionOrSubMenuContainer() {
            return this == ACTION_OR_SUBMENU_CONTAINER;
        }
    }
}

