/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.actionmenu.serviceactions;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.interactions.managed.ManagedAction;
import org.apache.isis.core.metamodel.object.ManagedObject;
import org.apache.isis.viewer.commons.applib.services.menu.MenuItemDto;
import org.apache.isis.viewer.commons.applib.services.menu.MenuUiModel;
import org.apache.isis.viewer.commons.applib.services.menu.MenuVisitor;
import org.apache.isis.viewer.commons.model.decorators.IconDecorator;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.models.UiObjectWkt;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.LinkAndLabelFactory;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.serviceactions.CssMenuItem;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.isis.viewer.wicket.ui.util.WktDecorators;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public final class ServiceActionUtil {
    static void addLeafItem(MetaModelContext commonContext, CssMenuItem menuItem, ListItem<CssMenuItem> listItem, MarkupContainer parent) {
        LinkAndLabel actionUiModel = menuItem.getLinkAndLabel();
        AjaxLink menuItemActionLink = actionUiModel.getUiComponent();
        Label menuItemLabel = Wkt.labelAdd((MarkupContainer)menuItemActionLink, "menuLinkLabel", menuItem.getName());
        WktDecorators.getActionLink().decorateMenuItem((Component)listItem, actionUiModel, commonContext.getTranslationService());
        Optional fontAwesome = actionUiModel.getFontAwesomeUiModel();
        WktDecorators.getIcon().decorate((Component)menuItemLabel, (Optional<IconDecorator.FontAwesomeDecorationModel>)fontAwesome);
        WktDecorators.getMissingIcon().decorate((Component)menuItemActionLink, (Optional<IconDecorator.FontAwesomeDecorationModel>)fontAwesome);
        Fragment leafItem = new Fragment("content", "leafItem", parent);
        leafItem.add(new Component[]{menuItemActionLink});
        listItem.add(new Component[]{leafItem});
    }

    static void addFolderItem(MetaModelContext commonContext, CssMenuItem subMenuItem, ListItem<CssMenuItem> listItem, MarkupContainer parent) {
        Wkt.cssAppend(listItem, "dropdown-submenu");
        Fragment folderItem = new Fragment("content", "folderItem", parent);
        listItem.add(new Component[]{folderItem});
        Wkt.labelAdd((MarkupContainer)folderItem, "folderName", (IModel<String>)(IModel & Serializable)() -> subMenuItem.getLinkAndLabel().getFriendlyName());
        List<CssMenuItem> menuItems = subMenuItem.getSubMenuItems();
        Wkt.listViewAdd((MarkupContainer)folderItem, "subMenuItems", menuItems, (SerializableConsumer & Serializable)item -> {
            CssMenuItem menuItem = (CssMenuItem)listItem.getModelObject();
            if (menuItem.hasSubMenuItems()) {
                ServiceActionUtil.addFolderItem(commonContext, menuItem, (ListItem<CssMenuItem>)item, parent);
            } else {
                ServiceActionUtil.addLeafItem(commonContext, menuItem, (ListItem<CssMenuItem>)item, parent);
            }
        });
    }

    public static void buildMenu(MetaModelContext commonContext, MenuUiModel menuUiModel, Consumer<CssMenuItem> onNewMenuItem) {
        menuUiModel.buildMenuItems(commonContext.getMetaModelContext(), (MenuVisitor)MenuBuilderWkt.of(commonContext, onNewMenuItem));
    }

    private ServiceActionUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class MenuBuilderWkt
    implements MenuVisitor {
        private final MetaModelContext commonContext;
        private final Consumer<CssMenuItem> onNewMenuItem;
        private CssMenuItem currentTopLevelMenu = null;

        public void addTopLevel(MenuItemDto menuDto) {
            this.currentTopLevelMenu = CssMenuItem.newMenuItem(menuDto.getName());
            this.onNewMenuItem.accept(this.currentTopLevelMenu);
        }

        public void addSectionSpacer() {
            CssMenuItem menuSection = CssMenuItem.newSpacer();
            this.currentTopLevelMenu.addSubMenuItem(menuSection);
        }

        public void addSubMenu(MenuItemDto menuDto) {
            ManagedAction managedAction = menuDto.getManagedAction();
            CssMenuItem menuItem = CssMenuItem.newMenuItem(menuDto.getName());
            this.currentTopLevelMenu.addSubMenuItem(menuItem);
            menuItem.setLinkAndLabel(this.newActionLink(managedAction));
        }

        public void addSectionLabel(String named) {
            CssMenuItem menuSectionLabel = CssMenuItem.newSectionLabel(named);
            this.currentTopLevelMenu.addSubMenuItem(menuSectionLabel);
        }

        private LinkAndLabel newActionLink(ManagedAction managedAction) {
            UiObjectWkt serviceModel = UiObjectWkt.ofAdapter((MetaModelContext)this.commonContext, (ManagedObject)managedAction.getOwner());
            return (LinkAndLabel)LinkAndLabelFactory.forMenu(serviceModel).apply(managedAction.getAction());
        }

        private MenuBuilderWkt(MetaModelContext commonContext, Consumer<CssMenuItem> onNewMenuItem) {
            this.commonContext = commonContext;
            this.onNewMenuItem = onNewMenuItem;
        }

        public static MenuBuilderWkt of(MetaModelContext commonContext, Consumer<CssMenuItem> onNewMenuItem) {
            return new MenuBuilderWkt(commonContext, onNewMenuItem);
        }
    }
}

