/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.actions;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.commons.functional.Either;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.core.metamodel.interactions.managed.ParameterNegotiationModel;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.viewer.commons.model.components.UiComponentType;
import org.apache.isis.viewer.commons.model.decorators.ConfirmDecorator;
import org.apache.isis.viewer.commons.model.layout.UiPlacementDirection;
import org.apache.isis.viewer.commons.model.scalar.UiParameter;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.ScalarParameterModel;
import org.apache.isis.viewer.wicket.model.models.ScalarPropertyModel;
import org.apache.isis.viewer.wicket.model.models.interaction.act.UiParameterWkt;
import org.apache.isis.viewer.wicket.ui.components.actions._Xray;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.isis.viewer.wicket.ui.panels.PromptFormAbstract;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.isis.viewer.wicket.ui.util.WktDecorators;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;

class ActionParametersForm
extends PromptFormAbstract<ActionModel> {
    private static final long serialVersionUID = 1L;

    public ActionParametersForm(String id, Component parentPanel, ActionModel actionModel) {
        super(id, parentPanel, actionModel);
    }

    protected ActionModel actionModel() {
        return (ActionModel)super.getModel();
    }

    @Override
    protected void addParameters() {
        ActionModel actionModel = this.actionModel();
        RepeatingView repeatingView = Wkt.add((MarkupContainer)this, new RepeatingView("parameters"));
        this.paramPanels.clear();
        actionModel.streamPendingParamUiModels().map(UiParameterWkt.class::cast).forEach(paramModel -> {
            WebMarkupContainer container = Wkt.containerAdd((MarkupContainer)repeatingView, repeatingView.newChildId());
            this.newParamPanel(container, (UiParameterWkt)paramModel, this.paramPanels::add);
        });
        this.setOutputMarkupId(true);
    }

    private void newParamPanel(WebMarkupContainer container, UiParameterWkt paramModel, Consumer<ScalarPanelAbstract> onNewScalarPanel) {
        ScalarParameterModel scalarParamModel = ScalarParameterModel.wrap((UiParameterWkt)paramModel);
        Component component = this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)container, "scalarNameAndValue", UiComponentType.SCALAR_NAME_AND_VALUE, (IModel<?>)scalarParamModel);
        _Casts.castTo(ScalarPanelAbstract.class, (Object)component).ifPresent(scalarPanel -> {
            scalarPanel.addChangeListener(this);
            onNewScalarPanel.accept((ScalarPanelAbstract)scalarPanel);
        });
    }

    @Override
    protected void configureOkButton(AjaxButton okButton) {
        this.applyAreYouSure(okButton);
    }

    private void applyAreYouSure(AjaxButton button) {
        ActionModel actionModel = this.actionModel();
        ObjectAction action = actionModel.getAction();
        if (action.getSemantics().isAreYouSure()) {
            ConfirmDecorator.ConfirmDecorationModel confirmUiModel = ConfirmDecorator.ConfirmDecorationModel.areYouSure((TranslationService)this.getTranslationService(), (UiPlacementDirection)UiPlacementDirection.BOTTOM);
            WktDecorators.getConfirm().decorate((Component)button, confirmUiModel);
        }
    }

    @Override
    public void onUpdate(AjaxRequestTarget target, ScalarPanelAbstract scalarPanelUpdated) {
        ActionModel actionModel = this.actionModel();
        UiParameter updatedParamModel = (UiParameter)scalarPanelUpdated.getModel();
        ParameterNegotiationModel paramNegotiationModel = updatedParamModel.getParameterNegotiationModel();
        int paramNumberUpdated = updatedParamModel.getParameterIndex();
        _Xray.beforeParamFormUpdate(paramNumberUpdated, paramNegotiationModel);
        int skipCount = paramNumberUpdated + 1;
        int paramCount = updatedParamModel.getMetaModel().getAction().getParameterCount();
        int maxCapacity = paramCount - skipCount;
        ArrayList paramOnlyUpdateRequestsHavingParamIndex = _Lists.newArrayList((int)maxCapacity);
        ScalarPanelAbstract.Repaint formRepaint = actionModel.streamPendingParamUiModels().skip(skipCount).map(paramModel -> {
            int paramIndexForReassessment = paramModel.getParameterIndex();
            ObjectActionParameter actionParameter = paramModel.getMetaModel();
            actionParameter.reassessDefault(paramNegotiationModel);
            _Xray.reassessedDefault(paramIndexForReassessment, paramNegotiationModel);
            ScalarPanelAbstract paramPanel = (ScalarPanelAbstract)this.paramPanels.get(paramIndexForReassessment);
            ScalarPanelAbstract.Repaint paramRepaint = paramPanel.updateIfNecessary((UiParameter)paramModel, Optional.of(target));
            if (paramRepaint.isParamOnly()) {
                paramOnlyUpdateRequestsHavingParamIndex.add(paramIndexForReassessment);
            }
            return paramRepaint;
        }).reduce(ScalarPanelAbstract.Repaint.NOTHING, (a, b) -> a.ordinal() > b.ordinal() ? a : b);
        switch (formRepaint) {
            case ENTIRE_FORM: {
                target.add(new Component[]{this});
                break;
            }
            case PARAM_ONLY: {
                paramOnlyUpdateRequestsHavingParamIndex.forEach(paramIndex -> {
                    ScalarPanelAbstract paramPanel = (ScalarPanelAbstract)this.paramPanels.get((int)paramIndex);
                    paramPanel.repaint(target);
                });
                break;
            }
            case NOTHING: {
                break;
            }
            default: {
                throw _Exceptions.unmatchedCase((Object)((Object)formRepaint));
            }
        }
        _Xray.afterParamFormUpdate(paramNumberUpdated, paramNegotiationModel);
    }

    @Override
    protected Either<ActionModel, ScalarPropertyModel> getMemberModel() {
        return Either.left((Object)this.actionModel());
    }
}

