/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collection;

import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import java.util.Optional;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.core.metamodel.interactions.managed.nonscalar.DataTableModel;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.viewer.commons.model.components.UiComponentType;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModelParented;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.LinkAndLabelFactory;
import org.apache.isis.viewer.wicket.ui.components.collection.bulk.MultiselectToggleProvider;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionPresentationSelectorPanel;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionPresentationSelectorProvider;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.GenericToggleboxColumn;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.feedback.ComponentFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.model.IModel;

public class CollectionPanel
extends PanelAbstract<DataTableModel, EntityCollectionModelParented>
implements CollectionPresentationSelectorProvider,
MultiselectToggleProvider {
    private static final long serialVersionUID = 1L;
    private static final String ID_FEEDBACK = "feedback";
    private CollectionPresentationSelectorPanel selectorDropdownPanel;
    private transient Optional<GenericToggleboxColumn> toggleboxColumn;

    public CollectionPanel(String id, EntityCollectionModelParented collectionModel) {
        super(id, collectionModel);
        OneToManyAssociation collMetaModel = ((EntityCollectionModelParented)this.getModel()).getMetaModel();
        Can associatedActions = (Can)collMetaModel.streamAssociatedActions().map(LinkAndLabelFactory.forCollection(collectionModel)).collect(Can.toCan());
        collectionModel.setLinkAndLabels((Iterable)associatedActions);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.buildGui();
    }

    private void buildGui() {
        Component collectionContents = this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)this, UiComponentType.COLLECTION_CONTENTS, (IModel<?>)this.getModel());
        this.addOrReplace(new Component[]{new NotificationPanel(ID_FEEDBACK, collectionContents, (IFeedbackMessageFilter)new ComponentFeedbackMessageFilter(collectionContents))});
        this.setOutputMarkupId(true);
    }

    @Override
    public GenericToggleboxColumn getToggleboxColumn() {
        if (this.toggleboxColumn == null) {
            EntityCollectionModelParented collModel = (EntityCollectionModelParented)this.getModel();
            OneToManyAssociation collMetaModel = collModel.getMetaModel();
            this.toggleboxColumn = collMetaModel.hasAssociatedActionsWithChoicesFromThisCollection() ? Optional.of(new GenericToggleboxColumn(super.getMetaModelContext(), (IModel<DataTableModel>)collModel.delegate())) : Optional.empty();
        }
        return this.toggleboxColumn.orElse(null);
    }

    @Override
    public CollectionPresentationSelectorPanel getSelectorDropdownPanel() {
        return this.selectorDropdownPanel;
    }

    public void setSelectorDropdownPanel(CollectionPresentationSelectorPanel selectorDropdownPanel) {
        this.selectorDropdownPanel = selectorDropdownPanel;
    }
}

