/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collection.selector;

import java.io.Serializable;
import java.util.List;
import org.apache.isis.core.metamodel.commons.StringExtensions;
import org.apache.isis.core.metamodel.interactions.managed.nonscalar.DataTableModel;
import org.apache.isis.viewer.commons.model.components.UiComponentType;
import org.apache.isis.viewer.commons.model.layout.UiPlacementDirection;
import org.apache.isis.viewer.wicket.model.hints.IsisSelectorEvent;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.model.util.ComponentHintKey;
import org.apache.isis.viewer.wicket.ui.CollectionContentsAsFactory;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionPresentationSelectorHelper;
import org.apache.isis.viewer.wicket.ui.components.widgets.links.AjaxLinkNoPropagate;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.isis.viewer.wicket.ui.util.WktLinks;
import org.apache.isis.viewer.wicket.ui.util.WktTooltips;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.DownloadLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public class CollectionPresentationSelectorPanel
extends PanelAbstract<DataTableModel, EntityCollectionModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_VIEWS = "views";
    private static final String ID_VIEW_LIST = "viewList";
    private static final String ID_VIEW_LINK = "viewLink";
    private static final String ID_VIEW_ITEM = "viewItem";
    private static final String ID_VIEW_ITEM_TITLE = "viewItemTitle";
    private static final String ID_VIEW_ITEM_ICON = "viewItemIcon";
    private static final String ID_VIEW_BUTTON_TITLE = "viewButtonTitle";
    private static final String ID_VIEW_BUTTON_ICON = "viewButtonIcon";
    private final CollectionPresentationSelectorHelper selectorHelper;
    private final ComponentHintKey componentHintKey;
    private ComponentFactory selectedComponentFactory;

    public CollectionPresentationSelectorPanel(String id, EntityCollectionModel model) {
        this(id, model, ComponentHintKey.noop());
    }

    public CollectionPresentationSelectorPanel(String id, EntityCollectionModel model, ComponentHintKey componentHintKey) {
        super(id, model);
        this.componentHintKey = componentHintKey;
        this.selectorHelper = new CollectionPresentationSelectorHelper(model, this.getComponentFactoryRegistry(), componentHintKey);
    }

    public void onInitialize() {
        super.onInitialize();
        this.addDropdown();
    }

    private void addDropdown() {
        List<ComponentFactory> componentFactories = this.selectorHelper.getComponentFactories();
        String selected = this.selectorHelper.honourViewHintElseDefault((Component)this);
        if (componentFactories.size() <= 1) {
            this.permanentlyHide(ID_VIEWS);
            return;
        }
        this.selectedComponentFactory = this.selectorHelper.find(selected);
        WebMarkupContainer views = new WebMarkupContainer(ID_VIEWS);
        WebMarkupContainer container = new WebMarkupContainer(ID_VIEW_LIST);
        WktTooltips.addTooltip(UiPlacementDirection.TOP, views, this.translate("Click to change view or see export options."));
        views.addOrReplace(new Component[]{container});
        views.setOutputMarkupId(true);
        this.setOutputMarkupId(true);
        Label viewButtonTitle = Wkt.labelAdd((MarkupContainer)views, ID_VIEW_BUTTON_TITLE, this.translate("Hidden"));
        Label viewButtonIcon = Wkt.labelAdd((MarkupContainer)views, ID_VIEW_BUTTON_ICON, "");
        Wkt.listViewAdd((MarkupContainer)container, ID_VIEW_ITEM, componentFactories, (SerializableConsumer & Serializable)item -> {
            boolean isSelected;
            ComponentFactory componentFactory = (ComponentFactory)item.getModelObject();
            if (componentFactory.getComponentType() == UiComponentType.COLLECTION_CONTENTS_EXPORT) {
                DownloadLink downloadLink = (DownloadLink)componentFactory.createComponent(ID_VIEW_LINK, (IModel<?>)this.getModel());
                item.addOrReplace(new Component[]{downloadLink});
                WktLinks.listItemAsDropdownLink(item, downloadLink, ID_VIEW_ITEM_TITLE, CollectionPresentationSelectorPanel::nameFor, ID_VIEW_ITEM_ICON, null, CollectionPresentationSelectorPanel::cssClassFor);
                return;
            }
            AjaxLinkNoPropagate link = Wkt.linkAdd((MarkupContainer)item, ID_VIEW_LINK, (SerializableConsumer<AjaxRequestTarget>)(SerializableConsumer & Serializable)target -> {
                CollectionPresentationSelectorPanel linksSelectorPanel = this;
                linksSelectorPanel.setViewHintAndBroadcast(componentFactory.getName(), (AjaxRequestTarget)target);
                linksSelectorPanel.selectedComponentFactory = componentFactory;
                ((EntityCollectionModel)this.getModel()).parentedHintingBookmark().ifPresent(bookmark -> this.componentHintKey.set(bookmark, componentFactory.getName()));
                target.add(new Component[]{linksSelectorPanel, views});
            });
            WktLinks.listItemAsDropdownLink(item, link, ID_VIEW_ITEM_TITLE, CollectionPresentationSelectorPanel::nameFor, ID_VIEW_ITEM_ICON, null, CollectionPresentationSelectorPanel::cssClassFor);
            boolean bl = isSelected = componentFactory == this.selectedComponentFactory;
            if (isSelected) {
                viewButtonTitle.setDefaultModel(CollectionPresentationSelectorPanel.nameFor(componentFactory));
                IModel<String> cssClass = CollectionPresentationSelectorPanel.cssClassFor(componentFactory, viewButtonIcon);
                Wkt.cssReplace(viewButtonIcon, "ViewLinkItem " + (String)cssClass.getObject());
                link.setVisible(false);
            }
        });
        this.addOrReplace(new Component[]{views});
    }

    private static IModel<String> cssClassFor(ComponentFactory componentFactory, Label viewIcon) {
        Model cssClass = null;
        if (componentFactory instanceof CollectionContentsAsFactory) {
            CollectionContentsAsFactory collectionContentsAsFactory = (CollectionContentsAsFactory)((Object)componentFactory);
            cssClass = collectionContentsAsFactory.getCssClass();
            viewIcon.setDefaultModelObject((Object)"");
            viewIcon.setEscapeModelStrings(true);
        }
        if (cssClass == null) {
            String name = componentFactory.getName();
            cssClass = Model.of((Serializable)((Object)StringExtensions.asLowerDashed((String)name)));
            viewIcon.setDefaultModelObject((Object)"&#160;&#160;&#160;&#160;&#160;");
            viewIcon.setEscapeModelStrings(false);
        }
        return cssClass;
    }

    private static IModel<String> nameFor(ComponentFactory componentFactory) {
        Model name = null;
        if (componentFactory instanceof CollectionContentsAsFactory) {
            CollectionContentsAsFactory collectionContentsAsFactory = (CollectionContentsAsFactory)((Object)componentFactory);
            name = collectionContentsAsFactory.getTitleLabel();
        }
        if (name == null) {
            name = Model.of((Serializable)((Object)componentFactory.getName()));
        }
        return name;
    }

    protected void setViewHintAndBroadcast(String viewName, AjaxRequestTarget target) {
        CollectionPresentationSelectorPanel component = this;
        this.send((IEventSink)this.getPage(), Broadcast.EXACT, new IsisSelectorEvent((Component)component, "selectedItem", viewName, target));
    }
}

