/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.interactions.managed.nonscalar.DataRow;
import org.apache.isis.core.metamodel.object.ManagedObject;
import org.apache.isis.core.metamodel.object.ManagedObjects;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.models.UiObjectWkt;
import org.apache.isis.viewer.wicket.model.models.interaction.coll.DataRowWkt;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.CollectionContentsSortableDataProvider;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.IsisAjaxHeadersToolbar;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.IsisAjaxNavigationToolbar;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.IsisTotalRecordsToolbar;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.GenericToggleboxColumn;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.NoRecordsToolbar;
import org.apache.wicket.markup.repeater.IItemFactory;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;

public class IsisAjaxDataTable
extends DataTable<DataRow, String> {
    private static final long serialVersionUID = 1L;
    static final String UIHINT_PAGE_NUMBER = "pageNumber";
    private final CollectionContentsSortableDataProvider dataProvider;
    private final GenericToggleboxColumn toggleboxColumn;
    private IsisAjaxHeadersToolbar headersToolbar;
    private IsisAjaxNavigationToolbar navigationToolbar;

    public IsisAjaxDataTable(String id, List<? extends IColumn<DataRow, String>> columns, CollectionContentsSortableDataProvider dataProvider, int rowsPerPage, GenericToggleboxColumn toggleboxColumn) {
        super(id, columns, (IDataProvider)dataProvider, (long)rowsPerPage);
        this.dataProvider = dataProvider;
        this.toggleboxColumn = toggleboxColumn;
        this.setOutputMarkupId(true);
        this.setVersioned(false);
        this.setItemReuseStrategy(IsisAjaxDataTable::itemReuseStrategyWithCast);
    }

    public void setPageNumberHintAndBroadcast(AjaxRequestTarget target) {
        UiHintContainer uiHintContainer = this.getUiHintContainer();
        if (uiHintContainer == null) {
            return;
        }
        uiHintContainer.setHint((Component)this, UIHINT_PAGE_NUMBER, "" + this.getCurrentPage());
    }

    public void setSortOrderHintAndBroadcast(SortOrder order, String property, AjaxRequestTarget target) {
        UiHintContainer uiHintContainer = this.getUiHintContainer();
        if (uiHintContainer == null) {
            return;
        }
        for (SortOrder eachSortOrder : SortOrder.values()) {
            uiHintContainer.clearHint((Component)this, eachSortOrder.name());
        }
        uiHintContainer.setHint((Component)this, order.name(), property);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.buildGui();
        this.honorHints();
    }

    private void buildGui() {
        this.headersToolbar = new IsisAjaxHeadersToolbar(this, this.dataProvider);
        this.addTopToolbar(this.headersToolbar);
        this.navigationToolbar = new IsisAjaxNavigationToolbar(this, this.toggleboxColumn);
        this.addBottomToolbar((AbstractToolbar)this.navigationToolbar);
        this.addBottomToolbar((AbstractToolbar)new NoRecordsToolbar((DataTable)this));
        this.addBottomToolbar(new IsisTotalRecordsToolbar(this));
    }

    protected void onConfigure() {
        super.onConfigure();
    }

    protected Item<DataRow> newRowItem(String id, int index, IModel<DataRow> model) {
        return Wkt.oddEvenItem(id, index, model, IsisAjaxDataTable::cssClassForRow);
    }

    private static String cssClassForRow(DataRow model) {
        if (model == null || ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)model.getRowElement())) {
            return null;
        }
        ManagedObject rowElement = model.getRowElement();
        return rowElement.getSpecification().getCssClass(rowElement);
    }

    private static Iterator<Item<DataRow>> itemReuseStrategy(final IItemFactory<DataRow> factory, final Iterator<IModel<DataRow>> newModels, Iterator<Item<DataRow>> existingItems) {
        final HashMap itemByUuid = _Maps.newHashMap();
        existingItems.forEachRemaining(item -> {
            IModel model = item.getModel();
            if (model instanceof DataRowWkt) {
                DataRowWkt dataRowWkt = (DataRowWkt)item.getModel();
                itemByUuid.put(dataRowWkt.getUuid(), item);
            }
        });
        return new Iterator<Item<DataRow>>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return newModels.hasNext();
            }

            @Override
            public Item<DataRow> next() {
                DataRowWkt newModel = (DataRowWkt)newModels.next();
                Item oldItem = (Item)itemByUuid.get(newModel.getUuid());
                DataRowWkt model2 = oldItem != null ? oldItem.getModel() : newModel;
                return factory.newItem(this.index++, (IModel)model2);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static <T> Iterator<Item<T>> itemReuseStrategyWithCast(IItemFactory<T> factory, Iterator<IModel<T>> newModels, Iterator<Item<T>> existingItems) {
        return (Iterator)_Casts.uncheckedCast(IsisAjaxDataTable.itemReuseStrategy((IItemFactory<DataRow>)((IItemFactory)_Casts.uncheckedCast(factory)), (Iterator)_Casts.uncheckedCast(newModels), (Iterator)_Casts.uncheckedCast(existingItems)));
    }

    private void honorHints() {
        this.headersToolbar.honourSortOrderHints();
        this.navigationToolbar.honourHints();
        this.honourPageNumberHint();
    }

    private void honourPageNumberHint() {
        UiHintContainer uiHintContainer = this.getUiHintContainer();
        if (uiHintContainer == null) {
            return;
        }
        String pageNumberStr = uiHintContainer.getHint((Component)this, UIHINT_PAGE_NUMBER);
        if (pageNumberStr != null) {
            try {
                long pageNumber = Long.parseLong(pageNumberStr);
                if (pageNumber >= 0L) {
                    this.setCurrentPage(pageNumber);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        uiHintContainer.setHint((Component)this, UIHINT_PAGE_NUMBER, "" + this.getCurrentPage());
    }

    private UiHintContainer getUiHintContainer() {
        return UiHintContainer.Util.hintContainerOf((Component)this, UiObjectWkt.class);
    }
}

