/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable;

import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.IsisAjaxDataTable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.sort.AjaxFallbackOrderByBorder;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortState;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;

public class IsisAjaxFallbackOrderByBorder<T>
extends AjaxFallbackOrderByBorder<T> {
    private static final long serialVersionUID = 1L;
    private final T sortProperty;
    private final IsisAjaxDataTable dataTable;
    private final ISortStateLocator<T> stateLocator;

    public IsisAjaxFallbackOrderByBorder(String id, IsisAjaxDataTable dataTable, T sortProperty, ISortStateLocator<T> stateLocator) {
        super(id, sortProperty, stateLocator);
        this.dataTable = dataTable;
        this.stateLocator = stateLocator;
        this.sortProperty = sortProperty;
    }

    protected void onAjaxClick(AjaxRequestTarget target) {
        target.add(new Component[]{this.dataTable});
        UiHintContainer uiHintContainer = this.getUiHintContainer();
        if (uiHintContainer == null) {
            return;
        }
        ISortState state = this.stateLocator.getSortState();
        SortOrder order = state.getPropertySortOrder(this.sortProperty);
        this.dataTable.setSortOrderHintAndBroadcast(order, this.sortProperty.toString(), target);
        this.dataTable.setPageNumberHintAndBroadcast(target);
    }

    protected void onSortChanged() {
        super.onSortChanged();
        this.dataTable.setCurrentPage(0L);
    }

    public UiHintContainer getUiHintContainer() {
        return UiHintContainer.Util.hintContainerOf((Component)this.dataTable);
    }
}

