/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable;

import java.io.Serializable;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.models.HasCommonContext;
import org.apache.isis.viewer.wicket.model.models.UiObjectWkt;
import org.apache.isis.viewer.wicket.model.util.WktContext;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.CollectionContentsSortableDataProvider;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.IsisAjaxPagingNavigator;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.PrototypingMessageProvider;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.GenericToggleboxColumn;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxNavigationToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.navigation.paging.PagingNavigator;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public class IsisAjaxNavigationToolbar
extends AjaxNavigationToolbar
implements HasCommonContext {
    private static final long serialVersionUID = 1L;
    private static final String navigatorContainerId = "span";
    private static final String ID_SHOW_ALL = "showAll";
    private static final String HINT_KEY_SHOW_ALL = "showAll";
    private final GenericToggleboxColumn toggleboxColumn;
    private transient MetaModelContext mmc;

    public IsisAjaxNavigationToolbar(DataTable<?, ?> table, GenericToggleboxColumn toggleboxColumn) {
        super(table);
        this.toggleboxColumn = toggleboxColumn;
        this.addShowAllButton(table);
    }

    protected PagingNavigator newPagingNavigator(String navigatorId, DataTable<?, ?> table) {
        return new IsisAjaxPagingNavigator(navigatorId, (IPageable)table);
    }

    private void addShowAllButton(DataTable<?, ?> table) {
        table.setOutputMarkupId(true);
        MarkupContainer container = this.navigatorContainer();
        Wkt.linkAdd(container, "showAll", (SerializableConsumer<AjaxRequestTarget>)(SerializableConsumer & Serializable)target -> {
            UiHintContainer hintContainer;
            IsisAjaxNavigationToolbar.showAllItemsOn(table);
            DataTable dataTable = this.getTable();
            CollectionContentsSortableDataProvider dataProvider = (CollectionContentsSortableDataProvider)dataTable.getDataProvider();
            if (this.toggleboxColumn != null) {
                dataProvider.getDataTableModel().getSelectAllToggle().setValue((Object)false);
                this.toggleboxColumn.removeToggles();
            }
            if ((hintContainer = this.getUiHintContainer()) != null) {
                hintContainer.setHint((Component)table, "showAll", "true");
            }
            target.add(new Component[]{table});
        });
        Wkt.labelAdd(container, "prototypingLabel", new PrototypingMessageProvider(this.getMetaModelContext()).getTookTimingMessageModel());
    }

    private MarkupContainer navigatorContainer() {
        return (MarkupContainer)this.get(navigatorContainerId);
    }

    void honourHints() {
        UiHintContainer uiHintContainer = this.getUiHintContainer();
        if (uiHintContainer == null) {
            return;
        }
        DataTable table = this.getTable();
        String showAll = uiHintContainer.getHint((Component)table, "showAll");
        if (showAll != null) {
            IsisAjaxNavigationToolbar.showAllItemsOn(table);
        }
    }

    static void showAllItemsOn(DataTable<?, ?> table) {
        table.setItemsPerPage(Long.MAX_VALUE);
    }

    private UiHintContainer getUiHintContainer() {
        return UiHintContainer.Util.hintContainerOf((Component)this, UiObjectWkt.class);
    }

    public MetaModelContext getMetaModelContext() {
        this.mmc = WktContext.computeIfAbsent((MetaModelContext)this.mmc);
        return this.mmc;
    }
}

