/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns;

import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.interactions.managed.nonscalar.DataRow;
import org.apache.isis.core.metamodel.object.ManagedObject;
import org.apache.isis.core.metamodel.object.ManagedObjects;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.viewer.commons.model.components.UiComponentType;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.model.models.UiObjectWkt;
import org.apache.isis.viewer.wicket.model.models.ValueModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.GenericColumnAbstract;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.springframework.lang.Nullable;

public final class GenericTitleColumn
extends GenericColumnAbstract {
    private static final long serialVersionUID = 1L;
    private final EntityCollectionModel.Variant variant;
    private Bookmark contextBookmark;

    public GenericTitleColumn(MetaModelContext commonContext, EntityCollectionModel.Variant variant, Bookmark contextBookmark, int maxTitleLength) {
        super(commonContext, GenericTitleColumn.columnName(variant, maxTitleLength));
        this.variant = variant;
        this.contextBookmark = contextBookmark;
    }

    public void populateItem(Item<ICellPopulator<DataRow>> cellItem, String componentId, IModel<DataRow> rowModel) {
        cellItem.add(new Component[]{this.createComponent(componentId, rowModel)});
        Wkt.cssAppend(cellItem, "title-column");
    }

    private static String columnName(@Nullable EntityCollectionModel.Variant variant, int maxTitleLength) {
        if (maxTitleLength == 0) {
            return "";
        }
        return (variant.isParented() ? "Related " : "") + "Object";
    }

    private Component createComponent(String id, IModel<DataRow> rowModel) {
        DataRow dataRow = (DataRow)rowModel.getObject();
        ManagedObject adapter = dataRow.getRowElement();
        if (ManagedObjects.isValue((ManagedObject)adapter)) {
            ObjectMember objectMember = dataRow.getParentTable().getMetaModel();
            ValueModel valueModel = ValueModel.of((MetaModelContext)super.getMetaModelContext(), (ObjectMember)objectMember, (ManagedObject)adapter);
            ComponentFactory componentFactory = this.findComponentFactory(UiComponentType.VALUE, (IModel<?>)valueModel);
            return componentFactory.createComponent(id, (IModel<?>)valueModel);
        }
        UiObjectWkt uiObject = UiObjectWkt.ofAdapterForCollection((MetaModelContext)super.getMetaModelContext(), (ManagedObject)adapter, (EntityCollectionModel.Variant)this.variant);
        uiObject.setContextBookmarkIfAny(this.contextBookmark);
        ComponentFactory componentFactory = this.findComponentFactory(UiComponentType.ENTITY_LINK, (IModel<?>)uiObject);
        return componentFactory.createComponent(id, (IModel<?>)uiObject);
    }
}

