/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns;

import java.io.Serializable;
import java.util.List;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.interactions.managed.nonscalar.DataRow;
import org.apache.isis.core.metamodel.interactions.managed.nonscalar.DataTableModel;
import org.apache.isis.viewer.wicket.model.models.interaction.coll.DataRowWkt;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.BulkToggleWkt;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.GenericColumnAbstract;
import org.apache.isis.viewer.wicket.ui.components.widgets.checkbox.ContainedToggleboxPanel;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;

public final class GenericToggleboxColumn
extends GenericColumnAbstract {
    private static final long serialVersionUID = 1L;
    private IModel<DataTableModel> dataTableModelHolder;
    private final List<ContainedToggleboxPanel> rowToggles = _Lists.newArrayList();

    public GenericToggleboxColumn(MetaModelContext commonContext, IModel<DataTableModel> dataTableModelHolder) {
        super(commonContext, "");
        this.dataTableModelHolder = dataTableModelHolder;
    }

    public Component getHeader(String componentId) {
        ContainedToggleboxPanel bulkToggle = new ContainedToggleboxPanel(componentId, (IModel<Boolean>)new BulkToggleWkt(this.dataTableModelHolder), (SerializableBiConsumer<Boolean, AjaxRequestTarget>)((SerializableBiConsumer & Serializable)this::onBulkUpdate));
        Wkt.cssAppend(bulkToggle, "title-column");
        return bulkToggle;
    }

    private void onBulkUpdate(Boolean isChecked, AjaxRequestTarget target) {
        BulkToggle bulkToggle = BulkToggle.valueOf(isChecked);
        for (ContainedToggleboxPanel rowToggle : this.rowToggles) {
            rowToggle.set(bulkToggle, target);
        }
    }

    public void populateItem(Item<ICellPopulator<DataRow>> cellItem, String componentId, IModel<DataRow> rowModel) {
        Wkt.cssAppend(cellItem, "togglebox-column");
        MarkupContainer row = cellItem.getParent().getParent();
        row.setOutputMarkupId(true);
        ContainedToggleboxPanel rowToggle = new ContainedToggleboxPanel(componentId, (IModel<Boolean>)((DataRowWkt)rowModel).getDataRowToggle());
        this.rowToggles.add(rowToggle);
        rowToggle.setOutputMarkupId(true);
        cellItem.add(new Component[]{rowToggle});
    }

    public void removeToggles() {
        this.rowToggles.clear();
    }

    public static enum BulkToggle {
        CLEAR_ALL,
        SET_ALL;


        static BulkToggle valueOf(boolean b) {
            return b ? SET_ALL : CLEAR_ALL;
        }

        public boolean isSetAll() {
            return this == SET_ALL;
        }
    }
}

