/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.icons;

import java.util.List;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.interactions.managed.nonscalar.DataRow;
import org.apache.isis.core.metamodel.interactions.managed.nonscalar.DataTableModel;
import org.apache.isis.core.metamodel.object.ManagedObject;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.model.models.UiObjectWkt;
import org.apache.isis.viewer.wicket.ui.components.entity.header.EntityHeaderPanel;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.markup.repeater.RepeatingView;

public class CollectionContentsAsIconsPanel
extends PanelAbstract<DataTableModel, EntityCollectionModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_ENTITY_INSTANCE = "entityInstance";

    public CollectionContentsAsIconsPanel(String id, EntityCollectionModel model) {
        super(id, model);
        this.buildGui();
    }

    private void buildGui() {
        EntityCollectionModel model = (EntityCollectionModel)this.getModel();
        List visibleAdapters = ((Can)model.getDataTableModel().getDataRowsFiltered().getValue()).map(DataRow::getRowElement).toList();
        RepeatingView entityInstances = new RepeatingView(ID_ENTITY_INSTANCE);
        this.add(new Component[]{entityInstances});
        for (ManagedObject adapter : visibleAdapters) {
            String childId = entityInstances.newChildId();
            UiObjectWkt entityModel = UiObjectWkt.ofAdapter((MetaModelContext)super.getMetaModelContext(), (ManagedObject)adapter);
            EntityHeaderPanel entitySummaryPanel = new EntityHeaderPanel(childId, entityModel);
            entityInstances.add(new Component[]{entitySummaryPanel});
        }
    }
}

