/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.entity;

import org.apache.isis.core.metamodel.object.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.commons.model.components.UiComponentType;
import org.apache.isis.viewer.wicket.model.models.UiObjectWkt;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentFactoryAbstract;
import org.apache.wicket.model.IModel;

public abstract class EntityComponentFactoryAbstract
extends ComponentFactoryAbstract {
    private static final long serialVersionUID = 1L;

    public EntityComponentFactoryAbstract(UiComponentType uiComponentType, Class<?> componentClass) {
        super(uiComponentType, componentClass);
    }

    public EntityComponentFactoryAbstract(UiComponentType uiComponentType, String name, Class<?> componentClass) {
        super(uiComponentType, name, componentClass);
    }

    @Override
    protected ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
        ObjectSpecification spec;
        if (!(model instanceof UiObjectWkt)) {
            return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
        }
        UiObjectWkt entityModel = (UiObjectWkt)model;
        ManagedObject adapter = entityModel.getManagedObject();
        if (adapter == null) {
            // empty if block
        }
        if ((spec = entityModel.getTypeOfSpecification()).isSingular() && !spec.isValue()) {
            return this.doAppliesTo(entityModel);
        }
        return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
    }

    protected ComponentFactory.ApplicationAdvice doAppliesTo(UiObjectWkt entityModel) {
        return ComponentFactory.ApplicationAdvice.APPLIES;
    }
}

