/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.entity.collection;

import java.util.List;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.core.config.metamodel.facets.CollectionLayoutConfigOptions;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.object.ManagedObject;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.util.Facets;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModelParented;
import org.apache.isis.viewer.wicket.model.models.UiObjectWkt;
import org.apache.isis.viewer.wicket.model.util.ComponentHintKey;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.AdditionalLinksPanel;
import org.apache.isis.viewer.wicket.ui.components.collection.CollectionPanel;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionPresentationSelectorHelper;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionPresentationSelectorPanel;
import org.apache.isis.viewer.wicket.ui.panels.HasDynamicallyVisibleContent;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.isis.viewer.wicket.ui.util.WktComponents;
import org.apache.isis.viewer.wicket.ui.util.WktTooltips;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;

public class EntityCollectionPanel
extends PanelAbstract<ManagedObject, UiObjectWkt>
implements HasDynamicallyVisibleContent {
    private static final long serialVersionUID = 1L;
    private static final String ID_COLLECTION_GROUP = "collectionGroup";
    private static final String ID_COLLECTION_NAME = "collectionName";
    private static final String ID_COLLECTION = "collection";
    private static final String ID_ADDITIONAL_LINKS = "additionalLinks";
    private static final String ID_SELECTOR_DROPDOWN = "selectorDropdown";
    private final ComponentHintKey selectedItemHintKey;
    private boolean visible = false;
    private CollectionPresentationSelectorPanel selectorDropdownPanel;
    private final WebMarkupContainer div = new WebMarkupContainer("collectionGroup");

    public EntityCollectionPanel(String id, UiObjectWkt entityModel) {
        super(id, entityModel);
        this.selectedItemHintKey = ComponentHintKey.create((MetaModelContext)super.getMetaModelContext(), this::getSelectorDropdownPanel, (String)"selectedItem");
        this.buildGui();
    }

    public void onInitialize() {
        super.onInitialize();
        EntityCollectionPanel panel = this;
        if (this.visible) {
            panel.add(new Component[]{this.div});
            this.setOutputMarkupId(true);
        } else {
            WktComponents.permanentlyHide((MarkupContainer)panel, this.div.getId());
        }
    }

    private void buildGui() {
        EntityCollectionModelParented collectionModel = EntityCollectionModelParented.forParentObjectModel((UiObjectWkt)((UiObjectWkt)this.getModel()));
        this.div.setMarkupId("collection-" + collectionModel.getLayoutData().getId());
        OneToManyAssociation collectionMetaModel = collectionModel.getMetaModel();
        Wkt.cssAppend(this.div, collectionModel.getIdentifier());
        Wkt.cssAppend(this.div, collectionModel.getElementType().getFeatureIdentifier());
        ManagedObject objectAdapter = (ManagedObject)((UiObjectWkt)this.getModel()).getObject();
        Consent visibility = collectionMetaModel.isVisible(objectAdapter, InteractionInitiatedBy.USER, Where.OBJECT_FORMS);
        if (visibility.isAllowed()) {
            this.visible = true;
            Facets.cssClass((FacetHolder)collectionMetaModel, (ManagedObject)objectAdapter).ifPresent(cssClass -> Wkt.cssAppend(this.div, cssClass));
            Facets.tableDecoration((FacetHolder)collectionMetaModel).map(CollectionLayoutConfigOptions.TableDecoration::cssClass).ifPresent(tableDecorationCssClass -> Wkt.cssAppend(this.div, tableDecorationCssClass));
            CollectionPanel collectionPanel = new CollectionPanel(ID_COLLECTION, collectionModel);
            this.div.addOrReplace(new Component[]{collectionPanel});
            Label labelComponent = Wkt.label(ID_COLLECTION_NAME, collectionMetaModel.getFriendlyName(() -> ((EntityCollectionModelParented)collectionModel).getParentObject()));
            labelComponent.setEscapeModelStrings(true);
            this.div.add(new Component[]{labelComponent});
            collectionMetaModel.getDescription(() -> ((EntityCollectionModelParented)collectionModel).getParentObject()).ifPresent(description -> WktTooltips.addTooltip(labelComponent, description));
            Can links = collectionModel.getLinks();
            AdditionalLinksPanel.addAdditionalLinks((MarkupContainer)this.div, ID_ADDITIONAL_LINKS, (Can<LinkAndLabel>)links, AdditionalLinksPanel.Style.INLINE_LIST);
            this.createSelectorDropdownPanel((EntityCollectionModel)collectionModel);
            collectionPanel.setSelectorDropdownPanel(this.selectorDropdownPanel);
        }
    }

    private void createSelectorDropdownPanel(EntityCollectionModel collectionModel) {
        CollectionPresentationSelectorHelper selectorHelper = new CollectionPresentationSelectorHelper(collectionModel, this.getComponentFactoryRegistry(), this.selectedItemHintKey);
        List<ComponentFactory> componentFactories = selectorHelper.getComponentFactories();
        if (componentFactories.size() <= 1) {
            this.permanentlyHide(ID_SELECTOR_DROPDOWN);
        } else {
            this.selectorDropdownPanel = new CollectionPresentationSelectorPanel(ID_SELECTOR_DROPDOWN, collectionModel, this.selectedItemHintKey);
            this.div.addOrReplace(new Component[]{this.selectorDropdownPanel});
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    protected CollectionPresentationSelectorPanel getSelectorDropdownPanel() {
        return this.selectorDropdownPanel;
    }
}

