/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.entity.header;

import org.apache.isis.commons.collections.Can;
import org.apache.isis.core.metamodel.object.ManagedObject;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.viewer.commons.model.components.UiComponentType;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.models.UiObjectWkt;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.AdditionalLinksPanel;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.LinkAndLabelFactory;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.model.IModel;

public class EntityHeaderPanel
extends PanelAbstract<ManagedObject, UiObjectWkt> {
    private static final long serialVersionUID = 1L;
    private static final String ID_ENTITY_ACTIONS = "entityActions";

    public EntityHeaderPanel(String id, UiObjectWkt entityModel) {
        super(id, entityModel);
    }

    public UiObjectWkt getEntityModel() {
        return (UiObjectWkt)this.getModel();
    }

    protected void onBeforeRender() {
        this.buildGui();
        super.onBeforeRender();
    }

    private void buildGui() {
        this.addOrReplaceIconAndTitle();
        this.buildEntityActionsGui();
    }

    private void addOrReplaceIconAndTitle() {
        ComponentFactory componentFactory = this.getComponentFactoryRegistry().findComponentFactory(UiComponentType.ENTITY_ICON_TITLE_AND_COPYLINK, (IModel<?>)this.getEntityModel());
        Component component = componentFactory.createComponent((IModel<?>)this.getEntityModel());
        this.addOrReplace(new Component[]{component});
    }

    private void buildEntityActionsGui() {
        UiObjectWkt model = (UiObjectWkt)this.getModel();
        ManagedObject adapter = (ManagedObject)model.getObject();
        if (adapter != null) {
            Can topLevelActions = (Can)ObjectAction.Util.streamTopBarActions((ManagedObject)adapter).map(LinkAndLabelFactory.forEntity(model)).collect(Can.toCan());
            AdditionalLinksPanel.addAdditionalLinks((MarkupContainer)this, ID_ENTITY_ACTIONS, (Can<LinkAndLabel>)topLevelActions, AdditionalLinksPanel.Style.INLINE_LIST);
        } else {
            this.permanentlyHide(ID_ENTITY_ACTIONS);
        }
    }
}

