/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.layout.bs.row;

import org.apache.isis.applib.layout.grid.bootstrap.BSClearFix;
import org.apache.isis.applib.layout.grid.bootstrap.BSCol;
import org.apache.isis.applib.layout.grid.bootstrap.BSRow;
import org.apache.isis.applib.layout.grid.bootstrap.BSRowContent;
import org.apache.isis.core.metamodel.object.ManagedObject;
import org.apache.isis.viewer.wicket.model.models.UiObjectWkt;
import org.apache.isis.viewer.wicket.ui.components.layout.bs.clearfix.ClearFix;
import org.apache.isis.viewer.wicket.ui.components.layout.bs.col.Col;
import org.apache.isis.viewer.wicket.ui.components.layout.bs.col.RepeatingViewWithDynamicallyVisibleContent;
import org.apache.isis.viewer.wicket.ui.panels.HasDynamicallyVisibleContent;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.isis.viewer.wicket.ui.util.WktComponents;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;

public class Row
extends PanelAbstract<ManagedObject, UiObjectWkt>
implements HasDynamicallyVisibleContent {
    private static final long serialVersionUID = 1L;
    private static final String ID_ROW_CONTENTS = "rowContents";
    private final BSRow bsRow;
    private boolean visible = false;

    public Row(String id, UiObjectWkt entityModel, BSRow bsRow) {
        super(id, entityModel);
        this.bsRow = bsRow;
        this.buildGui();
    }

    private void buildGui() {
        RepeatingViewWithDynamicallyVisibleContent rv = new RepeatingViewWithDynamicallyVisibleContent(ID_ROW_CONTENTS);
        for (BSRowContent bsRowContent : this.bsRow.getCols()) {
            PanelAbstract rowContent;
            String id = rv.newChildId();
            if (bsRowContent instanceof BSCol) {
                BSCol bsCol = (BSCol)bsRowContent;
                Col col = new Col(id, (UiObjectWkt)this.getModel(), bsCol);
                this.visible = this.visible || col.isVisible();
                rowContent = col;
            } else if (bsRowContent instanceof BSClearFix) {
                BSClearFix bsClearFix = (BSClearFix)bsRowContent;
                rowContent = new ClearFix(id, (UiObjectWkt)this.getModel(), bsClearFix);
            } else {
                throw new IllegalStateException("Unrecognized implementation of BSRowContent");
            }
            rv.add(new Component[]{rowContent});
        }
        Row panel = this;
        if (this.visible) {
            Wkt.cssAppend(panel, "row");
            Wkt.cssAppend(panel, this.bsRow.getCssClass());
            panel.add(new Component[]{rv});
        } else {
            WktComponents.permanentlyHide((MarkupContainer)panel, rv.getId());
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }
}

