/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.layout.bs.tabs;

import de.agilecoders.wicket.core.markup.html.bootstrap.tabs.AjaxBootstrapTabbedPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.isis.applib.layout.grid.bootstrap.BSTab;
import org.apache.isis.applib.layout.grid.bootstrap.BSTabGroup;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.viewer.wicket.model.models.UiObjectWkt;
import org.apache.isis.viewer.wicket.model.util.ComponentHintKey;
import org.apache.isis.viewer.wicket.ui.components.layout.bs.col.RepeatingViewWithDynamicallyVisibleContent;
import org.apache.isis.viewer.wicket.ui.components.layout.bs.tabs.TabPanel;
import org.apache.isis.viewer.wicket.ui.panels.HasDynamicallyVisibleContent;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.extensions.markup.html.tabs.TabbedPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class TabGroupPanel
extends AjaxBootstrapTabbedPanel<ITab>
implements HasDynamicallyVisibleContent {
    private static final long serialVersionUID = 1L;
    public static final String SESSION_ATTR_SELECTED_TAB = "selectedTab";
    private final ComponentHintKey selectedTabHintKey;
    private final UiObjectWkt entityModel;

    private static List<ITab> tabsFor(final UiObjectWkt entityModel, BSTabGroup bsTabGroup) {
        ArrayList<ITab> tabs = new ArrayList<ITab>();
        List tablist = _NullSafe.stream((Collection)bsTabGroup.getTabs()).filter(BSTab.Predicates.notEmpty()).collect(Collectors.toList());
        for (final BSTab bsTab : tablist) {
            final RepeatingViewWithDynamicallyVisibleContent repeatingViewWithDynamicallyVisibleContent = TabPanel.newRows(entityModel, bsTab);
            String tabName = bsTab.getName();
            tabs.add((ITab)new AbstractTab((IModel)Model.of((Serializable)((Object)tabName))){
                private static final long serialVersionUID = 1L;

                public Panel getPanel(String panelId) {
                    return new TabPanel(panelId, entityModel, bsTab, repeatingViewWithDynamicallyVisibleContent);
                }

                public boolean isVisible() {
                    return repeatingViewWithDynamicallyVisibleContent.isVisible();
                }
            });
        }
        return tabs;
    }

    public TabGroupPanel(String id, UiObjectWkt entityModel, BSTabGroup bsTabGroup) {
        super(id, TabGroupPanel.tabsFor(entityModel, bsTabGroup));
        this.entityModel = entityModel;
        this.selectedTabHintKey = ComponentHintKey.create((MetaModelContext)entityModel.getMetaModelContext(), (Component)this, (String)SESSION_ATTR_SELECTED_TAB);
    }

    protected void onInitialize() {
        this.setSelectedTabFromSessionIfAny(this);
        super.onInitialize();
    }

    public TabbedPanel<ITab> setSelectedTab(int index) {
        this.selectedTabHintKey.set(this.entityModel.getOwnerBookmark(), "" + index);
        return super.setSelectedTab(index);
    }

    private void setSelectedTabFromSessionIfAny(AjaxBootstrapTabbedPanel<ITab> ajaxBootstrapTabbedPanel) {
        String selectedTabStr = this.selectedTabHintKey.get(this.entityModel.getOwnerBookmark());
        Integer tabIndex = this.parse(selectedTabStr);
        if (tabIndex != null) {
            int numTabs = ajaxBootstrapTabbedPanel.getTabs().size();
            if (tabIndex < numTabs) {
                ajaxBootstrapTabbedPanel.setSelectedTab(tabIndex.intValue());
            }
        }
    }

    private Integer parse(String selectedTabStr) {
        try {
            return Integer.parseInt(selectedTabStr);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public boolean isVisible() {
        return _NullSafe.stream((Collection)this.getTabs()).anyMatch(ITab::isVisible);
    }
}

