/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.layout.bs.tabs;

import org.apache.isis.applib.layout.grid.bootstrap.BSRow;
import org.apache.isis.applib.layout.grid.bootstrap.BSTab;
import org.apache.isis.core.metamodel.object.ManagedObject;
import org.apache.isis.viewer.wicket.model.hints.HasUiHintDisambiguator;
import org.apache.isis.viewer.wicket.model.models.UiObjectWkt;
import org.apache.isis.viewer.wicket.ui.components.layout.bs.col.RepeatingViewWithDynamicallyVisibleContent;
import org.apache.isis.viewer.wicket.ui.components.layout.bs.row.Row;
import org.apache.isis.viewer.wicket.ui.panels.HasDynamicallyVisibleContent;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.isis.viewer.wicket.ui.util.WktComponents;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;

public class TabPanel
extends PanelAbstract<ManagedObject, UiObjectWkt>
implements HasUiHintDisambiguator,
HasDynamicallyVisibleContent {
    private static final long serialVersionUID = 1L;
    private static final String ID_TAB_PANEL = "tabPanel";
    private static final String ID_ROWS = "rows";
    private final BSTab bsTab;
    private boolean visible = false;

    public TabPanel(String id, UiObjectWkt model, BSTab bsTab) {
        this(id, model, bsTab, null);
    }

    public TabPanel(String id, UiObjectWkt model, BSTab bsTab, RepeatingViewWithDynamicallyVisibleContent repeatingViewWithDynamicallyVisibleContent) {
        super(id);
        this.bsTab = bsTab;
        this.buildGui(model, bsTab, repeatingViewWithDynamicallyVisibleContent);
    }

    public String getHintDisambiguator() {
        return this.bsTab.getName();
    }

    protected void buildGui(UiObjectWkt model, BSTab bsTab, RepeatingViewWithDynamicallyVisibleContent rvIfAny) {
        WebMarkupContainer div = new WebMarkupContainer(ID_TAB_PANEL);
        RepeatingViewWithDynamicallyVisibleContent rv = rvIfAny != null ? rvIfAny : TabPanel.newRows(model, bsTab);
        div.add(new Component[]{rv});
        this.visible = this.visible || rv.isVisible();
        TabPanel panel = this;
        if (this.visible) {
            Wkt.cssAppend(panel, bsTab.getCssClass());
            panel.add(new Component[]{div});
        } else {
            WktComponents.permanentlyHide((MarkupContainer)panel, div.getId());
        }
    }

    public static RepeatingViewWithDynamicallyVisibleContent newRows(UiObjectWkt model, BSTab bsTab) {
        RepeatingViewWithDynamicallyVisibleContent rv = new RepeatingViewWithDynamicallyVisibleContent(ID_ROWS);
        for (BSRow bsRow : bsTab.getRows()) {
            String newChildId = rv.newChildId();
            Row row = new Row(newChildId, model, bsRow);
            rv.add(new Component[]{row});
        }
        return rv;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }
}

