/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.isis.viewer.wicket.ui.util.WktComponents;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.springframework.lang.Nullable;

public final class ScalarFragmentFactory {
    private ScalarFragmentFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum PromptFragment {
        LABEL("fragment-prompt-label", promptLabelModel -> Wkt.label("scalarValue", (IModel<String>)promptLabelModel)),
        TEXTAREA("fragment-prompt-textarea", promptLabelModel -> Wkt.textArea("scalarValue", (IModel<String>)promptLabelModel)),
        CHECKBOX_YES("fragment-prompt-checkboxYes", null),
        CHECKBOX_NO("fragment-prompt-checkboxNo", null),
        CHECKBOX_INTERMEDIATE("fragment-prompt-checkboxIntermediate", null);

        private final String fragmentId;
        private final Function<IModel<String>, Component> componentFactory;

        public <T extends Component> Fragment createFragment(String id, MarkupContainer markupProvider, Function<String, T> componentFactory) {
            Fragment fragment = Wkt.fragment(id, this.fragmentId, markupProvider);
            fragment.add(new Component[]{(Component)componentFactory.apply("scalarValue")});
            return fragment;
        }

        public Fragment createFragment(MarkupContainer markupProvider, IModel<String> promptLabelModel, @Nullable Consumer<FormComponent<String>> onComponentCreated) {
            Fragment fragment = Wkt.fragment(FieldFrame.SCALAR_VALUE_CONTAINER.getContainerId(), this.fragmentId, markupProvider);
            Component component = this.componentFactory.apply(promptLabelModel);
            fragment.add(new Component[]{component});
            if (onComponentCreated != null && component instanceof FormComponent) {
                onComponentCreated.accept((FormComponent<String>)((FormComponent)_Casts.uncheckedCast((Object)component)));
            }
            return fragment;
        }

        public static Fragment createCheckboxFragment(String id, MarkupContainer markupProvider, Boolean value) {
            PromptFragment chkFragment = value == null ? CHECKBOX_INTERMEDIATE : (value != false ? CHECKBOX_YES : CHECKBOX_NO);
            return Wkt.fragment(id, chkFragment.fragmentId, markupProvider);
        }

        private PromptFragment(String fragmentId, Function<IModel<String>, Component> componentFactory) {
            this.fragmentId = fragmentId;
            this.componentFactory = componentFactory;
        }
    }

    public static enum InputFragment {
        TEXT("fragment-input-text"),
        TEXTAREA("fragment-input-textarea"),
        DATE("fragment-input-date"),
        CHECKBOX("fragment-input-checkbox"),
        FILE("fragment-input-file"),
        SELECT_VALUE("fragment-input-select_value"),
        SELECT_OBJECT("fragment-input-select_object");

        private final String fragmentId;

        public Fragment createFragment(MarkupContainer markupProvider, FormComponent<?> inputComponent) {
            Fragment fragment = Wkt.fragment(FieldFrame.SCALAR_VALUE_CONTAINER.getContainerId(), this.fragmentId, markupProvider);
            fragment.add(new Component[]{inputComponent});
            return fragment;
        }

        private InputFragment(String fragmentId) {
            this.fragmentId = fragmentId;
        }
    }

    public static enum CompactFragment {
        LABEL("fragment-compact-label"),
        LINK("fragment-compact-link"),
        BADGE("fragment-compact-badge"),
        ENTITY_LINK("fragment-compact-entityLink"),
        CHECKBOX_YES("fragment-compact-checkboxYes"),
        CHECKBOX_NO("fragment-compact-checkboxNo"),
        CHECKBOX_INTERMEDIATE("fragment-compact-checkboxIntermediate");

        public static String ID_LINK_LABEL;
        private final String fragmentId;

        public <T extends Component> Fragment createFragment(String id, MarkupContainer markupProvider, Function<String, T> componentFactory) {
            Fragment fragment = Wkt.fragment(id, this.fragmentId, markupProvider);
            fragment.add(new Component[]{(Component)componentFactory.apply("scalarValue")});
            return fragment;
        }

        public static Fragment createCheckboxFragment(String id, MarkupContainer markupProvider, Boolean value) {
            CompactFragment chkFragment = value == null ? CHECKBOX_INTERMEDIATE : (value != false ? CHECKBOX_YES : CHECKBOX_NO);
            return Wkt.fragment(id, chkFragment.fragmentId, markupProvider);
        }

        private CompactFragment(String fragmentId) {
            this.fragmentId = fragmentId;
        }

        static {
            ID_LINK_LABEL = "linkLabel";
        }
    }

    public static enum FieldFragement {
        LINK("fragment-fieldFrame-withLink"){

            @Override
            public RepeatingView createButtonContainer(MarkupContainer container) {
                return Wkt.repeatingViewAdd(container, "scalarValueInlinePromptLink-buttons");
            }
        }
        ,
        NO_LINK_VIEWING("fragment-fieldFrame-withoutLink-viewing"),
        NO_LINK_EDITING("fragment-fieldFrame-withoutLink-editing"){

            @Override
            public RepeatingView createButtonContainer(MarkupContainer container) {
                return Wkt.repeatingViewAdd(container, "scalarValueInput-buttons");
            }
        };

        private final String fragmentId;
        private final String containerId = "container-fieldFrame";

        public boolean isMatching(@Nullable MarkupContainer container) {
            if (container instanceof Fragment) {
                return this.fragmentId.equals(((Fragment)container).getAssociatedMarkupId());
            }
            return false;
        }

        public RepeatingView createButtonContainer(MarkupContainer container) {
            throw _Exceptions.unsupportedOperation((String)"not supported by %s", (Object[])new Object[]{this});
        }

        private FieldFragement(String fragmentId) {
            this.fragmentId = fragmentId;
        }

        public String getFragmentId() {
            return this.fragmentId;
        }

        public String getContainerId() {
            return this.containerId;
        }
    }

    public static enum FieldFrame {
        SCALAR_VALUE_INLINE_PROMPT_LINK("scalarValueInlinePromptLink"),
        SCALAR_VALUE_CONTAINER("container-scalarValue");

        private final String containerId;

        public <T extends Component> T createComponent(Function<String, T> factory) {
            return (T)((Component)factory.apply(this.containerId));
        }

        @Deprecated
        public Component addComponentIfMissing(MarkupContainer container, Function<String, ? extends Component> factory) {
            Component alreadyExisting = container.get(this.containerId);
            return alreadyExisting != null ? alreadyExisting : Wkt.add(container, this.createComponent(factory));
        }

        public Optional<Component> lookupIn(MarkupContainer container) {
            return Optional.ofNullable(container.get(this.containerId));
        }

        private FieldFrame(String containerId) {
            this.containerId = containerId;
        }

        public String getContainerId() {
            return this.containerId;
        }
    }

    public static enum RegularFrame {
        FIELD("container-fieldFrame"),
        FEEDBACK("feedback"),
        ASSOCIATED_ACTION_LINKS_BELOW("associatedActionLinksBelow"),
        ASSOCIATED_ACTION_LINKS_RIGHT("associatedActionLinksRight");

        private final String containerId;

        public <T extends Component> T createComponent(Function<String, T> factory) {
            return (T)((Component)factory.apply(this.containerId));
        }

        @Deprecated
        public void permanentlyHideIn(MarkupContainer container) {
            Component toHide = container.get(this.containerId);
            if (toHide != null) {
                toHide.setVisibilityAllowed(false);
                toHide.setVisible(false);
            } else {
                WktComponents.permanentlyHide(container, this.containerId);
            }
        }

        private RegularFrame(String containerId) {
            this.containerId = containerId;
        }

        public String getContainerId() {
            return this.containerId;
        }
    }

    public static enum FrameFragment {
        COMPACT("scalarIfCompact"),
        REGULAR("scalarIfRegular"),
        INLINE_PROMPT_FORM("scalarIfRegularInlinePromptForm");

        private final String containerId;

        public <T extends Component> T createComponent(Function<String, T> factory) {
            return (T)((Component)factory.apply(this.containerId));
        }

        private FrameFragment(String containerId) {
            this.containerId = containerId;
        }

        public String getContainerId() {
            return this.containerId;
        }
    }
}

