/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.NonNull;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.collections.ImmutableEnumSet;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.debug._Probe;
import org.apache.isis.core.metamodel.commons.ScalarRepresentation;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.object.ManagedObject;
import org.apache.isis.core.metamodel.object.ManagedObjects;
import org.apache.isis.core.metamodel.spec.feature.ObjectFeature;
import org.apache.isis.core.metamodel.util.Facets;
import org.apache.isis.viewer.commons.model.components.UiComponentType;
import org.apache.isis.viewer.commons.model.decorators.FormLabelDecorator;
import org.apache.isis.viewer.commons.model.scalar.UiParameter;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.AdditionalLinksPanel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarFragmentFactory;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarModelChangeDispatcher;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarModelChangeListener;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarModelDefaultChangeBehavior;
import org.apache.isis.viewer.wicket.ui.components.scalars._Util;
import org.apache.isis.viewer.wicket.ui.components.scalars._Xray;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.isis.viewer.wicket.ui.util.WktComponents;
import org.apache.isis.viewer.wicket.ui.util.WktDecorators;
import org.apache.isis.viewer.wicket.ui.util.WktTooltips;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.feedback.ComponentFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.springframework.lang.Nullable;

public abstract class ScalarPanelAbstract
extends PanelAbstract<ManagedObject, ScalarModel>
implements ScalarModelChangeListener {
    private static final long serialVersionUID = 1L;
    protected static final String ID_SCALAR_TYPE_CONTAINER = "scalarTypeContainer";
    protected static final String ID_SCALAR_NAME = "scalarName";
    protected static final String ID_SCALAR_VALUE = "scalarValue";
    protected static final String ID_XRAY_DETAILS = "xrayDetails";
    private final ImmutableEnumSet<FormatModifier> formatModifiers;
    private Component compactFrame;
    private MarkupContainer regularFrame;
    private WebMarkupContainer formFrame;
    private WebMarkupContainer scalarFrameContainer;
    private final RenderScenario renderScenario;
    private final ScalarModelChangeDispatcher scalarModelChangeDispatcher = new ScalarModelChangeDispatcherImpl(this);

    public final ScalarModel scalarModel() {
        return (ScalarModel)super.getModel();
    }

    protected void setupFormatModifiers(EnumSet<FormatModifier> modifiers) {
    }

    protected abstract Component createCompactFrame();

    protected abstract MarkupContainer createRegularFrame();

    protected final WebMarkupContainer getScalarFrameContainer() {
        return this.scalarFrameContainer;
    }

    protected ScalarPanelAbstract(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
        EnumSet<FormatModifier> formatModifiers = EnumSet.noneOf(FormatModifier.class);
        this.setupFormatModifiers(formatModifiers);
        this.formatModifiers = ImmutableEnumSet.from(formatModifiers);
        this.renderScenario = RenderScenario.inferFrom(this);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.buildGui();
        this.callHooks();
        this.setOutputMarkupId(true);
    }

    public final String getCssClassName() {
        return _Strings.decapitalize((String)this.getClass().getSimpleName());
    }

    private void buildGui() {
        ScalarModel scalarModel = this.scalarModel();
        this.scalarFrameContainer = Wkt.containerAdd((MarkupContainer)this, ID_SCALAR_TYPE_CONTAINER);
        Wkt.cssAppend(this.scalarFrameContainer, this.getCssClassName());
        switch (scalarModel.getRenderingHint()) {
            case REGULAR: {
                this.regularFrame = Wkt.ajaxEnable(this.createRegularFrame());
                this.compactFrame = this.createShallowCompactFrame();
                this.regularFrame.setVisible(true);
                this.compactFrame.setVisible(false);
                Component[] componentArray = new Component[3];
                componentArray[0] = this.compactFrame;
                componentArray[1] = this.regularFrame;
                this.formFrame = this.createFormFrame();
                componentArray[2] = this.formFrame;
                this.scalarFrameContainer.addOrReplace(componentArray);
                Can<LinkAndLabel> associatedLinksAndLabels = _Util.associatedLinksAndLabels(scalarModel);
                this.addPositioningCssTo(this.regularFrame, associatedLinksAndLabels);
                this.addActionLinksBelowAndRight(this.regularFrame, associatedLinksAndLabels);
                this.addFeedbackOnlyTo(this.regularFrame, this.getValidationFeedbackReceiver());
                this.setupInlinePrompt();
                break;
            }
            default: {
                this.regularFrame = this.createShallowRegularFrame();
                this.compactFrame = this.createCompactFrame();
                this.regularFrame.setVisible(false);
                this.compactFrame.setVisible(true);
                Component[] componentArray = new Component[3];
                componentArray[0] = this.compactFrame;
                componentArray[1] = this.regularFrame;
                this.formFrame = this.createFormFrame();
                componentArray[2] = this.formFrame;
                this.scalarFrameContainer.addOrReplace(componentArray);
            }
        }
        if (scalarModel.isProperty() && scalarModel.getMode() == ScalarRepresentation.VIEWING && (scalarModel.getPromptStyle().isDialogAny() || !scalarModel.canEnterEditMode())) {
            Wkt.noTabbing(this.getValidationFeedbackReceiver());
        }
        this.addCssFromMetaModel();
        this.addChangeListener(this);
        this.installScalarModelChangeBehavior();
    }

    protected abstract void setupInlinePrompt();

    protected MarkupContainer createShallowRegularFrame() {
        WebMarkupContainer shallowRegularFrame = ScalarFragmentFactory.FrameFragment.REGULAR.createComponent(Wkt::container);
        WktComponents.permanentlyHide((MarkupContainer)shallowRegularFrame, ID_SCALAR_NAME, ID_SCALAR_VALUE, ScalarFragmentFactory.RegularFrame.FIELD.getContainerId(), ScalarFragmentFactory.RegularFrame.FEEDBACK.getContainerId(), ScalarFragmentFactory.RegularFrame.ASSOCIATED_ACTION_LINKS_BELOW.getContainerId(), ScalarFragmentFactory.RegularFrame.ASSOCIATED_ACTION_LINKS_RIGHT.getContainerId());
        return shallowRegularFrame;
    }

    protected Component createShallowCompactFrame() {
        return ScalarFragmentFactory.FrameFragment.COMPACT.createComponent(Wkt::container);
    }

    protected WebMarkupContainer createFormFrame() {
        boolean isRegular = this.scalarModel().getRenderingHint().isRegular();
        return (WebMarkupContainer)ScalarFragmentFactory.FrameFragment.INLINE_PROMPT_FORM.createComponent(WebMarkupContainer::new).setVisible(false).setOutputMarkupId(isRegular);
    }

    protected final void switchRegularFrameToFormFrame() {
        this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)this.getScalarFrameContainer(), ScalarFragmentFactory.FrameFragment.INLINE_PROMPT_FORM.getContainerId(), UiComponentType.PROPERTY_EDIT_FORM, (IModel<?>)this.scalarModel());
        this.getRegularFrame().setVisible(false);
        this.getFormFrame().setVisible(true);
    }

    private void callHooks() {
        ScalarModel scalarModel = this.scalarModel();
        String disableReasonIfAny = scalarModel.disableReasonIfAny();
        boolean mustBeEditable = scalarModel.mustBeEditable();
        if (disableReasonIfAny != null) {
            if (mustBeEditable) {
                this.onInitializeNotEditable();
            } else {
                this.onInitializeReadonly(disableReasonIfAny);
            }
        } else if (scalarModel.isViewMode()) {
            this.onInitializeNotEditable();
        } else {
            this.onInitializeEditable();
        }
    }

    protected void onInitializeNotEditable() {
    }

    protected void onInitializeReadonly(String disableReason) {
    }

    protected void onInitializeEditable() {
    }

    protected void onNotEditable(String disableReason, Optional<AjaxRequestTarget> target) {
    }

    protected void onEditable(@NonNull Optional<AjaxRequestTarget> target) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
    }

    private void addCssFromMetaModel() {
        ScalarModel scalarModel = this.scalarModel();
        Wkt.cssAppend(this, scalarModel.getCssClass());
        Facets.cssClass((FacetHolder)scalarModel.getMetaModel(), (ManagedObject)scalarModel.getParentUiModel().getManagedObject()).ifPresent(cssClass -> Wkt.cssAppend(this, cssClass));
    }

    protected void onConfigure() {
        boolean hidden = this.scalarModel().whetherHidden();
        this.setVisibilityAllowed(!hidden);
        super.onConfigure();
    }

    protected void installScalarModelChangeBehavior() {
        this.addOrReplaceBehavoir(ScalarModelDefaultChangeBehavior.class, () -> new ScalarModelDefaultChangeBehavior(this));
    }

    public void addChangeListener(ScalarModelChangeListener listener) {
        ((ScalarModelChangeDispatcherImpl)this.getScalarModelChangeDispatcher()).addChangeListener(listener);
    }

    protected final <T extends Behavior> void addOrReplaceBehavoir(@NonNull Class<T> behaviorClass, @NonNull Supplier<T> factory) {
        if (behaviorClass == null) {
            throw new NullPointerException("behaviorClass is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        Component validationFeedbackReceiver = this.getValidationFeedbackReceiver();
        if (validationFeedbackReceiver == null) {
            return;
        }
        for (Behavior behavior : validationFeedbackReceiver.getBehaviors(behaviorClass)) {
            validationFeedbackReceiver.remove(new Behavior[]{behavior});
        }
        validationFeedbackReceiver.add(new Behavior[]{(Behavior)factory.get()});
    }

    @Override
    public void onUpdate(AjaxRequestTarget target, ScalarPanelAbstract scalarPanel) {
        if (((ScalarModel)this.getModel()).isParameter()) {
            Wkt.javaScriptAdd(target, Wkt.EventTopic.FOCUS_FIRST_PARAMETER, this.getMarkupId());
        }
    }

    @Override
    public void onError(AjaxRequestTarget target, ScalarPanelAbstract scalarPanel) {
    }

    protected Label createScalarNameLabel(String id, IModel<String> labelCaption) {
        Label scalarNameLabel = Wkt.label(id, labelCaption);
        if (_Strings.isNullOrEmpty((CharSequence)((CharSequence)labelCaption.getObject()))) {
            return scalarNameLabel;
        }
        ScalarModel scalarModel = this.scalarModel();
        WktDecorators.getFormLabel().decorate((Component)scalarNameLabel, FormLabelDecorator.FormLabelDecorationModel.mandatory((scalarModel.isRequired() && scalarModel.isEnabled() ? 1 : 0) != 0));
        scalarModel.getDescribedAs().ifPresent(describedAs -> WktTooltips.addTooltip(scalarNameLabel, describedAs));
        return scalarNameLabel;
    }

    @Nullable
    protected abstract Component getValidationFeedbackReceiver();

    private void addFeedbackOnlyTo(MarkupContainer markupContainer, Component component) {
        if (component == null) {
            return;
        }
        markupContainer.addOrReplace(new Component[]{ScalarFragmentFactory.RegularFrame.FEEDBACK.createComponent(id -> new NotificationPanel(id, component, (IFeedbackMessageFilter)new ComponentFeedbackMessageFilter(component)))});
    }

    private void addActionLinksBelowAndRight(MarkupContainer labelIfRegular, Can<LinkAndLabel> linkAndLabels) {
        Can linksBelow = linkAndLabels.filter(LinkAndLabel.isPositionedAt((ActionLayout.Position)ActionLayout.Position.BELOW));
        AdditionalLinksPanel.addAdditionalLinks(labelIfRegular, ScalarFragmentFactory.RegularFrame.ASSOCIATED_ACTION_LINKS_BELOW.getContainerId(), (Can<LinkAndLabel>)linksBelow, AdditionalLinksPanel.Style.INLINE_LIST);
        Can linksRight = linkAndLabels.filter(LinkAndLabel.isPositionedAt((ActionLayout.Position)ActionLayout.Position.RIGHT));
        AdditionalLinksPanel.addAdditionalLinks(labelIfRegular, ScalarFragmentFactory.RegularFrame.ASSOCIATED_ACTION_LINKS_RIGHT.getContainerId(), (Can<LinkAndLabel>)linksRight, AdditionalLinksPanel.Style.DROPDOWN);
    }

    private void addPositioningCssTo(MarkupContainer markupContainer, Can<LinkAndLabel> actionLinks) {
        Wkt.cssAppend(markupContainer, ScalarPanelAbstract.determinePropParamLayoutCss((ScalarModel)this.getModel()));
        Wkt.cssAppend(markupContainer, ScalarPanelAbstract.determineActionLayoutPositioningCss(actionLinks));
    }

    private static String determinePropParamLayoutCss(ScalarModel scalarModel) {
        return Facets.labelAtCss((ObjectFeature)scalarModel.getMetaModel());
    }

    private static String determineActionLayoutPositioningCss(Can<LinkAndLabel> entityActionLinks) {
        return entityActionLinks.stream().anyMatch(LinkAndLabel.isPositionedAt((ActionLayout.Position)ActionLayout.Position.RIGHT)) ? "actions-right" : null;
    }

    public void repaint(AjaxRequestTarget target) {
        target.add(new Component[]{this});
    }

    public Repaint updateIfNecessary(@NonNull UiParameter paramModel, @NonNull Optional<AjaxRequestTarget> target) {
        boolean valueChanged;
        if (paramModel == null) {
            throw new NullPointerException("paramModel is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        ScalarModel scalarModel = this.scalarModel();
        boolean visibilityBefore = this.isVisible() && this.isVisibilityAllowed();
        Consent visibilityConsent = paramModel.getParameterNegotiationModel().getVisibilityConsent(paramModel.getParameterIndex());
        boolean visibilityAfter = visibilityConsent.isAllowed();
        this.setVisibilityAllowed(visibilityAfter);
        this.setVisible(visibilityAfter);
        Consent usabilityConsent = paramModel.getParameterNegotiationModel().getUsabilityConsent(paramModel.getParameterIndex());
        boolean usabilityBefore = this.isEnabled();
        boolean usabilityAfter = usabilityConsent.isAllowed();
        if (usabilityAfter) {
            this.onEditable(target);
        } else {
            this.onNotEditable(usabilityConsent.getReason(), target);
        }
        ManagedObject paramValue = paramModel.getValue();
        boolean bl = valueChanged = !Objects.equals(scalarModel.getObject(), paramValue);
        if (valueChanged) {
            if (ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)paramValue)) {
                scalarModel.setObject(null);
            } else {
                scalarModel.setObject(paramValue);
            }
        }
        if (!visibilityBefore || !visibilityAfter) {
            return Repaint.ENTIRE_FORM;
        }
        if (!usabilityAfter || !usabilityBefore) {
            return Repaint.PARAM_ONLY;
        }
        return valueChanged ? Repaint.PARAM_ONLY : Repaint.NOTHING;
    }

    public ImmutableEnumSet<FormatModifier> getFormatModifiers() {
        return this.formatModifiers;
    }

    protected Component getCompactFrame() {
        return this.compactFrame;
    }

    protected MarkupContainer getRegularFrame() {
        return this.regularFrame;
    }

    protected WebMarkupContainer getFormFrame() {
        return this.formFrame;
    }

    protected RenderScenario getRenderScenario() {
        return this.renderScenario;
    }

    public ScalarModelChangeDispatcher getScalarModelChangeDispatcher() {
        return this.scalarModelChangeDispatcher;
    }

    static class ScalarModelChangeDispatcherImpl
    implements ScalarModelChangeDispatcher,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final List<ScalarModelChangeListener> changeListeners = _Lists.newArrayList();
        private final ScalarPanelAbstract scalarPanel;

        @Override
        public void notifyUpdate(AjaxRequestTarget target) {
            _Probe.entryPoint((_Probe.EntryPoint)_Probe.EntryPoint.USER_INTERACTION, (String)"Wicket Ajax Request, originating from User either having changed a Property value during inline editing or having changed a Parameter value within an open ActionPrompt.");
            _Xray.onUserParamOrPropertyEdit(this.scalarPanel);
            ScalarModelChangeDispatcher.super.notifyUpdate(target);
        }

        @Override
        @NonNull
        public Iterable<ScalarModelChangeListener> getChangeListeners() {
            return Collections.unmodifiableCollection(this.changeListeners);
        }

        public void addChangeListener(ScalarModelChangeListener listener) {
            this.changeListeners.add(listener);
        }

        public ScalarModelChangeDispatcherImpl(ScalarPanelAbstract scalarPanel) {
            this.scalarPanel = scalarPanel;
        }

        @Override
        public ScalarPanelAbstract getScalarPanel() {
            return this.scalarPanel;
        }
    }

    public static enum RenderScenario {
        COMPACT,
        READONLY,
        CAN_EDIT,
        CAN_EDIT_INLINE,
        CAN_EDIT_INLINE_VIA_ACTION,
        EDITING,
        EDITING_WITH_LINK_TO_NESTED;


        public boolean isCompact() {
            return this == COMPACT;
        }

        public boolean isReadonly() {
            return this == READONLY;
        }

        public boolean isCanEdit() {
            return this == CAN_EDIT;
        }

        public boolean isEditing() {
            return this == EDITING;
        }

        public boolean isEditingAny() {
            return this == EDITING || this == CAN_EDIT_INLINE_VIA_ACTION;
        }

        public boolean isViewingAndCanEditAny() {
            return this == CAN_EDIT || this == CAN_EDIT_INLINE || this == CAN_EDIT_INLINE_VIA_ACTION;
        }

        static RenderScenario inferFrom(ScalarPanelAbstract scalarPanel) {
            ScalarModel scalarModel = scalarPanel.scalarModel();
            if (!scalarModel.getRenderingHint().isRegular()) {
                return COMPACT;
            }
            if (scalarModel.isEditMode()) {
                return _Util.canParameterEnterNestedEdit(scalarModel) ? EDITING_WITH_LINK_TO_NESTED : EDITING;
            }
            if (_Util.canPropertyEnterInlineEditDirectly(scalarModel)) {
                return CAN_EDIT_INLINE;
            }
            if (_Util.lookupPropertyActionForInlineEdit(scalarModel).isPresent()) {
                return CAN_EDIT_INLINE_VIA_ACTION;
            }
            return scalarModel.isEnabled() ? CAN_EDIT : READONLY;
        }
    }

    public static enum Repaint {
        NOTHING,
        PARAM_ONLY,
        ENTIRE_FORM;


        public boolean isParamOnly() {
            return this == PARAM_ONLY;
        }

        public boolean isEntireForm() {
            return this == ENTIRE_FORM;
        }
    }

    public static enum FormatModifier {
        MARKUP,
        MULITLINE,
        COMPOSITE,
        TRISTATE,
        BLOB,
        BADGE,
        NO_OUTPUT_ESCAPE;

    }
}

