/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.fileinput.BootstrapFileInputField;
import java.io.Serializable;
import org.apache.isis.applib.services.placeholder.PlaceholderRenderService;
import org.apache.isis.commons.internal.functions._Functions;
import org.apache.isis.core.metamodel.commons.ScalarRepresentation;
import org.apache.isis.core.metamodel.interactions.managed.ManagedValue;
import org.apache.isis.viewer.commons.model.components.UiString;
import org.apache.isis.viewer.wicket.model.models.FormExecutorContext;
import org.apache.isis.viewer.wicket.model.models.InlinePromptContext;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.model.value.OptionsBasedOnValueSemantics;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarFragmentFactory;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelFormFieldAbstract;
import org.apache.isis.viewer.wicket.ui.components.scalars._Util;
import org.apache.isis.viewer.wicket.ui.components.scalars.markup.MarkupComponent;
import org.apache.isis.viewer.wicket.ui.components.widgets.links.AjaxLinkNoPropagate;
import org.apache.isis.viewer.wicket.ui.panels.FormExecutorDefault;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.isis.viewer.wicket.ui.util.WktTooltips;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.danekja.java.util.function.serializable.SerializableConsumer;
import org.springframework.lang.Nullable;

public abstract class ScalarPanelAbstract2
extends ScalarPanelAbstract {
    private static final long serialVersionUID = 1L;
    protected MarkupContainer fieldFrame;
    protected WebMarkupContainer inlinePromptLink;

    protected ScalarPanelAbstract2(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
    }

    @Override
    protected final void setupInlinePrompt() {
        ScalarModel scalarModel = this.scalarModel();
        MarkupContainer regularFrame = this.getRegularFrame();
        MarkupContainer fieldFrame = this.getFieldFrame();
        WebMarkupContainer scalarFrameContainer = this.getScalarFrameContainer();
        scalarModel.setInlinePromptContext(new InlinePromptContext(scalarModel, (MarkupContainer)scalarFrameContainer, (Component)regularFrame, this.getFormFrame()));
        if (ScalarFragmentFactory.FieldFragement.LINK.isMatching(fieldFrame)) {
            Component[] componentArray = new Component[1];
            this.inlinePromptLink = this.createInlinePromptLink();
            componentArray[0] = this.inlinePromptLink;
            fieldFrame.addOrReplace(componentArray);
            this.addOnClickBehaviorTo((MarkupContainer)this.inlinePromptLink);
            RepeatingView additionalButtonContainer = ScalarFragmentFactory.FieldFragement.LINK.createButtonContainer((MarkupContainer)this.inlinePromptLink);
            if (this.getRenderScenario() != ScalarPanelAbstract.RenderScenario.CAN_EDIT_INLINE_VIA_ACTION) {
                this.addAdditionalClickBehaviorTo(additionalButtonContainer);
            }
        } else if (ScalarFragmentFactory.FieldFragement.NO_LINK_EDITING.isMatching(fieldFrame)) {
            RepeatingView additionalButtonContainer = ScalarFragmentFactory.FieldFragement.NO_LINK_EDITING.createButtonContainer(fieldFrame);
            this.addAdditionalClickBehaviorTo(additionalButtonContainer);
        }
        if (fieldFrame != null && fieldFrame.get("scalarValue") == null) {
            Wkt.labelAdd(fieldFrame, "scalarValue", "\u2205");
        }
    }

    protected Component createComponentForOutput(String id) {
        if (this.isUsingTextarea()) {
            return ScalarFragmentFactory.PromptFragment.TEXTAREA.createFragment(id, (MarkupContainer)this, scalarValueId -> {
                TextArea<String> textArea = Wkt.textAreaNoTab(scalarValueId, (IModel<String>)((IModel & Serializable)this::outputFormatAsString));
                ScalarModel scalarModel = this.scalarModel();
                Wkt.setFormComponentAttributes(textArea, () -> ((ScalarModel)scalarModel).multilineNumberOfLines(), () -> ((ScalarModel)scalarModel).maxLength(), () -> ((ScalarModel)scalarModel).typicalLength());
                return textArea;
            });
        }
        return ScalarFragmentFactory.CompactFragment.LABEL.createFragment(id, (MarkupContainer)this, scalarValueId -> this.getFormatModifiers().contains((Enum)ScalarPanelAbstract.FormatModifier.NO_OUTPUT_ESCAPE) ? this.markupComponent((String)scalarValueId, (IModel<String>)((IModel & Serializable)this::outputFormatAsString)) : Wkt.labelWithDynamicEscaping(scalarValueId, (_Functions.SerializableSupplier<UiString>)((_Functions.SerializableSupplier & Serializable)this::obtainOutputFormat)));
    }

    private OptionsBasedOnValueSemantics getSemantics(ScalarModel scalarModel) {
        return new OptionsBasedOnValueSemantics(scalarModel.getMetaModel(), scalarModel.isEditMode() ? ScalarRepresentation.EDITING : ScalarRepresentation.VIEWING);
    }

    private MarkupComponent markupComponent(String id, IModel<String> model) {
        return new MarkupComponent(id, model, MarkupComponent.Options.builder().syntaxHighlighter(this.getSemantics(this.scalarModel()).getSyntaxHighlighter()).build());
    }

    private boolean isUsingTextarea() {
        if (this.getRenderScenario().isCompact() || this.getFormatModifiers().contains((Enum)ScalarPanelAbstract.FormatModifier.MARKUP) || !this.getFormatModifiers().contains((Enum)ScalarPanelAbstract.FormatModifier.MULITLINE)) {
            return false;
        }
        return !this.scalarModel().isEmpty();
    }

    protected final String outputFormatAsString() {
        return this.obtainOutputFormat().getString();
    }

    protected UiString obtainOutputFormat() {
        ManagedValue proposedValue = this.scalarModel().proposedValue();
        if (!proposedValue.isPresent()) {
            return UiString.markup((String)this.getPlaceholderRenderService().asHtml(PlaceholderRenderService.PlaceholderLiteral.NULL_REPRESENTATION));
        }
        boolean useText = this.isUsingTextarea() || this.getFormatModifiers().contains((Enum)ScalarPanelAbstract.FormatModifier.BADGE);
        return useText ? UiString.text((String)((String)proposedValue.getValueAsTitle().getValue())) : UiString.markup((String)((String)proposedValue.getValueAsHtml().getValue()));
    }

    protected void onSwitchFormForInlinePrompt(WebMarkupContainer inlinePromptForm, AjaxRequestTarget target) {
    }

    protected void configureInlinePromptLink(WebMarkupContainer inlinePromptLink) {
        Wkt.cssAppend(inlinePromptLink, this.obtainInlinePromptLinkCssIfAny());
    }

    protected String obtainInlinePromptLinkCssIfAny() {
        return "form-control form-control-sm";
    }

    private void addOnClickBehaviorTo(@Nullable MarkupContainer clickReceiver) {
        if (clickReceiver == null) {
            return;
        }
        ScalarModel scalarModel = this.scalarModel();
        if (_Util.canPropertyEnterInlineEditDirectly(scalarModel)) {
            _Util.lookupMixinForCompositeValueUpdate(scalarModel).ifPresentOrElse(mixinForCompositeValueEdit -> Wkt.behaviorAddOnClick((Component)clickReceiver, (SerializableConsumer<AjaxRequestTarget>)((SerializableConsumer & Serializable)arg_0 -> ((AjaxLink)mixinForCompositeValueEdit.getUiComponent()).onClick(arg_0))), () -> Wkt.behaviorAddOnClick((Component)clickReceiver, (SerializableConsumer<AjaxRequestTarget>)((SerializableConsumer & Serializable)this::onPropertyInlineEditClick)));
        } else {
            _Util.lookupPropertyActionForInlineEdit(scalarModel).ifPresent(actionLinkInlineAsIfEdit -> Wkt.behaviorAddOnClick((Component)clickReceiver, (SerializableConsumer<AjaxRequestTarget>)((SerializableConsumer & Serializable)arg_0 -> ((AjaxLink)actionLinkInlineAsIfEdit.getUiComponent()).onClick(arg_0))));
        }
    }

    private void addAdditionalClickBehaviorTo(@Nullable RepeatingView buttonContainer) {
        boolean isClearFieldButtonVisible;
        boolean bl = isClearFieldButtonVisible = !this.scalarModel().isRequired() && this.scalarModel().proposedValue().isPresent();
        if (isClearFieldButtonVisible) {
            AjaxLinkNoPropagate clearFieldButton = Wkt.linkAddWithBody(buttonContainer, Wkt.faIcon("fa-regular fa-trash-can"), (SerializableConsumer<AjaxRequestTarget>)((SerializableConsumer & Serializable)this::onClearFieldButtonClick));
            Wkt.cssAppend(clearFieldButton, "btn-warning");
            WktTooltips.addTooltip(clearFieldButton, this.translate("Click to clear the field"));
            if (this.scalarModel().isParameter()) {
                clearFieldButton.setEventPropagation(AjaxRequestAttributes.EventPropagation.BUBBLE);
            }
        }
    }

    private WebMarkupContainer createInlinePromptLink() {
        WebMarkupContainer inlinePromptLink = ScalarFragmentFactory.FieldFrame.SCALAR_VALUE_INLINE_PROMPT_LINK.createComponent(WebMarkupContainer::new);
        inlinePromptLink.setOutputMarkupId(true);
        inlinePromptLink.setOutputMarkupPlaceholderTag(true);
        this.configureInlinePromptLink(inlinePromptLink);
        Wkt.add((MarkupContainer)inlinePromptLink, ScalarFragmentFactory.FieldFrame.SCALAR_VALUE_CONTAINER.createComponent(id -> this.createComponentForOutput((String)id)));
        return inlinePromptLink;
    }

    private void onPropertyInlineEditClick(AjaxRequestTarget target) {
        this.scalarModel().toEditMode();
        this.switchRegularFrameToFormFrame();
        this.onSwitchFormForInlinePrompt(this.getFormFrame(), target);
        target.add(new Component[]{this.getScalarFrameContainer()});
        Wkt.focusOnMarkerAttribute((MarkupContainer)this.getFormFrame(), target);
    }

    private void onClearFieldButtonClick(AjaxRequestTarget target) {
        this.scalarModel().proposedValue().clear();
        this.scalarModel().getSpecialization().accept(param -> {
            this.clearBootstrapFileInputField();
            this.setupInlinePrompt();
            target.add(new Component[]{this});
        }, prop -> FormExecutorDefault.forProperty(prop).executeAndProcessResults(target, null, (FormExecutorContext)prop));
    }

    private void clearBootstrapFileInputField() {
        ScalarPanelFormFieldAbstract formContainer;
        FormComponent formComponent;
        if (this instanceof ScalarPanelFormFieldAbstract && (formComponent = (formContainer = (ScalarPanelFormFieldAbstract)this).getFormComponent()) instanceof BootstrapFileInputField) {
            FormComponent replacement = formContainer.createFormComponent(formComponent.getId(), this.scalarModel());
            formComponent.replaceWith(replacement);
        }
    }

    protected MarkupContainer getFieldFrame() {
        return this.fieldFrame;
    }
}

