/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import java.io.Serializable;
import java.util.Optional;
import java.util.function.Function;
import lombok.NonNull;
import org.apache.isis.core.metamodel.object.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.util.Facets;
import org.apache.isis.viewer.commons.model.components.UiString;
import org.apache.isis.viewer.commons.model.scalar.UiParameter;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelFormFieldAbstract;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.Select2;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers.ChoiceProviderAbstract;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.springframework.lang.Nullable;
import org.wicketstuff.select2.Settings;

public abstract class ScalarPanelSelectAbstract
extends ScalarPanelFormFieldAbstract<ManagedObject> {
    private static final long serialVersionUID = 1L;
    protected Select2 select2;

    protected ScalarPanelSelectAbstract(String id, ScalarModel scalarModel) {
        super(id, scalarModel, ManagedObject.class);
        this.setOutputMarkupId(true);
    }

    protected final Select2 createSelect2(String id, Function<ScalarModel, ChoiceProviderAbstract> choiceProviderFactory) {
        ScalarModel scalarModel = this.scalarModel();
        Select2 select2 = Select2.createSelect2(id, scalarModel, choiceProviderFactory.apply(scalarModel), this.getScalarModelChangeDispatcher());
        Settings settings = select2.getSettings();
        switch (scalarModel.getChoiceProviderSort()) {
            case CHOICES: {
                settings.setPlaceholder((Object)scalarModel.getFriendlyName());
                break;
            }
            case AUTO_COMPLETE: {
                settings.setPlaceholder((Object)scalarModel.getFriendlyName());
                settings.setMinimumInputLength(Integer.valueOf(scalarModel.getAutoCompleteMinLength()));
                break;
            }
            case OBJECT_AUTO_COMPLETE: {
                Facets.autoCompleteMinLength((ObjectSpecification)scalarModel.getScalarTypeSpec()).ifPresent(arg_0 -> ((Settings)settings).setMinimumInputLength(arg_0));
                break;
            }
        }
        return select2;
    }

    @Override
    protected final void installScalarModelChangeBehavior() {
    }

    protected final boolean isEditableWithEitherAutoCompleteOrChoices() {
        if (this.scalarModel().getRenderingHint().isInTable()) {
            return false;
        }
        if (this.scalarModel().isViewMode()) {
            return false;
        }
        return this.scalarModel().getChoiceProviderSort().isChoicesAny();
    }

    public final boolean checkSelect2Required() {
        return this.select2.checkRequired();
    }

    @Override
    protected final UiString obtainOutputFormat() {
        return UiString.text((String)((String)this.select2.obtainOutputFormatModel().getObject()));
    }

    @Override
    protected final void onSwitchFormForInlinePrompt(WebMarkupContainer inlinePromptForm, AjaxRequestTarget target) {
        Wkt.javaScriptAdd(target, Wkt.EventTopic.OPEN_SELECT2, inlinePromptForm.getMarkupId());
    }

    @Override
    public final ScalarPanelAbstract.Repaint updateIfNecessary(@NonNull UiParameter paramModel, @NonNull Optional<AjaxRequestTarget> target) {
        if (paramModel == null) {
            throw new NullPointerException("paramModel is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        ScalarPanelAbstract.Repaint repaint = super.updateIfNecessary(paramModel, target);
        boolean choicesUpdated = this.updateChoices(this.select2);
        if (repaint == ScalarPanelAbstract.Repaint.NOTHING) {
            if (choicesUpdated) {
                return ScalarPanelAbstract.Repaint.PARAM_ONLY;
            }
            return ScalarPanelAbstract.Repaint.NOTHING;
        }
        return repaint;
    }

    private boolean updateChoices(@Nullable Select2 select2) {
        if (select2 == null) {
            return false;
        }
        select2.rebuildChoiceProvider();
        return true;
    }

    @Override
    public final void repaint(AjaxRequestTarget target) {
        target.add(new Component[]{this});
    }

    public static interface ChoiceTitleHandler
    extends Serializable {
        public void clearTitleAttribute();

        public void setTitleAttribute(@Nullable String var1);
    }
}

