/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import java.util.Optional;
import lombok.NonNull;
import org.apache.isis.commons.internal.assertions._Assert;
import org.apache.isis.core.metamodel.commons.ScalarRepresentation;
import org.apache.isis.core.metamodel.spec.feature.ObjectFeature;
import org.apache.isis.viewer.commons.model.components.UiString;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarFragmentFactory;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelFormFieldAbstract;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;

public abstract class ScalarPanelTextFieldAbstract<T>
extends ScalarPanelFormFieldAbstract<T> {
    private static final long serialVersionUID = 1L;
    private AbstractTextComponent<T> formField;

    protected ScalarPanelTextFieldAbstract(String id, ScalarModel scalarModel, Class<T> type) {
        super(id, scalarModel, type);
        this.guardAgainstIncompatibleScalarType();
    }

    protected final IConverter<T> getConverter(ScalarModel scalarModel) {
        return this.getConverter(scalarModel.getMetaModel(), scalarModel.isEditMode() ? ScalarRepresentation.EDITING : ScalarRepresentation.VIEWING);
    }

    protected abstract IConverter<T> getConverter(@NonNull ObjectFeature var1, @NonNull ScalarRepresentation var2);

    protected AbstractTextComponent<T> createTextField(String id) {
        IConverter<T> converter = this.getConverter(this.scalarModel());
        return this.getFormatModifiers().contains((Enum)ScalarPanelAbstract.FormatModifier.MULITLINE) ? Wkt.textAreaWithConverter(id, this.unwrappedModel(), this.type, converter) : Wkt.textFieldWithConverter(id, this.unwrappedModel(), this.type, converter);
    }

    protected final IModel<T> unwrappedModel() {
        return this.scalarModel().unwrapped(this.type);
    }

    @Override
    protected final FormComponent<T> createFormComponent(String id, ScalarModel scalarModel) {
        this.formField = this.createTextField(id);
        this.formField.setOutputMarkupId(true);
        return this.applyFormComponentAttributes((FormComponent)this.formField);
    }

    @Override
    protected Optional<ScalarFragmentFactory.InputFragment> getInputFragmentType() {
        return Optional.of(this.getFormatModifiers().contains((Enum)ScalarPanelAbstract.FormatModifier.MULITLINE) ? ScalarFragmentFactory.InputFragment.TEXTAREA : ScalarFragmentFactory.InputFragment.TEXT);
    }

    @Override
    protected String obtainInlinePromptLinkCssIfAny() {
        return !this.getFormatModifiers().contains((Enum)ScalarPanelAbstract.FormatModifier.MULITLINE) ? super.obtainInlinePromptLinkCssIfAny() : null;
    }

    @Override
    protected final UiString obtainOutputFormat() {
        return super.obtainOutputFormat();
    }

    private void guardAgainstIncompatibleScalarType() {
        _Assert.assertTrue((boolean)this.scalarModel().getScalarTypeSpec().isAssignableFrom(this.type), () -> String.format("[%s:%s] cannot possibly unwrap model of type %s into target type %s", this.getClass().getSimpleName(), this.scalarModel().getIdentifier(), this.scalarModel().getScalarTypeSpec().getCorrespondingClass(), this.type));
    }

    <F extends FormComponent<?>> F applyFormComponentAttributes(F formComponent) {
        ScalarModel scalarModel = this.scalarModel();
        Wkt.setFormComponentAttributes(formComponent, () -> ((ScalarModel)scalarModel).multilineNumberOfLines(), () -> ((ScalarModel)scalarModel).maxLength(), () -> ((ScalarModel)scalarModel).typicalLength());
        return formComponent;
    }
}

